/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.ParenthesesUtils;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSSplitIfAndIntention
extends JSIntention {
    @NonNls
    private static final String IF_STATEMENT_PREFIX = "if (";
    @NonNls
    private static final String INNER_IF_STATEMENT_PREFIX = ") {\n if (";
    @NonNls
    private static final String ELSE_KEYWORD = "else ";

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        SplitIfAndPredicate splitIfAndPredicate = new SplitIfAndPredicate();
        if (splitIfAndPredicate == null) {
            JSSplitIfAndIntention.$$$reportNull$$$0(0);
        }
        return splitIfAndPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        int elseLength;
        PsiElement jsElement;
        if (element == null) {
            JSSplitIfAndIntention.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = jsElement = element.getParent() instanceof JSIfStatement ? element.getParent() : element;
        assert (jsElement != null);
        assert (jsElement instanceof JSIfStatement);
        JSIfStatement ifStatement = (JSIfStatement)jsElement;
        assert (ifStatement.getCondition() instanceof JSBinaryExpression);
        JSBinaryExpression condition = (JSBinaryExpression)ifStatement.getCondition();
        String lhsText = ParenthesesUtils.removeParentheses((JSExpression)condition.getLOperand());
        String rhsText = ParenthesesUtils.removeParentheses((JSExpression)condition.getROperand());
        JSStatement thenBranch = ifStatement.getThen();
        JSStatement elseBranch = ifStatement.getElse();
        String thenText = thenBranch.getText();
        String elseText = elseBranch == null ? null : elseBranch.getText();
        int n = elseLength = elseBranch == null ? 0 : elseText.length();
        assert (condition.getOperationSign().equals(JSTokenTypes.ANDAND));
        StringBuilder statement = new StringBuilder(ifStatement.getTextLength() + elseLength + 30);
        statement.append(IF_STATEMENT_PREFIX).append(lhsText).append(INNER_IF_STATEMENT_PREFIX).append(rhsText).append(')');
        if (!(thenBranch instanceof JSBlockStatement)) {
            statement.append(' ');
        }
        statement.append(thenText);
        if (elseBranch != null) {
            statement.append(ELSE_KEYWORD);
            if (!(elseBranch instanceof JSBlockStatement)) {
                statement.append(' ');
            }
            statement.append(elseText);
        }
        statement.append('}');
        if (elseBranch != null) {
            statement.append(ELSE_KEYWORD).append(elseText);
        }
        JSElementFactory.replaceStatement((JSStatement)ifStatement, (String)statement.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/trivialif/JSSplitIfAndIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/trivialif/JSSplitIfAndIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SplitIfAndPredicate
    implements JSElementPredicate {
        private SplitIfAndPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            JSIfStatement ifStatement;
            JSExpression condition;
            PsiElement parent;
            if (element == null) {
                SplitIfAndPredicate.$$$reportNull$$$0(0);
            }
            if (!((parent = element.getParent()) instanceof JSIfStatement)) {
                if (element instanceof JSIfStatement) {
                    parent = element;
                } else {
                    return false;
                }
            }
            if ((condition = (ifStatement = (JSIfStatement)parent).getCondition()) == null || ErrorUtil.containsError((PsiElement)condition)) {
                return false;
            }
            return condition instanceof JSBinaryExpression && ((JSBinaryExpression)condition).getOperationSign() == JSTokenTypes.ANDAND;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSSplitIfAndIntention$SplitIfAndPredicate", "satisfiedBy"));
        }
    }
}

