/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.fixes;

import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssElementFactory;
import org.jetbrains.annotations.NotNull;

public class CssAddPrefixQuickFix
extends LocalQuickFixBase {
    @NotNull
    private final String myPrefix;
    @NotNull
    private final Class<? extends CssAtRule> myClass;

    public CssAddPrefixQuickFix(@NotNull String message, @NotNull String prefix, @NotNull Class<? extends CssAtRule> elementClass) {
        if (message == null) {
            CssAddPrefixQuickFix.$$$reportNull$$$0(0);
        }
        if (prefix == null) {
            CssAddPrefixQuickFix.$$$reportNull$$$0(1);
        }
        if (elementClass == null) {
            CssAddPrefixQuickFix.$$$reportNull$$$0(2);
        }
        super(message);
        this.myPrefix = prefix;
        this.myClass = elementClass;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement startElement;
        if (project == null) {
            CssAddPrefixQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            CssAddPrefixQuickFix.$$$reportNull$$$0(4);
        }
        if (this.myClass.isInstance(startElement = descriptor.getStartElement())) {
            TextRange textRange = descriptor.getTextRangeInElement();
            String text = textRange.substring(startElement.getText());
            for (int i = 0; i < this.myPrefix.length(); ++i) {
                if (StringUtil.startsWith((CharSequence)text, (CharSequence)this.myPrefix.substring(0, i + 1))) continue;
                text = this.myPrefix + text.substring(i);
                break;
            }
            String newText = textRange.replace(startElement.getText(), text);
            startElement.replace((PsiElement)CssElementFactory.getInstance((Project)project).createAtRule(newText, this.myClass, startElement.getLanguage()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/inspections/fixes/CssAddPrefixQuickFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

