/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.intermediate;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.intermediate.AdaptIntermediateSession;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateFacade;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateSession;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateFacade;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateSession;

public class AdaptIntermediateFacade
implements IntegralIntermediateFacade {
    @NotNull
    private final Rdbms myRdbms;
    @NotNull
    private final PrimeIntermediateFacade myRemoteFacade;

    public AdaptIntermediateFacade(@NotNull PrimeIntermediateFacade remoteFacade) {
        this.myRemoteFacade = remoteFacade;
        this.myRdbms = remoteFacade.rdbms();
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return this.myRdbms;
    }

    @Override
    public void connect() {
        this.myRemoteFacade.connect();
    }

    @Override
    public void reconnect() {
        this.myRemoteFacade.reconnect();
    }

    @Override
    public void disconnect() {
        this.myRemoteFacade.disconnect();
    }

    @Override
    public boolean isConnected() {
        return this.myRemoteFacade.isConnected();
    }

    @Override
    @NotNull
    public ConnectionInfo getConnectionInfo() {
        return this.myRemoteFacade.getConnectionInfo();
    }

    @Override
    @NotNull
    public IntegralIntermediateSession openSession() {
        PrimeIntermediateSession remoteSession = this.myRemoteFacade.openSession();
        return new AdaptIntermediateSession(remoteSession);
    }

    @Override
    @Nullable
    public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) throws ClassCastException {
        return this.myRemoteFacade.getSpecificService(serviceClass, serviceName);
    }
}

