/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.exceptions.DBIsNotConnected;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSession;
import org.jetbrains.dekaf.jdbc.UnknownDatabaseInfo;
import org.jetbrains.dekaf.jdbc.UnknownDatabaseInfoHelper;
import org.jetbrains.dekaf.jdbc.UnknownDatabaseIntermediateSession;

public class UnknownDatabaseIntermediateFacade
extends JdbcIntermediateFacade {
    @Nullable
    private UnknownDatabaseInfo myUnknownInfo = null;
    private static final String CONNECTION_INFO_DB2_QUERY = "select rtrim(current_server), rtrim(current schema), rtrim(current_user) from sysibm.sysdummy1";
    private static final String CONNECTION_INFO_HSQL_QUERY = "select database(), current_schema, current_user from information_schema.schemata limit 1";

    public UnknownDatabaseIntermediateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, @NotNull Driver driver, int connectionsLimit, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        super(connectionString, connectionProperties, driver, connectionsLimit, exceptionRecognizer);
    }

    public UnknownDatabaseIntermediateFacade(@NotNull DataSource dataSource, int connectionsLimit, boolean ownConnections, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        super(dataSource, connectionsLimit, ownConnections, exceptionRecognizer);
    }

    @Override
    public synchronized void connect() {
        super.connect();
        if (this.myUnknownInfo == null) {
            this.myUnknownInfo = UnknownDatabaseInfoHelper.obtainDatabaseInfo(this);
        }
    }

    @Override
    public ConnectionInfo obtainConnectionInfoNatively() {
        assert (this.myUnknownInfo != null);
        String query = null;
        if (this.myUnknownInfo.isDB2) {
            query = CONNECTION_INFO_DB2_QUERY;
        }
        if (this.myUnknownInfo.isHsql) {
            query = CONNECTION_INFO_HSQL_QUERY;
        }
        if (query != null) {
            return this.getConnectionInfoSmartly(query, SIMPLE_VERSION_PATTERN, 1, SIMPLE_VERSION_PATTERN, 1);
        }
        return super.obtainConnectionInfoNatively();
    }

    @NotNull
    UnknownDatabaseInfo getUnknownInfo() {
        if (this.myUnknownInfo == null) {
            if (!this.isConnected()) {
                throw new DBIsNotConnected("Facade is not connected to DB");
            }
            throw new RuntimeException("The special internal info is not obtained. Possible the Facade was not initialized properly");
        }
        return this.myUnknownInfo;
    }

    @Override
    @NotNull
    protected JdbcIntermediateSession instantiateSession(@NotNull Connection connection, boolean ownConnection) {
        return new UnknownDatabaseIntermediateSession(this, this.getExceptionRecognizer(), connection, ownConnection);
    }
}

