/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.DataBus;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.session.AbstractMessageBusSession;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/console/session/MessageBusSession;", "Lcom/intellij/database/console/session/AbstractMessageBusSession;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "kernel", "Lcom/intellij/database/console/session/AbstractMessageBusSession$SessionKernel;", "title", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/console/session/AbstractMessageBusSession$SessionKernel;Ljava/lang/String;)V", "getErrorsLogger", "Lcom/intellij/database/datagrid/DataAuditor;", "init", "", "intellij.database.impl"})
public class MessageBusSession
extends AbstractMessageBusSession {
    @Override
    public void init() {
        DataAuditor obtainer = JdbcConsole.createAdvancedErrorsObtainer(this.getProject(), this.getDataSource(), this.getErrorsLogger());
        if (obtainer != null) {
            DataAuditor dataAuditor = obtainer;
            if (!(dataAuditor instanceof Disposable)) {
                dataAuditor = null;
            }
            Disposable disposable = (Disposable)dataAuditor;
            if (disposable != null) {
                Disposable disposable2;
                Disposable it = disposable2 = disposable;
                Disposer.register((Disposable)this, (Disposable)it);
            }
            this.getMessageBus().addAuditor(obtainer);
        }
    }

    @NotNull
    protected DataAuditor getErrorsLogger() {
        DataBus.Producing producing = DataBus.shortCircuit(this.getMessageBus());
        Intrinsics.checkExpressionValueIsNotNull((Object)producing, (String)"DataBus.shortCircuit(messageBus)");
        DataAuditor dataAuditor = producing.getDataAuditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataAuditor, (String)"DataBus.shortCircuit(messageBus).dataAuditor");
        return dataAuditor;
    }

    public MessageBusSession(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull AbstractMessageBusSession.SessionKernel kernel, @NotNull String title) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)kernel, (String)"kernel");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        super(project, dataSource, kernel, title);
    }
}

