/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.model;

import com.intellij.database.dialects.mssql.model.MsAliasType;
import com.intellij.database.dialects.mssql.model.MsDefaultConstraint;
import com.intellij.database.dialects.mssql.model.MsIndex;
import com.intellij.database.dialects.mssql.model.MsSourceAware;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/dialects/mssql/model/MsDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeMsAliasType", "Lcom/intellij/database/dialects/mssql/model/MsAliasType;", "describeMsDefaltConstraint", "def", "Lcom/intellij/database/dialects/mssql/model/MsDefaultConstraint;", "describeMsIndex", "index", "Lcom/intellij/database/dialects/mssql/model/MsIndex;", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "options", "updatePresentation", "project", "Lcom/intellij/openapi/project/Project;", "o", "Lcom/intellij/database/model/DasObject;", "intellij.database.dialects"})
public final class MsDescriptionService
extends DescriptionService {
    @Override
    @NotNull
    public String options(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return super.options(e, context) + (e instanceof MsSourceAware && ((MsSourceAware)e).isEncrypted() ? " [encrypted]" : "");
    }

    @Override
    @NotNull
    public String content(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BasicElement basicElement = e;
        return basicElement instanceof MsAliasType ? this.describeMsAliasType((MsAliasType)e) : (basicElement instanceof MsIndex ? this.describeMsIndex((MsIndex)e) : (basicElement instanceof MsDefaultConstraint ? this.describeMsDefaltConstraint((MsDefaultConstraint)e) : super.content(e, context)));
    }

    private final String describeMsAliasType(MsAliasType e) {
        return e.getDataType().toString() + (e.isNotNull() ? " NN" : "");
    }

    private final String describeMsIndex(MsIndex index2) {
        String prefix = index2.isClustering() ? "clustered " : "";
        String inner = this.describeIndexingItems(index2);
        String condition = index2.getCondition();
        String d2 = (index2.isUnique() ? "unique" : "index") + " (" + inner + ')';
        List<String> list = index2.getIncludeColNames();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"index.includeColNames");
        Collection collection = list;
        if (!collection.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder().append(d2).append(" include (");
            List<String> list2 = index2.getIncludeColNames();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"index.includeColNames");
            d2 = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).append(')').toString();
        }
        if (condition != null) {
            d2 = d2 + " when " + condition;
        }
        return prefix + d2;
    }

    private final String describeMsDefaltConstraint(MsDefaultConstraint def) {
        String string = StringUtil.join((Collection)def.getColNames(), (String)",");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.join(def.colNames, \",\")");
        String columnName = string;
        String string2 = def.getDefaultExpression();
        if (string2 == null) {
            string2 = "???";
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"def.defaultExpression ?: \"???\"");
        String defaultExpression = string2;
        return columnName + " = " + defaultExpression;
    }

    @Override
    public void updatePresentation(@NotNull Project project, @NotNull DasObject o, @NotNull PresentationData presentation) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        DasObject dasObject = o;
        if (dasObject instanceof MsIndex) {
            this.describeMsIndex(presentation, (MsIndex)o);
        } else {
            super.updatePresentation(project, o, presentation);
        }
    }

    private final void describeMsIndex(PresentationData presentation, MsIndex index2) {
        String unique = index2.isUnique() ? " UNIQUE" : "";
        String indexingItems = this.describeIndexingItems(index2);
        String columnsText = " (" + indexingItems + ')' + unique;
        List<String> list = index2.getIncludeColNames();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"index.includeColNames");
        List<String> includingColNames = list;
        if (!includingColNames.isEmpty()) {
            String string = StringUtil.join((Collection)includingColNames, (String)", ");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.join(includingColNames, \", \")");
            String icn = string;
            columnsText = columnsText + " include (" + icn + ')';
        }
        presentation.addText(columnsText, DbNodeDescriptor.getGrayAttrs());
        String condition = index2.getCondition();
        if (condition != null) {
            presentation.addText(" where " + condition, DbNodeDescriptor.getGrayAttrs());
        }
    }
}

