/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.clickhouse;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.clickhouse.CHouseDialect;
import com.intellij.sql.dialects.clickhouse.CHouseTokens;
import com.intellij.sql.dialects.clickhouse.CHouseTypes;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.lexer._CHouseLexer;
import org.jetbrains.annotations.NotNull;

public class CHouseLexer
extends SqlLexer {
    private int myInsertState;

    public CHouseLexer() {
        super(CHouseDialect.LazyData.ourClasses, new _CHouseLexer());
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            CHouseLexer.$$$reportNull$$$0(0);
        }
        this.myInsertState = initialState >>> 29;
        super.start(buffer, startOffset, endOffset, 0x1FFFFFFF & initialState);
    }

    public int getState() {
        return this.myInsertState << 29 | 0x1FFFFFFF & super.getState();
    }

    public void advance() {
        if (this.myInsertState == 1 && this.getTokenType() == SqlTokens.SQL_RAW_INPUT) {
            this.myInsertState = 0;
        }
        super.advance();
    }

    @Override
    protected void lookAhead(Lexer baseLexer) {
        if (!this.lookAheadNestedColumns(baseLexer)) {
            super.lookAhead(baseLexer);
        }
    }

    private boolean lookAheadNestedColumns(Lexer lexer) {
        int end;
        int start;
        IElementType type = lexer.getTokenType();
        if (type != SqlTokens.SQL_IDENT_DELIMITED) {
            return false;
        }
        CharSequence buf = lexer.getBufferSequence();
        int i2 = StringUtil.indexOf((CharSequence)buf, (char)'.', (int)((start = lexer.getTokenStart()) + 2), (int)((end = lexer.getTokenEnd()) - 2));
        if (i2 == -1) {
            return false;
        }
        this.addToken(start + 1, (IElementType)CHouseTokens.CH_DELIMITED_TOKEN_START);
        do {
            this.addToken(i2, (IElementType)SqlTokens.SQL_IDENT);
            this.addToken(i2 + 1, (IElementType)SqlTokens.SQL_PERIOD);
        } while ((i2 = StringUtil.indexOf((CharSequence)buf, (char)'.', (int)(i2 + 2), (int)(end - 2))) != -1);
        this.addToken(end - 1, (IElementType)SqlTokens.SQL_IDENT);
        this.advanceAs(lexer, (IElementType)CHouseTokens.CH_DELIMITED_TOKEN_END);
        return true;
    }

    @Override
    protected void lookSqlKeyword(Lexer baseLexer) {
        IElementType type = this.getSqlTokenType(baseLexer);
        if (this.myInsertState == 0) {
            if (type == SqlCommonKeywords.SQL_INSERT) {
                this.advanceAs(baseLexer, type);
                type = this.skipCommentsAndGet(baseLexer);
                if (type == SqlCommonKeywords.SQL_INTO) {
                    this.advanceAs(baseLexer, type);
                    type = this.skipCommentsAndGet(baseLexer);
                    if (type == SqlCommonKeywords.SQL_TABLE) {
                        this.advanceAs(baseLexer, type);
                        type = this.skipCommentsAndGet(baseLexer);
                    }
                    if (type == SqlCommonKeywords.SQL_FUNCTION) {
                        this.advanceAs(baseLexer, type);
                        type = this.skipCommentsAndGet(baseLexer);
                    }
                    if (CHouseLexer.isIdentifier(type)) {
                        this.advanceAs(baseLexer, type);
                        type = this.skipCommentsAndGet(baseLexer);
                        while (type == SqlTokens.SQL_PERIOD) {
                            this.advanceAs(baseLexer, type);
                            type = this.skipCommentsAndGet(baseLexer);
                            if (!CHouseLexer.isIdentifier(type)) {
                                return;
                            }
                            this.advanceAs(baseLexer, type);
                            type = this.skipCommentsAndGet(baseLexer);
                        }
                        this.myInsertState = 2;
                        return;
                    }
                }
            }
        } else if (this.myInsertState > 1) {
            int b2;
            int n = type == SqlTokens.SQL_LEFT_PAREN ? 1 : (b2 = type == SqlTokens.SQL_RIGHT_PAREN ? -1 : 0);
            if (this.myInsertState == 2 && b2 == 0 && type == SqlCommonKeywords.SQL_VALUES) {
                this.myInsertState = 0;
            } else if (this.myInsertState == 2 && b2 == 0 && type == CHouseTypes.CH_FORMAT) {
                this.advanceAs(baseLexer, type);
                type = this.skipCommentsAndGet(baseLexer);
                if (type == SqlCommonKeywords.SQL_VALUES) {
                    this.myInsertState = 0;
                } else if (CHouseLexer.isIdentifier(type)) {
                    this.advanceAs(baseLexer, type);
                    this.myInsertState = 1;
                    this.lookAheadRawEnd(baseLexer);
                    return;
                }
            } else {
                this.myInsertState = this.myInsertState == 2 && b2 == -1 ? 0 : (this.myInsertState += b2);
            }
        }
        if (this.myInsertState != 1 && CHouseLexer.isStatementSeparator(type)) {
            this.myInsertState = 0;
        }
        this.advanceAs(baseLexer, type);
    }

    private void lookAheadRawEnd(Lexer lexer) {
        IElementType type = lexer.getTokenType();
        CharSequence buf = lexer.getBufferSequence();
        int end = lexer.getBufferEnd();
        int start = lexer.getTokenStart();
        boolean oneline = true;
        if (SqlTokens.WS_TOKENS.contains(type)) {
            int e = lexer.getTokenEnd();
            int nl = StringUtil.indexOfAny((CharSequence)buf, (String)"\n\r", (int)start, (int)e);
            boolean bl = oneline = nl == -1;
            if (nl == -1 || nl == e - 1) {
                this.advanceLexer(lexer);
                start = e;
            } else {
                nl = CHouseLexer.newLineEnd(buf, nl, end);
                this.addToken(nl, SqlTokens.SQL_WHITE_SPACE);
                start = nl;
            }
        }
        int s = start;
        while (s < end) {
            char c2 = buf.charAt(s);
            if (CHouseLexer.isCrLf(c2)) {
                char nx;
                int ns;
                if (oneline) {
                    oneline = false;
                    if (s > start && buf.charAt(s - 1) == ';') {
                        --s;
                        break;
                    }
                }
                if ((ns = CHouseLexer.newLineEnd(buf, s, end)) < end && (CHouseLexer.isCrLf(nx = buf.charAt(ns)) || nx == ';' && (ns + 1 >= end || CHouseLexer.isCrLf(buf.charAt(ns + 1))))) break;
                s = ns;
                continue;
            }
            ++s;
        }
        this.addToken(s, (IElementType)SqlTokens.SQL_RAW_INPUT);
        lexer.start(buf, s, end, lexer.getState());
    }

    private static int newLineEnd(CharSequence buf, int start, int end) {
        if (start + 1 >= end) {
            return start + 1;
        }
        char p2 = buf.charAt(start);
        char n = buf.charAt(start + 1);
        return CHouseLexer.isCrLf(n) && n != p2 ? start + 2 : start + 1;
    }

    private static boolean isCrLf(char c2) {
        return c2 == '\n' || c2 == '\r';
    }

    private static boolean isIdentifier(IElementType type) {
        return type instanceof SqlKeywordTokenType || type == SqlTokens.SQL_IDENT || type == SqlTokens.SQL_IDENT_DELIMITED;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/sql/dialects/clickhouse/CHouseLexer", "start"));
    }
}

