/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;
import org.sablecc.sablecc.DisplayLicense;
import org.sablecc.sablecc.GenAlts;
import org.sablecc.sablecc.GenAnalyses;
import org.sablecc.sablecc.GenLexer;
import org.sablecc.sablecc.GenParser;
import org.sablecc.sablecc.GenProds;
import org.sablecc.sablecc.GenTokens;
import org.sablecc.sablecc.GenUtils;
import org.sablecc.sablecc.Grammar;
import org.sablecc.sablecc.LR0Collection;
import org.sablecc.sablecc.Production;
import org.sablecc.sablecc.ResolveIds;
import org.sablecc.sablecc.Symbol;
import org.sablecc.sablecc.lexer.Lexer;
import org.sablecc.sablecc.node.Start;
import org.sablecc.sablecc.parser.Parser;

public class SableCC {
    private static void displayCopyright() {
        System.out.println();
        System.out.println("SableCC version 2.16.2");
        System.out.println("Copyright (C) 1997-2001 Etienne M. Gagnon <egagnon@j-meg.com> and");
        System.out.println("others.  All rights reserved.");
        System.out.println();
        System.out.println("This software comes with ABSOLUTELY NO WARRANTY.  This is free software,");
        System.out.println("and you are welcome to redistribute it under certain conditions.");
        System.out.println();
        System.out.println("Type 'sablecc -license' to view");
        System.out.println("the complete copyright notice and license.");
        System.out.println();
    }

    private static void displayUsage() {
        System.out.println("Usage:");
        System.out.println("  sablecc [-d destination] filename [filename]...");
        System.out.println("  sablecc -license");
    }

    public static void main(String[] stringArray) {
        String string = null;
        Vector<String> vector = new Vector<String>();
        if (stringArray.length == 0) {
            SableCC.displayCopyright();
            SableCC.displayUsage();
            System.exit(1);
        }
        if (stringArray.length == 1 && stringArray[0].equals("-license")) {
            new DisplayLicense();
            System.exit(0);
        }
        SableCC.displayCopyright();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-d")) {
                if (string == null && ++n < stringArray.length) {
                    string = stringArray[n];
                } else {
                    SableCC.displayUsage();
                    System.exit(1);
                }
            } else {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        if (vector.size() == 0) {
            SableCC.displayUsage();
            System.exit(1);
        }
        try {
            try {
                int n2 = 0;
                while (n2 < vector.size()) {
                    SableCC.processGrammar((String)vector.elementAt(n2), string);
                    ++n2;
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
                System.exit(1);
            }
            catch (Throwable throwable) {
                System.out.println(throwable);
                System.exit(1);
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            System.exit(0);
            throw throwable;
        }
        System.exit(0);
    }

    public static void processGrammar(File file, File file2) throws Exception, Throwable {
        if (!file.exists()) {
            System.out.println("ERROR: grammar file " + file.getName() + " does not exist.");
            System.exit(1);
        }
        if (!file2.exists()) {
            System.out.println("ERROR: destination directory " + file2.getName() + " does not exist.");
            System.exit(1);
        }
        LR0Collection.reinit();
        Symbol.reinit();
        Production.reinit();
        Grammar.reinit();
        System.out.println("\n -- Generating parser for " + file.getName() + " in " + file2.getPath());
        FileReader fileReader = new FileReader(file);
        Start start = new Parser(new Lexer(new BufferedReader(fileReader))).parse();
        fileReader.close();
        System.out.println("Verifying identifiers.");
        ResolveIds resolveIds = new ResolveIds(file2);
        start.apply(resolveIds);
        System.out.println("Generating token classes.");
        start.apply(new GenTokens(resolveIds));
        System.out.println("Generating production classes.");
        start.apply(new GenProds(resolveIds));
        System.out.println("Generating alternative classes.");
        start.apply(new GenAlts(resolveIds));
        System.out.println("Generating analysis classes.");
        start.apply(new GenAnalyses(resolveIds));
        System.out.println("Generating utility classes.");
        start.apply(new GenUtils(resolveIds));
        try {
            System.out.println("Generating the lexer.");
            start.apply(new GenLexer(resolveIds));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            throw exception;
        }
        try {
            System.out.println("Generating the parser.");
            start.apply(new GenParser(resolveIds));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            throw exception;
        }
    }

    public static void processGrammar(String string, String string2) throws Exception, Throwable {
        File file;
        File file2 = new File(string);
        file2 = new File(file2.getAbsolutePath());
        if (string2 == null) {
            file = new File(file2.getParent());
        } else {
            file = new File(string2);
            file = new File(file.getAbsolutePath());
        }
        SableCC.processGrammar(file2, file);
    }
}

