/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute;

import java.io.Serializable;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.print.attribute.IntegerSyntax;

public abstract class SetOfIntegerSyntax
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3666874174847632203L;
    private int[][] members;

    private static final int[][] normalize(int[][] values, int size) {
        Arrays.sort((Object[])values, 0, size, new Comparator(){

            public final int compare(Object o1, Object o2) {
                int[] v1 = (int[])o1;
                int[] v2 = (int[])o2;
                if (v1[0] == v2[0]) {
                    return v1[1] - v2[1];
                }
                return v1[0] - v2[0];
            }
        });
        int outIndex = 0;
        int i = 0;
        while (i < size) {
            int save = i;
            while (i + 1 < size && values[i + 1][0] <= values[i][1] + 1) {
                values[i][1] = Math.max(values[i][1], values[i + 1][1]);
                ++i;
            }
            values[outIndex++] = values[save];
            ++i;
        }
        int[][] result = new int[outIndex][];
        System.arraycopy(values, 0, result, 0, outIndex);
        return result;
    }

    private final boolean skipWhitespace(StringCharacterIterator i) {
        while (Character.isWhitespace(i.current())) {
            i.next();
        }
        boolean bl = false;
        if (i.current() == (char)-1) {
            bl = true;
        }
        return bl;
    }

    private final boolean skipNumber(StringCharacterIterator i) {
        boolean readAny = false;
        while (Character.isDigit(i.current())) {
            readAny = true;
            i.next();
        }
        return readAny;
    }

    public boolean contains(int value) {
        int index = 0;
        while (index < this.members.length) {
            if (value < this.members[index][0]) {
                return false;
            }
            if (value <= this.members[index][1]) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public boolean contains(IntegerSyntax value) {
        return this.contains(value.getValue());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SetOfIntegerSyntax)) {
            return false;
        }
        SetOfIntegerSyntax other = (SetOfIntegerSyntax)obj;
        if (other.members.length != this.members.length) {
            return false;
        }
        int i = 0;
        while (i < this.members.length) {
            if (this.members[i][0] != other.members[i][0] || this.members[i][1] != other.members[i][1]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int[][] getMembers() {
        return (int[][])this.members.clone();
    }

    public int hashCode() {
        int result = 0;
        int i = 0;
        while (i < this.members.length) {
            result += this.members[i][0] + this.members[i][1];
            ++i;
        }
        return result;
    }

    public int next(int x) {
        int i = 0;
        while (i < this.members.length) {
            if (x < this.members[i][1]) {
                if (x < this.members[i][0]) {
                    return this.members[i][0];
                }
                return x + 1;
            }
            ++i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.members.length) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.members[i][0]);
            if (this.members[i][0] != this.members[i][1]) {
                sb.append('-');
                sb.append(this.members[i][1]);
            }
            ++i;
        }
        return sb.toString();
    }

    protected SetOfIntegerSyntax(int member) {
        if (member < 0) {
            throw new IllegalArgumentException("member may not be less than 0");
        }
        this.members = new int[][]{{member, member}};
    }

    protected SetOfIntegerSyntax(int[][] members) {
        int[][] newMembers;
        int outIndex = 0;
        if (members == null) {
            newMembers = new int[][]{};
        } else {
            newMembers = new int[members.length][];
            int index = 0;
            while (index < members.length) {
                int upper;
                int lower;
                if (members[index].length == 1) {
                    lower = members[index][0];
                    upper = members[index][0];
                } else if (members[index].length == 2) {
                    lower = members[index][0];
                    upper = members[index][1];
                } else {
                    throw new IllegalArgumentException("invalid member element");
                }
                if (lower <= upper && lower < 0) {
                    throw new IllegalArgumentException("invalid member element");
                }
                if (lower <= upper) {
                    int[] range = new int[]{lower, upper};
                    newMembers[outIndex++] = range;
                }
                ++index;
            }
        }
        this.members = SetOfIntegerSyntax.normalize(newMembers, outIndex);
    }

    protected SetOfIntegerSyntax(String s) {
        ArrayList vals = new ArrayList();
        StringCharacterIterator it = new StringCharacterIterator(s);
        while (!this.skipWhitespace(it)) {
            int index = it.getIndex();
            if (!this.skipNumber(it)) {
                throw new IllegalArgumentException();
            }
            int[] item = new int[2];
            item[0] = Integer.parseInt(s.substring(index, it.getIndex()));
            if (!this.skipWhitespace(it)) {
                char c = it.current();
                if (c == ':' || c == '-') {
                    it.next();
                    if (this.skipWhitespace(it)) {
                        throw new IllegalArgumentException();
                    }
                    index = it.getIndex();
                    if (!this.skipNumber(it)) {
                        throw new IllegalArgumentException();
                    }
                    item[1] = Integer.parseInt(s.substring(index, it.getIndex()));
                } else {
                    item[1] = item[0];
                }
            } else {
                item[1] = item[0];
            }
            if (item[0] <= item[1]) {
                vals.add(item);
            }
            if (this.skipWhitespace(it)) break;
            if (it.current() != ',') {
                throw new IllegalArgumentException();
            }
            it.next();
        }
        this.members = SetOfIntegerSyntax.normalize((int[][])vals.toArray((Object[])new int[0][]), vals.size());
    }

    protected SetOfIntegerSyntax(int lowerBound, int upperBound) {
        int[][] nArrayArray;
        if (lowerBound <= upperBound && lowerBound < 0) {
            throw new IllegalArgumentException();
        }
        if (lowerBound <= upperBound) {
            int[][] nArrayArray2 = new int[1][];
            nArrayArray = nArrayArray2;
            nArrayArray2[0] = new int[]{lowerBound, upperBound};
        } else {
            nArrayArray = new int[][]{};
        }
        this.members = nArrayArray;
    }
}

