
(define-library (chibi optional-test)
  (import (scheme base) (chibi optional) (chibi test))
  (export run-tests)
  (begin
    (define (run-tests)
      (test-begin "optional")
      (test '(0 11 12)
          (let-optionals '(0) ((a 10) (b 11) (c 12))
            (list a b c)))
      (test '(0 11 12)
          ((opt-lambda ((a 10) (b 11) (c 12))
             (list a b c))
           0))
      (test '(0 11 12)
          ((opt-lambda (a (b 11) (c 12))
             (list a b c))
           0))
      (test '(0 1 (2 3 4))
          (let-optionals* '(0 1 2 3 4) ((a 10) (b 11) . c)
            (list a b c)))
      (test '(0 1 (2 3 4))
          (let-optionals '(0 1 2 3 4) ((a 10) (b 11) . c)
            (list a b c)))
      (test-error '(0 11 12)
          ((opt-lambda (a (b 11) (c 12))
             (list a b c))))
      (let ()
        (define-opt (f a (b 11) (c 12))
          (list a b c))
        (test-error (f))
        (test '(0 11 12) (f 0))
        (test '(0 1 12) (f 0 1))
        (test '(0 1 2) (f 0 1 2))
        (test '(0 1 2) (f 0 1 2 3)))
      (test-end))))
