/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import com.martiansoftware.jsap.JSAPResult;
import edu.cornell.med.icb.identifier.IndexedIdentifier;
import it.unimi.dsi.lang.MutableString;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class ReadGroupHelper {
    private IndexedIdentifier basenames = new IndexedIdentifier();
    private boolean overrideReadGroups = false;
    private Map<String, String> readGroupMap = new HashMap<String, String>();

    public boolean isOverrideReadGroups() {
        return this.overrideReadGroups;
    }

    public void setOverrideReadGroups(boolean overrideReadGroups) {
        this.overrideReadGroups = overrideReadGroups;
    }

    public void parseReadGroupOptions(JSAPResult jsapResult, String[] inputFilenames) {
        if (jsapResult.userSpecified("platform")) {
            this.readGroupMap.put("PL", jsapResult.getString("platform"));
        }
    }

    public Map<String, String> getReadGroupMap() {
        return this.readGroupMap;
    }

    public String getPlatform(String inputFilename) {
        if (this.readGroupMap.containsKey("PL")) {
            return this.readGroupMap.get("PL");
        }
        return "platform";
    }

    public String getId(String inputFilename) {
        this.basenames.registerIdentifier(new MutableString(inputFilename));
        return Integer.toString(this.basenames.getInt((Object)new MutableString(inputFilename)));
    }

    public String getSample(String basename) {
        return FilenameUtils.getBaseName((String)basename);
    }
}

