require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_PMAP_H_)) {
    eval 'sub _MACHINE_PMAP_H_ () {1;}' unless defined(&_MACHINE_PMAP_H_);
    unless(defined(&_LOCORE)) {
	require 'machine/pte.ph';
	require 'sys/queue.ph';
	require 'uvm/uvm_object.ph';
	if(defined(&_KERNEL)) {
	    require 'machine/cpuset.ph';
	    if(defined(&SUN4V)) {
		require 'machine/hypervisor.ph';
	    }
	}
    }
    eval 'sub HOLESHIFT () {(43);}' unless defined(&HOLESHIFT);
    eval 'sub PTSZ () {( &PAGE_SIZE/8);}' unless defined(&PTSZ);
    eval 'sub PDSZ () {( &PTSZ);}' unless defined(&PDSZ);
    eval 'sub STSZ () {( &PTSZ);}' unless defined(&STSZ);
    eval 'sub PTSHIFT () {(13);}' unless defined(&PTSHIFT);
    eval 'sub PDSHIFT () {(10+ &PTSHIFT);}' unless defined(&PDSHIFT);
    eval 'sub STSHIFT () {(10+ &PDSHIFT);}' unless defined(&STSHIFT);
    eval 'sub PTMASK () {( &PTSZ-1);}' unless defined(&PTMASK);
    eval 'sub PDMASK () {( &PDSZ-1);}' unless defined(&PDMASK);
    eval 'sub STMASK () {( &STSZ-1);}' unless defined(&STMASK);
    unless(defined(&_LOCORE)) {
	if(defined(&_LP64)) {
	    eval 'sub MD_MMAP_RANGE_TEST {
	        my($MINVA, $MAXVA) = @_;
    		eval q( &sparc64_mmap_range_test($MINVA, $MAXVA));
	    }' unless defined(&MD_MMAP_RANGE_TEST);
	}
	if(defined(&DEBUG) || 1) {
	}
	eval 'sub va_to_seg {
	    my($v) = @_;
    	    eval q((((( &paddr_t)($v))>> &STSHIFT) &STMASK));
	}' unless defined(&va_to_seg);
	eval 'sub va_to_dir {
	    my($v) = @_;
    	    eval q((((( &paddr_t)($v))>> &PDSHIFT) &PDMASK));
	}' unless defined(&va_to_dir);
	eval 'sub va_to_pte {
	    my($v) = @_;
    	    eval q((((( &paddr_t)($v))>> &PTSHIFT) &PTMASK));
	}' unless defined(&va_to_pte);
	if(defined(&MULTIPROCESSOR)) {
	    eval 'sub PMAP_LIST_MAXNUMCPU () { &CPUSET_MAXNUMCPU;}' unless defined(&PMAP_LIST_MAXNUMCPU);
	} else {
	    eval 'sub PMAP_LIST_MAXNUMCPU () {1;}' unless defined(&PMAP_LIST_MAXNUMCPU);
	}
	eval 'sub pm_lock () { ($pm_obj->{vmobjlock});}' unless defined(&pm_lock);
	eval 'sub pm_refs () { ($pm_obj->{uo_refs});}' unless defined(&pm_refs);
	eval 'sub PMAP_NC () {0x1;}' unless defined(&PMAP_NC);
	eval 'sub PMAP_NVC () {0x2;}' unless defined(&PMAP_NVC);
	eval 'sub PMAP_LITTLE () {0x4;}' unless defined(&PMAP_LITTLE);
	eval 'sub PMAP_8K () {0x;}' unless defined(&PMAP_8K);
	eval 'sub PMAP_64K () {0x8;}' unless defined(&PMAP_64K);
	eval 'sub PMAP_512K () {0x10;}' unless defined(&PMAP_512K);
	eval 'sub PMAP_4M () {0x18;}' unless defined(&PMAP_4M);
	eval 'sub PMAP_SZ_TO_TTE {
	    my($x) = @_;
    	    eval q(((($x)&0x18)<<58));
	}' unless defined(&PMAP_SZ_TO_TTE);
	eval 'sub VA_ALIAS_MASK () {(1<< 13);}' unless defined(&VA_ALIAS_MASK);
	eval 'sub PMAP_WC () {0x20;}' unless defined(&PMAP_WC);
	if(defined(&_KERNEL)) {
	    if(defined(&PMAP_COUNT_DEBUG)) {
		eval 'sub pmap_resident_count {
		    my($pm) = @_;
    		    eval q( &pmap_count_res(($pm)));
		}' unless defined(&pmap_resident_count);
		eval 'sub pmap_wired_count {
		    my($pm) = @_;
    		    eval q( &pmap_count_wired(($pm)));
		}' unless defined(&pmap_wired_count);
	    } else {
		eval 'sub pmap_resident_count {
		    my($pm) = @_;
    		    eval q((($pm)-> ($pm_stats->{resident_count})));
		}' unless defined(&pmap_resident_count);
		eval 'sub pmap_wired_count {
		    my($pm) = @_;
    		    eval q((($pm)-> ($pm_stats->{wired_count})));
		}' unless defined(&pmap_wired_count);
	    }
	    eval 'sub pmap_phys_address {
	        my($x) = @_;
    		eval q(($x));
	    }' unless defined(&pmap_phys_address);
	    eval 'sub PMAP_PREFER {
	        my($fo, $va, $sz, $td) = @_;
    		eval q( &pmap_prefer(($fo), ($va), ($td)));
	    }' unless defined(&PMAP_PREFER);
	    eval 'sub pmap_prefer {
	        my($fo,$va,$td) = @_;
    		eval q({  &vaddr_t  &newva;  &vaddr_t  &m;  &m = 2*  &PAGE_SIZE;  &newva = (*$va & ~( &m - 1)) | ($fo & ( &m - 1));  &if ($td) {  &if ( &newva > *$va)  &newva -=  &m; }  &else {  &if ( &newva < *$va)  &newva +=  &m; } *$va =  &newva; });
	    }' unless defined(&pmap_prefer);
	    eval 'sub PMAP_GROWKERNEL () {1;}' unless defined(&PMAP_GROWKERNEL);
	    eval 'sub PMAP_NEED_PROCWR () {1;}' unless defined(&PMAP_NEED_PROCWR);
	    if(defined(&SUN4V)) {
	    }
	    eval 'sub __HAVE_VM_PAGE_MD () {1;}' unless defined(&__HAVE_VM_PAGE_MD);
	    eval 'sub VM_MDPAGE_INIT {
	        my($pg) = @_;
    		eval q( &do { ($pg)-> ($mdpage->{mdpg_pvh}->{pv_next}) =  &NULL; ($pg)-> ($mdpage->{mdpg_pvh}->{pv_pmap}) =  &NULL; ($pg)-> ($mdpage->{mdpg_pvh}->{pv_va}) = 0; }  &while ( 0));
	    }' unless defined(&VM_MDPAGE_INIT);
	    if(defined(&MULTIPROCESSOR)) {
		eval 'sub pmap_ctx_cpu {
		    my($PM, $C) = @_;
    		    eval q((($PM)-> $pm_ctx[($C)]));
		}' unless defined(&pmap_ctx_cpu);
		eval 'sub pmap_ctx {
		    my($PM) = @_;
    		    eval q( &pmap_ctx_cpu(($PM),  &cpu_number()));
		}' unless defined(&pmap_ctx);
	    } else {
		eval 'sub pmap_ctx {
		    my($PM) = @_;
    		    eval q((($PM)-> $pm_ctx[0]));
		}' unless defined(&pmap_ctx);
	    }
	}
    }
}
1;
