require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SPARC_CTLREG_H_)) {
    eval 'sub _SPARC_CTLREG_H_ () {1;}' unless defined(&_SPARC_CTLREG_H_);
    eval 'sub ASI_LITTLE () {0x8;}' unless defined(&ASI_LITTLE);
    eval 'sub ASI_NUCLEUS () {0x4;}' unless defined(&ASI_NUCLEUS);
    eval 'sub ASI_NUCLEUS_LITTLE () {0xc;}' unless defined(&ASI_NUCLEUS_LITTLE);
    eval 'sub ASI_AS_IF_USER_PRIMARY () {0x10;}' unless defined(&ASI_AS_IF_USER_PRIMARY);
    eval 'sub ASI_AS_IF_USER_SECONDARY () {0x11;}' unless defined(&ASI_AS_IF_USER_SECONDARY);
    eval 'sub ASI_PHYS_CACHED () {0x14;}' unless defined(&ASI_PHYS_CACHED);
    eval 'sub ASI_PHYS_NON_CACHED () {0x15;}' unless defined(&ASI_PHYS_NON_CACHED);
    eval 'sub ASI_AS_IF_USER_PRIMARY_LITTLE () {0x18;}' unless defined(&ASI_AS_IF_USER_PRIMARY_LITTLE);
    eval 'sub ASI_AS_IF_USER_SECONDARY_LITTLE () {0x19;}' unless defined(&ASI_AS_IF_USER_SECONDARY_LITTLE);
    eval 'sub ASI_PHYS_CACHED_LITTLE () {0x1c;}' unless defined(&ASI_PHYS_CACHED_LITTLE);
    eval 'sub ASI_PHYS_NON_CACHED_LITTLE () {0x1d;}' unless defined(&ASI_PHYS_NON_CACHED_LITTLE);
    eval 'sub ASI_MMU_CONTEXTID () {0x21;}' unless defined(&ASI_MMU_CONTEXTID);
    eval 'sub ASI_NUCLEUS_QUAD_LDD () {0x24;}' unless defined(&ASI_NUCLEUS_QUAD_LDD);
    eval 'sub ASI_QUEUE () {0x25;}' unless defined(&ASI_QUEUE);
    eval 'sub ASI_NUCLEUS_QUAD_LDD_LITTLE () {0x2c;}' unless defined(&ASI_NUCLEUS_QUAD_LDD_LITTLE);
    eval 'sub ASI_FLUSH_D_PAGE_PRIMARY () {0x38;}' unless defined(&ASI_FLUSH_D_PAGE_PRIMARY);
    eval 'sub ASI_FLUSH_D_PAGE_SECONDARY () {0x39;}' unless defined(&ASI_FLUSH_D_PAGE_SECONDARY);
    eval 'sub ASI_FLUSH_D_CTX_PRIMARY () {0x3a;}' unless defined(&ASI_FLUSH_D_CTX_PRIMARY);
    eval 'sub ASI_FLUSH_D_CTX_SECONDARY () {0x3b;}' unless defined(&ASI_FLUSH_D_CTX_SECONDARY);
    eval 'sub ASI_DCACHE_INVALIDATE () {0x42;}' unless defined(&ASI_DCACHE_INVALIDATE);
    eval 'sub ASI_DCACHE_UTAG () {0x43;}' unless defined(&ASI_DCACHE_UTAG);
    eval 'sub ASI_DCACHE_SNOOP_TAG () {0x44;}' unless defined(&ASI_DCACHE_SNOOP_TAG);
    eval 'sub ASI_LSU_CONTROL_REGISTER () {0x45;}' unless defined(&ASI_LSU_CONTROL_REGISTER);
    eval 'sub ASI_DCACHE_DATA () {0x46;}' unless defined(&ASI_DCACHE_DATA);
    eval 'sub ASI_DCACHE_TAG () {0x47;}' unless defined(&ASI_DCACHE_TAG);
    eval 'sub ASI_INTR_DISPATCH_STATUS () {0x48;}' unless defined(&ASI_INTR_DISPATCH_STATUS);
    eval 'sub ASI_INTR_RECEIVE () {0x49;}' unless defined(&ASI_INTR_RECEIVE);
    eval 'sub ASI_MID_REG () {0x4a;}' unless defined(&ASI_MID_REG);
    eval 'sub ASI_ERROR_EN_REG () {0x4b;}' unless defined(&ASI_ERROR_EN_REG);
    eval 'sub ASI_AFSR () {0x4c;}' unless defined(&ASI_AFSR);
    eval 'sub ASI_AFAR () {0x4d;}' unless defined(&ASI_AFAR);
    eval 'sub ASI_ICACHE_DATA () {0x66;}' unless defined(&ASI_ICACHE_DATA);
    eval 'sub ASI_ICACHE_TAG () {0x67;}' unless defined(&ASI_ICACHE_TAG);
    eval 'sub ASI_FLUSH_I_PAGE_PRIMARY () {0x68;}' unless defined(&ASI_FLUSH_I_PAGE_PRIMARY);
    eval 'sub ASI_FLUSH_I_PAGE_SECONDARY () {0x69;}' unless defined(&ASI_FLUSH_I_PAGE_SECONDARY);
    eval 'sub ASI_FLUSH_I_CTX_PRIMARY () {0x6a;}' unless defined(&ASI_FLUSH_I_CTX_PRIMARY);
    eval 'sub ASI_FLUSH_I_CTX_SECONDARY () {0x6b;}' unless defined(&ASI_FLUSH_I_CTX_SECONDARY);
    eval 'sub ASI_BLOCK_AS_IF_USER_PRIMARY () {0x70;}' unless defined(&ASI_BLOCK_AS_IF_USER_PRIMARY);
    eval 'sub ASI_BLOCK_AS_IF_USER_SECONDARY () {0x71;}' unless defined(&ASI_BLOCK_AS_IF_USER_SECONDARY);
    eval 'sub ASI_ECACHE_DIAG () {0x76;}' unless defined(&ASI_ECACHE_DIAG);
    eval 'sub ASI_DATAPATH_ERR_REG_WRITE () {0x77;}' unless defined(&ASI_DATAPATH_ERR_REG_WRITE);
    eval 'sub ASI_BLOCK_AS_IF_USER_PRIMARY_LITTLE () {0x78;}' unless defined(&ASI_BLOCK_AS_IF_USER_PRIMARY_LITTLE);
    eval 'sub ASI_BLOCK_AS_IF_USER_SECONDARY_LITTLE () {0x79;}' unless defined(&ASI_BLOCK_AS_IF_USER_SECONDARY_LITTLE);
    eval 'sub ASI_INTERRUPT_RECEIVE_DATA () {0x7f;}' unless defined(&ASI_INTERRUPT_RECEIVE_DATA);
    eval 'sub ASI_DATAPATH_ERR_REG_READ () {0x7f;}' unless defined(&ASI_DATAPATH_ERR_REG_READ);
    eval 'sub ASI_PRIMARY () {0x80;}' unless defined(&ASI_PRIMARY);
    eval 'sub ASI_SECONDARY () {0x81;}' unless defined(&ASI_SECONDARY);
    eval 'sub ASI_PRIMARY_NOFAULT () {0x82;}' unless defined(&ASI_PRIMARY_NOFAULT);
    eval 'sub ASI_SECONDARY_NOFAULT () {0x83;}' unless defined(&ASI_SECONDARY_NOFAULT);
    eval 'sub ASI_PRIMARY_LITTLE () {0x88;}' unless defined(&ASI_PRIMARY_LITTLE);
    eval 'sub ASI_SECONDARY_LITTLE () {0x89;}' unless defined(&ASI_SECONDARY_LITTLE);
    eval 'sub ASI_PRIMARY_NOFAULT_LITTLE () {0x8a;}' unless defined(&ASI_PRIMARY_NOFAULT_LITTLE);
    eval 'sub ASI_SECONDARY_NOFAULT_LITTLE () {0x8b;}' unless defined(&ASI_SECONDARY_NOFAULT_LITTLE);
    eval 'sub ASI_PST8_PRIMARY () {0xc0;}' unless defined(&ASI_PST8_PRIMARY);
    eval 'sub ASI_PST8_SECONDARY () {0xc1;}' unless defined(&ASI_PST8_SECONDARY);
    eval 'sub ASI_PST16_PRIMARY () {0xc2;}' unless defined(&ASI_PST16_PRIMARY);
    eval 'sub ASI_PST16_SECONDARY () {0xc3;}' unless defined(&ASI_PST16_SECONDARY);
    eval 'sub ASI_PST32_PRIMARY () {0xc4;}' unless defined(&ASI_PST32_PRIMARY);
    eval 'sub ASI_PST32_SECONDARY () {0xc5;}' unless defined(&ASI_PST32_SECONDARY);
    eval 'sub ASI_PST8_PRIMARY_LITTLE () {0xc8;}' unless defined(&ASI_PST8_PRIMARY_LITTLE);
    eval 'sub ASI_PST8_SECONDARY_LITTLE () {0xc9;}' unless defined(&ASI_PST8_SECONDARY_LITTLE);
    eval 'sub ASI_PST16_PRIMARY_LITTLE () {0xca;}' unless defined(&ASI_PST16_PRIMARY_LITTLE);
    eval 'sub ASI_PST16_SECONDARY_LITTLE () {0xcb;}' unless defined(&ASI_PST16_SECONDARY_LITTLE);
    eval 'sub ASI_PST32_PRIMARY_LITTLE () {0xcc;}' unless defined(&ASI_PST32_PRIMARY_LITTLE);
    eval 'sub ASI_PST32_SECONDARY_LITTLE () {0xcd;}' unless defined(&ASI_PST32_SECONDARY_LITTLE);
    eval 'sub ASI_FL8_PRIMARY () {0xd0;}' unless defined(&ASI_FL8_PRIMARY);
    eval 'sub ASI_FL8_SECONDARY () {0xd1;}' unless defined(&ASI_FL8_SECONDARY);
    eval 'sub ASI_FL16_PRIMARY () {0xd2;}' unless defined(&ASI_FL16_PRIMARY);
    eval 'sub ASI_FL16_SECONDARY () {0xd3;}' unless defined(&ASI_FL16_SECONDARY);
    eval 'sub ASI_FL8_PRIMARY_LITTLE () {0xd8;}' unless defined(&ASI_FL8_PRIMARY_LITTLE);
    eval 'sub ASI_FL8_SECONDARY_LITTLE () {0xd9;}' unless defined(&ASI_FL8_SECONDARY_LITTLE);
    eval 'sub ASI_FL16_PRIMARY_LITTLE () {0xda;}' unless defined(&ASI_FL16_PRIMARY_LITTLE);
    eval 'sub ASI_FL16_SECONDARY_LITTLE () {0xdb;}' unless defined(&ASI_FL16_SECONDARY_LITTLE);
    eval 'sub ASI_BLOCK_COMMIT_PRIMARY () {0xe0;}' unless defined(&ASI_BLOCK_COMMIT_PRIMARY);
    eval 'sub ASI_BLOCK_COMMIT_SECONDARY () {0xe1;}' unless defined(&ASI_BLOCK_COMMIT_SECONDARY);
    eval 'sub ASI_BLOCK_PRIMARY () {0xf0;}' unless defined(&ASI_BLOCK_PRIMARY);
    eval 'sub ASI_BLOCK_SECONDARY () {0xf1;}' unless defined(&ASI_BLOCK_SECONDARY);
    eval 'sub ASI_BLOCK_PRIMARY_LITTLE () {0xf8;}' unless defined(&ASI_BLOCK_PRIMARY_LITTLE);
    eval 'sub ASI_BLOCK_SECONDARY_LITTLE () {0xf9;}' unless defined(&ASI_BLOCK_SECONDARY_LITTLE);
    eval 'sub ASI_N () { &ASI_NUCLEUS;}' unless defined(&ASI_N);
    eval 'sub ASI_NL () { &ASI_NUCLEUS_LITTLE;}' unless defined(&ASI_NL);
    eval 'sub ASI_AIUP () { &ASI_AS_IF_USER_PRIMARY;}' unless defined(&ASI_AIUP);
    eval 'sub ASI_AIUS () { &ASI_AS_IF_USER_SECONDARY;}' unless defined(&ASI_AIUS);
    eval 'sub ASI_AIUPL () { &ASI_AS_IF_USER_PRIMARY_LITTLE;}' unless defined(&ASI_AIUPL);
    eval 'sub ASI_AIUSL () { &ASI_AS_IF_USER_SECONDARY_LITTLE;}' unless defined(&ASI_AIUSL);
    eval 'sub ASI_P () { &ASI_PRIMARY;}' unless defined(&ASI_P);
    eval 'sub ASI_S () { &ASI_SECONDARY;}' unless defined(&ASI_S);
    eval 'sub ASI_PNF () { &ASI_PRIMARY_NOFAULT;}' unless defined(&ASI_PNF);
    eval 'sub ASI_SNF () { &ASI_SECONDARY_NOFAULT;}' unless defined(&ASI_SNF);
    eval 'sub ASI_PL () { &ASI_PRIMARY_LITTLE;}' unless defined(&ASI_PL);
    eval 'sub ASI_SL () { &ASI_SECONDARY_LITTLE;}' unless defined(&ASI_SL);
    eval 'sub ASI_PNFL () { &ASI_PRIMARY_NOFAULT_LITTLE;}' unless defined(&ASI_PNFL);
    eval 'sub ASI_SNFL () { &ASI_SECONDARY_NOFAULT_LITTLE;}' unless defined(&ASI_SNFL);
    eval 'sub ASI_FL8_P () { &ASI_FL8_PRIMARY;}' unless defined(&ASI_FL8_P);
    eval 'sub ASI_FL8_S () { &ASI_FL8_SECONDARY;}' unless defined(&ASI_FL8_S);
    eval 'sub ASI_FL16_P () { &ASI_FL16_PRIMARY;}' unless defined(&ASI_FL16_P);
    eval 'sub ASI_FL16_S () { &ASI_FL16_SECONDARY;}' unless defined(&ASI_FL16_S);
    eval 'sub ASI_FL8_PL () { &ASI_FL8_PRIMARY_LITTLE;}' unless defined(&ASI_FL8_PL);
    eval 'sub ASI_FL8_SL () { &ASI_FL8_SECONDARY_LITTLE;}' unless defined(&ASI_FL8_SL);
    eval 'sub ASI_FL16_PL () { &ASI_FL16_PRIMARY_LITTLE;}' unless defined(&ASI_FL16_PL);
    eval 'sub ASI_FL16_SL () { &ASI_FL16_SECONDARY_LITTLE;}' unless defined(&ASI_FL16_SL);
    eval 'sub ASI_BLK_AIUP () { &ASI_BLOCK_AS_IF_USER_PRIMARY;}' unless defined(&ASI_BLK_AIUP);
    eval 'sub ASI_BLK_AIUPL () { &ASI_BLOCK_AS_IF_USER_PRIMARY_LITTLE;}' unless defined(&ASI_BLK_AIUPL);
    eval 'sub ASI_BLK_AIUS () { &ASI_BLOCK_AS_IF_USER_SECONDARY;}' unless defined(&ASI_BLK_AIUS);
    eval 'sub ASI_BLK_AIUSL () { &ASI_BLOCK_AS_IF_USER_SECONDARY_LITTLE;}' unless defined(&ASI_BLK_AIUSL);
    eval 'sub ASI_BLK_COMMIT_P () { &ASI_BLOCK_COMMIT_PRIMARY;}' unless defined(&ASI_BLK_COMMIT_P);
    eval 'sub ASI_BLK_COMMIT_PRIMARY () { &ASI_BLOCK_COMMIT_PRIMARY;}' unless defined(&ASI_BLK_COMMIT_PRIMARY);
    eval 'sub ASI_BLK_COMMIT_S () { &ASI_BLOCK_COMMIT_SECONDARY;}' unless defined(&ASI_BLK_COMMIT_S);
    eval 'sub ASI_BLK_COMMIT_SECONDARY () { &ASI_BLOCK_COMMIT_SECONDARY;}' unless defined(&ASI_BLK_COMMIT_SECONDARY);
    eval 'sub ASI_BLK_P () { &ASI_BLOCK_PRIMARY;}' unless defined(&ASI_BLK_P);
    eval 'sub ASI_BLK_PL () { &ASI_BLOCK_PRIMARY_LITTLE;}' unless defined(&ASI_BLK_PL);
    eval 'sub ASI_BLK_S () { &ASI_BLOCK_SECONDARY;}' unless defined(&ASI_BLK_S);
    eval 'sub ASI_BLK_SL () { &ASI_BLOCK_SECONDARY_LITTLE;}' unless defined(&ASI_BLK_SL);
    eval 'sub ASI_PRIMARY_NO_FAULT () { &ASI_PRIMARY_NOFAULT;}' unless defined(&ASI_PRIMARY_NO_FAULT);
    eval 'sub ASI_PRIMARY_NO_FAULT_LITTLE () { &ASI_PRIMARY_NOFAULT_LITTLE;}' unless defined(&ASI_PRIMARY_NO_FAULT_LITTLE);
    eval 'sub ASI_SECONDARY_NO_FAULT () { &ASI_SECONDARY_NOFAULT;}' unless defined(&ASI_SECONDARY_NO_FAULT);
    eval 'sub ASI_SECONDARY_NO_FAULT_LITTLE () { &ASI_SECONDARY_NOFAULT_LITTLE;}' unless defined(&ASI_SECONDARY_NO_FAULT_LITTLE);
    eval 'sub PHYS_ASI {
        my($x) = @_;
	    eval q(((($x) | 0x9) == 0x1d));
    }' unless defined(&PHYS_ASI);
    eval 'sub LITTLE_ASI {
        my($x) = @_;
	    eval q((($x) &  &ASI_LITTLE));
    }' unless defined(&LITTLE_ASI);
    eval 'sub UPA_CR_MID_SHIFT () {(17);}' unless defined(&UPA_CR_MID_SHIFT);
    eval 'sub UPA_CR_MID_SIZE () {(5);}' unless defined(&UPA_CR_MID_SIZE);
    eval 'sub UPA_CR_MID_MASK () {(((1<<  &UPA_CR_MID_SIZE) - 1) <<  &UPA_CR_MID_SHIFT);}' unless defined(&UPA_CR_MID_MASK);
    eval 'sub UPA_CR_MID {
        my($x) = @_;
	    eval q(((($x)>> &UPA_CR_MID_SHIFT)((1<<  &UPA_CR_MID_SIZE) - 1)));
    }' unless defined(&UPA_CR_MID);
    if(defined(&_LOCORE)) {
	eval 'sub UPA_GET_MID {
	    my($r1) = @_;
    	    eval q( &ldxa [% &g0]  &ASI_MID_REG, $r1 ;  &srlx $r1,  &UPA_CR_MID_SHIFT, $r1 ;  &and $r1, (1<<  &UPA_CR_MID_SIZE) - 1, $r1);
	}' unless defined(&UPA_GET_MID);
    } else {
	eval 'sub CPU_UPAID () { &UPA_CR_MID( &ldxa(0,  &ASI_MID_REG));}' unless defined(&CPU_UPAID);
    }
    eval 'sub FIREPLANE_CR_AID {
        my($x) = @_;
	    eval q(((($x) >> 17) & 0x3ff));
    }' unless defined(&FIREPLANE_CR_AID);
    eval 'sub CPU_FIREPLANEID () { &FIREPLANE_CR_AID( &ldxa(0,  &ASI_MID_REG));}' unless defined(&CPU_FIREPLANEID);
    eval 'sub JUPITER_CR_ITID {
        my($x) = @_;
	    eval q((($x) & 0x3ff));
    }' unless defined(&JUPITER_CR_ITID);
    eval 'sub CPU_JUPITERID () { &JUPITER_CR_ITID( &ldxa(0,  &ASI_MID_REG));}' unless defined(&CPU_JUPITERID);
    eval 'sub ASI_MCCR () { &ASI_LSU_CONTROL_REGISTER;}' unless defined(&ASI_MCCR);
    eval 'sub MCCR () {0x;}' unless defined(&MCCR);
    eval 'sub MCCR_DMMU_EN () {0x8;}' unless defined(&MCCR_DMMU_EN);
    eval 'sub MCCR_IMMU_EN () {0x4;}' unless defined(&MCCR_IMMU_EN);
    eval 'sub MCCR_DCACHE_EN () {0x2;}' unless defined(&MCCR_DCACHE_EN);
    eval 'sub MCCR_ICACHE_EN () {0x1;}' unless defined(&MCCR_ICACHE_EN);
    eval 'sub MCCR_RAW_EN () {0x400000000000;}' unless defined(&MCCR_RAW_EN);
    eval 'sub ASI_DMMU () {0x58;}' unless defined(&ASI_DMMU);
    eval 'sub ASI_IMMU () {0x50;}' unless defined(&ASI_IMMU);
    eval 'sub ASI_IMMU_8KPTR () {0x51;}' unless defined(&ASI_IMMU_8KPTR);
    eval 'sub ASI_IMMU_64KPTR () {0x52;}' unless defined(&ASI_IMMU_64KPTR);
    eval 'sub ASI_IMMU_DATA_IN () {0x54;}' unless defined(&ASI_IMMU_DATA_IN);
    eval 'sub ASI_IMMU_TLB_DATA () {0x55;}' unless defined(&ASI_IMMU_TLB_DATA);
    eval 'sub ASI_IMMU_TLB_TAG () {0x56;}' unless defined(&ASI_IMMU_TLB_TAG);
    eval 'sub ASI_DMMU_8KPTR () {0x59;}' unless defined(&ASI_DMMU_8KPTR);
    eval 'sub ASI_DMMU_64KPTR () {0x5a;}' unless defined(&ASI_DMMU_64KPTR);
    eval 'sub ASI_DMMU_DATA_IN () {0x5c;}' unless defined(&ASI_DMMU_DATA_IN);
    eval 'sub ASI_DMMU_TLB_DATA () {0x5d;}' unless defined(&ASI_DMMU_TLB_DATA);
    eval 'sub ASI_DMMU_TLB_TAG () {0x5e;}' unless defined(&ASI_DMMU_TLB_TAG);
    eval 'sub TSB_TAG_TARGET () {0x;}' unless defined(&TSB_TAG_TARGET);
    eval 'sub TLB_DATA_IN () {0x;}' unless defined(&TLB_DATA_IN);
    eval 'sub CTX_PRIMARY () {0x8;}' unless defined(&CTX_PRIMARY);
    eval 'sub CTX_SECONDARY () {0x10;}' unless defined(&CTX_SECONDARY);
    eval 'sub SFSR () {0x18;}' unless defined(&SFSR);
    eval 'sub SFAR () {0x20;}' unless defined(&SFAR);
    eval 'sub TSB () {0x28;}' unless defined(&TSB);
    eval 'sub TLB_TAG_ACCESS () {0x30;}' unless defined(&TLB_TAG_ACCESS);
    eval 'sub VIRTUAL_WATCHPOINT () {0x38;}' unless defined(&VIRTUAL_WATCHPOINT);
    eval 'sub PHYSICAL_WATCHPOINT () {0x40;}' unless defined(&PHYSICAL_WATCHPOINT);
    eval 'sub TSB_PEXT () {0x48;}' unless defined(&TSB_PEXT);
    eval 'sub TSB_SEXT () {0x50;}' unless defined(&TSB_SEXT);
    eval 'sub TSB_NEXT () {0x58;}' unless defined(&TSB_NEXT);
    eval 'sub TAG_TARGET_VA_MASK () {0x3ffffffffffffffff;}' unless defined(&TAG_TARGET_VA_MASK);
    eval 'sub TAG_TARGET_VA {
        my($x) = @_;
	    eval q(((($x)<<22) &TAG_TARGET_VA_MASK));
    }' unless defined(&TAG_TARGET_VA);
    eval 'sub TAG_TARGET_CONTEXT {
        my($x) = @_;
	    eval q((($x)>>48));
    }' unless defined(&TAG_TARGET_CONTEXT);
    eval 'sub TAG_TARGET {
        my($c,$v) = @_;
	    eval q((((( &uint64_t)$c)<<48)|((( &uint64_t)$v) &TAG_TARGET_VA_MASK)));
    }' unless defined(&TAG_TARGET);
    eval 'sub SFSR_ASI {
        my($x) = @_;
	    eval q((($x)>>16));
    }' unless defined(&SFSR_ASI);
    eval 'sub SFSR_FT_VA_OOR_2 () {0x2000;}' unless defined(&SFSR_FT_VA_OOR_2);
    eval 'sub SFSR_FT_VA_OOR_1 () {0x1000;}' unless defined(&SFSR_FT_VA_OOR_1);
    eval 'sub SFSR_FT_NFO () {0x800;}' unless defined(&SFSR_FT_NFO);
    eval 'sub SFSR_ILL_ASI () {0x400;}' unless defined(&SFSR_ILL_ASI);
    eval 'sub SFSR_FT_IO_ATOMIC () {0x200;}' unless defined(&SFSR_FT_IO_ATOMIC);
    eval 'sub SFSR_FT_ILL_NF () {0x100;}' unless defined(&SFSR_FT_ILL_NF);
    eval 'sub SFSR_FT_PRIV () {0x80;}' unless defined(&SFSR_FT_PRIV);
    eval 'sub SFSR_FT_E () {0x40;}' unless defined(&SFSR_FT_E);
    eval 'sub SFSR_CTXT {
        my($x) = @_;
	    eval q(((($x)>>4)&0x3));
    }' unless defined(&SFSR_CTXT);
    eval 'sub SFSR_CTXT_IS_PRIM {
        my($x) = @_;
	    eval q(( &SFSR_CTXT($x)==0x));
    }' unless defined(&SFSR_CTXT_IS_PRIM);
    eval 'sub SFSR_CTXT_IS_SECOND {
        my($x) = @_;
	    eval q(( &SFSR_CTXT($x)==0x1));
    }' unless defined(&SFSR_CTXT_IS_SECOND);
    eval 'sub SFSR_CTXT_IS_NUCLEUS {
        my($x) = @_;
	    eval q(( &SFSR_CTXT($x)==0x2));
    }' unless defined(&SFSR_CTXT_IS_NUCLEUS);
    eval 'sub SFSR_PRIV () {0x8;}' unless defined(&SFSR_PRIV);
    eval 'sub SFSR_W () {0x4;}' unless defined(&SFSR_W);
    eval 'sub SFSR_OW () {0x2;}' unless defined(&SFSR_OW);
    eval 'sub SFSR_FV () {0x1;}' unless defined(&SFSR_FV);
    eval 'sub SFSR_FT () {( &SFSR_FT_VA_OOR_2| &SFSR_FT_VA_OOR_1| &SFSR_FT_NFO|  &SFSR_ILL_ASI| &SFSR_FT_IO_ATOMIC| &SFSR_FT_ILL_NF| &SFSR_FT_PRIV);}' unless defined(&SFSR_FT);
    eval 'sub SFSR_BITS () {"\\177\\20" "f\\20\\30ASI\\0" "b\\16VAT\\0" "b\\15VAD\\0" "b\\14NFO\\0" "b\\13ASI\\0" "b\\12A\\0" "b\\11NF\\0" "b\\10PRIV\\0" "b\\7E\\0" "b\\6NUCLEUS\\0" "b\\5SECONDCTX\\0" "b\\4PRIV\\0" "b\\3W\\0" "b\\2OW\\0" "b\\1FV\\0";}' unless defined(&SFSR_BITS);
    eval 'sub ASFR_ME () {0x100000000;}' unless defined(&ASFR_ME);
    eval 'sub ASFR_PRIV () {0x80000000;}' unless defined(&ASFR_PRIV);
    eval 'sub ASFR_ISAP () {0x40000000;}' unless defined(&ASFR_ISAP);
    eval 'sub ASFR_ETP () {0x20000000;}' unless defined(&ASFR_ETP);
    eval 'sub ASFR_IVUE () {0x10000000;}' unless defined(&ASFR_IVUE);
    eval 'sub ASFR_TO () {0x8000000;}' unless defined(&ASFR_TO);
    eval 'sub ASFR_BERR () {0x4000000;}' unless defined(&ASFR_BERR);
    eval 'sub ASFR_LDP () {0x2000000;}' unless defined(&ASFR_LDP);
    eval 'sub ASFR_CP () {0x1000000;}' unless defined(&ASFR_CP);
    eval 'sub ASFR_WP () {0x800000;}' unless defined(&ASFR_WP);
    eval 'sub ASFR_EDP () {0x400000;}' unless defined(&ASFR_EDP);
    eval 'sub ASFR_UE () {0x200000;}' unless defined(&ASFR_UE);
    eval 'sub ASFR_CE () {0x100000;}' unless defined(&ASFR_CE);
    eval 'sub ASFR_ETS () {0xf0000;}' unless defined(&ASFR_ETS);
    eval 'sub ASFT_P_SYND () {0xffff;}' unless defined(&ASFT_P_SYND);
    eval 'sub AFSR_BITS () {"\\177\\20" "b\\40ME\\0" "b\\37PRIV\\0" "b\\36ISAP\\0" "b\\35ETP\\0" "b\\34IVUE\\0" "b\\33TO\\0" "b\\32BERR\\0" "b\\31LDP\\0" "b\\30CP\\0" "b\\27WP\\0" "b\\26EDP\\0" "b\\25UE\\0" "b\\24CE\\0" "f\\20\\4ETS\\0" "f\\0\\20P_SYND\\0";}' unless defined(&AFSR_BITS);
    eval 'sub TSB_SIZE_512 () {0x;}' unless defined(&TSB_SIZE_512);
    eval 'sub TSB_SIZE_1K () {0x1;}' unless defined(&TSB_SIZE_1K);
    eval 'sub TSB_SIZE_2K () {0x2;}' unless defined(&TSB_SIZE_2K);
    eval 'sub TSB_SIZE_4K () {0x3;}' unless defined(&TSB_SIZE_4K);
    eval 'sub TSB_SIZE_8K () {0x4;}' unless defined(&TSB_SIZE_8K);
    eval 'sub TSB_SIZE_16K () {0x5;}' unless defined(&TSB_SIZE_16K);
    eval 'sub TSB_SIZE_32K () {0x6;}' unless defined(&TSB_SIZE_32K);
    eval 'sub TSB_SIZE_64K () {0x7;}' unless defined(&TSB_SIZE_64K);
    eval 'sub TSB_SPLIT () {0x1000;}' unless defined(&TSB_SPLIT);
    eval 'sub TSB_BASE () {0xffffffffffffe000;}' unless defined(&TSB_BASE);
    eval 'sub TLB_TAG_ACCESS_VA () {0xffffffffffffe000;}' unless defined(&TLB_TAG_ACCESS_VA);
    eval 'sub TLB_TAG_ACCESS_CTX () {0x1fff;}' unless defined(&TLB_TAG_ACCESS_CTX);
    eval 'sub ASI_IMMU_DEMAP () {0x57;}' unless defined(&ASI_IMMU_DEMAP);
    eval 'sub ASI_DMMU_DEMAP () {0x5f;}' unless defined(&ASI_DMMU_DEMAP);
    eval 'sub DEMAP_PAGE_NUCLEUS () {((0x2)<<4);}' unless defined(&DEMAP_PAGE_NUCLEUS);
    eval 'sub DEMAP_PAGE_PRIMARY () {((0x)<<4);}' unless defined(&DEMAP_PAGE_PRIMARY);
    eval 'sub DEMAP_PAGE_SECONDARY () {((0x1)<<4);}' unless defined(&DEMAP_PAGE_SECONDARY);
    eval 'sub DEMAP_CTX_NUCLEUS () {((0x6)<<4);}' unless defined(&DEMAP_CTX_NUCLEUS);
    eval 'sub DEMAP_CTX_PRIMARY () {((0x4)<<4);}' unless defined(&DEMAP_CTX_PRIMARY);
    eval 'sub DEMAP_CTX_SECONDARY () {((0x5)<<4);}' unless defined(&DEMAP_CTX_SECONDARY);
    eval 'sub DEMAP_ALL () {((0x8)<<4);}' unless defined(&DEMAP_ALL);
    eval 'sub TLB_SIZE_SPITFIRE () {64;}' unless defined(&TLB_SIZE_SPITFIRE);
    eval 'sub TLB_SIZE_CHEETAH_I16 () {16;}' unless defined(&TLB_SIZE_CHEETAH_I16);
    eval 'sub TLB_SIZE_CHEETAH_I128 () {128;}' unless defined(&TLB_SIZE_CHEETAH_I128);
    eval 'sub TLB_SIZE_CHEETAH_D16 () {16;}' unless defined(&TLB_SIZE_CHEETAH_D16);
    eval 'sub TLB_SIZE_CHEETAH_D512_0 () {512;}' unless defined(&TLB_SIZE_CHEETAH_D512_0);
    eval 'sub TLB_SIZE_CHEETAH_D512_1 () {512;}' unless defined(&TLB_SIZE_CHEETAH_D512_1);
    eval 'sub TLB_CHEETAH_I16 () {(0<< 16);}' unless defined(&TLB_CHEETAH_I16);
    eval 'sub TLB_CHEETAH_I128 () {(2<< 16);}' unless defined(&TLB_CHEETAH_I128);
    eval 'sub TLB_CHEETAH_D16 () {(0<< 16);}' unless defined(&TLB_CHEETAH_D16);
    eval 'sub TLB_CHEETAH_D512_0 () {(2<< 16);}' unless defined(&TLB_CHEETAH_D512_0);
    eval 'sub TLB_CHEETAH_D512_1 () {(3<< 16);}' unless defined(&TLB_CHEETAH_D512_1);
    eval 'sub ASI_IRSR () {0x49;}' unless defined(&ASI_IRSR);
    eval 'sub IRSR () {0x;}' unless defined(&IRSR);
    eval 'sub IRSR_BUSY () {0x20;}' unless defined(&IRSR_BUSY);
    eval 'sub IRSR_MID {
        my($x) = @_;
	    eval q(($x&0x1f));
    }' unless defined(&IRSR_MID);
    eval 'sub ASI_IRDR () {0x7f;}' unless defined(&ASI_IRDR);
    eval 'sub IRDR_0H () {0x40;}' unless defined(&IRDR_0H);
    eval 'sub IRDR_0L () {0x48;}' unless defined(&IRDR_0L);
    eval 'sub IRDR_1H () {0x50;}' unless defined(&IRDR_1H);
    eval 'sub IRDR_1L () {0x58;}' unless defined(&IRDR_1L);
    eval 'sub IRDR_2H () {0x60;}' unless defined(&IRDR_2H);
    eval 'sub IRDR_2L () {0x68;}' unless defined(&IRDR_2L);
    eval 'sub IRDR_3H () {0x70;}' unless defined(&IRDR_3H);
    eval 'sub IRDR_3L () {0x78;}' unless defined(&IRDR_3L);
    eval 'sub ASI_IDSR () {0x48;}' unless defined(&ASI_IDSR);
    eval 'sub IDSR () {0x;}' unless defined(&IDSR);
    eval 'sub IDSR_NACK () {0x2;}' unless defined(&IDSR_NACK);
    eval 'sub IDSR_BUSY () {0x1;}' unless defined(&IDSR_BUSY);
    eval 'sub ASI_INTERRUPT_DISPATCH () {0x77;}' unless defined(&ASI_INTERRUPT_DISPATCH);
    eval 'sub IDCR {
        my($x) = @_;
	    eval q((((( &uint64_t)($x)) << 14) | 0x70));
    }' unless defined(&IDCR);
    eval 'sub IDDR_0H () {0x40;}' unless defined(&IDDR_0H);
    eval 'sub IDDR_0L () {0x48;}' unless defined(&IDDR_0L);
    eval 'sub IDDR_1H () {0x50;}' unless defined(&IDDR_1H);
    eval 'sub IDDR_1L () {0x58;}' unless defined(&IDDR_1L);
    eval 'sub IDDR_2H () {0x60;}' unless defined(&IDDR_2H);
    eval 'sub IDDR_2L () {0x68;}' unless defined(&IDDR_2L);
    eval 'sub IDDR_3H () {0x70;}' unless defined(&IDDR_3H);
    eval 'sub IDDR_3L () {0x78;}' unless defined(&IDDR_3L);
    eval 'sub ASI_AFAR () {0x4d;}' unless defined(&ASI_AFAR);
    eval 'sub AFAR () {0x;}' unless defined(&AFAR);
    eval 'sub ASI_AFSR () {0x4c;}' unless defined(&ASI_AFSR);
    eval 'sub AFSR () {0x;}' unless defined(&AFSR);
    eval 'sub ASI_P_EER () {0x4b;}' unless defined(&ASI_P_EER);
    eval 'sub P_EER () {0x;}' unless defined(&P_EER);
    eval 'sub P_EER_ISAPEN () {0x4;}' unless defined(&P_EER_ISAPEN);
    eval 'sub P_EER_NCEEN () {0x2;}' unless defined(&P_EER_NCEEN);
    eval 'sub P_EER_CEEN () {0x1;}' unless defined(&P_EER_CEEN);
    eval 'sub ASI_DATAPATH_READ () {0x7f;}' unless defined(&ASI_DATAPATH_READ);
    eval 'sub ASI_DATAPATH_WRITE () {0x77;}' unless defined(&ASI_DATAPATH_WRITE);
    eval 'sub P_DPER_0 () {0x;}' unless defined(&P_DPER_0);
    eval 'sub P_DPER_1 () {0x18;}' unless defined(&P_DPER_1);
    eval 'sub P_DCR_0 () {0x20;}' unless defined(&P_DCR_0);
    eval 'sub P_DCR_1 () {0x38;}' unless defined(&P_DCR_1);
    unless(defined(&_LOCORE)) {
	if(defined(&__arch64__)) {
	    eval 'sub SPARC64_LD_NONCONST {
	        my($ld, $type) = @_;
    		eval q( &__asm  &volatile( \\"wr %2,%%g0,%%asi;	\\" $ld \\" [%1]%%asi,%0	\\" : \\"=r\\" ( &_v) : \\"r\\" (( &__uintptr_t)( &loc)), \\"r\\" ( &asi), \\"m\\" (*($type *)( &__uintptr_t)( &loc))));
	    }' unless defined(&SPARC64_LD_NONCONST);
	    if(defined(&__GNUC__)  && defined(&__OPTIMIZE__)) {
		eval 'sub SPARC64_LD_DEF {
		    my($ld, $type, $vtype) = @_;
    		    eval q( &static  &__inline $type $ld( &paddr_t  &loc, \'int\'  &asi) { $vtype  &_v;  &if ( &__builtin_constant_p( &asi))  &__asm  &volatile( $ld \\" [%1]%2,%0		\\" : \\"=r\\" ( &_v) : \\"r\\" (( &__uintptr_t)( &loc)), \\"n\\" ( &asi), \\"m\\" (*($type *)( &__uintptr_t)( &loc)));  &else  &SPARC64_LD_NONCONST($ld, $type);  &return  &_v; });
		}' unless defined(&SPARC64_LD_DEF);
	    } else {
		eval 'sub SPARC64_LD_DEF {
		    my($ld, $type, $vtype) = @_;
    		    eval q( &static  &__inline $type $ld( &paddr_t  &loc, \'int\'  &asi) { $vtype  &_v;  &SPARC64_LD_NONCONST($ld, $type);  &return  &_v; });
		}' unless defined(&SPARC64_LD_DEF);
	    }
	    eval 'sub SPARC64_LD_DEF64 {
	        my($ld, $type) = @_;
    		eval q( &SPARC64_LD_DEF($ld, $type,  &uint64_t));
	    }' unless defined(&SPARC64_LD_DEF64);
	} else {
	    eval 'sub SPARC64_LD_PHYS_NONCONST {
	        my($ld) = @_;
    		eval q( &__asm  &volatile( \\"clruw %2;		\\" \\"rdpr %%pstate,%1;	\\" \\"sllx %3,32,%0;		\\" \\"wrpr %1,8,%%pstate;	\\" \\"or %0,%2,%0;		\\" \\"wr %4,%%g0,%%asi;	\\" $ld \\" [%0]%%asi,%0;	\\" \\"wrpr %1,0,%%pstate	\\" : \\"=&r\\" ( &_v), \\"=&r\\" ( &_pstate) : \\"r\\" (( &uint32_t)( &loc)), \\"r\\" ( &_hi), \\"r\\" ( &asi)));
	    }' unless defined(&SPARC64_LD_PHYS_NONCONST);
	    eval 'sub SPARC64_LD_NONCONST {
	        my($ld) = @_;
    		eval q( &__asm  &volatile( \\"wr %2,%%g0,%%asi;	\\" $ld \\" [%1]%%asi,%0	\\" : \\"=&r\\" ( &_v) : \\"r\\" (( &uint32_t)( &loc)), \\"r\\" ( &asi)));
	    }' unless defined(&SPARC64_LD_NONCONST);
	    eval 'sub SPARC64_LD_PHYS_NONCONST64 {
	        my($ld) = @_;
    		eval q( &__asm  &volatile( \\"clruw %2;		\\" \\"rdpr %%pstate,%1;	\\" \\"sllx %3,32,%0;		\\" \\"wrpr %1,8,%%pstate;	\\" \\"or %0,%2,%0;		\\" \\"wr %4,%%g0,%%asi;	\\" $ld \\" [%0]%%asi,%0;	\\" \\"wrpr %1,0,%%pstate;	\\" \\"srlx %0,32,%1;		\\" \\"srl %0,0,%0		\\" : \\"=&r\\" ( &_vlo), \\"=&r\\" ( &_vhi) : \\"r\\" (( &uint32_t)( &loc)), \\"r\\" ( &_hi), \\"r\\" ( &asi)));
	    }' unless defined(&SPARC64_LD_PHYS_NONCONST64);
	    eval 'sub SPARC64_LD_NONCONST64 {
	        my($ld) = @_;
    		eval q( &__asm  &volatile( \\"wr %3,%%g0,%%asi;	\\" $ld \\" [%2]%%asi,%0;	\\" \\"srlx %0,32,%1;		\\" \\"srl %0,0,%0		\\" : \\"=&r\\" ( &_vlo), \\"=&r\\" ( &_vhi) : \\"r\\" (( &uint32_t)( &loc)), \\"r\\" ( &asi)));
	    }' unless defined(&SPARC64_LD_NONCONST64);
	    if(defined(&__GNUC__)  && defined(&__OPTIMIZE__)) {
		eval 'sub SPARC64_LD_DEF {
		    my($ld, $type, $vtype) = @_;
    		    eval q( &static  &__inline $type $ld( &paddr_t  &loc, \'int\'  &asi) { $vtype  &_v;  &uint32_t  &_hi,  &_pstate;  &if ( &PHYS_ASI( &asi)) {  &_hi = ( &uint64_t)( &loc) >> 32;  &if ( &__builtin_constant_p( &asi))  &__asm  &volatile( \\"clruw %2;		\\" \\"rdpr %%pstate,%1;	\\" \\"sllx %3,32,%0;		\\" \\"wrpr %1,8,%%pstate;	\\" \\"or %0,%2,%0;		\\" $ld \\" [%0]%4,%0;	\\" \\"wrpr %1,0,%%pstate;	\\" : \\"=&r\\" ( &_v), \\"=&r\\" ( &_pstate) : \\"r\\" (( &uint32_t)( &loc)), \\"r\\" ( &_hi), \\"n\\" ( &asi));  &else  &SPARC64_LD_PHYS_NONCONST($ld); }  &else {  &if ( &__builtin_constant_p( &asi))  &__asm  &volatile( $ld \\" [%1]%2,%0		\\" : \\"=&r\\" ( &_v) : \\"r\\" (( &uint32_t)( &loc)), \\"n\\" ( &asi));  &else  &SPARC64_LD_NONCONST($ld); }  &return  &_v; });
		}' unless defined(&SPARC64_LD_DEF);
		eval 'sub SPARC64_LD_DEF64 {
		    my($ld, $type) = @_;
    		    eval q( &static  &__inline $type $ld( &paddr_t  &loc, \'int\'  &asi) {  &uint32_t  &_vlo,  &_vhi,  &_hi;  &if ( &PHYS_ASI( &asi)) {  &_hi = ( &uint64_t)( &loc) >> 32;  &if ( &__builtin_constant_p( &asi))  &__asm  &volatile( \\"clruw %2;		\\" \\"rdpr %%pstate,%1;	\\" \\"sllx %3,32,%0;		\\" \\"wrpr %1,8,%%pstate;	\\" \\"or %0,%2,%0;		\\" $ld \\" [%0]%4,%0;	\\" \\"wrpr %1,0,%%pstate;	\\" \\"srlx %0,32,%1;		\\" \\"srl %0,0,%0		\\" : \\"=&r\\" ( &_vlo), \\"=&r\\" ( &_vhi) : \\"r\\" (( &uint32_t)( &loc)), \\"r\\" ( &_hi), \\"n\\" ( &asi));  &else  &SPARC64_LD_PHYS_NONCONST64($ld); }  &else {  &if ( &__builtin_constant_p( &asi))  &__asm  &volatile( $ld \\" [%2]%3,%0;	\\" \\"srlx %0,32,%1;		\\" \\"srl %0,0,%0		\\" : \\"=&r\\" ( &_vlo), \\"=&r\\" ( &_vhi) : \\"r\\" (( &uint32_t)( &loc)), \\"n\\" ( &asi));  &else  &SPARC64_LD_NONCONST64($ld); }  &return (( &uint64_t) &_vhi << 32) |  &_vlo; });
		}' unless defined(&SPARC64_LD_DEF64);
	    } else {
		eval 'sub SPARC64_LD_DEF {
		    my($ld, $type, $vtype) = @_;
    		    eval q( &static  &__inline $type $ld( &paddr_t  &loc, \'int\'  &asi) { $vtype  &_v;  &uint32_t  &_hi,  &_pstate;  &if ( &PHYS_ASI( &asi)) {  &_hi = ( &uint64_t)( &loc) >> 32;  &SPARC64_LD_PHYS_NONCONST($ld); }  &else  &SPARC64_LD_NONCONST($ld);  &return  &_v; });
		}' unless defined(&SPARC64_LD_DEF);
		eval 'sub SPARC64_LD_DEF64 {
		    my($ld, $type) = @_;
    		    eval q( &static  &__inline $type $ld( &paddr_t  &loc, \'int\'  &asi) {  &uint32_t  &_vlo,  &_vhi,  &_hi;  &if ( &PHYS_ASI( &asi)) {  &_hi = ( &uint64_t)( &loc) >> 32;  &SPARC64_LD_PHYS_NONCONST64($ld); }  &else  &SPARC64_LD_NONCONST64($ld);  &return (( &uint64_t) &_vhi << 32) |  &_vlo; });
		}' unless defined(&SPARC64_LD_DEF64);
	    }
	}
	if(defined(&__arch64__)) {
	    eval 'sub SPARC64_ST_NONCONST {
	        my($st, $type) = @_;
    		eval q( &__asm  &volatile( \\"wr %3,%%g0,%%asi;	\\" $st \\" %1,[%2]%%asi	\\" : \\"=m\\" (*($type *)( &__uintptr_t)( &loc)) : \\"r\\" ( &value), \\"r\\" (( &__uintptr_t)( &loc)), \\"r\\" ( &asi)));
	    }' unless defined(&SPARC64_ST_NONCONST);
	    if(defined(&__GNUC__)  && defined(&__OPTIMIZE__)) {
		eval 'sub SPARC64_ST_DEF {
		    my($st, $type) = @_;
    		    eval q( &static  &__inline  &void $st( &paddr_t  &loc, \'int\'  &asi, $type  &value) {  &if ( &__builtin_constant_p( &asi))  &__asm  &volatile( $st \\" %1,[%2]%3		\\" : \\"=m\\" (*($type *)( &__uintptr_t)( &loc)) : \\"r\\" ( &value), \\"r\\" (( &__uintptr_t)( &loc)), \\"n\\" ( &asi));  &else  &SPARC64_ST_NONCONST($st, $type); });
		}' unless defined(&SPARC64_ST_DEF);
	    } else {
		eval 'sub SPARC64_ST_DEF {
		    my($st, $type) = @_;
    		    eval q( &static  &__inline  &void $st( &paddr_t  &loc, \'int\'  &asi, $type  &value) {  &SPARC64_ST_NONCONST($st, $type); });
		}' unless defined(&SPARC64_ST_DEF);
	    }
	    eval 'sub SPARC64_ST_DEF64 {
	        my($st, $type) = @_;
    		eval q( &SPARC64_ST_DEF($st, $type));
	    }' unless defined(&SPARC64_ST_DEF64);
	} else {
	    eval 'sub SPARC64_ST_PHYS_NONCONST {
	        my($st) = @_;
    		eval q( &__asm  &volatile( \\"clruw %3;		\\" \\"rdpr %%pstate,%1;	\\" \\"sllx %4,32,%0;		\\" \\"wrpr %1,8,%%pstate;	\\" \\"or %0,%3,%0;		\\" \\"wr %5,%%g0,%%asi;	\\" $st \\" %2,[%0]%%asi;	\\" \\"wrpr %1,0,%%pstate	\\" : \\"=&r\\" ( &_hi), \\"=&r\\" ( &_pstate) : \\"r\\" ( &value), \\"r\\" (( &uint32_t)( &loc)), \\"r\\" ( &_hi), \\"r\\" ( &asi)));
	    }' unless defined(&SPARC64_ST_PHYS_NONCONST);
	    eval 'sub SPARC64_ST_NONCONST {
	        my($st) = @_;
    		eval q( &__asm  &volatile( \\"wr %2,%%g0,%%asi;	\\" $st \\" %0,[%1]%%asi	\\" : : \\"r\\" ( &value), \\"r\\" (( &uint32_t)( &loc)), \\"r\\" ( &asi)));
	    }' unless defined(&SPARC64_ST_NONCONST);
	    eval 'sub SPARC64_ST_PHYS_NONCONST64 {
	        my($st) = @_;
    		eval q( &__asm  &volatile( \\"clruw %3;		\\" \\"clruw %5;		\\" \\"sllx %4,32,%1;		\\" \\"sllx %6,32,%0; 	\\" \\"rdpr %%pstate,%2;	\\" \\"or %1,%3,%1;		\\" \\"wrpr %2,8,%%pstate;	\\" \\"or %0,%5,%0;		\\" \\"wr %7,%%g0,%%asi;	\\" $st \\" %1,[%0]%%asi;	\\" \\"wrpr %2,0,%%pstate	\\" : \\"=&r\\" ( &_hi), \\"=&r\\" ( &_vhi), \\"=&r\\" ( &_vlo) : \\"r\\" ( &_vlo), \\"r\\" ( &_vhi), \\"r\\" (( &uint32_t)( &loc)), \\"r\\" ( &_hi), \\"r\\" ( &asi)));
	    }' unless defined(&SPARC64_ST_PHYS_NONCONST64);
	    eval 'sub SPARC64_ST_NONCONST64 {
	        my($st) = @_;
    		eval q( &__asm  &volatile( \\"clruw %1;		\\" \\"sllx %2,32,%0;		\\" \\"or %0,%1,%0;		\\" \\"wr %4,%%g0,%%asi;	\\" $st \\" %0,[%3]%%asi	\\" : \\"=&r\\" ( &_vhi) : \\"r\\" ( &_vlo), \\"r\\" ( &_vhi), \\"r\\" (( &uint32_t)( &loc)), \\"r\\" ( &asi)));
	    }' unless defined(&SPARC64_ST_NONCONST64);
	    if(defined(&__GNUC__)  && defined(&__OPTIMIZE__)) {
		eval 'sub SPARC64_ST_DEF {
		    my($st, $type) = @_;
    		    eval q( &static  &__inline  &void $st( &paddr_t  &loc, \'int\'  &asi, $type  &value) {  &uint32_t  &_hi,  &_pstate;  &if ( &PHYS_ASI( &asi)) {  &_hi = ( &uint64_t)( &loc) >> 32;  &if ( &__builtin_constant_p( &asi))  &__asm  &volatile( \\"clruw %3;		\\" \\"sllx %4,32,%0;		\\" \\"rdpr %%pstate,%1;	\\" \\"or %0,%3,%0;		\\" \\"wrpr %1,8,%%pstate;	\\" $st \\" %2,[%0]%5;	\\" \\"wrpr %1,0,%%pstate	\\" : \\"=&r\\" ( &_hi), \\"=&r\\" ( &_pstate) : \\"r\\" ( &value), \\"r\\" (( &uint32_t)( &loc)), \\"r\\" ( &_hi), \\"n\\" ( &asi));  &else  &SPARC64_ST_PHYS_NONCONST($st); }  &else {  &if ( &__builtin_constant_p( &asi))  &__asm  &volatile( $st \\" %0,[%1]%2		\\" : : \\"r\\" ( &value), \\"r\\" (( &uint32_t)( &loc)), \\"n\\" ( &asi));  &else  &SPARC64_ST_NONCONST($st); } });
		}' unless defined(&SPARC64_ST_DEF);
		eval 'sub SPARC64_ST_DEF64 {
		    my($st, $type) = @_;
    		    eval q( &static  &__inline  &void $st( &paddr_t  &loc, \'int\'  &asi, $type  &value) {  &uint32_t  &_vlo,  &_vhi,  &_hi;  &_vlo =  &value;  &_vhi = ( &uint64_t)( &value) >> 32;  &if ( &PHYS_ASI( &asi)) {  &_hi = ( &uint64_t)( &loc) >> 32;  &if ( &__builtin_constant_p( &asi))  &__asm  &volatile( \\"clruw %3;		\\" \\"clruw %5;		\\" \\"sllx %4,32,%1;		\\" \\"sllx %6,32,%0; 	\\" \\"rdpr %%pstate,%2;	\\" \\"or %1,%3,%1;		\\" \\"or %0,%5,%0;		\\" \\"wrpr %2,8,%%pstate;	\\" $st \\" %1,[%0]%7;	\\" \\"wrpr %2,0,%%pstate	\\" : \\"=&r\\" ( &_hi), \\"=&r\\" ( &_vhi), \\"=&r\\" ( &_vlo) : \\"r\\" ( &_vlo), \\"r\\" ( &_vhi), \\"r\\" (( &uint32_t)( &loc)), \\"r\\" ( &_hi), \\"n\\" ( &asi));  &else  &SPARC64_ST_PHYS_NONCONST64($st); }  &else {  &if ( &__builtin_constant_p( &asi))  &__asm  &volatile( \\"clruw %1;		\\" \\"sllx %2,32,%0;		\\" \\"or %0,%1,%0;		\\" $st \\" %0,[%3]%4		\\" : \\"=&r\\" ( &_vhi) : \\"r\\" ( &_vlo), \\"r\\" ( &_vhi), \\"r\\" (( &uint32_t)( &loc)), \\"n\\" ( &asi));  &else  &SPARC64_ST_NONCONST64($st); } });
		}' unless defined(&SPARC64_ST_DEF64);
	    } else {
		eval 'sub SPARC64_ST_DEF {
		    my($st, $type) = @_;
    		    eval q( &static  &__inline  &void $st( &paddr_t  &loc, \'int\'  &asi, $type  &value) {  &uint32_t  &_hi,  &_pstate;  &if ( &PHYS_ASI( &asi)) {  &_hi = ( &uint64_t)( &loc) >> 32;  &SPARC64_ST_PHYS_NONCONST($st); }  &else  &SPARC64_ST_NONCONST($st); });
		}' unless defined(&SPARC64_ST_DEF);
		eval 'sub SPARC64_ST_DEF64 {
		    my($st, $type) = @_;
    		    eval q( &static  &__inline  &void $st( &paddr_t  &loc, \'int\'  &asi, $type  &value) {  &uint32_t  &_vlo,  &_vhi,  &_hi;  &_vlo =  &value;  &_vhi = ( &uint64_t)( &value) >> 32;  &if ( &PHYS_ASI( &asi)) {  &_hi = ( &uint64_t)( &loc) >> 32;  &SPARC64_ST_PHYS_NONCONST64($st); }  &else  &SPARC64_ST_NONCONST64($st); });
		}' unless defined(&SPARC64_ST_DEF64);
	    }
	}
	eval 'sub sparc_flush_icache {
	    my($loc) = @_;
    	    eval q( &__asm  &volatile(\\"flush %0\\" : : \\"r\\" (( &__uintptr_t)($loc))));
	}' unless defined(&sparc_flush_icache);
	eval 'sub membar_StoreStore () {
	    eval q( &__asm  &volatile(\\"membar #StoreStore\\" : :));
	}' unless defined(&membar_StoreStore);
	eval 'sub membar_LoadStore () {
	    eval q( &__asm  &volatile(\\"membar #LoadStore\\" : :));
	}' unless defined(&membar_LoadStore);
	eval 'sub membar_StoreLoad () {
	    eval q( &__asm  &volatile(\\"membar #StoreLoad\\" : :));
	}' unless defined(&membar_StoreLoad);
	eval 'sub membar_LoadLoad () {
	    eval q( &__asm  &volatile(\\"membar #LoadLoad\\" : :));
	}' unless defined(&membar_LoadLoad);
	eval 'sub membar_Sync () {
	    eval q( &__asm  &volatile(\\"membar #Sync\\" : :));
	}' unless defined(&membar_Sync);
	eval 'sub membar_MemIssue () {
	    eval q( &__asm  &volatile(\\"membar #MemIssue\\" : :));
	}' unless defined(&membar_MemIssue);
	eval 'sub membar_Lookaside () {
	    eval q( &__asm  &volatile(\\"membar #Lookaside\\" : :));
	}' unless defined(&membar_Lookaside);
	eval 'sub membar_Load () {
	    eval q( &__asm  &volatile(\\"membar #LoadLoad | #LoadStore\\" : :));
	}' unless defined(&membar_Load);
	eval 'sub membar_Store () {
	    eval q( &__asm  &volatile(\\"membar #LoadStore | #StoreStore\\" : :));
	}' unless defined(&membar_Store);
    }
}
1;
