<?xml version="1.0" encoding="Shift_JIS" ?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/TR/WD-xsl"
    xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
    xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
>

<!-- ################ root note ################ -->
<xsl:template match="/">
	<html lang="ja">
	<head>
	<title><xsl:value-of select="//dc:Title"/></title>
	</head>

	<body>
	<h1><xsl:value-of select="//dc:Title"/></h1>
	<hr/>
	<xsl:apply-templates select="/diary"/>
	<hr/>
	<p>
	Powered by
	<xsl:value-of select="//dc:Publisher"/>
	</p>
	<address><xsl:value-of select="//dc:Creator"/>
	<a>
		<xsl:attribute name="href">
			<xsl:value-of select="//dc:Creator.Email"/>
		</xsl:attribute>
		&lt; <xsl:value-of select="//dc:Creator.Email"/> &gt;
	</a>
	</address>
	</body>
	</html>
</xsl:template>

<!-- ################ diary specified ################ -->
<xsl:template match="/diary">
	<xsl:apply-templates select="/diary/daily"/>
</xsl:template>

<xsl:template match="daily">
	<h2><xsl:apply-templates select="date"/></h2>
	<xsl:apply-templates select="topic"/>
	<hr/>
</xsl:template>

<xsl:template match="topic">
	<h3>
		<xsl:apply-templates select="number"/>
		<xsl:apply-templates select="category"/>
		<xsl:apply-templates select="title"/>
	</h3>
	<xsl:apply-templates select="content"/>
	<xsl:if test="content//footnote">
		<hr/>
		<xsl:for-each select="content//footnote">
			<xsl:apply-templates/>
		</xsl:for-each>
	</xsl:if>
</xsl:template>
	
<xsl:template match="topic/number">
	<a>
		<xsl:attribute name="href">
			?<xsl:value-of select="/diary/daily/date/year"/>
			<xsl:value-of select="/diary/daily/date/month"/>
			<xsl:value-of select="/diary/daily/date/day"/>
			#
			<xsl:value-of select="/diary/daily/date/day"/>
			-
			<xsl:value-of select="text()"/>
		</xsl:attribute>
		<xsl:attribute name="name">
			<xsl:value-of select="/diary/daily/date/day"/>-<xsl:value-of select="text()"/></xsl:attribute>
		<xsl:value-of select="text()"/>
	</a>
</xsl:template>

<xsl:template match="title">
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="category">
	[<xsl:apply-templates/>]
</xsl:template>

<xsl:template match="content">
	<xsl:apply-templates/>
</xsl:template>

<!-- date node -->
<xsl:template match="date">
	<a>
		<xsl:attribute name="href">
			?<xsl:value-of select="year"/>
			<xsl:value-of select="month"/>
			<xsl:value-of select="day"/>
			#
			<xsl:value-of select="day"/>
		</xsl:attribute>
		<xsl:attribute name="name">
			<xsl:value-of select="day"/></xsl:attribute>
		<xsl:value-of select="year"/>/<xsl:value-of select="month"/>/<xsl:value-of select="day"/>
	</a>
</xsl:template>

<!-- ################ block node ################ -->
<xsl:template match="p">
	<p><xsl:apply-templates/></p>
</xsl:template>

<xsl:template match="div">
	<div><xsl:apply-templates/></div>
</xsl:template>

<xsl:template match="code">
	<blockquote><pre><xsl:apply-templates/></pre></blockquote>
</xsl:template>

<xsl:template match="pre">
	<pre><xsl:apply-templates/></pre>
</xsl:template>

<xsl:template match="cite">
	<blockquote><xsl:apply-templates/></blockquote>
</xsl:template>


<xsl:template match="hr">
	<hr/>
</xsl:template>

<!-- list node -->
<xsl:template match="list">
	<xsl:if test='@count[.$eq$ "yes"]'>
	<ol>
		<xsl:for-each select="item">
			<li><xsl:apply-templates/></li>
		</xsl:for-each>
	</ol>
	</xsl:if>
	<xsl:if test='@count[.$eq$ "no"]'>
	<ul>
		<xsl:for-each select="item">
			<li><xsl:apply-templates/></li>
		</xsl:for-each>
	</ul>
	</xsl:if>
</xsl:template>

<!-- inline node -->
<xsl:template match="a">
	<a>
		<xsl:attribute name="href">
			<xsl:value-of select="@href"/>
		</xsl:attribute>
		<xsl:apply-templates/>
	</a>
</xsl:template>

<xsl:template match="strong">
	<xsl:if test='@level[.$eq$ "high"]'>
		<br/><span style="text-align: center; font-color: red;"><strong><big><xsl:apply-templates/></big></strong></span><br/>
	</xsl:if>
	<xsl:if test='@level[.$eq$ "middle"]'>
		<STRONG><xsl:apply-templates/></STRONG>
	</xsl:if>
	<xsl:if test='@level[.$eq$ "low"]'>
		<EM><xsl:apply-templates/></EM>
	</xsl:if>
</xsl:template>

<xsl:template match="decoration">
	<xsl:if test='@type[.$eq$ "underline"]'>
		<span style="text-decoration: underline"><xsl:apply-templates/></span>
	</xsl:if>
	<xsl:if test='@type[.$eq$ "linethrough"]'>
		<span style="text-decoration: line-through"><xsl:apply-templates/></span>
	</xsl:if>
</xsl:template>

<xsl:template match="image">
	<img>
		<xsl:attribute name="src">
			<xsl:value-of select="uri"/>
		</xsl:attribute>
		<xsl:attribute name="align">
			<xsl:value-of select="align"/>
		</xsl:attribute>
		<xsl:attribute name="alt">
			<xsl:value-of select="imagetitle"/>
		</xsl:attribute>
		<xsl:attribute name="width">
			<xsl:value-of select="size/width"/>
		</xsl:attribute>
		<xsl:attribute name="height">
			<xsl:value-of select="size/height"/>
		</xsl:attribute>
	</img>
</xsl:template>

<xsl:template match="span">
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="footnote">
	<sup>
	<a>
		<xsl:attribute name="href">
			#
			<xsl:value-of select="/diary/daily/date/day"/>
			-
			<xsl:value-of select="/diary/daily/topic/number"/>-F
			<xsl:value-of select="number"/>
		</xsl:attribute>
		*<xsl:value-of select="number"/>
	</a>
	</sup>
</xsl:template>

<xsl:template match="footnote/number">
	[
	<a>
		<xsl:attribute name="href">
			?<xsl:value-of select="/diary/daily/date/year"/>
			<xsl:value-of select="/diary/daily/date/month"/>
			<xsl:value-of select="/diary/daily/date/day"/>
			#
			<xsl:value-of select="/diary/daily/date/day"/>
			-
			<xsl:value-of select="/diary/daily/topic/number"/>-F
			<xsl:value-of select="text()"/>
		</xsl:attribute>
		<xsl:attribute name="name">
			<xsl:value-of select="/diary/daily/date/day"/>
			-
			<xsl:value-of select="/diary/daily/topic/number"/>-F
			<xsl:value-of select="text()"/>
		</xsl:attribute>		
		*<xsl:value-of/>
	</a>
	]:
</xsl:template>

<xsl:template match="br">
	<br/>
</xsl:template>

<xsl:template match="text()">
	<xsl:value-of/>
</xsl:template>

</xsl:stylesheet>