//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#ifndef _TRK_POINT_TYPE_H
#define _TRK_POINT_TYPE_H

#include "constants.h"
#include "packet.h"
#include "gpdlinetool.h"
#include "pos_type.h"

#include <string>
#include <iostream>

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

/// base class for storing a waypoint
class Trk_Point_Type : GPDLineTool 
{
   public:
      virtual ~Trk_Point_Type(){};

      /// creates an uninitialized track point
      Trk_Point_Type(){};

      /// initializes a new trackpoint
      Trk_Point_Type(double longitude, double latitude, float altitude,
		     bool endOfSegment, long time);

      /// output-string return the data in gpd-string format 
      string os(void);
   
      /// same as os(void) but output to ostream
      void os(ostream);
   
   
      /// set the data by garmin-packet 
      virtual void set(Packet);
   
   
      /// make Packet
      virtual Packet makePacket(void);
      
      /// set the data by gpd-string
      void set(string);
   
      /// same as set
      void operator<<(string);
   
      /// 
      virtual void clear(void);

      /// returns longitude (angle in radians)
      double getLongitude() const { return longitude; }

      /// return latitude (angle in radians)
      double getLatitude() const { return latitude; }

      /// return altitude
      float getAltitude() const { return altitude; }

      /// is this point starting a new segment ?
      bool getNewSegment() const { return new_segment; }

      /// return point time
      long getUnixTime() const { return unixtime; }


   protected:
      float    altitude;
      double   latitude;
      double   longitude;
      long     unixtime;  
      bool     new_segment;
};

}
#endif
