require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_VMPARAM_H_)) {
    eval 'sub _VMPARAM_H_ () {1;}' unless defined(&_VMPARAM_H_);
    eval 'sub PAGE_SHIFT () {12;}' unless defined(&PAGE_SHIFT);
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    eval 'sub USRSTACK () { &KERNBASE;}' unless defined(&USRSTACK);
    unless(defined(&MAXTSIZ)) {
	eval 'sub MAXTSIZ () {(32*1024*1024);}' unless defined(&MAXTSIZ);
    }
    unless(defined(&DFLDSIZ)) {
	eval 'sub DFLDSIZ () {(128*1024*1024);}' unless defined(&DFLDSIZ);
    }
    unless(defined(&MAXDSIZ)) {
	eval 'sub MAXDSIZ () {(512*1024*1024);}' unless defined(&MAXDSIZ);
    }
    unless(defined(&DFLSSIZ)) {
	eval 'sub DFLSSIZ () {(512*1024);}' unless defined(&DFLSSIZ);
    }
    unless(defined(&MAXSSIZ)) {
	eval 'sub MAXSSIZ () {(8*1024*1024);}' unless defined(&MAXSSIZ);
    }
    eval 'sub VM_PHYSSEG_MAX () {1;}' unless defined(&VM_PHYSSEG_MAX);
    eval 'sub VM_PHYSSEG_STRAT () { &VM_PSTRAT_BSEARCH;}' unless defined(&VM_PHYSSEG_STRAT);
    eval 'sub VM_NFREELIST () {1;}' unless defined(&VM_NFREELIST);
    eval 'sub VM_FREELIST_DEFAULT () {0;}' unless defined(&VM_FREELIST_DEFAULT);
    eval 'sub vax_round_page {
        my($x) = @_;
	    eval q(((( &vaddr_t)($x) +  &VAX_PGOFSET) & ~ &VAX_PGOFSET));
    }' unless defined(&vax_round_page);
    eval 'sub vax_trunc_page {
        my($x) = @_;
	    eval q((( &vaddr_t)($x) & ~ &VAX_PGOFSET));
    }' unless defined(&vax_trunc_page);
    eval 'sub VM_MIN_ADDRESS () {(( &vaddr_t)0);}' unless defined(&VM_MIN_ADDRESS);
    eval 'sub VM_MAXUSER_ADDRESS () {(( &vaddr_t) &KERNBASE);}' unless defined(&VM_MAXUSER_ADDRESS);
    eval 'sub VM_MAX_ADDRESS () {(( &vaddr_t) &KERNBASE);}' unless defined(&VM_MAX_ADDRESS);
    eval 'sub VM_MIN_KERNEL_ADDRESS () {(( &vaddr_t) &KERNBASE);}' unless defined(&VM_MIN_KERNEL_ADDRESS);
    eval 'sub VM_MAX_KERNEL_ADDRESS () {(( &vaddr_t)(0xc0000000));}' unless defined(&VM_MAX_KERNEL_ADDRESS);
    eval 'sub __USE_TOPDOWN_VM () {1;}' unless defined(&__USE_TOPDOWN_VM);
    eval 'sub USRIOSIZE () {(8*  &VAX_NPTEPG);}' unless defined(&USRIOSIZE);
    eval 'sub VM_PHYS_SIZE () {( &USRIOSIZE* &VAX_NBPG);}' unless defined(&VM_PHYS_SIZE);
}
1;
