# Article class for The Canadian Journal of Statistics

The package **cjs-rcs-article** provides the document class and
bibliographic styles to typeset articles for [The Canadian Journal of
Statistics](https://ssc.ca/en/publications/canadian-journal-statistics).

The class relies on modern and advanced tools, such as 
the class [memoir](https://ctan.org/pkg/memoir), 
the fonts [STIX Two](https://ctan.org/pkg/stix2-otf)
and [Fira](https://ctan.org/pkg/fira), 
and the package [babel](https://ctan.org/pkg/babel). 
To take full advantage of its characteristics, we recommend that you 
compile with XeLaTeX. The class remains nonetheless largely
compatible with the traditional engine pdfLaTeX.

## Licence

LaTeX Project Public License, version 1.3c or (at your option) any
later version. The documentation is also licensed under CC BY-SA 4.0
International.

## Version

1.1a (2024-07-30)

## Author

Vincent Goulet <vincent.goulet@act.ulaval.ca> for the Statistical
Society of Canada

## Source code repository

https://gitlab.com/cjs-rcs/cjs-rcs-article

## Contents

- `cjs-rcs-article.ins`: installation script for the class and
  bibliographic styles; see below;
- `cjs-rcs-article.dtx`: source code of the class, with documentation;
- `cjs-rcs-merlin.mbs`: master bibliographic style;
- `cjs-rcs-english.mbs`: langage definition file for English;
- `cjs-rcs-french.mbs`: langage definition file for French;
- `cjs-rcs-class.dbj`: driver file for the document class;
- `cjs-rcs-bst-en.dbj`: driver file for the English bibliographic
  style;
- `cjs-rcs-bst-fr.dbj`: driver file for the French bibliographic
  style;
- `cjs-rcs-article.pdf`: English documentation of the class (including
  the implementation details and version history);
- `cjs-rcs-article-fr.pdf`: French documentation of the class (without
  the implementation details and version history);
- `cjs-rcs-merlin.pdf`: documentation of the master bibliographic
  style;
- `README.md`: this file.

## Installation

The package **cjs-rcs-article** is distributed through the
Comprehensive TeX Archive Network (CTAN) and it is part of the
standard TeX distributions. Therefore, we strongly recommend using
the package manager of your distribution to install or update the
package.

TeX experts may generate the class and its bibliographic styles by
running the file `cjs-rcs-article.ins` through LaTeX:

    latex cjs-rcs-article.ins

The compilation will create the file of the class itself
(`cjs-rcs-article.cls`), templates for articles in English and in
French (`cjs-template.tex`, `rcs-gabarit.tex`), and the bibliographic
styles (`cjs-rcs-en.bst`, `cjs-rcs-fr.bst`).

## Documentation

The files `cjs-rcs-article.pdf` and `cjs-rcs-article-fr.pdf` contain
the complete documentation of the class and the bibliographic styles.
You may recreate these documents from the file `cjs-rcs-article.dtx`
as follows:

    xelatex cjs-rcs-article.dtx
    makeindex -s gglo.ist -o cjs-rcs-article.gls cjs-rcs-article.glo
    xelatex cjs-rcs-article.dtx
    xelatex cjs-rcs-article.dtx
    xelatex cjs-rcs-article-fr.tex
    xelatex cjs-rcs-article-fr.tex
    xelatex cjs-rcs-article-fr.tex

The file `cjs-rcs-merlin.pdf` contains documentation for the creation
and generation of the bibliographic styles. It should be of
interest to experts and developers only. To recreate the document,
compile `cjs-rcs-merlin.mbs` as follows:

    xelatex cjs-rcs-merlin.mbs
    makeindex -s gglo.ist -o cjs-rcs-merlin.gls cjs-rcs-merlin.glo
    xelatex cjs-rcs-merlin.mbs
	xelatex cjs-rcs-merlin.mbs

## Version history

The version history of the class appears in `cjs-article.pdf`. The
version history of the bibliographic styles appears in
`cjs-rcs-merlin.pdf`.

## Comments or suggestions

The GitLab [project repository](https://gitlab.com/cjs-rcs/cjs-rcs-article)
is the best place to report bugs or to propose improvements to the 
project.

======================================================================

# Classe pour les articles de La revue canadienne de statistique

Le paquetage **cjs-rcs-article** fournit la classe et les styles de
bibliographie pour la composition d'articles scientifiques destinés à
[La revue canadienne de statistique](https://ssc.ca/fr/publications/revue-canadienne-statistique).

La classe repose sur des outils modernes et évolués, tels que 
la classe [memoir](https://ctan.org/pkg/memoir), 
les polices [STIX Two](https://ctan.org/pkg/stix2-otf) 
et [Fira](https://ctan.org/pkg/fira), 
ainsi que le paquetage [babel](https://ctan.org/pkg/babel). 
Pour tirer pleinement profit des caractéristiques de la classe, nous
recommandons de compiler avec XeLaTeX. La classe demeure néanmoins en
grande partie compatible avec le moteur pdfLaTeX.

## Licence

LaTeX Project Public License, version 1.3c ou (à votre choix) toute
version ultérieure. La documentation est également publiée sous 
licence CC BY-SA 4.0 International.

## Version

1.1a (2024-07-30)

## Auteur

Vincent Goulet <vincent.goulet@act.ulaval.ca> pour la Société
canadienne de statistique

## Dépôt du code source

https://gitlab.com/cjs-rcs/cjs-rcs-article

## Contenu du paquetage

- `cjs-rcs-article.ins`: procédure d'installation de la classe et des
  styles de bibliographie; voir ci-dessous;
- `cjs-rcs-article.dtx`: fichier source documenté de la classe;
- `cjs-rcs-merlin.mbs`: fichier maitre de styles bibliographiques;
- `cjs-rcs-english.mbs`: fichier de localisation pour l'anglais;
- `cjs-rcs-french.mbs`: fichier de localisation pour le français;
- `cjs-rcs-class.dbj`: script de génération de la classe;
- `cjs-rcs-bst-en.dbj`: script de génération du style de bibliographie
   anglais;
- `cjs-rcs-bst-fr.dbj`: script de génération du style de bibliographie
  français;
- `cjs-rcs-article.pdf`: documentation anglaise de la classe (incluant
  la mise en œuvre et l'historique des versions);
- `cjs-rcs-article-fr.pdf`: documentation française de la classe (sans
  la mise en œuvre et l'historique des versions);
- `cjs-rcs-merlin.pdf`: documentation sur la création des styles de
  bibliographie;
- `README.md`: le présent fichier.

## Installation

Le paquetage **cjs-rcs-article** est distribué via le réseau de sites
Comprehensive TeX Archive Network (CTAN) et il fait partie des
distributions TeX standards. Par conséquent, nous recommandons
fortement d'installer ou de mettre à jour le paquetage à l'aide du
gestionnaire de paquetages de votre distribution.

Les experts TeX peuvent générer la classe et ses styles de
bibliographie en compilant le fichier `cjs-rcs-article.ins` avec
LaTeX:

    latex cjs-rcs-article.ins

La compilation créera le fichier de la classe elle-même
(`cjs-rcs-article.cls`), les gabarits pour des articles en anglais et
en français (`cjs-template.tex`, `rcs-gabarit.tex`), ainsi que les
styles de bibliographie (`cjs-rcs-en.bst`, `cjs-rcs-fr.bst`).

## Documentation

Les fichiers `cjs-rcs-article.pdf` et `cjs-rcs-article-fr.pdf`
contiennent la documentation complète de la classe et des styles de
bibliographie. Utilisez les commandes suivantes pour recréer les 
documents à partir du fichier `cjs-rcs-article.dtx`:

    xelatex cjs-rcs-article.dtx
    makeindex -s gglo.ist -o cjs-rcs-article.gls cjs-rcs-article.glo
    xelatex cjs-rcs-article.dtx
    xelatex cjs-rcs-article.dtx
    xelatex cjs-rcs-article-fr.tex
    xelatex cjs-rcs-article-fr.tex
    xelatex cjs-rcs-article-fr.tex

Le fichier `cjs-rcs-merlin.pdf` contient quant à lui la documentation
(en anglais) sur la création des styles de bibliographie. Celle-ci
est susceptible de n'intéresser que les experts et les développeurs.
Pour recréer le document, compilez `cjs-rcs-merlin.mbs` ainsi:

    xelatex cjs-rcs-merlin.mbs
    makeindex -s gglo.ist -o cjs-rcs-merlin.gls cjs-rcs-merlin.glo
    xelatex cjs-rcs-merlin.mbs
    xelatex cjs-rcs-merlin.mbs

## Historique des versions

L'historique des versions de la classe se trouve dans le fichier
`cjs-rcs-article.pdf`. L'historique des version des styles de 
bibliographie se trouve dans le fichier `cjs-rcs-merlin.pdf`.

## Commentaires et suggestions

Le [dépôt du projet](https://gitlab.com/cjs-rcs/cjs-rcs-article) dans
GitLab demeure le meilleur endroit pour rapporter des bogues ou pour
proposer des améliorations au projet.
