package TDS::Admin::FTP;
# $Id: FTP.pm,v 1.27 2001/02/06 05:02:11 tom Exp $
################################################################

use strict;

use vars qw(@ISA
	    $Server $ServerDiaryDir $ServerWebDir $ServerCustomizeDir
	    $UserName);

use ObjectTemplate;
use CGI::QueryString;

use TDS::System;
use TDS::AccessLog::DirInfo;
use TDS::DirInfo;

@ISA = qw(ObjectTemplate);

{
    $Server = "" unless defined $Server;              # warn if undefined
    $ServerDiaryDir = "" unless defined $ServerDiaryDir;   # regard as diary_dir unless undefined
    $ServerWebDir = "" unless defined $ServerWebDir;        # regard as web_dir unless undefined
    $ServerCustomizeDir = "" unless defined $ServerCustomizeDir;
}

attributes qw(password
	      putdir filename tmp_file);

################################################################
sub initialize($)
{
    my $self = shift;

    die qq(you MUST specify \$TDS::Admin::FTP::Server variable.
	   edit customize.ph or do '% perl customizer.pl')
	unless $Server;

    unless ($ServerDiaryDir){
	$ServerDiaryDir = GetDiaryDir();
    }
    unless ($ServerCustomizeDir){
	$ServerCustomizeDir = GetCustomizeDir();
    }
    unless ($ServerWebDir){
	$ServerWebDir = GetWebDiaryDir();
    }
    $self->password(param('ftp_password')) unless $self->password;

    $self->SUPER::initialize;
}
sub SetPutDir($$$)
{
    my ($self, $base_type, $putdir) = @_;

    $self->putdir($self->GetPutDir($base_type, $putdir));
}
sub GetPutDir($$$)
{
    my ($self, $base_type, $putdir) = @_;

    my $base_dir;
    my %hash = ('diary_dir' => $ServerDiaryDir,
		'web_dir' => $ServerWebDir,
		'customize_dir' => $ServerCustomizeDir);

    return $hash{$base_type} . "/$putdir";
}
sub SetPutDirOnDiaryDir($$)
{
    my ($self, $putdir) = @_;

    $self->putdir("$ServerDiaryDir/$putdir");
}
sub SetPutDirOnWebDir($$)
{
    my ($self, $putdir) = @_;

    $self->putdir("$ServerWebDir/$putdir");
}
sub SetPutDirOnCustomizeDir($$)
{
    my ($self, $putdir) = @_;

    $self->putdir("$ServerCustomizeDir/$putdir");
}

sub WriteTmpFile ($$)
{
    my ($self, $body) = @_;
    my $tmp_file = sprintf("%s/%s",
			   GetLogDir(),
			   $self->filename);
    $self->tmp_file($tmp_file);
    open(TMP, ">$tmp_file") || die $tmp_file;
    print TMP $body;
    close TMP;
}

sub Put($)
{
    my $self = shift;
    eval "require 'Net/FTP.pm';";
    unless ($@){
	my $ftp = new Net::FTP($Server);
	$ftp->login($UserName, $self->password) || die "login failed";
	unless ($ftp->cwd($self->putdir)){
	    $ftp->mkdir($self->putdir, 'recurse') ||
		die "can't create: " . $self->putdir;
	    $ftp->cwd($self->putdir) || die "can't change to " . $self->putdir;
	}
	my $tmp_file = $self->tmp_file;
	$ftp->put($tmp_file) || die "put failed: $tmp_file";
	$ftp->quit;
    } else {
	require 'ftp.pl';
	&ftp::login($UserName, $self->password) || die "login faild";
	unless(&ftp::cwd($self->putdir)){
	    &ftp::mkdir($self->putdir) || die "can't create: ". $self->putdir;
	    &ftp::cwd($self->putdir) || die "can't change to " . $self->putdir;
	}
	my $tmp_file = $self->tmp_file;
	&ftp::put($tmp_file) || die "put failed: $tmp_file";
	&ftp::quit;
    }
    unlink($self->tmp_file);
}

################################################################

1;
