/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.GIOP.v1_0;

import gnu.CORBA.CDR.AbstractCdrInput;
import gnu.CORBA.CDR.AbstractCdrOutput;
import gnu.CORBA.GIOP.CodeSetServiceContext;
import gnu.CORBA.GIOP.ServiceContext;

public class ReplyHeader
extends gnu.CORBA.GIOP.ReplyHeader {
    public String getStatusString() {
        switch (this.reply_status) {
            case 0: {
                return "ok";
            }
            case 1: {
                return "user exception";
            }
            case 2: {
                return "system exception";
            }
            case 3: {
                return "moved";
            }
        }
        return null;
    }

    public String contexts() {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < this.service_context.length) {
            b.append(this.service_context[i].toString());
            b.append(' ');
            ++i;
        }
        return b.toString();
    }

    public void read(AbstractCdrInput in) {
        this.service_context = ServiceContext.readSequence(in);
        this.request_id = in.read_ulong();
        this.reply_status = in.read_ulong();
        in.setCodeSet(CodeSetServiceContext.find(this.service_context));
    }

    public String toString() {
        String status = this.getStatusString();
        if (status == null) {
            status = "status " + this.reply_status;
        }
        return this.request_id + ", " + status + ' ' + this.contexts();
    }

    public void write(AbstractCdrOutput out) {
        ServiceContext.writeSequence(out, this.service_context);
        out.write_ulong(this.request_id);
        out.write_ulong(this.reply_status);
        out.setCodeSet(CodeSetServiceContext.find(this.service_context));
    }
}

