%{
require 'calfunc'
SYMBOL_TABLE = {}
$result = nil
%}


%token NUMBER SYMBOL

%%
program
: stm { $result = $1 }
;

stm
: expr { $$ = $1 }
| SYMBOL '=' expr { $SYMBOL_TABLE[$1] = $3 }
| /* empty */
;

expr
: term '+' term { $$ = plus($1,$3) }  /* CalFunc.plus */
| term '-' term { $$ = minus($1,$3) } /* CalFunc.minus */
| term { $$ = $1 }
;

term
: NUMBER { $$ = @yylval.to_i }
| SYMBOL {
           if SYMBOL_TABLE[$1]
              $$ = SYMBOL_TABLE[$1]
           else
              raise(RuntimeError,"can't find symbol")
           end
         }
;
%%
