/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.net.PlainSocketImpl;
import gnu.java.nio.NIOSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;

public final class SocketChannelImpl
extends SocketChannel {
    private PlainSocketImpl impl;
    private NIOSocket socket;
    private boolean connectionPending;

    public final void finalizer() {
        if (this.isConnected()) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    final PlainSocketImpl getPlainSocketImpl() {
        return this.impl;
    }

    protected final void implCloseSelectableChannel() throws IOException {
        this.socket.close();
    }

    protected final void implConfigureBlocking(boolean blocking) throws IOException {
        this.socket.setSoTimeout(blocking ? 0 : 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean connect(SocketAddress remote) throws IOException {
        Throwable throwable2;
        boolean bl;
        block11: {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.isConnected()) {
                throw new AlreadyConnectedException();
            }
            if (this.connectionPending) {
                throw new ConnectionPendingException();
            }
            if (!(remote instanceof InetSocketAddress)) {
                throw new UnsupportedAddressTypeException();
            }
            if (((InetSocketAddress)remote).isUnresolved()) {
                throw new UnresolvedAddressException();
            }
            this.socket.getPlainSocketImpl().setInChannelOperation(true);
            if (!this.isBlocking()) break block11;
            this.socket.connect(remote);
            boolean bl2 = true;
            Object var3_5 = null;
            this.socket.getPlainSocketImpl().setInChannelOperation(false);
            return bl2;
        }
        try {
            this.socket.connect(remote, 50);
            bl = true;
        }
        catch (SocketTimeoutException e) {
            try {
                this.connectionPending = true;
                boolean bl3 = false;
                Object var3_7 = null;
                this.socket.getPlainSocketImpl().setInChannelOperation(false);
                return bl3;
            }
            catch (Throwable throwable2) {
                Object var3_8 = null;
                this.socket.getPlainSocketImpl().setInChannelOperation(false);
            }
        }
        Object var3_6 = null;
        this.socket.getPlainSocketImpl().setInChannelOperation(false);
        return bl;
        throw throwable2;
    }

    public final boolean finishConnect() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.isConnected() && !this.connectionPending) {
            throw new NoConnectionPendingException();
        }
        if (this.isConnected()) {
            return true;
        }
        AbstractSelector selector = this.provider().openSelector();
        this.register(selector, 8);
        if (this.isBlocking()) {
            selector.select();
            this.connectionPending = false;
            return true;
        }
        int ready = selector.selectNow();
        if (ready == 1) {
            this.connectionPending = false;
            return true;
        }
        return false;
    }

    public final boolean isConnected() {
        return this.socket.isConnected();
    }

    public final boolean isConnectionPending() {
        return this.connectionPending;
    }

    public final Socket socket() {
        return this.socket;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int read(ByteBuffer dst) throws IOException {
        byte[] data;
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        int offset = 0;
        InputStream input = this.socket.getInputStream();
        int available = input.available();
        int len = dst.capacity() - dst.position();
        if (!this.isBlocking() && available == 0) {
            return 0;
        }
        if (dst.hasArray()) {
            offset = dst.arrayOffset() + dst.position();
            data = dst.array();
        } else {
            data = new byte[len];
        }
        int readBytes = 0;
        boolean completed = false;
        try {
            this.begin();
            this.socket.getPlainSocketImpl().setInChannelOperation(true);
            readBytes = input.read(data, offset, len);
            completed = true;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.end(completed);
            this.socket.getPlainSocketImpl().setInChannelOperation(false);
            throw throwable;
        }
        {
            Object var10_11 = null;
        }
        this.end(completed);
        this.socket.getPlainSocketImpl().setInChannelOperation(false);
        if (readBytes <= 0) return readBytes;
        if (dst.hasArray()) {
            dst.position(dst.position() + readBytes);
            return readBytes;
        }
        dst.put(data, offset, len);
        return readBytes;
    }

    public final long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (offset < 0 || offset > dsts.length || length < 0 || length > dsts.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        long readBytes = 0L;
        int index = offset;
        while (index < length) {
            readBytes += (long)this.read(dsts[index]);
            ++index;
        }
        return readBytes;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int write(ByteBuffer src) throws IOException {
        byte[] data;
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        int offset = 0;
        int len = src.remaining();
        if (!src.hasArray()) {
            data = new byte[len];
            src.get(data, 0, len);
        } else {
            offset = src.arrayOffset() + src.position();
            data = src.array();
        }
        OutputStream output = this.socket.getOutputStream();
        boolean completed = false;
        try {
            this.begin();
            this.socket.getPlainSocketImpl().setInChannelOperation(true);
            output.write(data, offset, len);
            completed = true;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.end(completed);
            this.socket.getPlainSocketImpl().setInChannelOperation(false);
            throw throwable;
        }
        {
            Object var8_9 = null;
        }
        this.end(completed);
        this.socket.getPlainSocketImpl().setInChannelOperation(false);
        if (src.hasArray()) {
            src.position(src.position() + len);
        }
        return len;
    }

    public final long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (offset < 0 || offset > srcs.length || length < 0 || length > srcs.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        long writtenBytes = 0L;
        int index = offset;
        while (index < length) {
            writtenBytes += (long)this.write(srcs[index]);
            ++index;
        }
        return writtenBytes;
    }

    SocketChannelImpl(SelectorProvider provider) throws IOException {
        super(provider);
        this.impl = new PlainSocketImpl();
        this.socket = new NIOSocket(this.impl, this);
        this.configureBlocking(true);
    }

    SocketChannelImpl(SelectorProvider provider, NIOSocket socket) throws IOException {
        super(provider);
        this.impl = socket.getPlainSocketImpl();
        this.socket = socket;
    }
}

