package TDS;
# $Id: TDS.pm,v 1.123.2.6 2001/03/04 15:48:57 tom Exp $
################################################################
use strict;
use vars qw($Version $SetupedVersion $Unreleased
	    $MainVersion
	    $TDSHomePage
	    $Status $Style);

use CGI::QueryString;

################################################################
$Status = undef;                # created in TDS::Initialize

$TDSHomePage = "http://www.morito.mgmt.waseda.ac.jp/~tom/TomSoft/TsDiary/";

# static initialize function:
# should be called in the end of 'conf.ph'

my $Initialized = 0;     # DO NOT CHANGE

$Unreleased = 0;
my $Pre = 0;

$MainVersion = "1.4.2";
$Version = GetVersionString($MainVersion,
			    'unreleased'=>$Unreleased,
			    'pre'=>$Pre);
$SetupedVersion = undef;

Initialize();

sub Initialize
{
    # check already initialized
    return if $Initialized;
    $Initialized = 1;

##    warn " initialize start";
#    print STDERR "initialize start:", times, "<br>\n";
    # require conf.ph
#    print STDERR "conf:", times(), "\n";
    eval "require 'conf.ph'";
    if ($@){
	if (-f './conf.ph'){
	    require './conf.ph';
	} elsif (-f '../conf.ph'){
	    require '../conf.ph';      # for admin tools
	}
    }
#    print STDERR "conf done:", times(), "\n";
    require TDS::DirInfo;
    &TDS::DirInfo::SetDirs();
    
    # read customize.ph
    my $cus_dir = TDS::DirInfo::GetCustomizeDir();
    if (-f "$cus_dir/customize.ph"){
	require "$cus_dir/customize.ph";
    }

    require TDS::System;
    &CGI::QueryString::SetInternalJcode(TDS::System::GetInternalJcode());

    require TDS::Style;
    &TDS::Style::SetStyle();

#    warn " create status";
    require TDS::Status;
    $Status = new TDS::Status;
##    warn " initialize done";
}
sub GetVersionString ($;%)
{
    my ($number, %opt) = @_;

    my $version = $number;

    if ($opt{'pre'}){
	$version .= "-pre$opt{'pre'}";
    } elsif ($opt{'unreleased'}){    # for unreleased
	my $date = q($Date: 2001/03/04 15:48:57 $dummy);
	$date =~ m!: (\d+)/(\d+)/(\d+) !;
	$version .= "-unreleased$1$2$3-merged$Unreleased";
    }
    return $version;
}
##warn "TDS use done";
1;
