/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.util.RuntimeEOFException;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DefaultBitInputStream
extends DataInputStream
implements BitInputStream {
    private int nofBufferedBits = 0;
    private int byteBuffer = 0;
    private boolean throwEOF = true;
    private static final long[] masks = new long[]{0L, 1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L};

    public DefaultBitInputStream(InputStream in) {
        super(in);
    }

    @Override
    public final boolean readBit() {
        if (--this.nofBufferedBits >= 0) {
            return (this.byteBuffer >>> this.nofBufferedBits & 1) == 1;
        }
        this.nofBufferedBits = 7;
        try {
            this.byteBuffer = this.in.read();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        if (this.byteBuffer == -1 && this.throwEOF) {
            throw new RuntimeEOFException("End of stream.");
        }
        return (this.byteBuffer >>> 7 & 1) == 1;
    }

    @Override
    public final int readBits(int n) {
        if (n == 0) {
            return 0;
        }
        int x = 0;
        while (n > this.nofBufferedBits) {
            x |= DefaultBitInputStream.rightBits(this.nofBufferedBits, this.byteBuffer) << (n -= this.nofBufferedBits);
            try {
                this.byteBuffer = this.in.read();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            if (this.byteBuffer == -1) {
                throw new RuntimeEOFException("End of stream.");
            }
            this.nofBufferedBits = 8;
        }
        this.nofBufferedBits -= n;
        return x | DefaultBitInputStream.rightBits(n, this.byteBuffer >>> this.nofBufferedBits);
    }

    private static int rightBits(int n, int x) {
        return x & (1 << n) - 1;
    }

    @Override
    public final long readLongBits(int n) {
        if (n > 64) {
            throw new RuntimeException("More then 64 bits are requested in one read from bit stream.");
        }
        if (n == 0) {
            return 0L;
        }
        long x = 0L;
        long byteBuffer = this.byteBuffer;
        if (this.nofBufferedBits == 0) {
            try {
                byteBuffer = this.in.read();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            if (byteBuffer == -1L) {
                throw new RuntimeEOFException("End of stream.");
            }
            this.nofBufferedBits = 8;
        }
        byteBuffer &= masks[this.nofBufferedBits];
        while (n > this.nofBufferedBits) {
            x |= byteBuffer << (n -= this.nofBufferedBits);
            try {
                byteBuffer = this.in.read();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            if (byteBuffer == -1L) {
                throw new RuntimeEOFException("End of stream.");
            }
            this.nofBufferedBits = 8;
        }
        this.nofBufferedBits -= n;
        this.byteBuffer = (int)(byteBuffer & masks[this.nofBufferedBits]);
        return x | byteBuffer >>> this.nofBufferedBits;
    }

    @Override
    public void reset() {
        this.nofBufferedBits = 0;
        this.byteBuffer = 0;
    }
}

