require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&OPENSSL_X509_VFY_H)) {
    eval 'sub OPENSSL_X509_VFY_H () {1;}' unless defined(&OPENSSL_X509_VFY_H);
    require 'openssl/macros.ph';
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub HEADER_X509_VFY_H () {1;}' unless defined(&HEADER_X509_VFY_H);
    }
    unless(defined(&OPENSSL_X509_H)) {
	require 'openssl/x509.ph';
    }
    require 'openssl/opensslconf.ph';
    require 'openssl/lhash.ph';
    require 'openssl/bio.ph';
    require 'openssl/crypto.ph';
    require 'openssl/symhacks.ph';
    if(defined(&__cplusplus)) {
    }
    eval("sub X509_LU_NONE () { 0; }") unless defined(&X509_LU_NONE);
    eval("sub X509_LU_X509 () { 1; }") unless defined(&X509_LU_X509);
    eval("sub X509_LU_CRL () { 2; }") unless defined(&X509_LU_CRL);
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	eval 'sub X509_LU_RETRY () {-1;}' unless defined(&X509_LU_RETRY);
	eval 'sub X509_LU_FAIL () {0;}' unless defined(&X509_LU_FAIL);
    }
    eval 'sub sk_X509_LOOKUP_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_X509_LOOKUP_sk_type($sk)));
    }' unless defined(&sk_X509_LOOKUP_num);
    eval 'sub sk_X509_LOOKUP_value {
        my($sk, $idx) = @_;
	    eval q((( &X509_LOOKUP *) &OPENSSL_sk_value( &ossl_check_const_X509_LOOKUP_sk_type($sk), ($idx))));
    }' unless defined(&sk_X509_LOOKUP_value);
    eval 'sub sk_X509_LOOKUP_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &X509_LOOKUP) *) &OPENSSL_sk_new( &ossl_check_X509_LOOKUP_compfunc_type($cmp))));
    }' unless defined(&sk_X509_LOOKUP_new);
    eval 'sub sk_X509_LOOKUP_new_null () {
        eval q((( &STACK_OF( &X509_LOOKUP) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_X509_LOOKUP_new_null);
    eval 'sub sk_X509_LOOKUP_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &X509_LOOKUP) *) &OPENSSL_sk_new_reserve( &ossl_check_X509_LOOKUP_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_X509_LOOKUP_new_reserve);
    eval 'sub sk_X509_LOOKUP_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_X509_LOOKUP_sk_type($sk), ($n)));
    }' unless defined(&sk_X509_LOOKUP_reserve);
    eval 'sub sk_X509_LOOKUP_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_X509_LOOKUP_sk_type($sk)));
    }' unless defined(&sk_X509_LOOKUP_free);
    eval 'sub sk_X509_LOOKUP_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_X509_LOOKUP_sk_type($sk)));
    }' unless defined(&sk_X509_LOOKUP_zero);
    eval 'sub sk_X509_LOOKUP_delete {
        my($sk, $i) = @_;
	    eval q((( &X509_LOOKUP *) &OPENSSL_sk_delete( &ossl_check_X509_LOOKUP_sk_type($sk), ($i))));
    }' unless defined(&sk_X509_LOOKUP_delete);
    eval 'sub sk_X509_LOOKUP_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &X509_LOOKUP *) &OPENSSL_sk_delete_ptr( &ossl_check_X509_LOOKUP_sk_type($sk),  &ossl_check_X509_LOOKUP_type($ptr))));
    }' unless defined(&sk_X509_LOOKUP_delete_ptr);
    eval 'sub sk_X509_LOOKUP_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_X509_LOOKUP_sk_type($sk),  &ossl_check_X509_LOOKUP_type($ptr)));
    }' unless defined(&sk_X509_LOOKUP_push);
    eval 'sub sk_X509_LOOKUP_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_X509_LOOKUP_sk_type($sk),  &ossl_check_X509_LOOKUP_type($ptr)));
    }' unless defined(&sk_X509_LOOKUP_unshift);
    eval 'sub sk_X509_LOOKUP_pop {
        my($sk) = @_;
	    eval q((( &X509_LOOKUP *) &OPENSSL_sk_pop( &ossl_check_X509_LOOKUP_sk_type($sk))));
    }' unless defined(&sk_X509_LOOKUP_pop);
    eval 'sub sk_X509_LOOKUP_shift {
        my($sk) = @_;
	    eval q((( &X509_LOOKUP *) &OPENSSL_sk_shift( &ossl_check_X509_LOOKUP_sk_type($sk))));
    }' unless defined(&sk_X509_LOOKUP_shift);
    eval 'sub sk_X509_LOOKUP_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_X509_LOOKUP_sk_type($sk), &ossl_check_X509_LOOKUP_freefunc_type($freefunc)));
    }' unless defined(&sk_X509_LOOKUP_pop_free);
    eval 'sub sk_X509_LOOKUP_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_X509_LOOKUP_sk_type($sk),  &ossl_check_X509_LOOKUP_type($ptr), ($idx)));
    }' unless defined(&sk_X509_LOOKUP_insert);
    eval 'sub sk_X509_LOOKUP_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &X509_LOOKUP *) &OPENSSL_sk_set( &ossl_check_X509_LOOKUP_sk_type($sk), ($idx),  &ossl_check_X509_LOOKUP_type($ptr))));
    }' unless defined(&sk_X509_LOOKUP_set);
    eval 'sub sk_X509_LOOKUP_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_X509_LOOKUP_sk_type($sk),  &ossl_check_X509_LOOKUP_type($ptr)));
    }' unless defined(&sk_X509_LOOKUP_find);
    eval 'sub sk_X509_LOOKUP_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_X509_LOOKUP_sk_type($sk),  &ossl_check_X509_LOOKUP_type($ptr)));
    }' unless defined(&sk_X509_LOOKUP_find_ex);
    eval 'sub sk_X509_LOOKUP_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_X509_LOOKUP_sk_type($sk),  &ossl_check_X509_LOOKUP_type($ptr), $pnum));
    }' unless defined(&sk_X509_LOOKUP_find_all);
    eval 'sub sk_X509_LOOKUP_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_X509_LOOKUP_sk_type($sk)));
    }' unless defined(&sk_X509_LOOKUP_sort);
    eval 'sub sk_X509_LOOKUP_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_X509_LOOKUP_sk_type($sk)));
    }' unless defined(&sk_X509_LOOKUP_is_sorted);
    eval 'sub sk_X509_LOOKUP_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &X509_LOOKUP) *) &OPENSSL_sk_dup( &ossl_check_const_X509_LOOKUP_sk_type($sk))));
    }' unless defined(&sk_X509_LOOKUP_dup);
    eval 'sub sk_X509_LOOKUP_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &X509_LOOKUP) *) &OPENSSL_sk_deep_copy( &ossl_check_const_X509_LOOKUP_sk_type($sk),  &ossl_check_X509_LOOKUP_copyfunc_type($copyfunc),  &ossl_check_X509_LOOKUP_freefunc_type($freefunc))));
    }' unless defined(&sk_X509_LOOKUP_deep_copy);
    eval 'sub sk_X509_LOOKUP_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_X509_LOOKUP_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_X509_LOOKUP_sk_type($sk),  &ossl_check_X509_LOOKUP_compfunc_type($cmp))));
    }' unless defined(&sk_X509_LOOKUP_set_cmp_func);
    eval 'sub sk_X509_OBJECT_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_X509_OBJECT_sk_type($sk)));
    }' unless defined(&sk_X509_OBJECT_num);
    eval 'sub sk_X509_OBJECT_value {
        my($sk, $idx) = @_;
	    eval q((( &X509_OBJECT *) &OPENSSL_sk_value( &ossl_check_const_X509_OBJECT_sk_type($sk), ($idx))));
    }' unless defined(&sk_X509_OBJECT_value);
    eval 'sub sk_X509_OBJECT_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &X509_OBJECT) *) &OPENSSL_sk_new( &ossl_check_X509_OBJECT_compfunc_type($cmp))));
    }' unless defined(&sk_X509_OBJECT_new);
    eval 'sub sk_X509_OBJECT_new_null () {
        eval q((( &STACK_OF( &X509_OBJECT) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_X509_OBJECT_new_null);
    eval 'sub sk_X509_OBJECT_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &X509_OBJECT) *) &OPENSSL_sk_new_reserve( &ossl_check_X509_OBJECT_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_X509_OBJECT_new_reserve);
    eval 'sub sk_X509_OBJECT_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_X509_OBJECT_sk_type($sk), ($n)));
    }' unless defined(&sk_X509_OBJECT_reserve);
    eval 'sub sk_X509_OBJECT_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_X509_OBJECT_sk_type($sk)));
    }' unless defined(&sk_X509_OBJECT_free);
    eval 'sub sk_X509_OBJECT_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_X509_OBJECT_sk_type($sk)));
    }' unless defined(&sk_X509_OBJECT_zero);
    eval 'sub sk_X509_OBJECT_delete {
        my($sk, $i) = @_;
	    eval q((( &X509_OBJECT *) &OPENSSL_sk_delete( &ossl_check_X509_OBJECT_sk_type($sk), ($i))));
    }' unless defined(&sk_X509_OBJECT_delete);
    eval 'sub sk_X509_OBJECT_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &X509_OBJECT *) &OPENSSL_sk_delete_ptr( &ossl_check_X509_OBJECT_sk_type($sk),  &ossl_check_X509_OBJECT_type($ptr))));
    }' unless defined(&sk_X509_OBJECT_delete_ptr);
    eval 'sub sk_X509_OBJECT_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_X509_OBJECT_sk_type($sk),  &ossl_check_X509_OBJECT_type($ptr)));
    }' unless defined(&sk_X509_OBJECT_push);
    eval 'sub sk_X509_OBJECT_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_X509_OBJECT_sk_type($sk),  &ossl_check_X509_OBJECT_type($ptr)));
    }' unless defined(&sk_X509_OBJECT_unshift);
    eval 'sub sk_X509_OBJECT_pop {
        my($sk) = @_;
	    eval q((( &X509_OBJECT *) &OPENSSL_sk_pop( &ossl_check_X509_OBJECT_sk_type($sk))));
    }' unless defined(&sk_X509_OBJECT_pop);
    eval 'sub sk_X509_OBJECT_shift {
        my($sk) = @_;
	    eval q((( &X509_OBJECT *) &OPENSSL_sk_shift( &ossl_check_X509_OBJECT_sk_type($sk))));
    }' unless defined(&sk_X509_OBJECT_shift);
    eval 'sub sk_X509_OBJECT_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_X509_OBJECT_sk_type($sk), &ossl_check_X509_OBJECT_freefunc_type($freefunc)));
    }' unless defined(&sk_X509_OBJECT_pop_free);
    eval 'sub sk_X509_OBJECT_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_X509_OBJECT_sk_type($sk),  &ossl_check_X509_OBJECT_type($ptr), ($idx)));
    }' unless defined(&sk_X509_OBJECT_insert);
    eval 'sub sk_X509_OBJECT_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &X509_OBJECT *) &OPENSSL_sk_set( &ossl_check_X509_OBJECT_sk_type($sk), ($idx),  &ossl_check_X509_OBJECT_type($ptr))));
    }' unless defined(&sk_X509_OBJECT_set);
    eval 'sub sk_X509_OBJECT_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_X509_OBJECT_sk_type($sk),  &ossl_check_X509_OBJECT_type($ptr)));
    }' unless defined(&sk_X509_OBJECT_find);
    eval 'sub sk_X509_OBJECT_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_X509_OBJECT_sk_type($sk),  &ossl_check_X509_OBJECT_type($ptr)));
    }' unless defined(&sk_X509_OBJECT_find_ex);
    eval 'sub sk_X509_OBJECT_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_X509_OBJECT_sk_type($sk),  &ossl_check_X509_OBJECT_type($ptr), $pnum));
    }' unless defined(&sk_X509_OBJECT_find_all);
    eval 'sub sk_X509_OBJECT_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_X509_OBJECT_sk_type($sk)));
    }' unless defined(&sk_X509_OBJECT_sort);
    eval 'sub sk_X509_OBJECT_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_X509_OBJECT_sk_type($sk)));
    }' unless defined(&sk_X509_OBJECT_is_sorted);
    eval 'sub sk_X509_OBJECT_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &X509_OBJECT) *) &OPENSSL_sk_dup( &ossl_check_const_X509_OBJECT_sk_type($sk))));
    }' unless defined(&sk_X509_OBJECT_dup);
    eval 'sub sk_X509_OBJECT_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &X509_OBJECT) *) &OPENSSL_sk_deep_copy( &ossl_check_const_X509_OBJECT_sk_type($sk),  &ossl_check_X509_OBJECT_copyfunc_type($copyfunc),  &ossl_check_X509_OBJECT_freefunc_type($freefunc))));
    }' unless defined(&sk_X509_OBJECT_deep_copy);
    eval 'sub sk_X509_OBJECT_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_X509_OBJECT_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_X509_OBJECT_sk_type($sk),  &ossl_check_X509_OBJECT_compfunc_type($cmp))));
    }' unless defined(&sk_X509_OBJECT_set_cmp_func);
    eval 'sub sk_X509_VERIFY_PARAM_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_X509_VERIFY_PARAM_sk_type($sk)));
    }' unless defined(&sk_X509_VERIFY_PARAM_num);
    eval 'sub sk_X509_VERIFY_PARAM_value {
        my($sk, $idx) = @_;
	    eval q((( &X509_VERIFY_PARAM *) &OPENSSL_sk_value( &ossl_check_const_X509_VERIFY_PARAM_sk_type($sk), ($idx))));
    }' unless defined(&sk_X509_VERIFY_PARAM_value);
    eval 'sub sk_X509_VERIFY_PARAM_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &X509_VERIFY_PARAM) *) &OPENSSL_sk_new( &ossl_check_X509_VERIFY_PARAM_compfunc_type($cmp))));
    }' unless defined(&sk_X509_VERIFY_PARAM_new);
    eval 'sub sk_X509_VERIFY_PARAM_new_null () {
        eval q((( &STACK_OF( &X509_VERIFY_PARAM) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_X509_VERIFY_PARAM_new_null);
    eval 'sub sk_X509_VERIFY_PARAM_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &X509_VERIFY_PARAM) *) &OPENSSL_sk_new_reserve( &ossl_check_X509_VERIFY_PARAM_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_X509_VERIFY_PARAM_new_reserve);
    eval 'sub sk_X509_VERIFY_PARAM_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_X509_VERIFY_PARAM_sk_type($sk), ($n)));
    }' unless defined(&sk_X509_VERIFY_PARAM_reserve);
    eval 'sub sk_X509_VERIFY_PARAM_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_X509_VERIFY_PARAM_sk_type($sk)));
    }' unless defined(&sk_X509_VERIFY_PARAM_free);
    eval 'sub sk_X509_VERIFY_PARAM_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_X509_VERIFY_PARAM_sk_type($sk)));
    }' unless defined(&sk_X509_VERIFY_PARAM_zero);
    eval 'sub sk_X509_VERIFY_PARAM_delete {
        my($sk, $i) = @_;
	    eval q((( &X509_VERIFY_PARAM *) &OPENSSL_sk_delete( &ossl_check_X509_VERIFY_PARAM_sk_type($sk), ($i))));
    }' unless defined(&sk_X509_VERIFY_PARAM_delete);
    eval 'sub sk_X509_VERIFY_PARAM_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &X509_VERIFY_PARAM *) &OPENSSL_sk_delete_ptr( &ossl_check_X509_VERIFY_PARAM_sk_type($sk),  &ossl_check_X509_VERIFY_PARAM_type($ptr))));
    }' unless defined(&sk_X509_VERIFY_PARAM_delete_ptr);
    eval 'sub sk_X509_VERIFY_PARAM_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_X509_VERIFY_PARAM_sk_type($sk),  &ossl_check_X509_VERIFY_PARAM_type($ptr)));
    }' unless defined(&sk_X509_VERIFY_PARAM_push);
    eval 'sub sk_X509_VERIFY_PARAM_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_X509_VERIFY_PARAM_sk_type($sk),  &ossl_check_X509_VERIFY_PARAM_type($ptr)));
    }' unless defined(&sk_X509_VERIFY_PARAM_unshift);
    eval 'sub sk_X509_VERIFY_PARAM_pop {
        my($sk) = @_;
	    eval q((( &X509_VERIFY_PARAM *) &OPENSSL_sk_pop( &ossl_check_X509_VERIFY_PARAM_sk_type($sk))));
    }' unless defined(&sk_X509_VERIFY_PARAM_pop);
    eval 'sub sk_X509_VERIFY_PARAM_shift {
        my($sk) = @_;
	    eval q((( &X509_VERIFY_PARAM *) &OPENSSL_sk_shift( &ossl_check_X509_VERIFY_PARAM_sk_type($sk))));
    }' unless defined(&sk_X509_VERIFY_PARAM_shift);
    eval 'sub sk_X509_VERIFY_PARAM_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_X509_VERIFY_PARAM_sk_type($sk), &ossl_check_X509_VERIFY_PARAM_freefunc_type($freefunc)));
    }' unless defined(&sk_X509_VERIFY_PARAM_pop_free);
    eval 'sub sk_X509_VERIFY_PARAM_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_X509_VERIFY_PARAM_sk_type($sk),  &ossl_check_X509_VERIFY_PARAM_type($ptr), ($idx)));
    }' unless defined(&sk_X509_VERIFY_PARAM_insert);
    eval 'sub sk_X509_VERIFY_PARAM_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &X509_VERIFY_PARAM *) &OPENSSL_sk_set( &ossl_check_X509_VERIFY_PARAM_sk_type($sk), ($idx),  &ossl_check_X509_VERIFY_PARAM_type($ptr))));
    }' unless defined(&sk_X509_VERIFY_PARAM_set);
    eval 'sub sk_X509_VERIFY_PARAM_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_X509_VERIFY_PARAM_sk_type($sk),  &ossl_check_X509_VERIFY_PARAM_type($ptr)));
    }' unless defined(&sk_X509_VERIFY_PARAM_find);
    eval 'sub sk_X509_VERIFY_PARAM_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_X509_VERIFY_PARAM_sk_type($sk),  &ossl_check_X509_VERIFY_PARAM_type($ptr)));
    }' unless defined(&sk_X509_VERIFY_PARAM_find_ex);
    eval 'sub sk_X509_VERIFY_PARAM_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_X509_VERIFY_PARAM_sk_type($sk),  &ossl_check_X509_VERIFY_PARAM_type($ptr), $pnum));
    }' unless defined(&sk_X509_VERIFY_PARAM_find_all);
    eval 'sub sk_X509_VERIFY_PARAM_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_X509_VERIFY_PARAM_sk_type($sk)));
    }' unless defined(&sk_X509_VERIFY_PARAM_sort);
    eval 'sub sk_X509_VERIFY_PARAM_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_X509_VERIFY_PARAM_sk_type($sk)));
    }' unless defined(&sk_X509_VERIFY_PARAM_is_sorted);
    eval 'sub sk_X509_VERIFY_PARAM_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &X509_VERIFY_PARAM) *) &OPENSSL_sk_dup( &ossl_check_const_X509_VERIFY_PARAM_sk_type($sk))));
    }' unless defined(&sk_X509_VERIFY_PARAM_dup);
    eval 'sub sk_X509_VERIFY_PARAM_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &X509_VERIFY_PARAM) *) &OPENSSL_sk_deep_copy( &ossl_check_const_X509_VERIFY_PARAM_sk_type($sk),  &ossl_check_X509_VERIFY_PARAM_copyfunc_type($copyfunc),  &ossl_check_X509_VERIFY_PARAM_freefunc_type($freefunc))));
    }' unless defined(&sk_X509_VERIFY_PARAM_deep_copy);
    eval 'sub sk_X509_VERIFY_PARAM_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_X509_VERIFY_PARAM_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_X509_VERIFY_PARAM_sk_type($sk),  &ossl_check_X509_VERIFY_PARAM_compfunc_type($cmp))));
    }' unless defined(&sk_X509_VERIFY_PARAM_set_cmp_func);
    eval 'sub sk_X509_TRUST_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_X509_TRUST_sk_type($sk)));
    }' unless defined(&sk_X509_TRUST_num);
    eval 'sub sk_X509_TRUST_value {
        my($sk, $idx) = @_;
	    eval q((( &X509_TRUST *) &OPENSSL_sk_value( &ossl_check_const_X509_TRUST_sk_type($sk), ($idx))));
    }' unless defined(&sk_X509_TRUST_value);
    eval 'sub sk_X509_TRUST_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &X509_TRUST) *) &OPENSSL_sk_new( &ossl_check_X509_TRUST_compfunc_type($cmp))));
    }' unless defined(&sk_X509_TRUST_new);
    eval 'sub sk_X509_TRUST_new_null () {
        eval q((( &STACK_OF( &X509_TRUST) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_X509_TRUST_new_null);
    eval 'sub sk_X509_TRUST_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &X509_TRUST) *) &OPENSSL_sk_new_reserve( &ossl_check_X509_TRUST_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_X509_TRUST_new_reserve);
    eval 'sub sk_X509_TRUST_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_X509_TRUST_sk_type($sk), ($n)));
    }' unless defined(&sk_X509_TRUST_reserve);
    eval 'sub sk_X509_TRUST_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_X509_TRUST_sk_type($sk)));
    }' unless defined(&sk_X509_TRUST_free);
    eval 'sub sk_X509_TRUST_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_X509_TRUST_sk_type($sk)));
    }' unless defined(&sk_X509_TRUST_zero);
    eval 'sub sk_X509_TRUST_delete {
        my($sk, $i) = @_;
	    eval q((( &X509_TRUST *) &OPENSSL_sk_delete( &ossl_check_X509_TRUST_sk_type($sk), ($i))));
    }' unless defined(&sk_X509_TRUST_delete);
    eval 'sub sk_X509_TRUST_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &X509_TRUST *) &OPENSSL_sk_delete_ptr( &ossl_check_X509_TRUST_sk_type($sk),  &ossl_check_X509_TRUST_type($ptr))));
    }' unless defined(&sk_X509_TRUST_delete_ptr);
    eval 'sub sk_X509_TRUST_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_X509_TRUST_sk_type($sk),  &ossl_check_X509_TRUST_type($ptr)));
    }' unless defined(&sk_X509_TRUST_push);
    eval 'sub sk_X509_TRUST_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_X509_TRUST_sk_type($sk),  &ossl_check_X509_TRUST_type($ptr)));
    }' unless defined(&sk_X509_TRUST_unshift);
    eval 'sub sk_X509_TRUST_pop {
        my($sk) = @_;
	    eval q((( &X509_TRUST *) &OPENSSL_sk_pop( &ossl_check_X509_TRUST_sk_type($sk))));
    }' unless defined(&sk_X509_TRUST_pop);
    eval 'sub sk_X509_TRUST_shift {
        my($sk) = @_;
	    eval q((( &X509_TRUST *) &OPENSSL_sk_shift( &ossl_check_X509_TRUST_sk_type($sk))));
    }' unless defined(&sk_X509_TRUST_shift);
    eval 'sub sk_X509_TRUST_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_X509_TRUST_sk_type($sk), &ossl_check_X509_TRUST_freefunc_type($freefunc)));
    }' unless defined(&sk_X509_TRUST_pop_free);
    eval 'sub sk_X509_TRUST_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_X509_TRUST_sk_type($sk),  &ossl_check_X509_TRUST_type($ptr), ($idx)));
    }' unless defined(&sk_X509_TRUST_insert);
    eval 'sub sk_X509_TRUST_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &X509_TRUST *) &OPENSSL_sk_set( &ossl_check_X509_TRUST_sk_type($sk), ($idx),  &ossl_check_X509_TRUST_type($ptr))));
    }' unless defined(&sk_X509_TRUST_set);
    eval 'sub sk_X509_TRUST_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_X509_TRUST_sk_type($sk),  &ossl_check_X509_TRUST_type($ptr)));
    }' unless defined(&sk_X509_TRUST_find);
    eval 'sub sk_X509_TRUST_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_X509_TRUST_sk_type($sk),  &ossl_check_X509_TRUST_type($ptr)));
    }' unless defined(&sk_X509_TRUST_find_ex);
    eval 'sub sk_X509_TRUST_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_X509_TRUST_sk_type($sk),  &ossl_check_X509_TRUST_type($ptr), $pnum));
    }' unless defined(&sk_X509_TRUST_find_all);
    eval 'sub sk_X509_TRUST_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_X509_TRUST_sk_type($sk)));
    }' unless defined(&sk_X509_TRUST_sort);
    eval 'sub sk_X509_TRUST_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_X509_TRUST_sk_type($sk)));
    }' unless defined(&sk_X509_TRUST_is_sorted);
    eval 'sub sk_X509_TRUST_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &X509_TRUST) *) &OPENSSL_sk_dup( &ossl_check_const_X509_TRUST_sk_type($sk))));
    }' unless defined(&sk_X509_TRUST_dup);
    eval 'sub sk_X509_TRUST_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &X509_TRUST) *) &OPENSSL_sk_deep_copy( &ossl_check_const_X509_TRUST_sk_type($sk),  &ossl_check_X509_TRUST_copyfunc_type($copyfunc),  &ossl_check_X509_TRUST_freefunc_type($freefunc))));
    }' unless defined(&sk_X509_TRUST_deep_copy);
    eval 'sub sk_X509_TRUST_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_X509_TRUST_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_X509_TRUST_sk_type($sk),  &ossl_check_X509_TRUST_compfunc_type($cmp))));
    }' unless defined(&sk_X509_TRUST_set_cmp_func);
    eval 'sub X509_TRUST_DEFAULT () {0;}' unless defined(&X509_TRUST_DEFAULT);
    eval 'sub X509_TRUST_COMPAT () {1;}' unless defined(&X509_TRUST_COMPAT);
    eval 'sub X509_TRUST_SSL_CLIENT () {2;}' unless defined(&X509_TRUST_SSL_CLIENT);
    eval 'sub X509_TRUST_SSL_SERVER () {3;}' unless defined(&X509_TRUST_SSL_SERVER);
    eval 'sub X509_TRUST_EMAIL () {4;}' unless defined(&X509_TRUST_EMAIL);
    eval 'sub X509_TRUST_OBJECT_SIGN () {5;}' unless defined(&X509_TRUST_OBJECT_SIGN);
    eval 'sub X509_TRUST_OCSP_SIGN () {6;}' unless defined(&X509_TRUST_OCSP_SIGN);
    eval 'sub X509_TRUST_OCSP_REQUEST () {7;}' unless defined(&X509_TRUST_OCSP_REQUEST);
    eval 'sub X509_TRUST_TSA () {8;}' unless defined(&X509_TRUST_TSA);
    eval 'sub X509_TRUST_MIN () {1;}' unless defined(&X509_TRUST_MIN);
    eval 'sub X509_TRUST_MAX () {8;}' unless defined(&X509_TRUST_MAX);
    eval 'sub X509_TRUST_DYNAMIC () {(1 << 0);}' unless defined(&X509_TRUST_DYNAMIC);
    eval 'sub X509_TRUST_DYNAMIC_NAME () {(1 << 1);}' unless defined(&X509_TRUST_DYNAMIC_NAME);
    eval 'sub X509_TRUST_NO_SS_COMPAT () {(1 << 2);}' unless defined(&X509_TRUST_NO_SS_COMPAT);
    eval 'sub X509_TRUST_DO_SS_COMPAT () {(1 << 3);}' unless defined(&X509_TRUST_DO_SS_COMPAT);
    eval 'sub X509_TRUST_OK_ANY_EKU () {(1 << 4);}' unless defined(&X509_TRUST_OK_ANY_EKU);
    eval 'sub X509_TRUST_TRUSTED () {1;}' unless defined(&X509_TRUST_TRUSTED);
    eval 'sub X509_TRUST_REJECTED () {2;}' unless defined(&X509_TRUST_REJECTED);
    eval 'sub X509_TRUST_UNTRUSTED () {3;}' unless defined(&X509_TRUST_UNTRUSTED);
    eval 'sub X509_STORE_CTX_set_app_data {
        my($ctx,$data) = @_;
	    eval q( &X509_STORE_CTX_set_ex_data($ctx,0,$data));
    }' unless defined(&X509_STORE_CTX_set_app_data);
    eval 'sub X509_STORE_CTX_get_app_data {
        my($ctx) = @_;
	    eval q( &X509_STORE_CTX_get_ex_data($ctx,0));
    }' unless defined(&X509_STORE_CTX_get_app_data);
    eval 'sub X509_L_FILE_LOAD () {1;}' unless defined(&X509_L_FILE_LOAD);
    eval 'sub X509_L_ADD_DIR () {2;}' unless defined(&X509_L_ADD_DIR);
    eval 'sub X509_L_ADD_STORE () {3;}' unless defined(&X509_L_ADD_STORE);
    eval 'sub X509_L_LOAD_STORE () {4;}' unless defined(&X509_L_LOAD_STORE);
    eval 'sub X509_LOOKUP_load_file {
        my($x,$name,$type) = @_;
	    eval q( &X509_LOOKUP_ctrl(, &X509_L_FILE_LOAD,,($type), &NULL));
    }' unless defined(&X509_LOOKUP_load_file);
    eval 'sub X509_LOOKUP_add_dir {
        my($x,$name,$type) = @_;
	    eval q( &X509_LOOKUP_ctrl(, &X509_L_ADD_DIR,,($type), &NULL));
    }' unless defined(&X509_LOOKUP_add_dir);
    eval 'sub X509_LOOKUP_add_store {
        my($x,$name) = @_;
	    eval q( &X509_LOOKUP_ctrl(($x), &X509_L_ADD_STORE,($name),0, &NULL));
    }' unless defined(&X509_LOOKUP_add_store);
    eval 'sub X509_LOOKUP_load_store {
        my($x,$name) = @_;
	    eval q( &X509_LOOKUP_ctrl(($x), &X509_L_LOAD_STORE,($name),0, &NULL));
    }' unless defined(&X509_LOOKUP_load_store);
    eval 'sub X509_LOOKUP_load_file_ex {
        my($x, $name, $type, $libctx, $propq) = @_;
	    eval q( &X509_LOOKUP_ctrl_ex(,  &X509_L_FILE_LOAD, , ($type),  &NULL, ($libctx), ($propq)));
    }' unless defined(&X509_LOOKUP_load_file_ex);
    eval 'sub X509_LOOKUP_load_store_ex {
        my($x, $name, $libctx, $propq) = @_;
	    eval q( &X509_LOOKUP_ctrl_ex(($x),  &X509_L_LOAD_STORE, ($name), 0,  &NULL, ($libctx), ($propq)));
    }' unless defined(&X509_LOOKUP_load_store_ex);
    eval 'sub X509_LOOKUP_add_store_ex {
        my($x, $name, $libctx, $propq) = @_;
	    eval q( &X509_LOOKUP_ctrl_ex(($x),  &X509_L_ADD_STORE, ($name), 0,  &NULL, ($libctx), ($propq)));
    }' unless defined(&X509_LOOKUP_add_store_ex);
    eval 'sub X509_V_OK () {0;}' unless defined(&X509_V_OK);
    eval 'sub X509_V_ERR_UNSPECIFIED () {1;}' unless defined(&X509_V_ERR_UNSPECIFIED);
    eval 'sub X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT () {2;}' unless defined(&X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT);
    eval 'sub X509_V_ERR_UNABLE_TO_GET_CRL () {3;}' unless defined(&X509_V_ERR_UNABLE_TO_GET_CRL);
    eval 'sub X509_V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE () {4;}' unless defined(&X509_V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE);
    eval 'sub X509_V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE () {5;}' unless defined(&X509_V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE);
    eval 'sub X509_V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY () {6;}' unless defined(&X509_V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY);
    eval 'sub X509_V_ERR_CERT_SIGNATURE_FAILURE () {7;}' unless defined(&X509_V_ERR_CERT_SIGNATURE_FAILURE);
    eval 'sub X509_V_ERR_CRL_SIGNATURE_FAILURE () {8;}' unless defined(&X509_V_ERR_CRL_SIGNATURE_FAILURE);
    eval 'sub X509_V_ERR_CERT_NOT_YET_VALID () {9;}' unless defined(&X509_V_ERR_CERT_NOT_YET_VALID);
    eval 'sub X509_V_ERR_CERT_HAS_EXPIRED () {10;}' unless defined(&X509_V_ERR_CERT_HAS_EXPIRED);
    eval 'sub X509_V_ERR_CRL_NOT_YET_VALID () {11;}' unless defined(&X509_V_ERR_CRL_NOT_YET_VALID);
    eval 'sub X509_V_ERR_CRL_HAS_EXPIRED () {12;}' unless defined(&X509_V_ERR_CRL_HAS_EXPIRED);
    eval 'sub X509_V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD () {13;}' unless defined(&X509_V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD);
    eval 'sub X509_V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD () {14;}' unless defined(&X509_V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD);
    eval 'sub X509_V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD () {15;}' unless defined(&X509_V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD);
    eval 'sub X509_V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD () {16;}' unless defined(&X509_V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD);
    eval 'sub X509_V_ERR_OUT_OF_MEM () {17;}' unless defined(&X509_V_ERR_OUT_OF_MEM);
    eval 'sub X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT () {18;}' unless defined(&X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT);
    eval 'sub X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN () {19;}' unless defined(&X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN);
    eval 'sub X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY () {20;}' unless defined(&X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY);
    eval 'sub X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE () {21;}' unless defined(&X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE);
    eval 'sub X509_V_ERR_CERT_CHAIN_TOO_LONG () {22;}' unless defined(&X509_V_ERR_CERT_CHAIN_TOO_LONG);
    eval 'sub X509_V_ERR_CERT_REVOKED () {23;}' unless defined(&X509_V_ERR_CERT_REVOKED);
    eval 'sub X509_V_ERR_NO_ISSUER_PUBLIC_KEY () {24;}' unless defined(&X509_V_ERR_NO_ISSUER_PUBLIC_KEY);
    eval 'sub X509_V_ERR_PATH_LENGTH_EXCEEDED () {25;}' unless defined(&X509_V_ERR_PATH_LENGTH_EXCEEDED);
    eval 'sub X509_V_ERR_INVALID_PURPOSE () {26;}' unless defined(&X509_V_ERR_INVALID_PURPOSE);
    eval 'sub X509_V_ERR_CERT_UNTRUSTED () {27;}' unless defined(&X509_V_ERR_CERT_UNTRUSTED);
    eval 'sub X509_V_ERR_CERT_REJECTED () {28;}' unless defined(&X509_V_ERR_CERT_REJECTED);
    eval 'sub X509_V_ERR_SUBJECT_ISSUER_MISMATCH () {29;}' unless defined(&X509_V_ERR_SUBJECT_ISSUER_MISMATCH);
    eval 'sub X509_V_ERR_AKID_SKID_MISMATCH () {30;}' unless defined(&X509_V_ERR_AKID_SKID_MISMATCH);
    eval 'sub X509_V_ERR_AKID_ISSUER_SERIAL_MISMATCH () {31;}' unless defined(&X509_V_ERR_AKID_ISSUER_SERIAL_MISMATCH);
    eval 'sub X509_V_ERR_KEYUSAGE_NO_CERTSIGN () {32;}' unless defined(&X509_V_ERR_KEYUSAGE_NO_CERTSIGN);
    eval 'sub X509_V_ERR_UNABLE_TO_GET_CRL_ISSUER () {33;}' unless defined(&X509_V_ERR_UNABLE_TO_GET_CRL_ISSUER);
    eval 'sub X509_V_ERR_UNHANDLED_CRITICAL_EXTENSION () {34;}' unless defined(&X509_V_ERR_UNHANDLED_CRITICAL_EXTENSION);
    eval 'sub X509_V_ERR_KEYUSAGE_NO_CRL_SIGN () {35;}' unless defined(&X509_V_ERR_KEYUSAGE_NO_CRL_SIGN);
    eval 'sub X509_V_ERR_UNHANDLED_CRITICAL_CRL_EXTENSION () {36;}' unless defined(&X509_V_ERR_UNHANDLED_CRITICAL_CRL_EXTENSION);
    eval 'sub X509_V_ERR_INVALID_NON_CA () {37;}' unless defined(&X509_V_ERR_INVALID_NON_CA);
    eval 'sub X509_V_ERR_PROXY_PATH_LENGTH_EXCEEDED () {38;}' unless defined(&X509_V_ERR_PROXY_PATH_LENGTH_EXCEEDED);
    eval 'sub X509_V_ERR_KEYUSAGE_NO_DIGITAL_SIGNATURE () {39;}' unless defined(&X509_V_ERR_KEYUSAGE_NO_DIGITAL_SIGNATURE);
    eval 'sub X509_V_ERR_PROXY_CERTIFICATES_NOT_ALLOWED () {40;}' unless defined(&X509_V_ERR_PROXY_CERTIFICATES_NOT_ALLOWED);
    eval 'sub X509_V_ERR_INVALID_EXTENSION () {41;}' unless defined(&X509_V_ERR_INVALID_EXTENSION);
    eval 'sub X509_V_ERR_INVALID_POLICY_EXTENSION () {42;}' unless defined(&X509_V_ERR_INVALID_POLICY_EXTENSION);
    eval 'sub X509_V_ERR_NO_EXPLICIT_POLICY () {43;}' unless defined(&X509_V_ERR_NO_EXPLICIT_POLICY);
    eval 'sub X509_V_ERR_DIFFERENT_CRL_SCOPE () {44;}' unless defined(&X509_V_ERR_DIFFERENT_CRL_SCOPE);
    eval 'sub X509_V_ERR_UNSUPPORTED_EXTENSION_FEATURE () {45;}' unless defined(&X509_V_ERR_UNSUPPORTED_EXTENSION_FEATURE);
    eval 'sub X509_V_ERR_UNNESTED_RESOURCE () {46;}' unless defined(&X509_V_ERR_UNNESTED_RESOURCE);
    eval 'sub X509_V_ERR_PERMITTED_VIOLATION () {47;}' unless defined(&X509_V_ERR_PERMITTED_VIOLATION);
    eval 'sub X509_V_ERR_EXCLUDED_VIOLATION () {48;}' unless defined(&X509_V_ERR_EXCLUDED_VIOLATION);
    eval 'sub X509_V_ERR_SUBTREE_MINMAX () {49;}' unless defined(&X509_V_ERR_SUBTREE_MINMAX);
    eval 'sub X509_V_ERR_APPLICATION_VERIFICATION () {50;}' unless defined(&X509_V_ERR_APPLICATION_VERIFICATION);
    eval 'sub X509_V_ERR_UNSUPPORTED_CONSTRAINT_TYPE () {51;}' unless defined(&X509_V_ERR_UNSUPPORTED_CONSTRAINT_TYPE);
    eval 'sub X509_V_ERR_UNSUPPORTED_CONSTRAINT_SYNTAX () {52;}' unless defined(&X509_V_ERR_UNSUPPORTED_CONSTRAINT_SYNTAX);
    eval 'sub X509_V_ERR_UNSUPPORTED_NAME_SYNTAX () {53;}' unless defined(&X509_V_ERR_UNSUPPORTED_NAME_SYNTAX);
    eval 'sub X509_V_ERR_CRL_PATH_VALIDATION_ERROR () {54;}' unless defined(&X509_V_ERR_CRL_PATH_VALIDATION_ERROR);
    eval 'sub X509_V_ERR_PATH_LOOP () {55;}' unless defined(&X509_V_ERR_PATH_LOOP);
    eval 'sub X509_V_ERR_SUITE_B_INVALID_VERSION () {56;}' unless defined(&X509_V_ERR_SUITE_B_INVALID_VERSION);
    eval 'sub X509_V_ERR_SUITE_B_INVALID_ALGORITHM () {57;}' unless defined(&X509_V_ERR_SUITE_B_INVALID_ALGORITHM);
    eval 'sub X509_V_ERR_SUITE_B_INVALID_CURVE () {58;}' unless defined(&X509_V_ERR_SUITE_B_INVALID_CURVE);
    eval 'sub X509_V_ERR_SUITE_B_INVALID_SIGNATURE_ALGORITHM () {59;}' unless defined(&X509_V_ERR_SUITE_B_INVALID_SIGNATURE_ALGORITHM);
    eval 'sub X509_V_ERR_SUITE_B_LOS_NOT_ALLOWED () {60;}' unless defined(&X509_V_ERR_SUITE_B_LOS_NOT_ALLOWED);
    eval 'sub X509_V_ERR_SUITE_B_CANNOT_SIGN_P_384_WITH_P_256 () {61;}' unless defined(&X509_V_ERR_SUITE_B_CANNOT_SIGN_P_384_WITH_P_256);
    eval 'sub X509_V_ERR_HOSTNAME_MISMATCH () {62;}' unless defined(&X509_V_ERR_HOSTNAME_MISMATCH);
    eval 'sub X509_V_ERR_EMAIL_MISMATCH () {63;}' unless defined(&X509_V_ERR_EMAIL_MISMATCH);
    eval 'sub X509_V_ERR_IP_ADDRESS_MISMATCH () {64;}' unless defined(&X509_V_ERR_IP_ADDRESS_MISMATCH);
    eval 'sub X509_V_ERR_DANE_NO_MATCH () {65;}' unless defined(&X509_V_ERR_DANE_NO_MATCH);
    eval 'sub X509_V_ERR_EE_KEY_TOO_SMALL () {66;}' unless defined(&X509_V_ERR_EE_KEY_TOO_SMALL);
    eval 'sub X509_V_ERR_CA_KEY_TOO_SMALL () {67;}' unless defined(&X509_V_ERR_CA_KEY_TOO_SMALL);
    eval 'sub X509_V_ERR_CA_MD_TOO_WEAK () {68;}' unless defined(&X509_V_ERR_CA_MD_TOO_WEAK);
    eval 'sub X509_V_ERR_INVALID_CALL () {69;}' unless defined(&X509_V_ERR_INVALID_CALL);
    eval 'sub X509_V_ERR_STORE_LOOKUP () {70;}' unless defined(&X509_V_ERR_STORE_LOOKUP);
    eval 'sub X509_V_ERR_NO_VALID_SCTS () {71;}' unless defined(&X509_V_ERR_NO_VALID_SCTS);
    eval 'sub X509_V_ERR_PROXY_SUBJECT_NAME_VIOLATION () {72;}' unless defined(&X509_V_ERR_PROXY_SUBJECT_NAME_VIOLATION);
    eval 'sub X509_V_ERR_OCSP_VERIFY_NEEDED () {73;}' unless defined(&X509_V_ERR_OCSP_VERIFY_NEEDED);
    eval 'sub X509_V_ERR_OCSP_VERIFY_FAILED () {74;}' unless defined(&X509_V_ERR_OCSP_VERIFY_FAILED);
    eval 'sub X509_V_ERR_OCSP_CERT_UNKNOWN () {75;}' unless defined(&X509_V_ERR_OCSP_CERT_UNKNOWN);
    eval 'sub X509_V_ERR_UNSUPPORTED_SIGNATURE_ALGORITHM () {76;}' unless defined(&X509_V_ERR_UNSUPPORTED_SIGNATURE_ALGORITHM);
    eval 'sub X509_V_ERR_SIGNATURE_ALGORITHM_MISMATCH () {77;}' unless defined(&X509_V_ERR_SIGNATURE_ALGORITHM_MISMATCH);
    eval 'sub X509_V_ERR_SIGNATURE_ALGORITHM_INCONSISTENCY () {78;}' unless defined(&X509_V_ERR_SIGNATURE_ALGORITHM_INCONSISTENCY);
    eval 'sub X509_V_ERR_INVALID_CA () {79;}' unless defined(&X509_V_ERR_INVALID_CA);
    eval 'sub X509_V_ERR_PATHLEN_INVALID_FOR_NON_CA () {80;}' unless defined(&X509_V_ERR_PATHLEN_INVALID_FOR_NON_CA);
    eval 'sub X509_V_ERR_PATHLEN_WITHOUT_KU_KEY_CERT_SIGN () {81;}' unless defined(&X509_V_ERR_PATHLEN_WITHOUT_KU_KEY_CERT_SIGN);
    eval 'sub X509_V_ERR_KU_KEY_CERT_SIGN_INVALID_FOR_NON_CA () {82;}' unless defined(&X509_V_ERR_KU_KEY_CERT_SIGN_INVALID_FOR_NON_CA);
    eval 'sub X509_V_ERR_ISSUER_NAME_EMPTY () {83;}' unless defined(&X509_V_ERR_ISSUER_NAME_EMPTY);
    eval 'sub X509_V_ERR_SUBJECT_NAME_EMPTY () {84;}' unless defined(&X509_V_ERR_SUBJECT_NAME_EMPTY);
    eval 'sub X509_V_ERR_MISSING_AUTHORITY_KEY_IDENTIFIER () {85;}' unless defined(&X509_V_ERR_MISSING_AUTHORITY_KEY_IDENTIFIER);
    eval 'sub X509_V_ERR_MISSING_SUBJECT_KEY_IDENTIFIER () {86;}' unless defined(&X509_V_ERR_MISSING_SUBJECT_KEY_IDENTIFIER);
    eval 'sub X509_V_ERR_EMPTY_SUBJECT_ALT_NAME () {87;}' unless defined(&X509_V_ERR_EMPTY_SUBJECT_ALT_NAME);
    eval 'sub X509_V_ERR_EMPTY_SUBJECT_SAN_NOT_CRITICAL () {88;}' unless defined(&X509_V_ERR_EMPTY_SUBJECT_SAN_NOT_CRITICAL);
    eval 'sub X509_V_ERR_CA_BCONS_NOT_CRITICAL () {89;}' unless defined(&X509_V_ERR_CA_BCONS_NOT_CRITICAL);
    eval 'sub X509_V_ERR_AUTHORITY_KEY_IDENTIFIER_CRITICAL () {90;}' unless defined(&X509_V_ERR_AUTHORITY_KEY_IDENTIFIER_CRITICAL);
    eval 'sub X509_V_ERR_SUBJECT_KEY_IDENTIFIER_CRITICAL () {91;}' unless defined(&X509_V_ERR_SUBJECT_KEY_IDENTIFIER_CRITICAL);
    eval 'sub X509_V_ERR_CA_CERT_MISSING_KEY_USAGE () {92;}' unless defined(&X509_V_ERR_CA_CERT_MISSING_KEY_USAGE);
    eval 'sub X509_V_ERR_EXTENSIONS_REQUIRE_VERSION_3 () {93;}' unless defined(&X509_V_ERR_EXTENSIONS_REQUIRE_VERSION_3);
    eval 'sub X509_V_ERR_EC_KEY_EXPLICIT_PARAMS () {94;}' unless defined(&X509_V_ERR_EC_KEY_EXPLICIT_PARAMS);
    eval 'sub X509_V_ERR_RPK_UNTRUSTED () {95;}' unless defined(&X509_V_ERR_RPK_UNTRUSTED);
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	eval 'sub X509_V_FLAG_CB_ISSUER_CHECK () {0x;}' unless defined(&X509_V_FLAG_CB_ISSUER_CHECK);
    }
    eval 'sub X509_V_FLAG_USE_CHECK_TIME () {0x2;}' unless defined(&X509_V_FLAG_USE_CHECK_TIME);
    eval 'sub X509_V_FLAG_CRL_CHECK () {0x4;}' unless defined(&X509_V_FLAG_CRL_CHECK);
    eval 'sub X509_V_FLAG_CRL_CHECK_ALL () {0x8;}' unless defined(&X509_V_FLAG_CRL_CHECK_ALL);
    eval 'sub X509_V_FLAG_IGNORE_CRITICAL () {0x10;}' unless defined(&X509_V_FLAG_IGNORE_CRITICAL);
    eval 'sub X509_V_FLAG_X509_STRICT () {0x20;}' unless defined(&X509_V_FLAG_X509_STRICT);
    eval 'sub X509_V_FLAG_ALLOW_PROXY_CERTS () {0x40;}' unless defined(&X509_V_FLAG_ALLOW_PROXY_CERTS);
    eval 'sub X509_V_FLAG_POLICY_CHECK () {0x80;}' unless defined(&X509_V_FLAG_POLICY_CHECK);
    eval 'sub X509_V_FLAG_EXPLICIT_POLICY () {0x100;}' unless defined(&X509_V_FLAG_EXPLICIT_POLICY);
    eval 'sub X509_V_FLAG_INHIBIT_ANY () {0x200;}' unless defined(&X509_V_FLAG_INHIBIT_ANY);
    eval 'sub X509_V_FLAG_INHIBIT_MAP () {0x400;}' unless defined(&X509_V_FLAG_INHIBIT_MAP);
    eval 'sub X509_V_FLAG_NOTIFY_POLICY () {0x800;}' unless defined(&X509_V_FLAG_NOTIFY_POLICY);
    eval 'sub X509_V_FLAG_EXTENDED_CRL_SUPPORT () {0x1000;}' unless defined(&X509_V_FLAG_EXTENDED_CRL_SUPPORT);
    eval 'sub X509_V_FLAG_USE_DELTAS () {0x2000;}' unless defined(&X509_V_FLAG_USE_DELTAS);
    eval 'sub X509_V_FLAG_CHECK_SS_SIGNATURE () {0x4000;}' unless defined(&X509_V_FLAG_CHECK_SS_SIGNATURE);
    eval 'sub X509_V_FLAG_TRUSTED_FIRST () {0x8000;}' unless defined(&X509_V_FLAG_TRUSTED_FIRST);
    eval 'sub X509_V_FLAG_SUITEB_128_LOS_ONLY () {0x10000;}' unless defined(&X509_V_FLAG_SUITEB_128_LOS_ONLY);
    eval 'sub X509_V_FLAG_SUITEB_192_LOS () {0x20000;}' unless defined(&X509_V_FLAG_SUITEB_192_LOS);
    eval 'sub X509_V_FLAG_SUITEB_128_LOS () {0x30000;}' unless defined(&X509_V_FLAG_SUITEB_128_LOS);
    eval 'sub X509_V_FLAG_PARTIAL_CHAIN () {0x80000;}' unless defined(&X509_V_FLAG_PARTIAL_CHAIN);
    eval 'sub X509_V_FLAG_NO_ALT_CHAINS () {0x100000;}' unless defined(&X509_V_FLAG_NO_ALT_CHAINS);
    eval 'sub X509_V_FLAG_NO_CHECK_TIME () {0x200000;}' unless defined(&X509_V_FLAG_NO_CHECK_TIME);
    eval 'sub X509_VP_FLAG_DEFAULT () {0x1;}' unless defined(&X509_VP_FLAG_DEFAULT);
    eval 'sub X509_VP_FLAG_OVERWRITE () {0x2;}' unless defined(&X509_VP_FLAG_OVERWRITE);
    eval 'sub X509_VP_FLAG_RESET_FLAGS () {0x4;}' unless defined(&X509_VP_FLAG_RESET_FLAGS);
    eval 'sub X509_VP_FLAG_LOCKED () {0x8;}' unless defined(&X509_VP_FLAG_LOCKED);
    eval 'sub X509_VP_FLAG_ONCE () {0x10;}' unless defined(&X509_VP_FLAG_ONCE);
    eval 'sub X509_V_FLAG_POLICY_MASK () {( &X509_V_FLAG_POLICY_CHECK |  &X509_V_FLAG_EXPLICIT_POLICY |  &X509_V_FLAG_INHIBIT_ANY |  &X509_V_FLAG_INHIBIT_MAP);}' unless defined(&X509_V_FLAG_POLICY_MASK);
    eval 'sub X509_STORE_set_verify_func {
        my($ctx, $func) = @_;
	    eval q( &X509_STORE_set_verify(($ctx),($func)));
    }' unless defined(&X509_STORE_set_verify_func);
    eval 'sub X509_STORE_set_verify_cb_func {
        my($ctx,$func) = @_;
	    eval q( &X509_STORE_set_verify_cb(($ctx),($func)));
    }' unless defined(&X509_STORE_set_verify_cb_func);
    eval 'sub X509_STORE_set_lookup_crls_cb {
        my($ctx, $func) = @_;
	    eval q( &X509_STORE_set_lookup_crls(($ctx), ($func)));
    }' unless defined(&X509_STORE_set_lookup_crls_cb);
    eval 'sub X509_STORE_get_ex_new_index {
        my($l, $p, $newf, $dupf, $freef) = @_;
	    eval q( &CRYPTO_get_ex_new_index( &CRYPTO_EX_INDEX_X509_STORE, $l, $p, $newf, $dupf, $freef));
    }' unless defined(&X509_STORE_get_ex_new_index);
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	eval 'sub X509_STORE_CTX_get_chain () { &X509_STORE_CTX_get0_chain;}' unless defined(&X509_STORE_CTX_get_chain);
	eval 'sub X509_STORE_CTX_set_chain () { &X509_STORE_CTX_set0_untrusted;}' unless defined(&X509_STORE_CTX_set_chain);
	eval 'sub X509_STORE_CTX_trusted_stack () { &X509_STORE_CTX_set0_trusted_stack;}' unless defined(&X509_STORE_CTX_trusted_stack);
	eval 'sub X509_STORE_get_by_subject () { &X509_STORE_CTX_get_by_subject;}' unless defined(&X509_STORE_get_by_subject);
	eval 'sub X509_STORE_get1_certs () { &X509_STORE_CTX_get1_certs;}' unless defined(&X509_STORE_get1_certs);
	eval 'sub X509_STORE_get1_crls () { &X509_STORE_CTX_get1_crls;}' unless defined(&X509_STORE_get1_crls);
	eval 'sub X509_STORE_get1_cert () { &X509_STORE_CTX_get1_certs;}' unless defined(&X509_STORE_get1_cert);
	eval 'sub X509_STORE_get1_crl () { &X509_STORE_CTX_get1_crls;}' unless defined(&X509_STORE_get1_crl);
    }
    eval 'sub X509_STORE_CTX_get_ex_new_index {
        my($l, $p, $newf, $dupf, $freef) = @_;
	    eval q( &CRYPTO_get_ex_new_index( &CRYPTO_EX_INDEX_X509_STORE_CTX, $l, $p, $newf, $dupf, $freef));
    }' unless defined(&X509_STORE_CTX_get_ex_new_index);
    eval 'sub DANE_FLAG_NO_DANE_EE_NAMECHECKS () {(1 << 0);}' unless defined(&DANE_FLAG_NO_DANE_EE_NAMECHECKS);
    eval 'sub X509_PCY_TREE_FAILURE () {-2;}' unless defined(&X509_PCY_TREE_FAILURE);
    eval 'sub X509_PCY_TREE_INVALID () {-1;}' unless defined(&X509_PCY_TREE_INVALID);
    eval 'sub X509_PCY_TREE_INTERNAL () {0;}' unless defined(&X509_PCY_TREE_INTERNAL);
    eval 'sub X509_PCY_TREE_VALID () {1;}' unless defined(&X509_PCY_TREE_VALID);
    eval 'sub X509_PCY_TREE_EMPTY () {2;}' unless defined(&X509_PCY_TREE_EMPTY);
    eval 'sub X509_PCY_TREE_EXPLICIT () {4;}' unless defined(&X509_PCY_TREE_EXPLICIT);
    if(defined(&__cplusplus)) {
    }
}
1;
