$NetBSD: patch-src_lib_signature.c,v 1.2 2020/04/25 12:07:47 nia Exp $

Fix build with OpenSSL 1.1 by syncing with NetBSD src

Output signatures to the standard output for "-".

--- src/lib/signature.c.orig	2012-03-05 02:20:18.000000000 +0000
+++ src/lib/signature.c
@@ -232,6 +232,7 @@ dsa_sign(pgp_hash_t *hash,
 	unsigned        t;
 	uint8_t		hashbuf[NETPGP_BUFSIZ];
 	DSA_SIG        *dsasig;
+	const BIGNUM	*r, *s;
 
 	/* hashsize must be "equal in size to the number of bits of q,  */
 	/* the group generated by the DSA key's generator value */
@@ -252,8 +253,14 @@ dsa_sign(pgp_hash_t *hash,
 	dsasig = pgp_dsa_sign(hashbuf, hashsize, sdsa, dsa);
 
 	/* convert and write the sig out to memory */
-	pgp_write_mpi(output, dsasig->r);
-	pgp_write_mpi(output, dsasig->s);
+#if OPENSSL_VERSION_NUMBER >= 0x10100000
+	DSA_SIG_get0(dsasig, &r, &s);
+#else
+	r = dsasig->r;
+	s = dsasig->s;
+#endif
+	pgp_write_mpi(output, r);
+	pgp_write_mpi(output, s);
 	DSA_SIG_free(dsasig);
 	return 1;
 }
@@ -903,7 +910,11 @@ open_output_file(pgp_output_t **output,
 
 	/* setup output file */
 	if (outname) {
-		fd = pgp_setup_file_write(output, outname, overwrite);
+		if (strcmp(outname, "-") == 0) {
+			fd = pgp_setup_file_write(output, NULL, overwrite);
+		} else {
+			fd = pgp_setup_file_write(output, outname, overwrite);
+		}
 	} else {
 		unsigned        flen = (unsigned)(strlen(inname) + 4 + 1);
 		char           *f = NULL;
