#!/usr/local/bin/perl
#
# cafCGI.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package cafInstall_;

#BEGIN {
#	chdir "..";
#}

use  File::stat;
use  Fcntl ':mode';
use  Cwd;
use CGI;

my $refdbh;
my $pageh;

my $lang;

my $sessionid;

my $userid;

my $pageid;

my $installpage;

my $CGIHEADERS = 0;

sub InitPath {

	my $cgi = new CGI;
	my $basedir = $cgi->param("_basedir") || "..";

	if (not ((-d "$basedir/cgi") and (-d "$basedir/mains") and (-d "$basedir/tools") and (-d "$basedir/connectors"))) {
		my $error;
		if ($basedir eq '..') {
			$error .= 'you must supply directory where Cafeterra is installed using :<BR><FONT SIZE="+3" COLOR="RED">';
			$error .= 'http://path/to/cgi-bin/install.pl?_basedir=/path/to/cafetera';
		}
		else {
			$error .= "Cafeterra is not installed in <FONT SIZE=\"+3\" COLOR=\"RED\">$basedir";
		}
		$error .= "</FONT> $basedir";
		die $error;
	}
	chdir $basedir;
	$basedir = Cwd->getcwd();

	push @INC, "$basedir";
	

	require  cgi::cafCGI;
	print cafCGI->printheader();
	$CGIHEADERS = 1;

	require  connectors::cafDBI;
	require  connectors::refDBI;
	require  tools::cafDbg;
	require  cgi::cafPage;

	$lang      = cafCGI->language();

	push @INC, "cgi/$lang";
	push @INC, "cgi/EN" unless ($lang eq 'EN');

	$sessionid = cafCGI->param("_sessionid");

	$userid    = cafCGI->param("_userid");

	$pageid    = cafCGI->param("_nextpage");

	$installpage = "install";

}

=over
sub GetConfig {
	my $context = shift || "cgi";
	$context = "cgi" if ($context =~ /desing/i);
	my $required = $context . "conf";

	eval "require $required";

	my $cwd = Cwd->getcwd();
	return { basedir => $cwd } if ($@);
	
	my $conf;
	if ($contxt eq 'cgi') { $conf = conf->new(); }
	else { $conf = CTXTCFG->new(); }

	my $db = $conf->refdb();
	my $dsn = $db->{connector}{dbidsn};
	my $user = $db->{user}{username};
	my $pass = $db->{user}{password};
	my $basedir = $conf->wd();

	return { dsn => $dsn, user => $user, pass => $pass, basedir => $basedir }
}

sub FileAccessLoop {
	my $uid = shift;
	my $file = shift;
	my $invalid = shift;

	my $cwd = Cwd->getcwd();
	my $err = "";
	my $sep ="";
	my $sf = stat ($file);
	my $suid = sprintf("%0o", $sf->uid());
	if ($sf->uid() != $uid) { my $rowner = getpwuid($sf->uid()) || $sf->uid(); $err .= $sep . "Inavlid owner $rowner"; $sep = ","; }
	my $mode = $sf->mode & 0777;
	my $isdir;
	{
		no strict 'subs';
		$isdir = $sf->mode & S_IFDIR;
		use strict;
	}
	if ($isdir) {
		unless ($mode & 0755) { $err .= $sep . "Invalid mode $mode"; $sep = ","; }
		if ($err) { push @$invalid, $err . " for directory $file (in $cwd)"; }
		if (opendir(D, $file)) {
			my @files = readdir(D);
			close D;
			chdir $file;
			foreach my $f (@files) { next if ($f =~ /^\./); FileAccessLoop($uid, $f, $invalid); }
			chdir("..");
		}
	}
	else {
		unless ($mode & 0644) { $err .= $sep . "Invalid mode $mode"; $sep = ","; }
		if ($err) { push @$invalid, $err . " for file $file (in $cwd)"; }
	}
	use strict;
}

sub FileAccess {
	my $owner = shift;
	my $homeDir = shift;

	my $invalid = [];
	my $uid = getpwnam($owner) || $owner;
	FileAccessLoop($uid, $homeDir, $invalid);
	return $invalid;
}

sub ServerOwner {
	my $owner = getpwuid($<);
}

sub IsUserExists {
	my $user = shift;
	my $dbh = shift;

	my $queryText = "select username, usecreatedb, usesuper, usecatupd from pg_user where username = '$user'";
	my $query = $dbh->newquery();
	my $query->query($queryText);
	my $rows = $dbh->hexecfetchall($query);
	my $err;
	
	if ($rows->[0]{username} eq $user) {
		my $isaDba = ($rows->[0]{usecreatedb}) and ($rows->[0]{usesuper}) and ($rows->[0]{usesuper});
		if (not $isaDba) { $err = "User $user is not a Dba"; }
	}
	else {$err = "User $user doe's not exists"; }
	
	return $err;
}

sub IsDbExists {
	my dsn = shift;
	my $user = shift;
	my $pass = shift;

	my $dbh = {
		connector => { driverid   => "Pg",  protocolid => "DBI", dbidsn => $dsn, },
		user      => { username   => $user, password   => $pass, },
		_ATTRS    => { PrintError => 0,     RaiseError => 1,     AutoCommit => 0, _FLOWDIR => "/tmp",
		},
	};

	return refDBI->Connect($dbh);
}

sub CreateDbUser {
	my $dbh = shift;
	my $user = shift;
	my $pass = shift;

	my $queryText = "create user $user with password '$password' createdb, createuser";

	my $query = $dbh->newquery();
	$query->query($queryText);
	$dbh->executefinish($query);
}

sub CreateDb {
	my $dbh = shift;
	my $dbname = shift;

	my $queryText = "create database $dbname";

	my $query = $dbh->newquery();
	$query->query($queryText);
	$dbh->executefinish($query);
}

sub TestDba {
	my $user = shift;
	my $pass = shift;
	my $dsn   = shift;


	createUser();
	connectNewUser();
	createDb();
	createObjects();
	insertData();
	
}

sub TestHttpdConf {
	my $httpdconf = shift;

        my $defaulthttpdconf = "/etc/httpd/conf/commonhttpd.conf";
        unless (-f $defaulthttpdconf) { $defaulthttpdconf = "/usr/local/apache/conf/commonhttpd.conf"; }
        unless (-f $defaulthttpdconf) { $defaulthttpdconf = "/usr/local/apache/conf/httpd.conf"; }
        unless (-f $defaulthttpdconf) { $defaulthttpdconf = "/etc/httpd/conf/httpd.conf"; }
        $httpdconf ||= $defaulthttpdconf; #"/etc/httpd/conf/commonhttpd.conf";
}
=cut

sub pageattrs {

	my $newpageattrs;

		$newpageattrs = {
			_system => {
				userlabel       => undef,
				_conf           => undef,
				_cgi            => cafCGI->new(),
				_translate      => cafetrans->new(),
			},
			_hidden => {
				_sessionid         => cafCGI->param("_sessionid"),
				_userid            => cafCGI->param("_userid"),
				_nextaction        => undef,
				_nextpage          => undef,
				_prevpage          => cafCGI->param("_currpage"),
				_currpage          => $pageid,
				_curraction        => cafCGI->param("_nextaction"),
				_actiondetail      => cafCGI->param("_actiondetail"),
			},
			_data   => {
				_contextid      => undef,
				_contextlabel   => undef,
				_ctxttype       => undef,
				_masterdsn      => undef,
				_masertuser     => undef,
				_masterpwd      => undef,
				_contextbname   => undef,
				_createdb       => undef,
				_contextdsn     => undef,
				_masertuser     => undef,
				_contextpwd     => undef,
				_createdbuser   => undef,
				_basedir        => undef,
				_httpdpath      => undef,
				_cgialias       => undef,
				_docalias       => undef,
				result          => undef,
			},
		};

	for (my $i = 0; $i < 10;  $i++) {
		my $paramvalue = cafCGI->param("__param__$i");
		$newpageattrs->{_hidden}{"__param__$i"} = $paramvalue;
	}
	$newpageattrs;
}

sub requirepage {
	my $refdbh = shift;

	$pageid = "install";

	eval "require translate";
	eval "require cgi::PM::install";
	if ($@) {
		die "00003; Can't load page install<BR>\n$@<BR>";
	}
	return ($pageid->new(pageattrs($refdbh)));
}

sub initerrors {
	my $pageh = shift;
	my $errors = cafDbg->geterrorn();
 
	if ($errors >= 0) {
		$pageh->_attribute("_debug", "errortext", cafDbg->geterrors());
		$pageh->_attribute("_debug", "errors", $errors + 1);
	}
}

#main 


eval {
	InitPath();
	$pageh  = requirepage ($refdbh);

	eval { $pageh->startpage(); };
	if ($@ and (cafDbg->geterrorn() < 0)) {
		cafDbg->pusherror("0000;Error while executing startpage " . $@);
	}
	initerrors($pageh);
	$pageh->checkredirect();
	$refdbh->disconnect () if ($refdbh);
};

if ($@) {
	my $e = $@ . "<BR> INC CONTAINS " . join ("<BR>", @INC);
	unless ($CGIHEADERS) { print CGI->header(); }
	$e =~ s/\n/<P>\n/g;
	if ($refdbh) {
		if (my $q = $refdbh->lastquery()) { $e =  "<BR>\nlast query is: <I>" . $q->query() . "<BR>\n" . $e; }
		$e =  "<BR>\nlast error is : " . DBI->errstr . "<BR>\n" . $e;
		eval { $refdbh->disconnect(); };
	}
	print "<html><head></head><body><P><B>$e</B></body></html>";
	die "$e";
}

