#!/usr/local/bin/perl
#
# cafHTML 27/07/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;

package cafdHTML;
 
#@ISA = (cafDBI);
use strict;
use connectors::cafQry;


=cut
	_tempdir => Flowdir/temp
	_mailqueue => FLOWDIR/_mailq
	_smtpqueue => FLOWDIR/_smtpq
	_imapqueue => FLOWDIR/_imapq/folder
	_ftpqueue  => FLOWDIR/_ftpq
=cut

my %NOTCLOSEDTAGS = (area      => 1, base      => 1, basefont  => 1, br        => 1, col       => 1,
                     frame     => 1, hr        => 1, img       => 1, input     => 1, isindex   => 1,
                     link      => 1, meta      => 1, param     => 1, p         => 1);
sub NewConnection {
	my $class = shift;
	my $db = shift;

	$class = ref($class) || $class;

	my $proto = "cafp" . $db->{connector}{protocolid};

	eval { require $proto };

        eval "require connectors::$proto";
        my $e = $@;
        if ($@) { cafDbg->pushstackdump(1); }
 
        die "$e" if ($e);
 
        @cafdHTML::ISA = ($proto);

	my $self = $class->NewProtocol($db);

	
	my %html_attrs = (
		record_tag       => $db->{_ATTRS}{RECORD_TAG},
		rootname         => $db->{_ATTRS}{ROOTNAME},
	);
	foreach my $a (keys %html_attrs) {
		if (($html_attrs{$a} !~ /^\\$/) and defined($html_attrs{$a})) { eval "\$html_attrs{$a} = \"$html_attrs{$a}\""; }
	}
	$self->{_HTML_ATTRS} = \%html_attrs;
	$self->{dbh}       = DBI->connect("dbi:AnyData(RaiseError=>1):");
	$! = "";
	$self;
}

sub htmlattrib {
	my $self = shift;
	my $attrib = shift;

	if (@_) { $self->{_HTML_ATTRS}{$attrib} = shift; }
	$self->{_HTML_ATTRS}{$attrib};
}
		
sub htmlinfo {
	my $self = shift;
	my $q = shift;

	return $q->specialattrs("__HTMLINFO", @_);

#	if (@_) { $self->{_HTMLINFO}{$infolabel} = shift; }
#	$self->{_HTMLINFO}{$infolabel};
}

sub clearhtmlinfo {
	my $self = shift;
	my $q = shift;

	$q->clearspecialattrs ("__HTMLINFO");
#	$self->{_HTMLINFO} = undef;
#	delete $self->{_HTMLINFO};
}

sub preprepare {
	my $self = shift;
	my $q = shift;

	my ($cmd, $mode, $ad_mode);
	my $qText = $q->query();
	if ($qText =~ /\s*select/i) { $cmd = "select"; $mode = "r" }
	elsif ($qText =~ /\s*insert/i) { $cmd = "insert"; $mode = "w" }
	elsif ($qText =~ /\s*update/i) { $cmd = "update"; $mode = "w" }
	elsif ($qText =~ /\s*delete/i) { $cmd = "delete"; $mode = "w" }
	else { die "Unsuported sql command"; }

	$q->_attribute("command", $cmd);
	my $container = $self->{db}{container};


	my @col_map;
	my %map_col;
	my $colpos = 0;
	my %col_pos;
	foreach my $col (@{$container->{_FIELDS}}) {
		push @col_map, { $col->{externalname} => $col->{name} };
		my @split = split("/", $col->{externalname});
		shift @split unless($split[0]);
		$self->htmlattrib("rootname", $split[0]) unless ($self->htmlattrib("rootname"));
		my $realname = $split[$#split];
		$realname =~ s/^[*]//;
		$map_col{$col->{name}} = [ $col->{externalname}, \@split, $realname ];
		$col_pos{$col->{externalname}} = $colpos;
		$colpos++;
	}

	my @acol_names = map { $_->{name} }  @{$container->{_FIELDS}};
	my $scol_names = join(',', @acol_names);

	my $name = $container->{name};
	my $externalname = $container->{externalname};

	$self->htmlinfo($q, "_NAME", $name);
	$self->htmlinfo($q, "_MODE", $mode);
	$self->htmlinfo($q, "_CMD", $cmd);
	$self->htmlinfo($q, "_EXTERNALNAME", $externalname);
	$self->htmlinfo($q, "_SCOLNAMES", $scol_names);
	$self->htmlinfo($q, "_ACOLNAMES", \@acol_names);
	$self->htmlinfo($q, "_COLMAP", \@col_map);
	$self->htmlinfo($q, "_MAPCOL", \%map_col);
	$self->htmlinfo($q, "_COLPOS", \%col_pos);
	$self->htmlinfo($q, "_RECORD_TAG", $container->{_ATTRS}{RECORD_TAG});
}

sub prepare {
	my $self = shift;
	my $q = shift;

#	return $self->SUPER::prepare($q) if ($self->{_NAME});

	unless ($self->htmlinfo($q, "_NAME")) {

		$self->preprepare($q);
		my ($cmd, $mode) = ($self->htmlinfo($q, "_CMD"),$self->htmlinfo($q, "_MODE"));
		my $dbh = $self->{dbh};

		if ($cmd eq "select") {
			my $tempfile = $self->getfile({ fname => $self->htmlinfo($q, "_EXTERNALNAME"), mode => "r" });
			$self->htmlinfo($q, "_TEMPFILE", $tempfile);
			$self->htmlinfo($q, "_DATA", $self->readdata($q));
		}
		else {
			$self->htmltable($q);
			$self->htmlinfo($q, "_DATA", [[]]);
		}
		$dbh->func($self->htmlinfo($q, "_NAME"), 'ARRAY', $self->htmlinfo($q, "_DATA"), {col_names => $self->htmlinfo($q, "_SCOLNAMES")}, 'ad_catalog'); 
	}
	return $self->SUPER::prepare($q);
}

sub read_eltdata {
	my $self = shift;
	my ($c, $k, $data, $eltdata) = @_;

	$eltdata =~ s/^\s*$//g;
	if ($eltdata and (my $colpos = $data->{colpos}{$c})) {
		$data->{currrow}{row}[$colpos] = $eltdata;
		$data->{currrow}{nfield} += 1;
	}
}

sub read_tags {
	my $self = shift;
	my $tree = shift;
	my $data = shift;
	my $chemin = "";

	for (my $i = 1; $tree->[$i];) {
	        my $el= $tree->[$i];
	        $self->read_tags2($el, "$chemin/$tree->[0]", $data, $tree->[0]) if (ref($el));
	        $i += 2;
	}

	if ($data->{currrow}{nfield}) { push @{$data->{data}}, $data->{currrow}{row}; }

}

sub read_tags2 {
	my $self = shift;
	my $tree = shift;
	my $chemin = shift;
	my $data = shift;
	my $lasttag = shift;

#	if ($lasttag eq $self->htmlinfo($q, "_RECORD_TAG")) {
#		if ($data->{currrow}{nfield}) { push @{$data->{data}}, $data->{currrow}{row}; }
#		$data->{currrow} = { visited => {}, row => [], nfield => 0 };
#	}

	my $attr = $tree->[0];
	foreach my $el  (keys %{$attr}) {
	        $self->read_eltdata("$chemin", "\*$el", $data, $attr->{$el} );
	}

	for (my $i = 1; defined($tree->[$i]);) {
		my $el = $tree->[$i];
	        if ($el and ref($tree->[$i + 1])) {
	                if ($el and ref($tree->[$i + 1])) { $self->read_tags2($tree->[$i + 1], "$chemin/$el", $data, $el); }
	        }
		else { $self->read_eltdata("$chemin", $el, $data, $tree->[$i + 1]); }
	        $i+=2;
	}
}

sub readdata {
	my $self = shift;
	my $q = shift;

	my $rows =  [$self->htmlinfo($q, "_ACOLNAMES")];
	my $data = {
		data => $rows,
		colpos => $self->htmlinfo($q, "_COLPOS"),
		currrow => { visited => {}, row => [], nfield => 0, fstack => [], stale => undef}
	};

	require HTML::TokeParser::Simple;

	my $tree = HTML::TokeParser::Simple->new($self->htmlinfo($q, "_TEMPFILE"));
	my (%elements, %kel, @ksort) = ((), (), ());
	my $desc = { elements => \%elements, kel => \%kel, ksort => \@ksort, readdata => 1};
	desc_gettags($tree, $desc, $data);
 

	$self->read_tags($tree, $data);
	use Data::Dumper;
	return $rows;
}

sub htmlarraytohash {
	my $self = shift;
	my $q = shift;
	my $ahash = [];

	my $lines = $self->htmlinfo($q, "_DATA");
	my $colnames = $self->htmlinfo($q, "_ACOLNAMES");
	my $mapcol = $self->htmlinfo($q, "_MAPCOL");

	foreach my $line (@$lines) {
		my %hash = ();
		for (my $ifld = 0; $ifld <$#$line; $ifld++) {
			my $elt = \%hash;
			my $parentkey;
			my $parent = undef;

			my $fldname = $colnames->[$ifld];
			my $realname = $mapcol->{$fldname}[2];
			my $path = $mapcol->{$fldname}[1];

			for (my $i = 1; $i < $#$path; $i++) {
				my $key = $path->[$i];
				if (ref($elt) eq "ARRAY") { $elt = {} };
				$elt->{$key} = undef unless($elt->{$key});
				if ($parentkey) { $parent->{$parentkey} = $elt; }
				$parentkey = $key;
				$parent = $elt;
				$elt = $elt->{$key}
			}
			
			if (ref($elt) eq "ARRAY") { $elt = {} };
			$elt->{$realname} = [] unless ($elt->{$realname});
			push @{$elt->{$realname}}, $line->[$ifld];
			$parent->{$parentkey} = $elt;
		}
		push @{$ahash}, \%hash;
	}
	$ahash
}

sub setexternalname {
        my $self = shift;
        my $filename = shift;
        $self->htmlinfo("_EXTERNALNAME", $filename);
}

sub getexternalname {
        my $self = shift;
        my $filename = shift;
        $self->htmlinfo("_EXTERNALNAME");
}


sub finalcommit {
	my $self = shift;

	foreach my $qlabel (@{$self->queries()}) {
		my $q = $self->query($qlabel);
		next unless $self->htmlinfo($q, "_NAME");
		if ($self->htmlinfo($q, "_CMD") ne "select") {
			require HTML::Simple;

			#print "final Commit ", $self->htmlinfo($q, "_EXTERNALNAME"), "\n";
			my $xs = HTML::Simple->new(keyattr => [], noattr => 0, rootname => $self->htmlattrib("rootname"));

			#use Data::Dumper;
			#print Dumper $self->htmlinfo($q, "_DATA");
			my $str = $xs->HTMLout($self->htmlarraytohash());
			my $rootname = $self->htmlattrib("rootname");
			#$str =~ s/<$rootname>\s*<anon>/<$rootname>/;
			#$str =~ s/[ \t]*<\/anon>\s*<\/$rootname>/<\/$rootname>/;
			$str =~ s/\s*<[\/]*anon><\/$rootname>/<\/$rootname>/;

			my $tempfile = $self->getfile({ fname => $self->htmlinfo($q, "_EXTERNALNAME"), mode => "w" });
			my $tempioh = IO::File->new($tempfile, "w");

			my $strioh = IO::Scalar->new(\$str);
			binmode $tempioh;
#			binmode $strioh;
			$tempioh->autoflush(1);
 
			my $nreads;
			my $nwrite = 0;
			my $in;
			while ($nreads = $strioh->read($in, 1024)) { $nwrite = $tempioh->write($in, $nreads); }
			$tempioh->close();
			$strioh->close();
#			system("cat $tempfile");
			$self->protocommit($tempfile, $self->htmlinfo($q, "_EXTERNALNAME"));
		}
		$self->clearhtmlinfo($q);
	}
}

sub finalrollback {
	my $self = shift;

	foreach my $qlabel (@{$self->queries()}) {
		my $q = $self->query($qlabel);
		next unless $self->htmlinfo($q, "_NAME");
		my $tempfile = $self->htmlinfo("_TEMPFILE");
		$self->protorollback($tempfile);
		$self->clearhtmlinfo($q);
	}
}

sub register_tag {
	my $tag = shift;
	my $desc = shift;
	my $toke = shift;
	my $data = shift;

	my $elements = $desc->{elements};
	my $kel = $desc->{kel};
	my $ksort = $desc->{ksort};

	my $chemin  = $desc->{chemin};
	my $tabstack = $desc->{tabstack};
	my $fstack = $data->{currrow}{fstack};

	my $readdata = $desc->{readdata} && $data && ref($data);

	my $rtag = $tag;
	if ($tag =~ /td/i) {
		$rtag .= "_" . $tabstack->[$#$tabstack]; $tabstack->[$#$tabstack] += 1;
	}
	elsif ($tag =~ /table/i) {
		push @$tabstack, 0;
		if ($readdata) { push @$fstack, []; }
	}
	if ($readdata) {
		my $text = $toke->as_is();
		$text = s/\s*$//;
		my $colpos = $data->{colpos}{"$chemin/$tag"};
		if ($text and (defined($colpos))) {
			$data->{currrow}{row}[$colpos] = $text; #$eltdata;
			$data->{currrow}{nfield} += 1;
			if ($#$fstack >=0) { my $dstack = $fstack->{$#$fstack}; push @$dstack, $colpos; }
			$data->{currrow}{stale} = 1;
		}
	}
	unless ($elements->{$chemin/$rtag}) { 
		$kel->{$tag} = 0 unless ($kel->{$tag});
		$elements->{$chemin/$tag} = $tag . "_" . $kel->{$tag};
		push @$ksort, "$chemin/$rtag";
	}
}

sub desc_gettags {
	my $tree = shift;
	my $desc = shift;
	my $data = shift;
	my $elements = $desc->{elements};
	my $kel = $desc->{kel};
	my $ksort = $desc->{ksort};

	my $fstack;
	my $currrow;

	my $readdata = $desc->{readdata} && $data && ref($data);
	if ($readdata) {
		$fstack = $data->{currrow}{fstack};
		$currrow = $data->{currrow}{row};
	}

	my $chemin = "";
	my $tabstack = [];
	$desc->{chemin} = $chemin;
	$desc->{tabstack} = $tabstack;

	while (my $toke = $tree->get_token()) {
		if ($toke->is_start_tag()) {
			my $tag = $toke->return_tag();
			register_tag($tag, $desc, $toke, $data);
			$desc->{chemin} .= "/$tag" if ($NOTCLOSEDTAGS{$tag});
			$desc->{lasttag} = $tag;
			my $attrseq = $toke->return_attrseq();
			my $attrs = $toke->return_attr();
			foreach my $attr (@$attrseq) {
				register_tag("\*$tag", $desc, $toke, $data);
			}
		}
		elsif ($toke->is_text()) {
			my $tag = $desc->{lasttag}. "_text";
			register_tag($tag, $desc, $toke, $data);
		}
		elsif ($toke->is_comment()) {
			register_tag("__comment__", $desc, $toke, $data);
		}
		elsif ($toke->is_declaration()) {
			register_tag("__decl__", $desc, $toke, $data);
		}
		elsif ($toke->is_process_instruction()) {
			register_tag("__pi__", $desc, $toke, $data);
		}
		elsif ($toke->is_end_tag()) {
			my $tag = $toke->return_tag();
			my $endrow;
			if ($#$tabstack >= 0) {
				if ($tag =~ /^table/i) { pop @$tabstack; $endrow = 1; }
				elsif($tag =~ /^tr/i) { $tabstack->[$#$tabstack] = 0; $endrow = 1; }
				if ($endrow and $readdata and $data->{currrow}{stale}) {
					my @row = @$currrow;
					push @{$data->{rows}}, \@row;
					$data->{currrow}{stale} = undef;
					if ($#$fstack >= 0) {
						my $dstack = pop @$fstack;
						foreach my $colpos (@$dstack) {
							$currrow->[$colpos] =  undef if(defined($colpos));
						}
					}
				elsif($tag =~ /^tr/i) { push @$fstack, []; }
				}
					
			}
			my @c = split ("/", $chemin);
			my $ic = $#c;
			while (($ic >= 0) and ($c[$ic] !~ /^$tag/)) {$ic--; };
			if ($ic > 0) { $chemin = join("/", @c[0..$ic]); }
		}
	}
}

sub describe {
	my $self = shift;
	my $table_name = shift;

	return undef unless $self->connected();
	my $tempfile;
	return undef unless ($tempfile = $self->getfile({ fname => $table_name, mode => "r" }));

	my $dbh = $self->{dbh};

#	$record_tag = "head";
	require HTML::TokeParser::Simple;

	my $tree = HTML::TokeParser::Simple->new($tempfile);
	
	my (%elements, %kel, @ksort) = ((), (), ());
	my $desc = { elements => \%elements, kel => \%kel, ksort => \@ksort, readdata => undef};
	
#	desc_gettags($tree, {elements => \%elements, kel => \%kel, ksort => \@ksort, readdata => undef});
	desc_gettags($tree, $desc);

	my @ret;
	my $i = 0;
	#foreach my $e (keys %elements) {
	foreach my $e (@ksort) {
		$i++;
		$elements{$e} =~ s/^\*//;
		my $chemin = $e;
		#if ($record_tag) { $chemin =~ s/.*$record_tag/$record_tag/; }
		push @ret, {
				name => $elements{$e},
				externalname => $chemin,
				datatypeid => 'VARCHAR',
				datalength => 100,
				fieldorder => $i*10,
				keyposition  => ($i > 3) ? undef : $i,
		};
	}
	unlink $tempfile;

	\@ret;
}


sub generatequery {
	my $self = shift;

	@cafdHTML::ISA = ('refDBI') unless ($self->isa('refDBI'));
	return $self->SUPER::generatequery(@_);

	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $datatypes = shift;

	my $sub = "generate$command";
	return $self->$sub($command, $connector, $container, $fields, $datatypes);
}


sub columnnameformat {
	my $self = shift;
	my $col = shift;
	return $col->{name};
}

sub tablenameformat {
	my $self = shift;
	my $container = shift;
return $container->{name};
}


sub generatechartodate {
	my $self = shift;
	my $col = shift;

	return ":c_$col->{name}";
}
		
sub generatedatetochar {
	my $self = shift;
	my $col = shift;

	return $col->{name};
}

1;
