#!/usr/bin/perl
use strict;
use DBI;
use Getopt::Long;
use Cwd;
use File::Basename;
use File::stat;
use Time::ParseDate;


sub Question {
	my ($question, $answer, $pattern) = (shift, shift, shift);

	my $ans;
	while (1) {
		print  "$question [$answer] : ";
		$ans = <STDIN>;
		chomp $ans;
		if (defined($pattern)) { $ans = undef unless ($ans =~ /$pattern/); }
		if ($answer) { return $answer unless ($ans); }
		last if $ans;

	}
	return $ans;
}

sub YesNo {
	my ($question, $answer) = (shift, shift);
	while (1) {
		my $ans = Question($question . " (YES/NO)", $answer);
		$ans = uc($ans);
		if (($ans eq "YES") or ($ans eq "Y")) { return "yes"; }
		elsif (($ans eq "NO") or ($ans eq "N")) { return "no"; }
		print "\n";
	}
}

sub Usage {
	die "Usage initialize install {Q|R} dbname aliphepw [contextid]\n";
}


my %config;
my $migrobjs;
my $db;
sub getparam  {
	Getopt::Long::GetOptions(\%config, "dsn=s", "user=s", "pwd=s", "flow=s", "context=s", "force=s");
	my $usage = "perl $0 --dsn=dbi:Pg:dbname=cafeterradb --user=aliphe --pwd=aliphe --flow=2238 --context=aliphe [--force=1|0]";
#	print "$config{user} and $config{pwd} and $config{flow} and $config{context} and $config{dsn}, $config{force},\n";
	unless ($config{user} and $config{pwd} and $config{flow} and $config{context} and $config{dsn}) {
		print  STDERR "ERROR : Usage $usage\n";
		die;
	}

	$config{dsn} = Question ("DBI DSN ") unless ($config{dsn});
	$config{user}     = Question ("Utilisateur Postgres", "aliphe") unless ($config{user});
	$config{pwd}     = Question ("Mot de passe Postgres", "aliphe") unless ($config{pwd});
	$config{flow} = undef unless ($config{flow} =~ /^[[:digit:]]+$/);
	$config{flow}    = Question ("Id du flux a migrer", undef, '^[[:digit:]]*$') unless ($config{flow});

	$config{cwd} = Cwd::cwd();
 
	my ($name,$path,$suffix) = fileparse($0);

	chdir $path;
	my $path = Cwd::cwd();
	chdir "..";
	my $cwd = Cwd::cwd();
	push @INC, "$cwd";

	chdir $path;

	require tools::cafUtils;
	$config{opath} = $path;
	my $date = cafUtils->datetime1();
	$config{ofile} = $config{context} . "_" . $config{flow} . "_";
	$config{opackage} = $config{context} . "_" . $config{flow};
	my $pattern = $config{ofile} . ".*.pm";
	my $lastmodif = 0;
	my $lastfile = undef;
	chdir ($config{opath});
        if (opendir (DIRH, $config{opath})) {
		my @files = readdir(DIRH);
		close (DIRH);
		foreach my $file (@files) {
			if ($file =~ /^$pattern$/) {
				my $sf = stat ($file);
				if ($lastmodif < $sf->[9]) {
					$lastmodif = $sf->[9];
					$lastfile = $file;
				}
			}
		}
        }
	if ($lastfile and -f $lastfile) {
		#eval { "require $lastfile;" };
		require $lastfile;
		my $opackage = $config{opackage};
		$migrobjs = $opackage->objectsrefs();
#		print "The file : $lastfile ", cafUtils->datetime1($lastmodif), "\n";
#		print "THE OBJECTS : " . ref($migrobjs) . "\n";
	}
	else { die "no file found"; }

	my @a = split(":", $config{dsn});
	$db = {
		connector      => {
			driverid     => $a[1],
			protocolid   => "DBI",
			dbidsn       => $config{dsn},
		},
		user                 => { username => $config{user}, password => $config{pwd}, },
		userid               => { username => $config{user}, password => $config{pwd}, },
		_ATTRS               => {
		PrintError        => 0,
		RaiseError        => 1,
		AutoCommit        => 0,
		},
        };
}

sub executeqry {
	my $dbh = shift;
	my $qry = shift;
	my $keyfld = shift;
	my $p = shift;
#	$p=1;

	if ($p) { print "\n\nQUERY = $qry\n\n"; }
	my $sth = $dbh->prepare($qry);
	$sth->execute();
	my @ret = ();
	while (my $row = $sth->fetchrow_hashref()) {
		my %row = %{$row};
		push @ret, \%row;
	}
	$sth->finish();
	\@ret;
}


sub updateobject {
	my $dbh = shift;
	my $object_id = shift;
	my $params = shift;
	my $qfunc1 = shift;
	my $qfunc2 = shift;

	my $q = $dbh->newquery($params);
	$q->$qfunc1();
	my $ret = $dbh->executefinish($q);
	if ($ret <= 0) {
		$q->$qfunc2();
		$ret = $dbh->executefinish($q);
		if ($ret <= 0) {
			$dbh->rollback();
			die "Error while importing $object_id " . $q->query();
		}
	}
}

my $datformat = "YYYY/MM/DD HH24:MI:SS";

sub updateimports {
	my $dbh = shift;
	my $object_id = shift;
	my $theobject = shift;
	my $objects = shift;


	my $q = $dbh->newquery();
#	my $lastm = $theobject->{last_modified};
	my $lastm = $objects->{$object_id}{last_modified};
#	unless ($lastm) { print "OUUULALALALALAL $object_id $lastm\n"; }
	my $ext_id = $object_id;
	my $loc_id = $objects->{$object_id}{local_id};
	$q->query("UPDATE imports set last_modified = to_timestamp('$lastm', '$datformat'), 
		last_imported = now(), local_id = $loc_id
		WHERE contextid = '$config{context}' AND external_id = $ext_id");
	my $ret = $dbh->executefinish($q);
	if ($ret <= 0) {
		$q->query("INSERT INTO imports (contextid, external_id, local_id, last_modified)
			VALUES ('$config{context}', $ext_id, $loc_id, to_timestamp('$lastm', '$datformat'))");
		$ret = $dbh->executefinish($q);
		if ($ret <= 0) {
			$dbh->rollback();
			die "Error while importing $object_id " . $q->query();
		}
	}
}

getparam();

my $objects = $migrobjs->{objects};
my $himports = {};
my $thedump = $migrobjs->{thedump};
my $attributes = $migrobjs->{attributes};
my $otherobj = $migrobjs->{otherobj};
my $objscr = $migrobjs->{objscr};
my $mapping = $migrobjs->{mapping};

my $dbh;
my $objectlist;
my $sep = "";
eval {

	require Data::Dumper;
	require connectors::refDBI;
	require tools::cafDbg;
	$dbh = refDBI->Connect($db);
	foreach my $object_id (keys %$objects) {
		$objects->{$object_id}{last_epochmodified} = cafUtils->parsedatetime3($objects->{$object_id}{last_modified}, UK => 1);
		$objectlist .= "$sep$object_id";
		$sep = ", ";
#		print "$obj, $thedump->{$obj}{type} LAST MODIFIED $objects->{$obj}\n";
	}
	my $q = $dbh->newquery();
		$q->query("SELECT contextid, external_id, local_id, to_char(first_imported, '$datformat') AS first_imported,
			to_char(last_imported, '$datformat') AS last_imported, to_char(last_modified, '$datformat') AS last_modified
			FROM imports
			WHERE contextid = '$config{context}' AND external_id in ($objectlist)");
		my $importedobjs = $dbh->hexecfetchall($q) || [];
		foreach my $obj (@$importedobjs) {
			if ($config{force}) { $obj->{last_epochmodified} = 0; }
			else {
				$obj->{last_epochmodified} = cafUtils->parsedatetime3($obj->{last_modified}, UK => 1);
				$obj->{last_epochmodified} = 1 unless ($obj->{last_epochmodified});
			}
			$himports->{$obj->{external_id}} = $obj;
		}

	foreach my $object_id (keys %$objects) {
		if ($himports->{$object_id}{local_id}) {
			$objects->{$object_id}{local_id} = $himports->{$object_id}{local_id};
		}
		else {
			$objects->{$object_id}{local_id} = $dbh->nextseq("objects");
			$himports->{$object_id}{local_id} = $objects->{$object_id}{local_id};
		}

#		if ($config{force}) { $himports->{$object_id}{last_epochmodified} = 0; }
#		else { $himports->{$object_id}{last_epochmodified} = 1 unless ($himports->{$object_id}{last_epochmodified}); }

	#	print "$object_id <=> $objects->{$object_id}{last_epochmodified} : $himports->{$object_id}{last_epochmodified}\n";
	}

	foreach my $object_id (keys %$objects) {
		unless ($himports and ($himports->{$object_id}{last_epochmodified} >= $objects->{$object_id}{last_epochmodified})) {
#			print "$object_id $himports->{$object_id}{last_modified} <> $objects->{$object_id}{last_modified}and ($himports->{$object_id}{last_epochmodified} >= $objects->{$object_id}{last_epochmodified}\n";
			my $theobject = $thedump->{$object_id};
			my $otype = $theobject->{type};
			$otype = "scripts" if ($otype =~ /^perl|^sql/);
			if ($theobject->{parent_id} and ($theobject->{parent_id} > 0)) {
				$theobject->{parent_id} = $objects->{$theobject->{parent_id}}{local_id};
			}
			if ($otype eq "subflow") {
				$theobject->{flow_id} = $theobject->{parent_id};
				$theobject->{container_id} = $objects->{$theobject->{container_id}}{local_id};
				$theobject->{container_id} = -1 unless ($theobject->{container_id});
			}
			$theobject->{object_id} = $objects->{$object_id}{local_id};

			updateobject ($dbh, $object_id, $theobject, "uobject", "iobject");
			updateobject ($dbh, $object_id, $theobject, "u$otype", "i$otype");
			if ($theobject->{type} eq 'sql') {
				$theobject->{parsetext} = $theobject->{parsetext}{parsetext} if (ref($theobject->{parsetext}));
				updateobject ($dbh, $object_id, $theobject, "upscripts", "ipscripts");
			}

			updateimports($dbh, $object_id, $theobject, $objects);
		}
	}

	foreach my $obj_id (keys %$attributes) {
		next if ($himports->{$obj_id}{last_epochmodified} >= $objects->{$obj_id}{last_epochmodified});
		my $object_id = $objects->{$obj_id}{local_id};
		my $ret = $dbh->updateattributes($object_id, $attributes->{$obj_id});
		die "Unable to update attributes for $object_id" if ($ret <= 0);
	}

	foreach my $obj_id (keys %$mapping) {
		next if ($himports->{$obj_id}{last_epochmodified} >= $objects->{$obj_id}{last_epochmodified});
		my $object_id = $objects->{$obj_id}{local_id};
		foreach my $so (@{$mapping->{$obj_id}}) {
			$so->{subflow_id} = $object_id;
			$so->{outgofield_id} = $objects->{$so->{outgofield_id}}{local_id};
			if ($so->{incomfield_id}) { $so->{incomfield_id} = $objects->{$so->{incomfield_id}}{local_id}; }
			else { $so->{incomfield_id} = -1; }
#			$so->{incomfield_id} = $objects->{$so->{incomfield_id}}{local_id} if ($so->{incomfield_id});
			$so->{script_id} = $objects->{$so->{script_id}}{local_id} if ($so->{script_id});
		}
		my $ret = $dbh->updatemymapping($object_id, $mapping->{$obj_id});
		die "Unable to update mapping for $object_id" if ($ret <= 0);
	}

	foreach my $obj_id (keys %$objscr) {
		next if ($himports->{$obj_id}{last_epochmodified} >= $objects->{$obj_id}{last_epochmodified});
		my $object_id = $objects->{$obj_id}{local_id};
		foreach my $so (@{$objscr->{$obj_id}}) {
			$so->{object_id} = $object_id;
			$so->{script_id} = $objects->{$so->{script_id}}{local_id};
		}
		my $ret = $dbh->updatemyscripts($object_id, $objscr->{$obj_id});
		die "Unable to update attributes for $object_id" if ($ret <= 0);
	}

	foreach my $obj_id (keys %$otherobj) {
		next if ($himports->{$obj_id}{last_epochmodified} >= $objects->{$obj_id}{last_epochmodified});
		my $object_id = $objects->{$obj_id}{local_id};
		next unless ($object_id);
		my @oorel;
		foreach my $oo (@{$objscr->{$obj_id}}) {
			#	$oo->{parent_id} = $object_id;
			#	$oo->{child_id} = $objects->{$oo->{child_id}}{local_id};
			print "updatemyobjects for : $object_id => $oo->{child_id} / $objects->{$oo->{child_id}}{local_id}\n";
			next unless ($object_id and $oo->{child_id} and $objects->{$oo->{child_id}}{local_id});
			push @oorel, {parent_id => $object_id, child_id => $objects->{$oo->{child_id}}{local_id} };

		}
		my $ret;
		eval {
			$ret = $dbh->updatemyobjects($object_id, \@oorel); #$otherobj->{$obj_id});
		};
		die "Unable to update attributes for $object_id $@" if (($ret <= 0) || $@);
	}


	
	$dbh->commit();
	$dbh->disconnect();

};

if ($@) {
	if ($dbh) {
		print $dbh->lastquery()->query(), "\n" if ($dbh->lastquery());
		$dbh->rollback(); $dbh->disconnect(); }
	print "$@ " . "\n";
}
elsif ($dbh) { $dbh->rollback(); $dbh->disconnect(); $dbh = undef; }

1;
