/*
Open Asset Import Library (ASSIMP)
----------------------------------------------------------------------

Copyright (c) 2006-2020, ASSIMP Development Team
All rights reserved.

Redistribution and use of this software in source and binary forms,
with or without modification, are permitted provided that the
following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.

* Redistributions in binary form must reproduce the above
  copyright notice, this list of conditions and the
  following disclaimer in the documentation and/or other
  materials provided with the distribution.

* Neither the name of the ASSIMP team, nor the names of its
  contributors may be used to endorse or promote products
  derived from this software without specific prior
  written permission of the ASSIMP Development Team.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

----------------------------------------------------------------------
*/

/** MACHINE-GENERATED by scripts/ICFImporter/CppGenerator.py */

#ifndef INCLUDED_IFC_READER_GEN_H
#define INCLUDED_IFC_READER_GEN_H

#include "STEPFile.h"

namespace Assimp {
namespace IFC {
namespace Schema_4 {

	using namespace STEP;
	using namespace STEP::EXPRESS;


	struct NotImplemented : public ObjectHelper<NotImplemented,0> {

	};


	// ******************************************************************************
	// IFC Custom data types
	// ******************************************************************************


    // C++ wrapper type for IfcStrippedOptional
    typedef BOOLEAN IfcStrippedOptional;
    // C++ wrapper type for IfcAbsorbedDoseMeasure
    typedef REAL IfcAbsorbedDoseMeasure;
    // C++ wrapper type for IfcAccelerationMeasure
    typedef REAL IfcAccelerationMeasure;
    // C++ wrapper type for IfcAmountOfSubstanceMeasure
    typedef REAL IfcAmountOfSubstanceMeasure;
    // C++ wrapper type for IfcAngularVelocityMeasure
    typedef REAL IfcAngularVelocityMeasure;
    // C++ wrapper type for IfcArcIndex
    typedef ListOf< INTEGER, 3, 3 > IfcArcIndex;
    // C++ wrapper type for IfcAreaDensityMeasure
    typedef REAL IfcAreaDensityMeasure;
    // C++ wrapper type for IfcAreaMeasure
    typedef REAL IfcAreaMeasure;
    // C++ wrapper type for IfcBoolean
    typedef BOOLEAN IfcBoolean;
    // C++ wrapper type for IfcBoxAlignment
    typedef STRING IfcBoxAlignment;
    // C++ wrapper type for IfcCardinalPointReference
    typedef INTEGER IfcCardinalPointReference;
    // C++ wrapper type for IfcCompoundPlaneAngleMeasure
    typedef ListOf< INTEGER, 3, 4 > IfcCompoundPlaneAngleMeasure;
    // C++ wrapper type for IfcContextDependentMeasure
    typedef REAL IfcContextDependentMeasure;
    // C++ wrapper type for IfcCountMeasure
    typedef NUMBER IfcCountMeasure;
    // C++ wrapper type for IfcCurvatureMeasure
    typedef REAL IfcCurvatureMeasure;
    // C++ wrapper type for IfcDate
    typedef STRING IfcDate;
    // C++ wrapper type for IfcDateTime
    typedef STRING IfcDateTime;
    // C++ wrapper type for IfcDayInMonthNumber
    typedef INTEGER IfcDayInMonthNumber;
    // C++ wrapper type for IfcDayInWeekNumber
    typedef INTEGER IfcDayInWeekNumber;
    // C++ wrapper type for IfcDescriptiveMeasure
    typedef STRING IfcDescriptiveMeasure;
    // C++ wrapper type for IfcDimensionCount
    typedef INTEGER IfcDimensionCount;
    // C++ wrapper type for IfcDoseEquivalentMeasure
    typedef REAL IfcDoseEquivalentMeasure;
    // C++ wrapper type for IfcDuration
    typedef STRING IfcDuration;
    // C++ wrapper type for IfcDynamicViscosityMeasure
    typedef REAL IfcDynamicViscosityMeasure;
    // C++ wrapper type for IfcElectricCapacitanceMeasure
    typedef REAL IfcElectricCapacitanceMeasure;
    // C++ wrapper type for IfcElectricChargeMeasure
    typedef REAL IfcElectricChargeMeasure;
    // C++ wrapper type for IfcElectricConductanceMeasure
    typedef REAL IfcElectricConductanceMeasure;
    // C++ wrapper type for IfcElectricCurrentMeasure
    typedef REAL IfcElectricCurrentMeasure;
    // C++ wrapper type for IfcElectricResistanceMeasure
    typedef REAL IfcElectricResistanceMeasure;
    // C++ wrapper type for IfcElectricVoltageMeasure
    typedef REAL IfcElectricVoltageMeasure;
    // C++ wrapper type for IfcEnergyMeasure
    typedef REAL IfcEnergyMeasure;
    // C++ wrapper type for IfcFontStyle
    typedef STRING IfcFontStyle;
    // C++ wrapper type for IfcFontVariant
    typedef STRING IfcFontVariant;
    // C++ wrapper type for IfcFontWeight
    typedef STRING IfcFontWeight;
    // C++ wrapper type for IfcForceMeasure
    typedef REAL IfcForceMeasure;
    // C++ wrapper type for IfcFrequencyMeasure
    typedef REAL IfcFrequencyMeasure;
    // C++ wrapper type for IfcGloballyUniqueId
    typedef STRING IfcGloballyUniqueId;
    // C++ wrapper type for IfcHeatFluxDensityMeasure
    typedef REAL IfcHeatFluxDensityMeasure;
    // C++ wrapper type for IfcHeatingValueMeasure
    typedef REAL IfcHeatingValueMeasure;
    // C++ wrapper type for IfcIdentifier
    typedef STRING IfcIdentifier;
    // C++ wrapper type for IfcIlluminanceMeasure
    typedef REAL IfcIlluminanceMeasure;
    // C++ wrapper type for IfcInductanceMeasure
    typedef REAL IfcInductanceMeasure;
    // C++ wrapper type for IfcInteger
    typedef INTEGER IfcInteger;
    // C++ wrapper type for IfcIntegerCountRateMeasure
    typedef INTEGER IfcIntegerCountRateMeasure;
    // C++ wrapper type for IfcIonConcentrationMeasure
    typedef REAL IfcIonConcentrationMeasure;
    // C++ wrapper type for IfcIsothermalMoistureCapacityMeasure
    typedef REAL IfcIsothermalMoistureCapacityMeasure;
    // C++ wrapper type for IfcKinematicViscosityMeasure
    typedef REAL IfcKinematicViscosityMeasure;
    // C++ wrapper type for IfcLabel
    typedef STRING IfcLabel;
    // C++ wrapper type for IfcLanguageId
    typedef STRING IfcLanguageId;
    // C++ wrapper type for IfcLengthMeasure
    typedef REAL IfcLengthMeasure;
    // C++ wrapper type for IfcLineIndex
    typedef ListOf< INTEGER, 2, 0 > IfcLineIndex;
    // C++ wrapper type for IfcLinearForceMeasure
    typedef REAL IfcLinearForceMeasure;
    // C++ wrapper type for IfcLinearMomentMeasure
    typedef REAL IfcLinearMomentMeasure;
    // C++ wrapper type for IfcLinearStiffnessMeasure
    typedef REAL IfcLinearStiffnessMeasure;
    // C++ wrapper type for IfcLinearVelocityMeasure
    typedef REAL IfcLinearVelocityMeasure;
    // C++ wrapper type for IfcLogical
    typedef LOGICAL IfcLogical;
    // C++ wrapper type for IfcLuminousFluxMeasure
    typedef REAL IfcLuminousFluxMeasure;
    // C++ wrapper type for IfcLuminousIntensityDistributionMeasure
    typedef REAL IfcLuminousIntensityDistributionMeasure;
    // C++ wrapper type for IfcLuminousIntensityMeasure
    typedef REAL IfcLuminousIntensityMeasure;
    // C++ wrapper type for IfcMagneticFluxDensityMeasure
    typedef REAL IfcMagneticFluxDensityMeasure;
    // C++ wrapper type for IfcMagneticFluxMeasure
    typedef REAL IfcMagneticFluxMeasure;
    // C++ wrapper type for IfcMassDensityMeasure
    typedef REAL IfcMassDensityMeasure;
    // C++ wrapper type for IfcMassFlowRateMeasure
    typedef REAL IfcMassFlowRateMeasure;
    // C++ wrapper type for IfcMassMeasure
    typedef REAL IfcMassMeasure;
    // C++ wrapper type for IfcMassPerLengthMeasure
    typedef REAL IfcMassPerLengthMeasure;
    // C++ wrapper type for IfcModulusOfElasticityMeasure
    typedef REAL IfcModulusOfElasticityMeasure;
    // C++ wrapper type for IfcModulusOfLinearSubgradeReactionMeasure
    typedef REAL IfcModulusOfLinearSubgradeReactionMeasure;
    // C++ wrapper type for IfcModulusOfRotationalSubgradeReactionMeasure
    typedef REAL IfcModulusOfRotationalSubgradeReactionMeasure;
    // C++ wrapper type for IfcModulusOfSubgradeReactionMeasure
    typedef REAL IfcModulusOfSubgradeReactionMeasure;
    // C++ wrapper type for IfcMoistureDiffusivityMeasure
    typedef REAL IfcMoistureDiffusivityMeasure;
    // C++ wrapper type for IfcMolecularWeightMeasure
    typedef REAL IfcMolecularWeightMeasure;
    // C++ wrapper type for IfcMomentOfInertiaMeasure
    typedef REAL IfcMomentOfInertiaMeasure;
    // C++ wrapper type for IfcMonetaryMeasure
    typedef REAL IfcMonetaryMeasure;
    // C++ wrapper type for IfcMonthInYearNumber
    typedef INTEGER IfcMonthInYearNumber;
    // C++ wrapper type for IfcNonNegativeLengthMeasure
    typedef REAL IfcNonNegativeLengthMeasure;
    // C++ wrapper type for IfcNormalisedRatioMeasure
    typedef REAL IfcNormalisedRatioMeasure;
    // C++ wrapper type for IfcNumericMeasure
    typedef NUMBER IfcNumericMeasure;
    // C++ wrapper type for IfcPHMeasure
    typedef REAL IfcPHMeasure;
    // C++ wrapper type for IfcParameterValue
    typedef REAL IfcParameterValue;
    // C++ wrapper type for IfcPlanarForceMeasure
    typedef REAL IfcPlanarForceMeasure;
    // C++ wrapper type for IfcPlaneAngleMeasure
    typedef REAL IfcPlaneAngleMeasure;
    // C++ wrapper type for IfcPositiveInteger
    typedef INTEGER IfcPositiveInteger;
    // C++ wrapper type for IfcPositiveLengthMeasure
    typedef REAL IfcPositiveLengthMeasure;
    // C++ wrapper type for IfcPositivePlaneAngleMeasure
    typedef REAL IfcPositivePlaneAngleMeasure;
    // C++ wrapper type for IfcPositiveRatioMeasure
    typedef REAL IfcPositiveRatioMeasure;
    // C++ wrapper type for IfcPowerMeasure
    typedef REAL IfcPowerMeasure;
    // C++ wrapper type for IfcPresentableText
    typedef STRING IfcPresentableText;
    // C++ wrapper type for IfcPressureMeasure
    typedef REAL IfcPressureMeasure;
    // C++ wrapper type for IfcRadioActivityMeasure
    typedef REAL IfcRadioActivityMeasure;
    // C++ wrapper type for IfcRatioMeasure
    typedef REAL IfcRatioMeasure;
    // C++ wrapper type for IfcReal
    typedef REAL IfcReal;
    // C++ wrapper type for IfcRotationalFrequencyMeasure
    typedef REAL IfcRotationalFrequencyMeasure;
    // C++ wrapper type for IfcRotationalMassMeasure
    typedef REAL IfcRotationalMassMeasure;
    // C++ wrapper type for IfcRotationalStiffnessMeasure
    typedef REAL IfcRotationalStiffnessMeasure;
    // C++ wrapper type for IfcSectionModulusMeasure
    typedef REAL IfcSectionModulusMeasure;
    // C++ wrapper type for IfcSectionalAreaIntegralMeasure
    typedef REAL IfcSectionalAreaIntegralMeasure;
    // C++ wrapper type for IfcShearModulusMeasure
    typedef REAL IfcShearModulusMeasure;
    // C++ wrapper type for IfcSolidAngleMeasure
    typedef REAL IfcSolidAngleMeasure;
    // C++ wrapper type for IfcSoundPowerLevelMeasure
    typedef REAL IfcSoundPowerLevelMeasure;
    // C++ wrapper type for IfcSoundPowerMeasure
    typedef REAL IfcSoundPowerMeasure;
    // C++ wrapper type for IfcSoundPressureLevelMeasure
    typedef REAL IfcSoundPressureLevelMeasure;
    // C++ wrapper type for IfcSoundPressureMeasure
    typedef REAL IfcSoundPressureMeasure;
    // C++ wrapper type for IfcSpecificHeatCapacityMeasure
    typedef REAL IfcSpecificHeatCapacityMeasure;
    // C++ wrapper type for IfcSpecularExponent
    typedef REAL IfcSpecularExponent;
    // C++ wrapper type for IfcSpecularRoughness
    typedef REAL IfcSpecularRoughness;
    // C++ wrapper type for IfcTemperatureGradientMeasure
    typedef REAL IfcTemperatureGradientMeasure;
    // C++ wrapper type for IfcTemperatureRateOfChangeMeasure
    typedef REAL IfcTemperatureRateOfChangeMeasure;
    // C++ wrapper type for IfcText
    typedef STRING IfcText;
    // C++ wrapper type for IfcTextAlignment
    typedef STRING IfcTextAlignment;
    // C++ wrapper type for IfcTextDecoration
    typedef STRING IfcTextDecoration;
    // C++ wrapper type for IfcTextFontName
    typedef STRING IfcTextFontName;
    // C++ wrapper type for IfcTextTransformation
    typedef STRING IfcTextTransformation;
    // C++ wrapper type for IfcThermalAdmittanceMeasure
    typedef REAL IfcThermalAdmittanceMeasure;
    // C++ wrapper type for IfcThermalConductivityMeasure
    typedef REAL IfcThermalConductivityMeasure;
    // C++ wrapper type for IfcThermalExpansionCoefficientMeasure
    typedef REAL IfcThermalExpansionCoefficientMeasure;
    // C++ wrapper type for IfcThermalResistanceMeasure
    typedef REAL IfcThermalResistanceMeasure;
    // C++ wrapper type for IfcThermalTransmittanceMeasure
    typedef REAL IfcThermalTransmittanceMeasure;
    // C++ wrapper type for IfcThermodynamicTemperatureMeasure
    typedef REAL IfcThermodynamicTemperatureMeasure;
    // C++ wrapper type for IfcTime
    typedef STRING IfcTime;
    // C++ wrapper type for IfcTimeMeasure
    typedef REAL IfcTimeMeasure;
    // C++ wrapper type for IfcTimeStamp
    typedef INTEGER IfcTimeStamp;
    // C++ wrapper type for IfcTorqueMeasure
    typedef REAL IfcTorqueMeasure;
    // C++ wrapper type for IfcURIReference
    typedef STRING IfcURIReference;
    // C++ wrapper type for IfcVaporPermeabilityMeasure
    typedef REAL IfcVaporPermeabilityMeasure;
    // C++ wrapper type for IfcVolumeMeasure
    typedef REAL IfcVolumeMeasure;
    // C++ wrapper type for IfcVolumetricFlowRateMeasure
    typedef REAL IfcVolumetricFlowRateMeasure;
    // C++ wrapper type for IfcWarpingConstantMeasure
    typedef REAL IfcWarpingConstantMeasure;
    // C++ wrapper type for IfcWarpingMomentMeasure
    typedef REAL IfcWarpingMomentMeasure;
    // C++ wrapper type for IfcActionRequestTypeEnum
    typedef ENUMERATION IfcActionRequestTypeEnum;
    // C++ wrapper type for IfcActionSourceTypeEnum
    typedef ENUMERATION IfcActionSourceTypeEnum;
    // C++ wrapper type for IfcActionTypeEnum
    typedef ENUMERATION IfcActionTypeEnum;
    // C++ wrapper type for IfcActuatorTypeEnum
    typedef ENUMERATION IfcActuatorTypeEnum;
    // C++ wrapper type for IfcAddressTypeEnum
    typedef ENUMERATION IfcAddressTypeEnum;
    // C++ wrapper type for IfcAirTerminalBoxTypeEnum
    typedef ENUMERATION IfcAirTerminalBoxTypeEnum;
    // C++ wrapper type for IfcAirTerminalTypeEnum
    typedef ENUMERATION IfcAirTerminalTypeEnum;
    // C++ wrapper type for IfcAirToAirHeatRecoveryTypeEnum
    typedef ENUMERATION IfcAirToAirHeatRecoveryTypeEnum;
    // C++ wrapper type for IfcAlarmTypeEnum
    typedef ENUMERATION IfcAlarmTypeEnum;
    // C++ wrapper type for IfcAnalysisModelTypeEnum
    typedef ENUMERATION IfcAnalysisModelTypeEnum;
    // C++ wrapper type for IfcAnalysisTheoryTypeEnum
    typedef ENUMERATION IfcAnalysisTheoryTypeEnum;
    // C++ wrapper type for IfcArithmeticOperatorEnum
    typedef ENUMERATION IfcArithmeticOperatorEnum;
    // C++ wrapper type for IfcAssemblyPlaceEnum
    typedef ENUMERATION IfcAssemblyPlaceEnum;
    // C++ wrapper type for IfcAudioVisualApplianceTypeEnum
    typedef ENUMERATION IfcAudioVisualApplianceTypeEnum;
    // C++ wrapper type for IfcBSplineCurveForm
    typedef ENUMERATION IfcBSplineCurveForm;
    // C++ wrapper type for IfcBSplineSurfaceForm
    typedef ENUMERATION IfcBSplineSurfaceForm;
    // C++ wrapper type for IfcBeamTypeEnum
    typedef ENUMERATION IfcBeamTypeEnum;
    // C++ wrapper type for IfcBenchmarkEnum
    typedef ENUMERATION IfcBenchmarkEnum;
    // C++ wrapper type for IfcBoilerTypeEnum
    typedef ENUMERATION IfcBoilerTypeEnum;
    // C++ wrapper type for IfcBooleanOperator
    typedef ENUMERATION IfcBooleanOperator;
    // C++ wrapper type for IfcBuildingElementPartTypeEnum
    typedef ENUMERATION IfcBuildingElementPartTypeEnum;
    // C++ wrapper type for IfcBuildingElementProxyTypeEnum
    typedef ENUMERATION IfcBuildingElementProxyTypeEnum;
    // C++ wrapper type for IfcBuildingSystemTypeEnum
    typedef ENUMERATION IfcBuildingSystemTypeEnum;
    // C++ wrapper type for IfcBurnerTypeEnum
    typedef ENUMERATION IfcBurnerTypeEnum;
    // C++ wrapper type for IfcCableCarrierFittingTypeEnum
    typedef ENUMERATION IfcCableCarrierFittingTypeEnum;
    // C++ wrapper type for IfcCableCarrierSegmentTypeEnum
    typedef ENUMERATION IfcCableCarrierSegmentTypeEnum;
    // C++ wrapper type for IfcCableFittingTypeEnum
    typedef ENUMERATION IfcCableFittingTypeEnum;
    // C++ wrapper type for IfcCableSegmentTypeEnum
    typedef ENUMERATION IfcCableSegmentTypeEnum;
    // C++ wrapper type for IfcChangeActionEnum
    typedef ENUMERATION IfcChangeActionEnum;
    // C++ wrapper type for IfcChillerTypeEnum
    typedef ENUMERATION IfcChillerTypeEnum;
    // C++ wrapper type for IfcChimneyTypeEnum
    typedef ENUMERATION IfcChimneyTypeEnum;
    // C++ wrapper type for IfcCoilTypeEnum
    typedef ENUMERATION IfcCoilTypeEnum;
    // C++ wrapper type for IfcColumnTypeEnum
    typedef ENUMERATION IfcColumnTypeEnum;
    // C++ wrapper type for IfcCommunicationsApplianceTypeEnum
    typedef ENUMERATION IfcCommunicationsApplianceTypeEnum;
    // C++ wrapper type for IfcComplexPropertyTemplateTypeEnum
    typedef ENUMERATION IfcComplexPropertyTemplateTypeEnum;
    // C++ wrapper type for IfcCompressorTypeEnum
    typedef ENUMERATION IfcCompressorTypeEnum;
    // C++ wrapper type for IfcCondenserTypeEnum
    typedef ENUMERATION IfcCondenserTypeEnum;
    // C++ wrapper type for IfcConnectionTypeEnum
    typedef ENUMERATION IfcConnectionTypeEnum;
    // C++ wrapper type for IfcConstraintEnum
    typedef ENUMERATION IfcConstraintEnum;
    // C++ wrapper type for IfcConstructionEquipmentResourceTypeEnum
    typedef ENUMERATION IfcConstructionEquipmentResourceTypeEnum;
    // C++ wrapper type for IfcConstructionMaterialResourceTypeEnum
    typedef ENUMERATION IfcConstructionMaterialResourceTypeEnum;
    // C++ wrapper type for IfcConstructionProductResourceTypeEnum
    typedef ENUMERATION IfcConstructionProductResourceTypeEnum;
    // C++ wrapper type for IfcControllerTypeEnum
    typedef ENUMERATION IfcControllerTypeEnum;
    // C++ wrapper type for IfcCooledBeamTypeEnum
    typedef ENUMERATION IfcCooledBeamTypeEnum;
    // C++ wrapper type for IfcCoolingTowerTypeEnum
    typedef ENUMERATION IfcCoolingTowerTypeEnum;
    // C++ wrapper type for IfcCostItemTypeEnum
    typedef ENUMERATION IfcCostItemTypeEnum;
    // C++ wrapper type for IfcCostScheduleTypeEnum
    typedef ENUMERATION IfcCostScheduleTypeEnum;
    // C++ wrapper type for IfcCoveringTypeEnum
    typedef ENUMERATION IfcCoveringTypeEnum;
    // C++ wrapper type for IfcCrewResourceTypeEnum
    typedef ENUMERATION IfcCrewResourceTypeEnum;
    // C++ wrapper type for IfcCurtainWallTypeEnum
    typedef ENUMERATION IfcCurtainWallTypeEnum;
    // C++ wrapper type for IfcCurveInterpolationEnum
    typedef ENUMERATION IfcCurveInterpolationEnum;
    // C++ wrapper type for IfcDamperTypeEnum
    typedef ENUMERATION IfcDamperTypeEnum;
    // C++ wrapper type for IfcDataOriginEnum
    typedef ENUMERATION IfcDataOriginEnum;
    // C++ wrapper type for IfcDerivedUnitEnum
    typedef ENUMERATION IfcDerivedUnitEnum;
    // C++ wrapper type for IfcDirectionSenseEnum
    typedef ENUMERATION IfcDirectionSenseEnum;
    // C++ wrapper type for IfcDiscreteAccessoryTypeEnum
    typedef ENUMERATION IfcDiscreteAccessoryTypeEnum;
    // C++ wrapper type for IfcDistributionChamberElementTypeEnum
    typedef ENUMERATION IfcDistributionChamberElementTypeEnum;
    // C++ wrapper type for IfcDistributionPortTypeEnum
    typedef ENUMERATION IfcDistributionPortTypeEnum;
    // C++ wrapper type for IfcDistributionSystemEnum
    typedef ENUMERATION IfcDistributionSystemEnum;
    // C++ wrapper type for IfcDocumentConfidentialityEnum
    typedef ENUMERATION IfcDocumentConfidentialityEnum;
    // C++ wrapper type for IfcDocumentStatusEnum
    typedef ENUMERATION IfcDocumentStatusEnum;
    // C++ wrapper type for IfcDoorPanelOperationEnum
    typedef ENUMERATION IfcDoorPanelOperationEnum;
    // C++ wrapper type for IfcDoorPanelPositionEnum
    typedef ENUMERATION IfcDoorPanelPositionEnum;
    // C++ wrapper type for IfcDoorStyleConstructionEnum
    typedef ENUMERATION IfcDoorStyleConstructionEnum;
    // C++ wrapper type for IfcDoorStyleOperationEnum
    typedef ENUMERATION IfcDoorStyleOperationEnum;
    // C++ wrapper type for IfcDoorTypeEnum
    typedef ENUMERATION IfcDoorTypeEnum;
    // C++ wrapper type for IfcDoorTypeOperationEnum
    typedef ENUMERATION IfcDoorTypeOperationEnum;
    // C++ wrapper type for IfcDuctFittingTypeEnum
    typedef ENUMERATION IfcDuctFittingTypeEnum;
    // C++ wrapper type for IfcDuctSegmentTypeEnum
    typedef ENUMERATION IfcDuctSegmentTypeEnum;
    // C++ wrapper type for IfcDuctSilencerTypeEnum
    typedef ENUMERATION IfcDuctSilencerTypeEnum;
    // C++ wrapper type for IfcElectricApplianceTypeEnum
    typedef ENUMERATION IfcElectricApplianceTypeEnum;
    // C++ wrapper type for IfcElectricDistributionBoardTypeEnum
    typedef ENUMERATION IfcElectricDistributionBoardTypeEnum;
    // C++ wrapper type for IfcElectricFlowStorageDeviceTypeEnum
    typedef ENUMERATION IfcElectricFlowStorageDeviceTypeEnum;
    // C++ wrapper type for IfcElectricGeneratorTypeEnum
    typedef ENUMERATION IfcElectricGeneratorTypeEnum;
    // C++ wrapper type for IfcElectricMotorTypeEnum
    typedef ENUMERATION IfcElectricMotorTypeEnum;
    // C++ wrapper type for IfcElectricTimeControlTypeEnum
    typedef ENUMERATION IfcElectricTimeControlTypeEnum;
    // C++ wrapper type for IfcElementAssemblyTypeEnum
    typedef ENUMERATION IfcElementAssemblyTypeEnum;
    // C++ wrapper type for IfcElementCompositionEnum
    typedef ENUMERATION IfcElementCompositionEnum;
    // C++ wrapper type for IfcEngineTypeEnum
    typedef ENUMERATION IfcEngineTypeEnum;
    // C++ wrapper type for IfcEvaporativeCoolerTypeEnum
    typedef ENUMERATION IfcEvaporativeCoolerTypeEnum;
    // C++ wrapper type for IfcEvaporatorTypeEnum
    typedef ENUMERATION IfcEvaporatorTypeEnum;
    // C++ wrapper type for IfcEventTriggerTypeEnum
    typedef ENUMERATION IfcEventTriggerTypeEnum;
    // C++ wrapper type for IfcEventTypeEnum
    typedef ENUMERATION IfcEventTypeEnum;
    // C++ wrapper type for IfcExternalSpatialElementTypeEnum
    typedef ENUMERATION IfcExternalSpatialElementTypeEnum;
    // C++ wrapper type for IfcFanTypeEnum
    typedef ENUMERATION IfcFanTypeEnum;
    // C++ wrapper type for IfcFastenerTypeEnum
    typedef ENUMERATION IfcFastenerTypeEnum;
    // C++ wrapper type for IfcFilterTypeEnum
    typedef ENUMERATION IfcFilterTypeEnum;
    // C++ wrapper type for IfcFireSuppressionTerminalTypeEnum
    typedef ENUMERATION IfcFireSuppressionTerminalTypeEnum;
    // C++ wrapper type for IfcFlowDirectionEnum
    typedef ENUMERATION IfcFlowDirectionEnum;
    // C++ wrapper type for IfcFlowInstrumentTypeEnum
    typedef ENUMERATION IfcFlowInstrumentTypeEnum;
    // C++ wrapper type for IfcFlowMeterTypeEnum
    typedef ENUMERATION IfcFlowMeterTypeEnum;
    // C++ wrapper type for IfcFootingTypeEnum
    typedef ENUMERATION IfcFootingTypeEnum;
    // C++ wrapper type for IfcFurnitureTypeEnum
    typedef ENUMERATION IfcFurnitureTypeEnum;
    // C++ wrapper type for IfcGeographicElementTypeEnum
    typedef ENUMERATION IfcGeographicElementTypeEnum;
    // C++ wrapper type for IfcGeometricProjectionEnum
    typedef ENUMERATION IfcGeometricProjectionEnum;
    // C++ wrapper type for IfcGlobalOrLocalEnum
    typedef ENUMERATION IfcGlobalOrLocalEnum;
    // C++ wrapper type for IfcGridTypeEnum
    typedef ENUMERATION IfcGridTypeEnum;
    // C++ wrapper type for IfcHeatExchangerTypeEnum
    typedef ENUMERATION IfcHeatExchangerTypeEnum;
    // C++ wrapper type for IfcHumidifierTypeEnum
    typedef ENUMERATION IfcHumidifierTypeEnum;
    // C++ wrapper type for IfcInterceptorTypeEnum
    typedef ENUMERATION IfcInterceptorTypeEnum;
    // C++ wrapper type for IfcInternalOrExternalEnum
    typedef ENUMERATION IfcInternalOrExternalEnum;
    // C++ wrapper type for IfcInventoryTypeEnum
    typedef ENUMERATION IfcInventoryTypeEnum;
    // C++ wrapper type for IfcJunctionBoxTypeEnum
    typedef ENUMERATION IfcJunctionBoxTypeEnum;
    // C++ wrapper type for IfcKnotType
    typedef ENUMERATION IfcKnotType;
    // C++ wrapper type for IfcLaborResourceTypeEnum
    typedef ENUMERATION IfcLaborResourceTypeEnum;
    // C++ wrapper type for IfcLampTypeEnum
    typedef ENUMERATION IfcLampTypeEnum;
    // C++ wrapper type for IfcLayerSetDirectionEnum
    typedef ENUMERATION IfcLayerSetDirectionEnum;
    // C++ wrapper type for IfcLightDistributionCurveEnum
    typedef ENUMERATION IfcLightDistributionCurveEnum;
    // C++ wrapper type for IfcLightEmissionSourceEnum
    typedef ENUMERATION IfcLightEmissionSourceEnum;
    // C++ wrapper type for IfcLightFixtureTypeEnum
    typedef ENUMERATION IfcLightFixtureTypeEnum;
    // C++ wrapper type for IfcLoadGroupTypeEnum
    typedef ENUMERATION IfcLoadGroupTypeEnum;
    // C++ wrapper type for IfcLogicalOperatorEnum
    typedef ENUMERATION IfcLogicalOperatorEnum;
    // C++ wrapper type for IfcMechanicalFastenerTypeEnum
    typedef ENUMERATION IfcMechanicalFastenerTypeEnum;
    // C++ wrapper type for IfcMedicalDeviceTypeEnum
    typedef ENUMERATION IfcMedicalDeviceTypeEnum;
    // C++ wrapper type for IfcMemberTypeEnum
    typedef ENUMERATION IfcMemberTypeEnum;
    // C++ wrapper type for IfcMotorConnectionTypeEnum
    typedef ENUMERATION IfcMotorConnectionTypeEnum;
    // C++ wrapper type for IfcNullStyle
    typedef ENUMERATION IfcNullStyle;
    // C++ wrapper type for IfcObjectTypeEnum
    typedef ENUMERATION IfcObjectTypeEnum;
    // C++ wrapper type for IfcObjectiveEnum
    typedef ENUMERATION IfcObjectiveEnum;
    // C++ wrapper type for IfcOccupantTypeEnum
    typedef ENUMERATION IfcOccupantTypeEnum;
    // C++ wrapper type for IfcOpeningElementTypeEnum
    typedef ENUMERATION IfcOpeningElementTypeEnum;
    // C++ wrapper type for IfcOutletTypeEnum
    typedef ENUMERATION IfcOutletTypeEnum;
    // C++ wrapper type for IfcPerformanceHistoryTypeEnum
    typedef ENUMERATION IfcPerformanceHistoryTypeEnum;
    // C++ wrapper type for IfcPermeableCoveringOperationEnum
    typedef ENUMERATION IfcPermeableCoveringOperationEnum;
    // C++ wrapper type for IfcPermitTypeEnum
    typedef ENUMERATION IfcPermitTypeEnum;
    // C++ wrapper type for IfcPhysicalOrVirtualEnum
    typedef ENUMERATION IfcPhysicalOrVirtualEnum;
    // C++ wrapper type for IfcPileConstructionEnum
    typedef ENUMERATION IfcPileConstructionEnum;
    // C++ wrapper type for IfcPileTypeEnum
    typedef ENUMERATION IfcPileTypeEnum;
    // C++ wrapper type for IfcPipeFittingTypeEnum
    typedef ENUMERATION IfcPipeFittingTypeEnum;
    // C++ wrapper type for IfcPipeSegmentTypeEnum
    typedef ENUMERATION IfcPipeSegmentTypeEnum;
    // C++ wrapper type for IfcPlateTypeEnum
    typedef ENUMERATION IfcPlateTypeEnum;
    // C++ wrapper type for IfcPreferredSurfaceCurveRepresentation
    typedef ENUMERATION IfcPreferredSurfaceCurveRepresentation;
    // C++ wrapper type for IfcProcedureTypeEnum
    typedef ENUMERATION IfcProcedureTypeEnum;
    // C++ wrapper type for IfcProfileTypeEnum
    typedef ENUMERATION IfcProfileTypeEnum;
    // C++ wrapper type for IfcProjectOrderTypeEnum
    typedef ENUMERATION IfcProjectOrderTypeEnum;
    // C++ wrapper type for IfcProjectedOrTrueLengthEnum
    typedef ENUMERATION IfcProjectedOrTrueLengthEnum;
    // C++ wrapper type for IfcProjectionElementTypeEnum
    typedef ENUMERATION IfcProjectionElementTypeEnum;
    // C++ wrapper type for IfcPropertySetTemplateTypeEnum
    typedef ENUMERATION IfcPropertySetTemplateTypeEnum;
    // C++ wrapper type for IfcProtectiveDeviceTrippingUnitTypeEnum
    typedef ENUMERATION IfcProtectiveDeviceTrippingUnitTypeEnum;
    // C++ wrapper type for IfcProtectiveDeviceTypeEnum
    typedef ENUMERATION IfcProtectiveDeviceTypeEnum;
    // C++ wrapper type for IfcPumpTypeEnum
    typedef ENUMERATION IfcPumpTypeEnum;
    // C++ wrapper type for IfcRailingTypeEnum
    typedef ENUMERATION IfcRailingTypeEnum;
    // C++ wrapper type for IfcRampFlightTypeEnum
    typedef ENUMERATION IfcRampFlightTypeEnum;
    // C++ wrapper type for IfcRampTypeEnum
    typedef ENUMERATION IfcRampTypeEnum;
    // C++ wrapper type for IfcRecurrenceTypeEnum
    typedef ENUMERATION IfcRecurrenceTypeEnum;
    // C++ wrapper type for IfcReflectanceMethodEnum
    typedef ENUMERATION IfcReflectanceMethodEnum;
    // C++ wrapper type for IfcReinforcingBarRoleEnum
    typedef ENUMERATION IfcReinforcingBarRoleEnum;
    // C++ wrapper type for IfcReinforcingBarSurfaceEnum
    typedef ENUMERATION IfcReinforcingBarSurfaceEnum;
    // C++ wrapper type for IfcReinforcingBarTypeEnum
    typedef ENUMERATION IfcReinforcingBarTypeEnum;
    // C++ wrapper type for IfcReinforcingMeshTypeEnum
    typedef ENUMERATION IfcReinforcingMeshTypeEnum;
    // C++ wrapper type for IfcRoleEnum
    typedef ENUMERATION IfcRoleEnum;
    // C++ wrapper type for IfcRoofTypeEnum
    typedef ENUMERATION IfcRoofTypeEnum;
    // C++ wrapper type for IfcSIPrefix
    typedef ENUMERATION IfcSIPrefix;
    // C++ wrapper type for IfcSIUnitName
    typedef ENUMERATION IfcSIUnitName;
    // C++ wrapper type for IfcSanitaryTerminalTypeEnum
    typedef ENUMERATION IfcSanitaryTerminalTypeEnum;
    // C++ wrapper type for IfcSectionTypeEnum
    typedef ENUMERATION IfcSectionTypeEnum;
    // C++ wrapper type for IfcSensorTypeEnum
    typedef ENUMERATION IfcSensorTypeEnum;
    // C++ wrapper type for IfcSequenceEnum
    typedef ENUMERATION IfcSequenceEnum;
    // C++ wrapper type for IfcShadingDeviceTypeEnum
    typedef ENUMERATION IfcShadingDeviceTypeEnum;
    // C++ wrapper type for IfcSimplePropertyTemplateTypeEnum
    typedef ENUMERATION IfcSimplePropertyTemplateTypeEnum;
    // C++ wrapper type for IfcSlabTypeEnum
    typedef ENUMERATION IfcSlabTypeEnum;
    // C++ wrapper type for IfcSolarDeviceTypeEnum
    typedef ENUMERATION IfcSolarDeviceTypeEnum;
    // C++ wrapper type for IfcSpaceHeaterTypeEnum
    typedef ENUMERATION IfcSpaceHeaterTypeEnum;
    // C++ wrapper type for IfcSpaceTypeEnum
    typedef ENUMERATION IfcSpaceTypeEnum;
    // C++ wrapper type for IfcSpatialZoneTypeEnum
    typedef ENUMERATION IfcSpatialZoneTypeEnum;
    // C++ wrapper type for IfcStackTerminalTypeEnum
    typedef ENUMERATION IfcStackTerminalTypeEnum;
    // C++ wrapper type for IfcStairFlightTypeEnum
    typedef ENUMERATION IfcStairFlightTypeEnum;
    // C++ wrapper type for IfcStairTypeEnum
    typedef ENUMERATION IfcStairTypeEnum;
    // C++ wrapper type for IfcStateEnum
    typedef ENUMERATION IfcStateEnum;
    // C++ wrapper type for IfcStructuralCurveActivityTypeEnum
    typedef ENUMERATION IfcStructuralCurveActivityTypeEnum;
    // C++ wrapper type for IfcStructuralCurveMemberTypeEnum
    typedef ENUMERATION IfcStructuralCurveMemberTypeEnum;
    // C++ wrapper type for IfcStructuralSurfaceActivityTypeEnum
    typedef ENUMERATION IfcStructuralSurfaceActivityTypeEnum;
    // C++ wrapper type for IfcStructuralSurfaceMemberTypeEnum
    typedef ENUMERATION IfcStructuralSurfaceMemberTypeEnum;
    // C++ wrapper type for IfcSubContractResourceTypeEnum
    typedef ENUMERATION IfcSubContractResourceTypeEnum;
    // C++ wrapper type for IfcSurfaceFeatureTypeEnum
    typedef ENUMERATION IfcSurfaceFeatureTypeEnum;
    // C++ wrapper type for IfcSurfaceSide
    typedef ENUMERATION IfcSurfaceSide;
    // C++ wrapper type for IfcSwitchingDeviceTypeEnum
    typedef ENUMERATION IfcSwitchingDeviceTypeEnum;
    // C++ wrapper type for IfcSystemFurnitureElementTypeEnum
    typedef ENUMERATION IfcSystemFurnitureElementTypeEnum;
    // C++ wrapper type for IfcTankTypeEnum
    typedef ENUMERATION IfcTankTypeEnum;
    // C++ wrapper type for IfcTaskDurationEnum
    typedef ENUMERATION IfcTaskDurationEnum;
    // C++ wrapper type for IfcTaskTypeEnum
    typedef ENUMERATION IfcTaskTypeEnum;
    // C++ wrapper type for IfcTendonAnchorTypeEnum
    typedef ENUMERATION IfcTendonAnchorTypeEnum;
    // C++ wrapper type for IfcTendonTypeEnum
    typedef ENUMERATION IfcTendonTypeEnum;
    // C++ wrapper type for IfcTextPath
    typedef ENUMERATION IfcTextPath;
    // C++ wrapper type for IfcTimeSeriesDataTypeEnum
    typedef ENUMERATION IfcTimeSeriesDataTypeEnum;
    // C++ wrapper type for IfcTransformerTypeEnum
    typedef ENUMERATION IfcTransformerTypeEnum;
    // C++ wrapper type for IfcTransitionCode
    typedef ENUMERATION IfcTransitionCode;
    // C++ wrapper type for IfcTransportElementTypeEnum
    typedef ENUMERATION IfcTransportElementTypeEnum;
    // C++ wrapper type for IfcTrimmingPreference
    typedef ENUMERATION IfcTrimmingPreference;
    // C++ wrapper type for IfcTubeBundleTypeEnum
    typedef ENUMERATION IfcTubeBundleTypeEnum;
    // C++ wrapper type for IfcUnitEnum
    typedef ENUMERATION IfcUnitEnum;
    // C++ wrapper type for IfcUnitaryControlElementTypeEnum
    typedef ENUMERATION IfcUnitaryControlElementTypeEnum;
    // C++ wrapper type for IfcUnitaryEquipmentTypeEnum
    typedef ENUMERATION IfcUnitaryEquipmentTypeEnum;
    // C++ wrapper type for IfcValveTypeEnum
    typedef ENUMERATION IfcValveTypeEnum;
    // C++ wrapper type for IfcVibrationIsolatorTypeEnum
    typedef ENUMERATION IfcVibrationIsolatorTypeEnum;
    // C++ wrapper type for IfcVoidingFeatureTypeEnum
    typedef ENUMERATION IfcVoidingFeatureTypeEnum;
    // C++ wrapper type for IfcWallTypeEnum
    typedef ENUMERATION IfcWallTypeEnum;
    // C++ wrapper type for IfcWasteTerminalTypeEnum
    typedef ENUMERATION IfcWasteTerminalTypeEnum;
    // C++ wrapper type for IfcWindowPanelOperationEnum
    typedef ENUMERATION IfcWindowPanelOperationEnum;
    // C++ wrapper type for IfcWindowPanelPositionEnum
    typedef ENUMERATION IfcWindowPanelPositionEnum;
    // C++ wrapper type for IfcWindowStyleConstructionEnum
    typedef ENUMERATION IfcWindowStyleConstructionEnum;
    // C++ wrapper type for IfcWindowStyleOperationEnum
    typedef ENUMERATION IfcWindowStyleOperationEnum;
    // C++ wrapper type for IfcWindowTypeEnum
    typedef ENUMERATION IfcWindowTypeEnum;
    // C++ wrapper type for IfcWindowTypePartitioningEnum
    typedef ENUMERATION IfcWindowTypePartitioningEnum;
    // C++ wrapper type for IfcWorkCalendarTypeEnum
    typedef ENUMERATION IfcWorkCalendarTypeEnum;
    // C++ wrapper type for IfcWorkPlanTypeEnum
    typedef ENUMERATION IfcWorkPlanTypeEnum;
    // C++ wrapper type for IfcWorkScheduleTypeEnum
    typedef ENUMERATION IfcWorkScheduleTypeEnum;
    // C++ wrapper type for IfcActorSelect
    typedef SELECT IfcActorSelect;
    // C++ wrapper type for IfcAppliedValueSelect
    typedef SELECT IfcAppliedValueSelect;
    // C++ wrapper type for IfcAxis2Placement
    typedef SELECT IfcAxis2Placement;
    // C++ wrapper type for IfcBendingParameterSelect
    typedef SELECT IfcBendingParameterSelect;
    // C++ wrapper type for IfcBooleanOperand
    typedef SELECT IfcBooleanOperand;
    // C++ wrapper type for IfcClassificationReferenceSelect
    typedef SELECT IfcClassificationReferenceSelect;
    // C++ wrapper type for IfcClassificationSelect
    typedef SELECT IfcClassificationSelect;
    // C++ wrapper type for IfcColour
    typedef SELECT IfcColour;
    // C++ wrapper type for IfcColourOrFactor
    typedef SELECT IfcColourOrFactor;
    // C++ wrapper type for IfcCoordinateReferenceSystemSelect
    typedef SELECT IfcCoordinateReferenceSystemSelect;
    // C++ wrapper type for IfcCsgSelect
    typedef SELECT IfcCsgSelect;
    // C++ wrapper type for IfcCurveFontOrScaledCurveFontSelect
    typedef SELECT IfcCurveFontOrScaledCurveFontSelect;
    // C++ wrapper type for IfcCurveOnSurface
    typedef SELECT IfcCurveOnSurface;
    // C++ wrapper type for IfcCurveOrEdgeCurve
    typedef SELECT IfcCurveOrEdgeCurve;
    // C++ wrapper type for IfcCurveStyleFontSelect
    typedef SELECT IfcCurveStyleFontSelect;
    // C++ wrapper type for IfcDefinitionSelect
    typedef SELECT IfcDefinitionSelect;
    // C++ wrapper type for IfcDerivedMeasureValue
    typedef SELECT IfcDerivedMeasureValue;
    // C++ wrapper type for IfcDocumentSelect
    typedef SELECT IfcDocumentSelect;
    // C++ wrapper type for IfcFillStyleSelect
    typedef SELECT IfcFillStyleSelect;
    // C++ wrapper type for IfcGeometricSetSelect
    typedef SELECT IfcGeometricSetSelect;
    // C++ wrapper type for IfcGridPlacementDirectionSelect
    typedef SELECT IfcGridPlacementDirectionSelect;
    // C++ wrapper type for IfcHatchLineDistanceSelect
    typedef SELECT IfcHatchLineDistanceSelect;
    // C++ wrapper type for IfcLayeredItem
    typedef SELECT IfcLayeredItem;
    // C++ wrapper type for IfcLibrarySelect
    typedef SELECT IfcLibrarySelect;
    // C++ wrapper type for IfcLightDistributionDataSourceSelect
    typedef SELECT IfcLightDistributionDataSourceSelect;
    // C++ wrapper type for IfcMaterialSelect
    typedef SELECT IfcMaterialSelect;
    // C++ wrapper type for IfcMeasureValue
    typedef SELECT IfcMeasureValue;
    // C++ wrapper type for IfcMetricValueSelect
    typedef SELECT IfcMetricValueSelect;
    // C++ wrapper type for IfcModulusOfRotationalSubgradeReactionSelect
    typedef SELECT IfcModulusOfRotationalSubgradeReactionSelect;
    // C++ wrapper type for IfcModulusOfSubgradeReactionSelect
    typedef SELECT IfcModulusOfSubgradeReactionSelect;
    // C++ wrapper type for IfcModulusOfTranslationalSubgradeReactionSelect
    typedef SELECT IfcModulusOfTranslationalSubgradeReactionSelect;
    // C++ wrapper type for IfcObjectReferenceSelect
    typedef SELECT IfcObjectReferenceSelect;
    // C++ wrapper type for IfcPointOrVertexPoint
    typedef SELECT IfcPointOrVertexPoint;
    // C++ wrapper type for IfcPresentationStyleSelect
    typedef SELECT IfcPresentationStyleSelect;
    // C++ wrapper type for IfcProcessSelect
    typedef SELECT IfcProcessSelect;
    // C++ wrapper type for IfcProductRepresentationSelect
    typedef SELECT IfcProductRepresentationSelect;
    // C++ wrapper type for IfcProductSelect
    typedef SELECT IfcProductSelect;
    // C++ wrapper type for IfcPropertySetDefinitionSelect
    typedef SELECT IfcPropertySetDefinitionSelect;
    // C++ wrapper type for IfcResourceObjectSelect
    typedef SELECT IfcResourceObjectSelect;
    // C++ wrapper type for IfcResourceSelect
    typedef SELECT IfcResourceSelect;
    // C++ wrapper type for IfcRotationalStiffnessSelect
    typedef SELECT IfcRotationalStiffnessSelect;
    // C++ wrapper type for IfcSegmentIndexSelect
    typedef SELECT IfcSegmentIndexSelect;
    // C++ wrapper type for IfcShell
    typedef SELECT IfcShell;
    // C++ wrapper type for IfcSimpleValue
    typedef SELECT IfcSimpleValue;
    // C++ wrapper type for IfcSizeSelect
    typedef SELECT IfcSizeSelect;
    // C++ wrapper type for IfcSolidOrShell
    typedef SELECT IfcSolidOrShell;
    // C++ wrapper type for IfcSpaceBoundarySelect
    typedef SELECT IfcSpaceBoundarySelect;
    // C++ wrapper type for IfcSpecularHighlightSelect
    typedef SELECT IfcSpecularHighlightSelect;
    // C++ wrapper type for IfcStructuralActivityAssignmentSelect
    typedef SELECT IfcStructuralActivityAssignmentSelect;
    // C++ wrapper type for IfcStyleAssignmentSelect
    typedef SELECT IfcStyleAssignmentSelect;
    // C++ wrapper type for IfcSurfaceOrFaceSurface
    typedef SELECT IfcSurfaceOrFaceSurface;
    // C++ wrapper type for IfcSurfaceStyleElementSelect
    typedef SELECT IfcSurfaceStyleElementSelect;
    // C++ wrapper type for IfcTextFontSelect
    typedef SELECT IfcTextFontSelect;
    // C++ wrapper type for IfcTimeOrRatioSelect
    typedef SELECT IfcTimeOrRatioSelect;
    // C++ wrapper type for IfcTranslationalStiffnessSelect
    typedef SELECT IfcTranslationalStiffnessSelect;
    // C++ wrapper type for IfcTrimmingSelect
    typedef SELECT IfcTrimmingSelect;
    // C++ wrapper type for IfcUnit
    typedef SELECT IfcUnit;
    // C++ wrapper type for IfcValue
    typedef SELECT IfcValue;
    // C++ wrapper type for IfcVectorOrDirection
    typedef SELECT IfcVectorOrDirection;
    // C++ wrapper type for IfcWarpingStiffnessSelect
    typedef SELECT IfcWarpingStiffnessSelect;


	// ******************************************************************************
	// IFC Entities
	// ******************************************************************************

	struct IfcRoot;
	struct IfcObjectDefinition;
	struct IfcObject;
	struct IfcControl;
	struct IfcActionRequest;
	struct IfcActor;
	typedef NotImplemented IfcActorRole; // (not currently used by Assimp)
	struct IfcProduct;
	struct IfcElement;
	struct IfcDistributionElement;
	struct IfcDistributionControlElement;
	struct IfcActuator;
	struct IfcTypeObject;
	struct IfcTypeProduct;
	struct IfcElementType;
	struct IfcDistributionElementType;
	struct IfcDistributionControlElementType;
	struct IfcActuatorType;
	typedef NotImplemented IfcAddress; // (not currently used by Assimp)
	struct IfcRepresentationItem;
	struct IfcGeometricRepresentationItem;
	struct IfcSolidModel;
	struct IfcManifoldSolidBrep;
	struct IfcAdvancedBrep;
	struct IfcAdvancedBrepWithVoids;
	struct IfcTopologicalRepresentationItem;
	struct IfcFace;
	struct IfcFaceSurface;
	struct IfcAdvancedFace;
	struct IfcDistributionFlowElement;
	struct IfcFlowTerminal;
	struct IfcAirTerminal;
	struct IfcFlowController;
	struct IfcAirTerminalBox;
	struct IfcDistributionFlowElementType;
	struct IfcFlowControllerType;
	struct IfcAirTerminalBoxType;
	struct IfcFlowTerminalType;
	struct IfcAirTerminalType;
	struct IfcEnergyConversionDevice;
	struct IfcAirToAirHeatRecovery;
	struct IfcEnergyConversionDeviceType;
	struct IfcAirToAirHeatRecoveryType;
	struct IfcAlarm;
	struct IfcAlarmType;
	struct IfcAnnotation;
	struct IfcAnnotationFillArea;
	typedef NotImplemented IfcApplication; // (not currently used by Assimp)
	typedef NotImplemented IfcAppliedValue; // (not currently used by Assimp)
	typedef NotImplemented IfcApproval; // (not currently used by Assimp)
	typedef NotImplemented IfcResourceLevelRelationship; // (not currently used by Assimp)
	typedef NotImplemented IfcApprovalRelationship; // (not currently used by Assimp)
	struct IfcProfileDef;
	struct IfcArbitraryClosedProfileDef;
	struct IfcArbitraryOpenProfileDef;
	struct IfcArbitraryProfileDefWithVoids;
	struct IfcGroup;
	struct IfcAsset;
	struct IfcParameterizedProfileDef;
	struct IfcAsymmetricIShapeProfileDef;
	struct IfcAudioVisualAppliance;
	struct IfcAudioVisualApplianceType;
	struct IfcPlacement;
	struct IfcAxis1Placement;
	struct IfcAxis2Placement2D;
	struct IfcAxis2Placement3D;
	struct IfcCurve;
	struct IfcBoundedCurve;
	struct IfcBSplineCurve;
	struct IfcBSplineCurveWithKnots;
	struct IfcSurface;
	struct IfcBoundedSurface;
	struct IfcBSplineSurface;
	struct IfcBSplineSurfaceWithKnots;
	struct IfcBuildingElement;
	struct IfcBeam;
	struct IfcBeamStandardCase;
	struct IfcBuildingElementType;
	struct IfcBeamType;
	struct IfcPresentationItem;
	typedef NotImplemented IfcSurfaceTexture; // (not currently used by Assimp)
	typedef NotImplemented IfcBlobTexture; // (not currently used by Assimp)
	struct IfcCsgPrimitive3D;
	struct IfcBlock;
	struct IfcBoiler;
	struct IfcBoilerType;
	struct IfcBooleanResult;
	struct IfcBooleanClippingResult;
	typedef NotImplemented IfcBoundaryCondition; // (not currently used by Assimp)
	struct IfcCompositeCurve;
	struct IfcCompositeCurveOnSurface;
	struct IfcBoundaryCurve;
	typedef NotImplemented IfcBoundaryEdgeCondition; // (not currently used by Assimp)
	typedef NotImplemented IfcBoundaryFaceCondition; // (not currently used by Assimp)
	typedef NotImplemented IfcBoundaryNodeCondition; // (not currently used by Assimp)
	typedef NotImplemented IfcBoundaryNodeConditionWarping; // (not currently used by Assimp)
	struct IfcBoundingBox;
	struct IfcHalfSpaceSolid;
	struct IfcBoxedHalfSpace;
	struct IfcSpatialElement;
	struct IfcSpatialStructureElement;
	struct IfcBuilding;
	struct IfcElementComponent;
	struct IfcBuildingElementPart;
	struct IfcElementComponentType;
	struct IfcBuildingElementPartType;
	struct IfcBuildingElementProxy;
	struct IfcBuildingElementProxyType;
	struct IfcBuildingStorey;
	struct IfcSystem;
	struct IfcBuildingSystem;
	struct IfcBurner;
	struct IfcBurnerType;
	struct IfcCShapeProfileDef;
	struct IfcFlowFitting;
	struct IfcCableCarrierFitting;
	struct IfcFlowFittingType;
	struct IfcCableCarrierFittingType;
	struct IfcFlowSegment;
	struct IfcCableCarrierSegment;
	struct IfcFlowSegmentType;
	struct IfcCableCarrierSegmentType;
	struct IfcCableFitting;
	struct IfcCableFittingType;
	struct IfcCableSegment;
	struct IfcCableSegmentType;
	struct IfcPoint;
	struct IfcCartesianPoint;
	struct IfcCartesianPointList;
	struct IfcCartesianPointList2D;
	struct IfcCartesianPointList3D;
	struct IfcCartesianTransformationOperator;
	struct IfcCartesianTransformationOperator2D;
	struct IfcCartesianTransformationOperator2DnonUniform;
	struct IfcCartesianTransformationOperator3D;
	struct IfcCartesianTransformationOperator3DnonUniform;
	struct IfcCenterLineProfileDef;
	struct IfcChiller;
	struct IfcChillerType;
	struct IfcChimney;
	struct IfcChimneyType;
	struct IfcConic;
	struct IfcCircle;
	struct IfcCircleProfileDef;
	struct IfcCircleHollowProfileDef;
	struct IfcCivilElement;
	struct IfcCivilElementType;
	typedef NotImplemented IfcExternalInformation; // (not currently used by Assimp)
	typedef NotImplemented IfcClassification; // (not currently used by Assimp)
	typedef NotImplemented IfcExternalReference; // (not currently used by Assimp)
	typedef NotImplemented IfcClassificationReference; // (not currently used by Assimp)
	struct IfcConnectedFaceSet;
	struct IfcClosedShell;
	struct IfcCoil;
	struct IfcCoilType;
	struct IfcColourSpecification;
	struct IfcColourRgb;
	typedef NotImplemented IfcColourRgbList; // (not currently used by Assimp)
	struct IfcColumn;
	struct IfcColumnStandardCase;
	struct IfcColumnType;
	struct IfcCommunicationsAppliance;
	struct IfcCommunicationsApplianceType;
	struct IfcPropertyAbstraction;
	struct IfcProperty;
	struct IfcComplexProperty;
	struct IfcPropertyDefinition;
	typedef NotImplemented IfcPropertyTemplateDefinition; // (not currently used by Assimp)
	typedef NotImplemented IfcPropertyTemplate; // (not currently used by Assimp)
	typedef NotImplemented IfcComplexPropertyTemplate; // (not currently used by Assimp)
	struct IfcCompositeCurveSegment;
	struct IfcCompositeProfileDef;
	struct IfcFlowMovingDevice;
	struct IfcCompressor;
	struct IfcFlowMovingDeviceType;
	struct IfcCompressorType;
	struct IfcCondenser;
	struct IfcCondenserType;
	typedef NotImplemented IfcConnectionGeometry; // (not currently used by Assimp)
	typedef NotImplemented IfcConnectionCurveGeometry; // (not currently used by Assimp)
	typedef NotImplemented IfcConnectionPointGeometry; // (not currently used by Assimp)
	typedef NotImplemented IfcConnectionPointEccentricity; // (not currently used by Assimp)
	typedef NotImplemented IfcConnectionSurfaceGeometry; // (not currently used by Assimp)
	typedef NotImplemented IfcConnectionVolumeGeometry; // (not currently used by Assimp)
	typedef NotImplemented IfcConstraint; // (not currently used by Assimp)
	struct IfcResource;
	struct IfcConstructionResource;
	struct IfcConstructionEquipmentResource;
	struct IfcTypeResource;
	struct IfcConstructionResourceType;
	struct IfcConstructionEquipmentResourceType;
	struct IfcConstructionMaterialResource;
	struct IfcConstructionMaterialResourceType;
	struct IfcConstructionProductResource;
	struct IfcConstructionProductResourceType;
	struct IfcContext;
	struct IfcNamedUnit;
	struct IfcContextDependentUnit;
	struct IfcController;
	struct IfcControllerType;
	struct IfcConversionBasedUnit;
	struct IfcConversionBasedUnitWithOffset;
	struct IfcCooledBeam;
	struct IfcCooledBeamType;
	struct IfcCoolingTower;
	struct IfcCoolingTowerType;
	typedef NotImplemented IfcCoordinateOperation; // (not currently used by Assimp)
	typedef NotImplemented IfcCoordinateReferenceSystem; // (not currently used by Assimp)
	struct IfcCostItem;
	struct IfcCostSchedule;
	typedef NotImplemented IfcCostValue; // (not currently used by Assimp)
	struct IfcCovering;
	struct IfcCoveringType;
	struct IfcCrewResource;
	struct IfcCrewResourceType;
	struct IfcCsgSolid;
	typedef NotImplemented IfcCurrencyRelationship; // (not currently used by Assimp)
	struct IfcCurtainWall;
	struct IfcCurtainWallType;
	struct IfcCurveBoundedPlane;
	struct IfcCurveBoundedSurface;
	struct IfcPresentationStyle;
	typedef NotImplemented IfcCurveStyle; // (not currently used by Assimp)
	typedef NotImplemented IfcCurveStyleFont; // (not currently used by Assimp)
	typedef NotImplemented IfcCurveStyleFontAndScaling; // (not currently used by Assimp)
	typedef NotImplemented IfcCurveStyleFontPattern; // (not currently used by Assimp)
	struct IfcElementarySurface;
	struct IfcCylindricalSurface;
	struct IfcDamper;
	struct IfcDamperType;
	struct IfcDerivedProfileDef;
	typedef NotImplemented IfcDerivedUnit; // (not currently used by Assimp)
	typedef NotImplemented IfcDerivedUnitElement; // (not currently used by Assimp)
	typedef NotImplemented IfcDimensionalExponents; // (not currently used by Assimp)
	struct IfcDirection;
	struct IfcDiscreteAccessory;
	struct IfcDiscreteAccessoryType;
	struct IfcDistributionChamberElement;
	struct IfcDistributionChamberElementType;
	struct IfcDistributionSystem;
	struct IfcDistributionCircuit;
	struct IfcPort;
	struct IfcDistributionPort;
	typedef NotImplemented IfcDocumentInformation; // (not currently used by Assimp)
	typedef NotImplemented IfcDocumentInformationRelationship; // (not currently used by Assimp)
	typedef NotImplemented IfcDocumentReference; // (not currently used by Assimp)
	struct IfcDoor;
	struct IfcPropertySetDefinition;
	typedef NotImplemented IfcPreDefinedPropertySet; // (not currently used by Assimp)
	typedef NotImplemented IfcDoorLiningProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcDoorPanelProperties; // (not currently used by Assimp)
	struct IfcDoorStandardCase;
	struct IfcDoorStyle;
	struct IfcDoorType;
	typedef NotImplemented IfcPreDefinedItem; // (not currently used by Assimp)
	typedef NotImplemented IfcPreDefinedColour; // (not currently used by Assimp)
	typedef NotImplemented IfcDraughtingPreDefinedColour; // (not currently used by Assimp)
	typedef NotImplemented IfcPreDefinedCurveFont; // (not currently used by Assimp)
	typedef NotImplemented IfcDraughtingPreDefinedCurveFont; // (not currently used by Assimp)
	struct IfcDuctFitting;
	struct IfcDuctFittingType;
	struct IfcDuctSegment;
	struct IfcDuctSegmentType;
	struct IfcFlowTreatmentDevice;
	struct IfcDuctSilencer;
	struct IfcFlowTreatmentDeviceType;
	struct IfcDuctSilencerType;
	struct IfcEdge;
	struct IfcEdgeCurve;
	struct IfcLoop;
	struct IfcEdgeLoop;
	struct IfcElectricAppliance;
	struct IfcElectricApplianceType;
	struct IfcElectricDistributionBoard;
	struct IfcElectricDistributionBoardType;
	struct IfcFlowStorageDevice;
	struct IfcElectricFlowStorageDevice;
	struct IfcFlowStorageDeviceType;
	struct IfcElectricFlowStorageDeviceType;
	struct IfcElectricGenerator;
	struct IfcElectricGeneratorType;
	struct IfcElectricMotor;
	struct IfcElectricMotorType;
	struct IfcElectricTimeControl;
	struct IfcElectricTimeControlType;
	struct IfcElementAssembly;
	struct IfcElementAssemblyType;
	struct IfcQuantitySet;
	struct IfcElementQuantity;
	struct IfcEllipse;
	struct IfcEllipseProfileDef;
	struct IfcEngine;
	struct IfcEngineType;
	struct IfcEvaporativeCooler;
	struct IfcEvaporativeCoolerType;
	struct IfcEvaporator;
	struct IfcEvaporatorType;
	struct IfcProcess;
	struct IfcEvent;
	typedef NotImplemented IfcSchedulingTime; // (not currently used by Assimp)
	typedef NotImplemented IfcEventTime; // (not currently used by Assimp)
	struct IfcTypeProcess;
	struct IfcEventType;
	typedef NotImplemented IfcExtendedProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcExternalReferenceRelationship; // (not currently used by Assimp)
	struct IfcExternalSpatialStructureElement;
	struct IfcExternalSpatialElement;
	typedef NotImplemented IfcExternallyDefinedHatchStyle; // (not currently used by Assimp)
	typedef NotImplemented IfcExternallyDefinedSurfaceStyle; // (not currently used by Assimp)
	typedef NotImplemented IfcExternallyDefinedTextFont; // (not currently used by Assimp)
	struct IfcSweptAreaSolid;
	struct IfcExtrudedAreaSolid;
	struct IfcExtrudedAreaSolidTapered;
	struct IfcFaceBasedSurfaceModel;
	struct IfcFaceBound;
	struct IfcFaceOuterBound;
	struct IfcFacetedBrep;
	struct IfcFacetedBrepWithVoids;
	typedef NotImplemented IfcStructuralConnectionCondition; // (not currently used by Assimp)
	typedef NotImplemented IfcFailureConnectionCondition; // (not currently used by Assimp)
	struct IfcFan;
	struct IfcFanType;
	struct IfcFastener;
	struct IfcFastenerType;
	struct IfcFeatureElement;
	struct IfcFeatureElementAddition;
	struct IfcFeatureElementSubtraction;
	typedef NotImplemented IfcFillAreaStyle; // (not currently used by Assimp)
	struct IfcFillAreaStyleHatching;
	struct IfcFillAreaStyleTiles;
	struct IfcFilter;
	struct IfcFilterType;
	struct IfcFireSuppressionTerminal;
	struct IfcFireSuppressionTerminalType;
	struct IfcFixedReferenceSweptAreaSolid;
	struct IfcFlowInstrument;
	struct IfcFlowInstrumentType;
	struct IfcFlowMeter;
	struct IfcFlowMeterType;
	struct IfcFooting;
	struct IfcFootingType;
	struct IfcFurnishingElement;
	struct IfcFurnishingElementType;
	struct IfcFurniture;
	struct IfcFurnitureType;
	struct IfcGeographicElement;
	struct IfcGeographicElementType;
	struct IfcGeometricSet;
	struct IfcGeometricCurveSet;
	struct IfcRepresentationContext;
	struct IfcGeometricRepresentationContext;
	struct IfcGeometricRepresentationSubContext;
	struct IfcGrid;
	typedef NotImplemented IfcGridAxis; // (not currently used by Assimp)
	struct IfcObjectPlacement;
	struct IfcGridPlacement;
	struct IfcHeatExchanger;
	struct IfcHeatExchangerType;
	struct IfcHumidifier;
	struct IfcHumidifierType;
	struct IfcIShapeProfileDef;
	typedef NotImplemented IfcImageTexture; // (not currently used by Assimp)
	typedef NotImplemented IfcIndexedColourMap; // (not currently used by Assimp)
	struct IfcIndexedPolyCurve;
	struct IfcTessellatedItem;
	struct IfcIndexedPolygonalFace;
	struct IfcIndexedPolygonalFaceWithVoids;
	typedef NotImplemented IfcTextureCoordinate; // (not currently used by Assimp)
	typedef NotImplemented IfcIndexedTextureMap; // (not currently used by Assimp)
	typedef NotImplemented IfcIndexedTriangleTextureMap; // (not currently used by Assimp)
	struct IfcInterceptor;
	struct IfcInterceptorType;
	struct IfcSurfaceCurve;
	struct IfcIntersectionCurve;
	struct IfcInventory;
	typedef NotImplemented IfcTimeSeries; // (not currently used by Assimp)
	typedef NotImplemented IfcIrregularTimeSeries; // (not currently used by Assimp)
	typedef NotImplemented IfcIrregularTimeSeriesValue; // (not currently used by Assimp)
	struct IfcJunctionBox;
	struct IfcJunctionBoxType;
	struct IfcLShapeProfileDef;
	struct IfcLaborResource;
	struct IfcLaborResourceType;
	typedef NotImplemented IfcLagTime; // (not currently used by Assimp)
	struct IfcLamp;
	struct IfcLampType;
	typedef NotImplemented IfcLibraryInformation; // (not currently used by Assimp)
	typedef NotImplemented IfcLibraryReference; // (not currently used by Assimp)
	typedef NotImplemented IfcLightDistributionData; // (not currently used by Assimp)
	struct IfcLightFixture;
	struct IfcLightFixtureType;
	typedef NotImplemented IfcLightIntensityDistribution; // (not currently used by Assimp)
	struct IfcLightSource;
	struct IfcLightSourceAmbient;
	struct IfcLightSourceDirectional;
	struct IfcLightSourceGoniometric;
	struct IfcLightSourcePositional;
	struct IfcLightSourceSpot;
	struct IfcLine;
	struct IfcLocalPlacement;
	typedef NotImplemented IfcMapConversion; // (not currently used by Assimp)
	struct IfcMappedItem;
	typedef NotImplemented IfcMaterialDefinition; // (not currently used by Assimp)
	typedef NotImplemented IfcMaterial; // (not currently used by Assimp)
	typedef NotImplemented IfcMaterialClassificationRelationship; // (not currently used by Assimp)
	typedef NotImplemented IfcMaterialConstituent; // (not currently used by Assimp)
	typedef NotImplemented IfcMaterialConstituentSet; // (not currently used by Assimp)
	struct IfcProductRepresentation;
	struct IfcMaterialDefinitionRepresentation;
	typedef NotImplemented IfcMaterialLayer; // (not currently used by Assimp)
	typedef NotImplemented IfcMaterialLayerSet; // (not currently used by Assimp)
	typedef NotImplemented IfcMaterialUsageDefinition; // (not currently used by Assimp)
	typedef NotImplemented IfcMaterialLayerSetUsage; // (not currently used by Assimp)
	typedef NotImplemented IfcMaterialLayerWithOffsets; // (not currently used by Assimp)
	typedef NotImplemented IfcMaterialList; // (not currently used by Assimp)
	typedef NotImplemented IfcMaterialProfile; // (not currently used by Assimp)
	typedef NotImplemented IfcMaterialProfileSet; // (not currently used by Assimp)
	typedef NotImplemented IfcMaterialProfileSetUsage; // (not currently used by Assimp)
	typedef NotImplemented IfcMaterialProfileSetUsageTapering; // (not currently used by Assimp)
	typedef NotImplemented IfcMaterialProfileWithOffsets; // (not currently used by Assimp)
	typedef NotImplemented IfcMaterialProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcMaterialRelationship; // (not currently used by Assimp)
	struct IfcMeasureWithUnit;
	struct IfcMechanicalFastener;
	struct IfcMechanicalFastenerType;
	struct IfcMedicalDevice;
	struct IfcMedicalDeviceType;
	struct IfcMember;
	struct IfcMemberStandardCase;
	struct IfcMemberType;
	typedef NotImplemented IfcMetric; // (not currently used by Assimp)
	struct IfcMirroredProfileDef;
	typedef NotImplemented IfcMonetaryUnit; // (not currently used by Assimp)
	struct IfcMotorConnection;
	struct IfcMotorConnectionType;
	typedef NotImplemented IfcObjective; // (not currently used by Assimp)
	struct IfcOccupant;
	struct IfcOffsetCurve2D;
	struct IfcOffsetCurve3D;
	struct IfcOpenShell;
	struct IfcOpeningElement;
	struct IfcOpeningStandardCase;
	typedef NotImplemented IfcOrganization; // (not currently used by Assimp)
	typedef NotImplemented IfcOrganizationRelationship; // (not currently used by Assimp)
	struct IfcOrientedEdge;
	struct IfcOuterBoundaryCurve;
	struct IfcOutlet;
	struct IfcOutletType;
	typedef NotImplemented IfcOwnerHistory; // (not currently used by Assimp)
	struct IfcPath;
	struct IfcPcurve;
	struct IfcPerformanceHistory;
	typedef NotImplemented IfcPermeableCoveringProperties; // (not currently used by Assimp)
	struct IfcPermit;
	typedef NotImplemented IfcPerson; // (not currently used by Assimp)
	typedef NotImplemented IfcPersonAndOrganization; // (not currently used by Assimp)
	typedef NotImplemented IfcPhysicalQuantity; // (not currently used by Assimp)
	typedef NotImplemented IfcPhysicalComplexQuantity; // (not currently used by Assimp)
	typedef NotImplemented IfcPhysicalSimpleQuantity; // (not currently used by Assimp)
	struct IfcPile;
	struct IfcPileType;
	struct IfcPipeFitting;
	struct IfcPipeFittingType;
	struct IfcPipeSegment;
	struct IfcPipeSegmentType;
	typedef NotImplemented IfcPixelTexture; // (not currently used by Assimp)
	struct IfcPlanarExtent;
	struct IfcPlanarBox;
	struct IfcPlane;
	struct IfcPlate;
	struct IfcPlateStandardCase;
	struct IfcPlateType;
	struct IfcPointOnCurve;
	struct IfcPointOnSurface;
	struct IfcPolyLoop;
	struct IfcPolygonalBoundedHalfSpace;
	struct IfcTessellatedFaceSet;
	struct IfcPolygonalFaceSet;
	struct IfcPolyline;
	typedef NotImplemented IfcPostalAddress; // (not currently used by Assimp)
	typedef NotImplemented IfcPreDefinedProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcPreDefinedTextFont; // (not currently used by Assimp)
	typedef NotImplemented IfcPresentationLayerAssignment; // (not currently used by Assimp)
	typedef NotImplemented IfcPresentationLayerWithStyle; // (not currently used by Assimp)
	struct IfcPresentationStyleAssignment;
	struct IfcProcedure;
	struct IfcProcedureType;
	struct IfcProductDefinitionShape;
	typedef NotImplemented IfcProfileProperties; // (not currently used by Assimp)
	struct IfcProject;
	struct IfcProjectLibrary;
	struct IfcProjectOrder;
	typedef NotImplemented IfcProjectedCRS; // (not currently used by Assimp)
	struct IfcProjectionElement;
	struct IfcSimpleProperty;
	struct IfcPropertyBoundedValue;
	typedef NotImplemented IfcPropertyDependencyRelationship; // (not currently used by Assimp)
	struct IfcPropertyEnumeratedValue;
	typedef NotImplemented IfcPropertyEnumeration; // (not currently used by Assimp)
	struct IfcPropertyListValue;
	struct IfcPropertyReferenceValue;
	struct IfcPropertySet;
	typedef NotImplemented IfcPropertySetTemplate; // (not currently used by Assimp)
	struct IfcPropertySingleValue;
	struct IfcPropertyTableValue;
	struct IfcProtectiveDevice;
	struct IfcProtectiveDeviceTrippingUnit;
	struct IfcProtectiveDeviceTrippingUnitType;
	struct IfcProtectiveDeviceType;
	struct IfcProxy;
	struct IfcPump;
	struct IfcPumpType;
	typedef NotImplemented IfcQuantityArea; // (not currently used by Assimp)
	typedef NotImplemented IfcQuantityCount; // (not currently used by Assimp)
	typedef NotImplemented IfcQuantityLength; // (not currently used by Assimp)
	typedef NotImplemented IfcQuantityTime; // (not currently used by Assimp)
	typedef NotImplemented IfcQuantityVolume; // (not currently used by Assimp)
	typedef NotImplemented IfcQuantityWeight; // (not currently used by Assimp)
	struct IfcRailing;
	struct IfcRailingType;
	struct IfcRamp;
	struct IfcRampFlight;
	struct IfcRampFlightType;
	struct IfcRampType;
	struct IfcRationalBSplineCurveWithKnots;
	struct IfcRationalBSplineSurfaceWithKnots;
	struct IfcRectangleProfileDef;
	struct IfcRectangleHollowProfileDef;
	struct IfcRectangularPyramid;
	struct IfcRectangularTrimmedSurface;
	typedef NotImplemented IfcRecurrencePattern; // (not currently used by Assimp)
	typedef NotImplemented IfcReference; // (not currently used by Assimp)
	typedef NotImplemented IfcRegularTimeSeries; // (not currently used by Assimp)
	typedef NotImplemented IfcReinforcementBarProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcReinforcementDefinitionProperties; // (not currently used by Assimp)
	struct IfcReinforcingElement;
	struct IfcReinforcingBar;
	struct IfcReinforcingElementType;
	struct IfcReinforcingBarType;
	struct IfcReinforcingMesh;
	struct IfcReinforcingMeshType;
	struct IfcRelationship;
	struct IfcRelDecomposes;
	struct IfcRelAggregates;
	typedef NotImplemented IfcRelAssigns; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssignsToActor; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssignsToControl; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssignsToGroup; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssignsToGroupByFactor; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssignsToProcess; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssignsToProduct; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssignsToResource; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssociates; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssociatesApproval; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssociatesClassification; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssociatesConstraint; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssociatesDocument; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssociatesLibrary; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssociatesMaterial; // (not currently used by Assimp)
	struct IfcRelConnects;
	typedef NotImplemented IfcRelConnectsElements; // (not currently used by Assimp)
	typedef NotImplemented IfcRelConnectsPathElements; // (not currently used by Assimp)
	typedef NotImplemented IfcRelConnectsPortToElement; // (not currently used by Assimp)
	typedef NotImplemented IfcRelConnectsPorts; // (not currently used by Assimp)
	typedef NotImplemented IfcRelConnectsStructuralActivity; // (not currently used by Assimp)
	typedef NotImplemented IfcRelConnectsStructuralMember; // (not currently used by Assimp)
	typedef NotImplemented IfcRelConnectsWithEccentricity; // (not currently used by Assimp)
	typedef NotImplemented IfcRelConnectsWithRealizingElements; // (not currently used by Assimp)
	struct IfcRelContainedInSpatialStructure;
	typedef NotImplemented IfcRelCoversBldgElements; // (not currently used by Assimp)
	typedef NotImplemented IfcRelCoversSpaces; // (not currently used by Assimp)
	typedef NotImplemented IfcRelDeclares; // (not currently used by Assimp)
	struct IfcRelDefines;
	typedef NotImplemented IfcRelDefinesByObject; // (not currently used by Assimp)
	struct IfcRelDefinesByProperties;
	typedef NotImplemented IfcRelDefinesByTemplate; // (not currently used by Assimp)
	typedef NotImplemented IfcRelDefinesByType; // (not currently used by Assimp)
	struct IfcRelFillsElement;
	typedef NotImplemented IfcRelFlowControlElements; // (not currently used by Assimp)
	typedef NotImplemented IfcRelInterferesElements; // (not currently used by Assimp)
	typedef NotImplemented IfcRelNests; // (not currently used by Assimp)
	typedef NotImplemented IfcRelProjectsElement; // (not currently used by Assimp)
	typedef NotImplemented IfcRelReferencedInSpatialStructure; // (not currently used by Assimp)
	typedef NotImplemented IfcRelSequence; // (not currently used by Assimp)
	typedef NotImplemented IfcRelServicesBuildings; // (not currently used by Assimp)
	typedef NotImplemented IfcRelSpaceBoundary; // (not currently used by Assimp)
	typedef NotImplemented IfcRelSpaceBoundary1stLevel; // (not currently used by Assimp)
	typedef NotImplemented IfcRelSpaceBoundary2ndLevel; // (not currently used by Assimp)
	struct IfcRelVoidsElement;
	struct IfcReparametrisedCompositeCurveSegment;
	struct IfcRepresentation;
	struct IfcRepresentationMap;
	typedef NotImplemented IfcResourceApprovalRelationship; // (not currently used by Assimp)
	typedef NotImplemented IfcResourceConstraintRelationship; // (not currently used by Assimp)
	typedef NotImplemented IfcResourceTime; // (not currently used by Assimp)
	struct IfcRevolvedAreaSolid;
	struct IfcRevolvedAreaSolidTapered;
	struct IfcRightCircularCone;
	struct IfcRightCircularCylinder;
	struct IfcRoof;
	struct IfcRoofType;
	struct IfcRoundedRectangleProfileDef;
	struct IfcSIUnit;
	struct IfcSanitaryTerminal;
	struct IfcSanitaryTerminalType;
	struct IfcSeamCurve;
	typedef NotImplemented IfcSectionProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcSectionReinforcementProperties; // (not currently used by Assimp)
	struct IfcSectionedSpine;
	struct IfcSensor;
	struct IfcSensorType;
	struct IfcShadingDevice;
	struct IfcShadingDeviceType;
	typedef NotImplemented IfcShapeAspect; // (not currently used by Assimp)
	struct IfcShapeModel;
	struct IfcShapeRepresentation;
	struct IfcShellBasedSurfaceModel;
	typedef NotImplemented IfcSimplePropertyTemplate; // (not currently used by Assimp)
	struct IfcSite;
	struct IfcSlab;
	struct IfcSlabElementedCase;
	struct IfcSlabStandardCase;
	struct IfcSlabType;
	typedef NotImplemented IfcSlippageConnectionCondition; // (not currently used by Assimp)
	struct IfcSolarDevice;
	struct IfcSolarDeviceType;
	struct IfcSpace;
	struct IfcSpaceHeater;
	struct IfcSpaceHeaterType;
	struct IfcSpatialElementType;
	struct IfcSpatialStructureElementType;
	struct IfcSpaceType;
	struct IfcSpatialZone;
	struct IfcSpatialZoneType;
	struct IfcSphere;
	struct IfcSphericalSurface;
	struct IfcStackTerminal;
	struct IfcStackTerminalType;
	struct IfcStair;
	struct IfcStairFlight;
	struct IfcStairFlightType;
	struct IfcStairType;
	struct IfcStructuralActivity;
	struct IfcStructuralAction;
	struct IfcStructuralAnalysisModel;
	struct IfcStructuralItem;
	struct IfcStructuralConnection;
	struct IfcStructuralCurveAction;
	struct IfcStructuralCurveConnection;
	struct IfcStructuralMember;
	struct IfcStructuralCurveMember;
	struct IfcStructuralCurveMemberVarying;
	struct IfcStructuralReaction;
	struct IfcStructuralCurveReaction;
	struct IfcStructuralLinearAction;
	typedef NotImplemented IfcStructuralLoad; // (not currently used by Assimp)
	struct IfcStructuralLoadGroup;
	struct IfcStructuralLoadCase;
	typedef NotImplemented IfcStructuralLoadConfiguration; // (not currently used by Assimp)
	typedef NotImplemented IfcStructuralLoadOrResult; // (not currently used by Assimp)
	typedef NotImplemented IfcStructuralLoadStatic; // (not currently used by Assimp)
	typedef NotImplemented IfcStructuralLoadLinearForce; // (not currently used by Assimp)
	typedef NotImplemented IfcStructuralLoadPlanarForce; // (not currently used by Assimp)
	typedef NotImplemented IfcStructuralLoadSingleDisplacement; // (not currently used by Assimp)
	typedef NotImplemented IfcStructuralLoadSingleDisplacementDistortion; // (not currently used by Assimp)
	typedef NotImplemented IfcStructuralLoadSingleForce; // (not currently used by Assimp)
	typedef NotImplemented IfcStructuralLoadSingleForceWarping; // (not currently used by Assimp)
	typedef NotImplemented IfcStructuralLoadTemperature; // (not currently used by Assimp)
	struct IfcStructuralSurfaceAction;
	struct IfcStructuralPlanarAction;
	struct IfcStructuralPointAction;
	struct IfcStructuralPointConnection;
	struct IfcStructuralPointReaction;
	struct IfcStructuralResultGroup;
	struct IfcStructuralSurfaceConnection;
	struct IfcStructuralSurfaceMember;
	struct IfcStructuralSurfaceMemberVarying;
	struct IfcStructuralSurfaceReaction;
	struct IfcStyleModel;
	struct IfcStyledItem;
	struct IfcStyledRepresentation;
	struct IfcSubContractResource;
	struct IfcSubContractResourceType;
	struct IfcSubedge;
	struct IfcSurfaceCurveSweptAreaSolid;
	struct IfcSurfaceFeature;
	struct IfcSweptSurface;
	struct IfcSurfaceOfLinearExtrusion;
	struct IfcSurfaceOfRevolution;
	typedef NotImplemented IfcSurfaceReinforcementArea; // (not currently used by Assimp)
	struct IfcSurfaceStyle;
	typedef NotImplemented IfcSurfaceStyleLighting; // (not currently used by Assimp)
	typedef NotImplemented IfcSurfaceStyleRefraction; // (not currently used by Assimp)
	struct IfcSurfaceStyleShading;
	struct IfcSurfaceStyleRendering;
	struct IfcSurfaceStyleWithTextures;
	struct IfcSweptDiskSolid;
	struct IfcSweptDiskSolidPolygonal;
	struct IfcSwitchingDevice;
	struct IfcSwitchingDeviceType;
	struct IfcSystemFurnitureElement;
	struct IfcSystemFurnitureElementType;
	struct IfcTShapeProfileDef;
	typedef NotImplemented IfcTable; // (not currently used by Assimp)
	typedef NotImplemented IfcTableColumn; // (not currently used by Assimp)
	typedef NotImplemented IfcTableRow; // (not currently used by Assimp)
	struct IfcTank;
	struct IfcTankType;
	struct IfcTask;
	typedef NotImplemented IfcTaskTime; // (not currently used by Assimp)
	typedef NotImplemented IfcTaskTimeRecurring; // (not currently used by Assimp)
	struct IfcTaskType;
	typedef NotImplemented IfcTelecomAddress; // (not currently used by Assimp)
	struct IfcTendon;
	struct IfcTendonAnchor;
	struct IfcTendonAnchorType;
	struct IfcTendonType;
	struct IfcTextLiteral;
	struct IfcTextLiteralWithExtent;
	typedef NotImplemented IfcTextStyle; // (not currently used by Assimp)
	typedef NotImplemented IfcTextStyleFontModel; // (not currently used by Assimp)
	typedef NotImplemented IfcTextStyleForDefinedFont; // (not currently used by Assimp)
	typedef NotImplemented IfcTextStyleTextModel; // (not currently used by Assimp)
	typedef NotImplemented IfcTextureCoordinateGenerator; // (not currently used by Assimp)
	typedef NotImplemented IfcTextureMap; // (not currently used by Assimp)
	typedef NotImplemented IfcTextureVertex; // (not currently used by Assimp)
	typedef NotImplemented IfcTextureVertexList; // (not currently used by Assimp)
	typedef NotImplemented IfcTimePeriod; // (not currently used by Assimp)
	typedef NotImplemented IfcTimeSeriesValue; // (not currently used by Assimp)
	struct IfcTopologyRepresentation;
	struct IfcToroidalSurface;
	struct IfcTransformer;
	struct IfcTransformerType;
	struct IfcTransportElement;
	struct IfcTransportElementType;
	struct IfcTrapeziumProfileDef;
	struct IfcTriangulatedFaceSet;
	struct IfcTrimmedCurve;
	struct IfcTubeBundle;
	struct IfcTubeBundleType;
	struct IfcUShapeProfileDef;
	struct IfcUnitAssignment;
	struct IfcUnitaryControlElement;
	struct IfcUnitaryControlElementType;
	struct IfcUnitaryEquipment;
	struct IfcUnitaryEquipmentType;
	struct IfcValve;
	struct IfcValveType;
	struct IfcVector;
	struct IfcVertex;
	struct IfcVertexLoop;
	struct IfcVertexPoint;
	struct IfcVibrationIsolator;
	struct IfcVibrationIsolatorType;
	struct IfcVirtualElement;
	typedef NotImplemented IfcVirtualGridIntersection; // (not currently used by Assimp)
	struct IfcVoidingFeature;
	struct IfcWall;
	struct IfcWallElementedCase;
	struct IfcWallStandardCase;
	struct IfcWallType;
	struct IfcWasteTerminal;
	struct IfcWasteTerminalType;
	struct IfcWindow;
	typedef NotImplemented IfcWindowLiningProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcWindowPanelProperties; // (not currently used by Assimp)
	struct IfcWindowStandardCase;
	struct IfcWindowStyle;
	struct IfcWindowType;
	struct IfcWorkCalendar;
	struct IfcWorkControl;
	struct IfcWorkPlan;
	struct IfcWorkSchedule;
	typedef NotImplemented IfcWorkTime; // (not currently used by Assimp)
	struct IfcZShapeProfileDef;
	struct IfcZone;



    // C++ wrapper for IfcRoot
    struct IfcRoot :  ObjectHelper<IfcRoot,4> { IfcRoot() : Object("IfcRoot") {}
		IfcGloballyUniqueId::Out GlobalId;
		Maybe< Lazy< NotImplemented > > OwnerHistory;
		Maybe< IfcLabel::Out > Name;
		Maybe< IfcText::Out > Description;
    };

    // C++ wrapper for IfcObjectDefinition
    struct IfcObjectDefinition : IfcRoot, ObjectHelper<IfcObjectDefinition,0> { IfcObjectDefinition() : Object("IfcObjectDefinition") {}

    };

    // C++ wrapper for IfcObject
    struct IfcObject : IfcObjectDefinition, ObjectHelper<IfcObject,1> { IfcObject() : Object("IfcObject") {}
		Maybe< IfcLabel::Out > ObjectType;
    };

    // C++ wrapper for IfcControl
    struct IfcControl : IfcObject, ObjectHelper<IfcControl,1> { IfcControl() : Object("IfcControl") {}
		Maybe< IfcIdentifier::Out > Identification;
    };

    // C++ wrapper for IfcActionRequest
    struct IfcActionRequest : IfcControl, ObjectHelper<IfcActionRequest,3> { IfcActionRequest() : Object("IfcActionRequest") {}
		Maybe< IfcActionRequestTypeEnum::Out > PredefinedType;
		Maybe< IfcLabel::Out > Status;
		Maybe< IfcText::Out > LongDescription;
    };

    // C++ wrapper for IfcActor
    struct IfcActor : IfcObject, ObjectHelper<IfcActor,1> { IfcActor() : Object("IfcActor") {}
		IfcActorSelect::Out TheActor;
    };

    // C++ wrapper for IfcProduct
    struct IfcProduct : IfcObject, ObjectHelper<IfcProduct,2> { IfcProduct() : Object("IfcProduct") {}
		Maybe< Lazy< IfcObjectPlacement > > ObjectPlacement;
		Maybe< Lazy< IfcProductRepresentation > > Representation;
    };

    // C++ wrapper for IfcElement
    struct IfcElement : IfcProduct, ObjectHelper<IfcElement,1> { IfcElement() : Object("IfcElement") {}
		Maybe< IfcIdentifier::Out > Tag;
    };

    // C++ wrapper for IfcDistributionElement
    struct IfcDistributionElement : IfcElement, ObjectHelper<IfcDistributionElement,0> { IfcDistributionElement() : Object("IfcDistributionElement") {}

    };

    // C++ wrapper for IfcDistributionControlElement
    struct IfcDistributionControlElement : IfcDistributionElement, ObjectHelper<IfcDistributionControlElement,0> { IfcDistributionControlElement() : Object("IfcDistributionControlElement") {}

    };

    // C++ wrapper for IfcActuator
    struct IfcActuator : IfcDistributionControlElement, ObjectHelper<IfcActuator,1> { IfcActuator() : Object("IfcActuator") {}
		Maybe< IfcActuatorTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcTypeObject
    struct IfcTypeObject : IfcObjectDefinition, ObjectHelper<IfcTypeObject,2> { IfcTypeObject() : Object("IfcTypeObject") {}
		Maybe< IfcIdentifier::Out > ApplicableOccurrence;
		Maybe< ListOf< Lazy< IfcPropertySetDefinition >, 1, 0 > > HasPropertySets;
    };

    // C++ wrapper for IfcTypeProduct
    struct IfcTypeProduct : IfcTypeObject, ObjectHelper<IfcTypeProduct,2> { IfcTypeProduct() : Object("IfcTypeProduct") {}
		Maybe< ListOf< Lazy< IfcRepresentationMap >, 1, 0 > > RepresentationMaps;
		Maybe< IfcLabel::Out > Tag;
    };

    // C++ wrapper for IfcElementType
    struct IfcElementType : IfcTypeProduct, ObjectHelper<IfcElementType,1> { IfcElementType() : Object("IfcElementType") {}
		Maybe< IfcLabel::Out > ElementType;
    };

    // C++ wrapper for IfcDistributionElementType
    struct IfcDistributionElementType : IfcElementType, ObjectHelper<IfcDistributionElementType,0> { IfcDistributionElementType() : Object("IfcDistributionElementType") {}

    };

    // C++ wrapper for IfcDistributionControlElementType
    struct IfcDistributionControlElementType : IfcDistributionElementType, ObjectHelper<IfcDistributionControlElementType,0> { IfcDistributionControlElementType() : Object("IfcDistributionControlElementType") {}

    };

    // C++ wrapper for IfcActuatorType
    struct IfcActuatorType : IfcDistributionControlElementType, ObjectHelper<IfcActuatorType,1> { IfcActuatorType() : Object("IfcActuatorType") {}
		IfcActuatorTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcRepresentationItem
    struct IfcRepresentationItem :  ObjectHelper<IfcRepresentationItem,0> { IfcRepresentationItem() : Object("IfcRepresentationItem") {}

    };

    // C++ wrapper for IfcGeometricRepresentationItem
    struct IfcGeometricRepresentationItem : IfcRepresentationItem, ObjectHelper<IfcGeometricRepresentationItem,0> { IfcGeometricRepresentationItem() : Object("IfcGeometricRepresentationItem") {}

    };

    // C++ wrapper for IfcSolidModel
    struct IfcSolidModel : IfcGeometricRepresentationItem, ObjectHelper<IfcSolidModel,0> { IfcSolidModel() : Object("IfcSolidModel") {}

    };

    // C++ wrapper for IfcManifoldSolidBrep
    struct IfcManifoldSolidBrep : IfcSolidModel, ObjectHelper<IfcManifoldSolidBrep,1> { IfcManifoldSolidBrep() : Object("IfcManifoldSolidBrep") {}
		Lazy< IfcClosedShell > Outer;
    };

    // C++ wrapper for IfcAdvancedBrep
    struct IfcAdvancedBrep : IfcManifoldSolidBrep, ObjectHelper<IfcAdvancedBrep,0> { IfcAdvancedBrep() : Object("IfcAdvancedBrep") {}

    };

    // C++ wrapper for IfcAdvancedBrepWithVoids
    struct IfcAdvancedBrepWithVoids : IfcAdvancedBrep, ObjectHelper<IfcAdvancedBrepWithVoids,1> { IfcAdvancedBrepWithVoids() : Object("IfcAdvancedBrepWithVoids") {}
		ListOf< Lazy< IfcClosedShell >, 1, 0 > Voids;
    };

    // C++ wrapper for IfcTopologicalRepresentationItem
    struct IfcTopologicalRepresentationItem : IfcRepresentationItem, ObjectHelper<IfcTopologicalRepresentationItem,0> { IfcTopologicalRepresentationItem() : Object("IfcTopologicalRepresentationItem") {}

    };

    // C++ wrapper for IfcFace
    struct IfcFace : IfcTopologicalRepresentationItem, ObjectHelper<IfcFace,1> { IfcFace() : Object("IfcFace") {}
		ListOf< Lazy< IfcFaceBound >, 1, 0 > Bounds;
    };

    // C++ wrapper for IfcFaceSurface
    struct IfcFaceSurface : IfcFace, ObjectHelper<IfcFaceSurface,2> { IfcFaceSurface() : Object("IfcFaceSurface") {}
		Lazy< IfcSurface > FaceSurface;
		IfcBoolean::Out SameSense;
    };

    // C++ wrapper for IfcAdvancedFace
    struct IfcAdvancedFace : IfcFaceSurface, ObjectHelper<IfcAdvancedFace,0> { IfcAdvancedFace() : Object("IfcAdvancedFace") {}

    };

    // C++ wrapper for IfcDistributionFlowElement
    struct IfcDistributionFlowElement : IfcDistributionElement, ObjectHelper<IfcDistributionFlowElement,0> { IfcDistributionFlowElement() : Object("IfcDistributionFlowElement") {}

    };

    // C++ wrapper for IfcFlowTerminal
    struct IfcFlowTerminal : IfcDistributionFlowElement, ObjectHelper<IfcFlowTerminal,0> { IfcFlowTerminal() : Object("IfcFlowTerminal") {}

    };

    // C++ wrapper for IfcAirTerminal
    struct IfcAirTerminal : IfcFlowTerminal, ObjectHelper<IfcAirTerminal,1> { IfcAirTerminal() : Object("IfcAirTerminal") {}
		Maybe< IfcAirTerminalTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcFlowController
    struct IfcFlowController : IfcDistributionFlowElement, ObjectHelper<IfcFlowController,0> { IfcFlowController() : Object("IfcFlowController") {}

    };

    // C++ wrapper for IfcAirTerminalBox
    struct IfcAirTerminalBox : IfcFlowController, ObjectHelper<IfcAirTerminalBox,1> { IfcAirTerminalBox() : Object("IfcAirTerminalBox") {}
		Maybe< IfcAirTerminalBoxTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcDistributionFlowElementType
    struct IfcDistributionFlowElementType : IfcDistributionElementType, ObjectHelper<IfcDistributionFlowElementType,0> { IfcDistributionFlowElementType() : Object("IfcDistributionFlowElementType") {}

    };

    // C++ wrapper for IfcFlowControllerType
    struct IfcFlowControllerType : IfcDistributionFlowElementType, ObjectHelper<IfcFlowControllerType,0> { IfcFlowControllerType() : Object("IfcFlowControllerType") {}

    };

    // C++ wrapper for IfcAirTerminalBoxType
    struct IfcAirTerminalBoxType : IfcFlowControllerType, ObjectHelper<IfcAirTerminalBoxType,1> { IfcAirTerminalBoxType() : Object("IfcAirTerminalBoxType") {}
		IfcAirTerminalBoxTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcFlowTerminalType
    struct IfcFlowTerminalType : IfcDistributionFlowElementType, ObjectHelper<IfcFlowTerminalType,0> { IfcFlowTerminalType() : Object("IfcFlowTerminalType") {}

    };

    // C++ wrapper for IfcAirTerminalType
    struct IfcAirTerminalType : IfcFlowTerminalType, ObjectHelper<IfcAirTerminalType,1> { IfcAirTerminalType() : Object("IfcAirTerminalType") {}
		IfcAirTerminalTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcEnergyConversionDevice
    struct IfcEnergyConversionDevice : IfcDistributionFlowElement, ObjectHelper<IfcEnergyConversionDevice,0> { IfcEnergyConversionDevice() : Object("IfcEnergyConversionDevice") {}

    };

    // C++ wrapper for IfcAirToAirHeatRecovery
    struct IfcAirToAirHeatRecovery : IfcEnergyConversionDevice, ObjectHelper<IfcAirToAirHeatRecovery,1> { IfcAirToAirHeatRecovery() : Object("IfcAirToAirHeatRecovery") {}
		Maybe< IfcAirToAirHeatRecoveryTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcEnergyConversionDeviceType
    struct IfcEnergyConversionDeviceType : IfcDistributionFlowElementType, ObjectHelper<IfcEnergyConversionDeviceType,0> { IfcEnergyConversionDeviceType() : Object("IfcEnergyConversionDeviceType") {}

    };

    // C++ wrapper for IfcAirToAirHeatRecoveryType
    struct IfcAirToAirHeatRecoveryType : IfcEnergyConversionDeviceType, ObjectHelper<IfcAirToAirHeatRecoveryType,1> { IfcAirToAirHeatRecoveryType() : Object("IfcAirToAirHeatRecoveryType") {}
		IfcAirToAirHeatRecoveryTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcAlarm
    struct IfcAlarm : IfcDistributionControlElement, ObjectHelper<IfcAlarm,1> { IfcAlarm() : Object("IfcAlarm") {}
		Maybe< IfcAlarmTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcAlarmType
    struct IfcAlarmType : IfcDistributionControlElementType, ObjectHelper<IfcAlarmType,1> { IfcAlarmType() : Object("IfcAlarmType") {}
		IfcAlarmTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcAnnotation
    struct IfcAnnotation : IfcProduct, ObjectHelper<IfcAnnotation,0> { IfcAnnotation() : Object("IfcAnnotation") {}

    };

    // C++ wrapper for IfcAnnotationFillArea
    struct IfcAnnotationFillArea : IfcGeometricRepresentationItem, ObjectHelper<IfcAnnotationFillArea,2> { IfcAnnotationFillArea() : Object("IfcAnnotationFillArea") {}
		Lazy< IfcCurve > OuterBoundary;
		Maybe< ListOf< Lazy< IfcCurve >, 1, 0 > > InnerBoundaries;
    };

    // C++ wrapper for IfcProfileDef
    struct IfcProfileDef :  ObjectHelper<IfcProfileDef,2> { IfcProfileDef() : Object("IfcProfileDef") {}
		IfcProfileTypeEnum::Out ProfileType;
		Maybe< IfcLabel::Out > ProfileName;
    };

    // C++ wrapper for IfcArbitraryClosedProfileDef
    struct IfcArbitraryClosedProfileDef : IfcProfileDef, ObjectHelper<IfcArbitraryClosedProfileDef,1> { IfcArbitraryClosedProfileDef() : Object("IfcArbitraryClosedProfileDef") {}
		Lazy< IfcCurve > OuterCurve;
    };

    // C++ wrapper for IfcArbitraryOpenProfileDef
    struct IfcArbitraryOpenProfileDef : IfcProfileDef, ObjectHelper<IfcArbitraryOpenProfileDef,1> { IfcArbitraryOpenProfileDef() : Object("IfcArbitraryOpenProfileDef") {}
		Lazy< IfcBoundedCurve > Curve;
    };

    // C++ wrapper for IfcArbitraryProfileDefWithVoids
    struct IfcArbitraryProfileDefWithVoids : IfcArbitraryClosedProfileDef, ObjectHelper<IfcArbitraryProfileDefWithVoids,1> { IfcArbitraryProfileDefWithVoids() : Object("IfcArbitraryProfileDefWithVoids") {}
		ListOf< Lazy< IfcCurve >, 1, 0 > InnerCurves;
    };

    // C++ wrapper for IfcGroup
    struct IfcGroup : IfcObject, ObjectHelper<IfcGroup,0> { IfcGroup() : Object("IfcGroup") {}

    };

    // C++ wrapper for IfcAsset
    struct IfcAsset : IfcGroup, ObjectHelper<IfcAsset,9> { IfcAsset() : Object("IfcAsset") {}
		Maybe< IfcIdentifier::Out > Identification;
		Maybe< Lazy< NotImplemented > > OriginalValue;
		Maybe< Lazy< NotImplemented > > CurrentValue;
		Maybe< Lazy< NotImplemented > > TotalReplacementCost;
		Maybe< IfcActorSelect::Out > Owner;
		Maybe< IfcActorSelect::Out > User;
		Maybe< Lazy< NotImplemented > > ResponsiblePerson;
		Maybe< IfcDate::Out > IncorporationDate;
		Maybe< Lazy< NotImplemented > > DepreciatedValue;
    };

    // C++ wrapper for IfcParameterizedProfileDef
    struct IfcParameterizedProfileDef : IfcProfileDef, ObjectHelper<IfcParameterizedProfileDef,1> { IfcParameterizedProfileDef() : Object("IfcParameterizedProfileDef") {}
		Maybe< Lazy< IfcAxis2Placement2D > > Position;
    };

    // C++ wrapper for IfcAsymmetricIShapeProfileDef
    struct IfcAsymmetricIShapeProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcAsymmetricIShapeProfileDef,12> { IfcAsymmetricIShapeProfileDef() : Object("IfcAsymmetricIShapeProfileDef") {}
		IfcPositiveLengthMeasure::Out BottomFlangeWidth;
		IfcPositiveLengthMeasure::Out OverallDepth;
		IfcPositiveLengthMeasure::Out WebThickness;
		IfcPositiveLengthMeasure::Out BottomFlangeThickness;
		Maybe< IfcNonNegativeLengthMeasure::Out > BottomFlangeFilletRadius;
		IfcPositiveLengthMeasure::Out TopFlangeWidth;
		Maybe< IfcPositiveLengthMeasure::Out > TopFlangeThickness;
		Maybe< IfcNonNegativeLengthMeasure::Out > TopFlangeFilletRadius;
		Maybe< IfcNonNegativeLengthMeasure::Out > BottomFlangeEdgeRadius;
		Maybe< IfcPlaneAngleMeasure::Out > BottomFlangeSlope;
		Maybe< IfcNonNegativeLengthMeasure::Out > TopFlangeEdgeRadius;
		Maybe< IfcPlaneAngleMeasure::Out > TopFlangeSlope;
    };

    // C++ wrapper for IfcAudioVisualAppliance
    struct IfcAudioVisualAppliance : IfcFlowTerminal, ObjectHelper<IfcAudioVisualAppliance,1> { IfcAudioVisualAppliance() : Object("IfcAudioVisualAppliance") {}
		Maybe< IfcAudioVisualApplianceTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcAudioVisualApplianceType
    struct IfcAudioVisualApplianceType : IfcFlowTerminalType, ObjectHelper<IfcAudioVisualApplianceType,1> { IfcAudioVisualApplianceType() : Object("IfcAudioVisualApplianceType") {}
		IfcAudioVisualApplianceTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcPlacement
    struct IfcPlacement : IfcGeometricRepresentationItem, ObjectHelper<IfcPlacement,1> { IfcPlacement() : Object("IfcPlacement") {}
		Lazy< IfcCartesianPoint > Location;
    };

    // C++ wrapper for IfcAxis1Placement
    struct IfcAxis1Placement : IfcPlacement, ObjectHelper<IfcAxis1Placement,1> { IfcAxis1Placement() : Object("IfcAxis1Placement") {}
		Maybe< Lazy< IfcDirection > > Axis;
    };

    // C++ wrapper for IfcAxis2Placement2D
    struct IfcAxis2Placement2D : IfcPlacement, ObjectHelper<IfcAxis2Placement2D,1> { IfcAxis2Placement2D() : Object("IfcAxis2Placement2D") {}
		Maybe< Lazy< IfcDirection > > RefDirection;
    };

    // C++ wrapper for IfcAxis2Placement3D
    struct IfcAxis2Placement3D : IfcPlacement, ObjectHelper<IfcAxis2Placement3D,2> { IfcAxis2Placement3D() : Object("IfcAxis2Placement3D") {}
		Maybe< Lazy< IfcDirection > > Axis;
		Maybe< Lazy< IfcDirection > > RefDirection;
    };

    // C++ wrapper for IfcCurve
    struct IfcCurve : IfcGeometricRepresentationItem, ObjectHelper<IfcCurve,0> { IfcCurve() : Object("IfcCurve") {}

    };

    // C++ wrapper for IfcBoundedCurve
    struct IfcBoundedCurve : IfcCurve, ObjectHelper<IfcBoundedCurve,0> { IfcBoundedCurve() : Object("IfcBoundedCurve") {}

    };

    // C++ wrapper for IfcBSplineCurve
    struct IfcBSplineCurve : IfcBoundedCurve, ObjectHelper<IfcBSplineCurve,5> { IfcBSplineCurve() : Object("IfcBSplineCurve") {}
		IfcInteger::Out Degree;
		ListOf< Lazy< IfcCartesianPoint >, 2, 0 > ControlPointsList;
		IfcBSplineCurveForm::Out CurveForm;
		IfcLogical::Out ClosedCurve;
		IfcLogical::Out SelfIntersect;
    };

    // C++ wrapper for IfcBSplineCurveWithKnots
    struct IfcBSplineCurveWithKnots : IfcBSplineCurve, ObjectHelper<IfcBSplineCurveWithKnots,3> { IfcBSplineCurveWithKnots() : Object("IfcBSplineCurveWithKnots") {}
		ListOf< IfcInteger, 2, 0 >::Out KnotMultiplicities;
		ListOf< IfcParameterValue, 2, 0 >::Out Knots;
		IfcKnotType::Out KnotSpec;
    };

    // C++ wrapper for IfcSurface
    struct IfcSurface : IfcGeometricRepresentationItem, ObjectHelper<IfcSurface,0> { IfcSurface() : Object("IfcSurface") {}

    };

    // C++ wrapper for IfcBoundedSurface
    struct IfcBoundedSurface : IfcSurface, ObjectHelper<IfcBoundedSurface,0> { IfcBoundedSurface() : Object("IfcBoundedSurface") {}

    };

    // C++ wrapper for IfcBSplineSurface
    struct IfcBSplineSurface : IfcBoundedSurface, ObjectHelper<IfcBSplineSurface,6> { IfcBSplineSurface() : Object("IfcBSplineSurface") {}
		IfcInteger::Out UDegree;
		IfcInteger::Out VDegree;
		IfcBSplineSurfaceForm::Out SurfaceForm;
		IfcLogical::Out UClosed;
		IfcLogical::Out VClosed;
		IfcLogical::Out SelfIntersect;
    };

    // C++ wrapper for IfcBSplineSurfaceWithKnots
    struct IfcBSplineSurfaceWithKnots : IfcBSplineSurface, ObjectHelper<IfcBSplineSurfaceWithKnots,5> { IfcBSplineSurfaceWithKnots() : Object("IfcBSplineSurfaceWithKnots") {}
		ListOf< IfcInteger, 2, 0 >::Out UMultiplicities;
		ListOf< IfcInteger, 2, 0 >::Out VMultiplicities;
		ListOf< IfcParameterValue, 2, 0 >::Out UKnots;
		ListOf< IfcParameterValue, 2, 0 >::Out VKnots;
		IfcKnotType::Out KnotSpec;
    };

    // C++ wrapper for IfcBuildingElement
    struct IfcBuildingElement : IfcElement, ObjectHelper<IfcBuildingElement,0> { IfcBuildingElement() : Object("IfcBuildingElement") {}

    };

    // C++ wrapper for IfcBeam
    struct IfcBeam : IfcBuildingElement, ObjectHelper<IfcBeam,1> { IfcBeam() : Object("IfcBeam") {}
		Maybe< IfcBeamTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcBeamStandardCase
    struct IfcBeamStandardCase : IfcBeam, ObjectHelper<IfcBeamStandardCase,0> { IfcBeamStandardCase() : Object("IfcBeamStandardCase") {}

    };

    // C++ wrapper for IfcBuildingElementType
    struct IfcBuildingElementType : IfcElementType, ObjectHelper<IfcBuildingElementType,0> { IfcBuildingElementType() : Object("IfcBuildingElementType") {}

    };

    // C++ wrapper for IfcBeamType
    struct IfcBeamType : IfcBuildingElementType, ObjectHelper<IfcBeamType,1> { IfcBeamType() : Object("IfcBeamType") {}
		IfcBeamTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcPresentationItem
    struct IfcPresentationItem :  ObjectHelper<IfcPresentationItem,0> { IfcPresentationItem() : Object("IfcPresentationItem") {}

    };

    // C++ wrapper for IfcCsgPrimitive3D
    struct IfcCsgPrimitive3D : IfcGeometricRepresentationItem, ObjectHelper<IfcCsgPrimitive3D,1> { IfcCsgPrimitive3D() : Object("IfcCsgPrimitive3D") {}
		Lazy< IfcAxis2Placement3D > Position;
    };

    // C++ wrapper for IfcBlock
    struct IfcBlock : IfcCsgPrimitive3D, ObjectHelper<IfcBlock,3> { IfcBlock() : Object("IfcBlock") {}
		IfcPositiveLengthMeasure::Out XLength;
		IfcPositiveLengthMeasure::Out YLength;
		IfcPositiveLengthMeasure::Out ZLength;
    };

    // C++ wrapper for IfcBoiler
    struct IfcBoiler : IfcEnergyConversionDevice, ObjectHelper<IfcBoiler,1> { IfcBoiler() : Object("IfcBoiler") {}
		Maybe< IfcBoilerTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcBoilerType
    struct IfcBoilerType : IfcEnergyConversionDeviceType, ObjectHelper<IfcBoilerType,1> { IfcBoilerType() : Object("IfcBoilerType") {}
		IfcBoilerTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcBooleanResult
    struct IfcBooleanResult : IfcGeometricRepresentationItem, ObjectHelper<IfcBooleanResult,3> { IfcBooleanResult() : Object("IfcBooleanResult") {}
		IfcBooleanOperator::Out Operator;
		IfcBooleanOperand::Out FirstOperand;
		IfcBooleanOperand::Out SecondOperand;
    };

    // C++ wrapper for IfcBooleanClippingResult
    struct IfcBooleanClippingResult : IfcBooleanResult, ObjectHelper<IfcBooleanClippingResult,0> { IfcBooleanClippingResult() : Object("IfcBooleanClippingResult") {}

    };

    // C++ wrapper for IfcCompositeCurve
    struct IfcCompositeCurve : IfcBoundedCurve, ObjectHelper<IfcCompositeCurve,2> { IfcCompositeCurve() : Object("IfcCompositeCurve") {}
		ListOf< Lazy< IfcCompositeCurveSegment >, 1, 0 > Segments;
		IfcLogical::Out SelfIntersect;
    };

    // C++ wrapper for IfcCompositeCurveOnSurface
    struct IfcCompositeCurveOnSurface : IfcCompositeCurve, ObjectHelper<IfcCompositeCurveOnSurface,0> { IfcCompositeCurveOnSurface() : Object("IfcCompositeCurveOnSurface") {}

    };

    // C++ wrapper for IfcBoundaryCurve
    struct IfcBoundaryCurve : IfcCompositeCurveOnSurface, ObjectHelper<IfcBoundaryCurve,0> { IfcBoundaryCurve() : Object("IfcBoundaryCurve") {}

    };

    // C++ wrapper for IfcBoundingBox
    struct IfcBoundingBox : IfcGeometricRepresentationItem, ObjectHelper<IfcBoundingBox,4> { IfcBoundingBox() : Object("IfcBoundingBox") {}
		Lazy< IfcCartesianPoint > Corner;
		IfcPositiveLengthMeasure::Out XDim;
		IfcPositiveLengthMeasure::Out YDim;
		IfcPositiveLengthMeasure::Out ZDim;
    };

    // C++ wrapper for IfcHalfSpaceSolid
    struct IfcHalfSpaceSolid : IfcGeometricRepresentationItem, ObjectHelper<IfcHalfSpaceSolid,2> { IfcHalfSpaceSolid() : Object("IfcHalfSpaceSolid") {}
		Lazy< IfcSurface > BaseSurface;
		IfcBoolean::Out AgreementFlag;
    };

    // C++ wrapper for IfcBoxedHalfSpace
    struct IfcBoxedHalfSpace : IfcHalfSpaceSolid, ObjectHelper<IfcBoxedHalfSpace,1> { IfcBoxedHalfSpace() : Object("IfcBoxedHalfSpace") {}
		Lazy< IfcBoundingBox > Enclosure;
    };

    // C++ wrapper for IfcSpatialElement
    struct IfcSpatialElement : IfcProduct, ObjectHelper<IfcSpatialElement,1> { IfcSpatialElement() : Object("IfcSpatialElement") {}
		Maybe< IfcLabel::Out > LongName;
    };

    // C++ wrapper for IfcSpatialStructureElement
    struct IfcSpatialStructureElement : IfcSpatialElement, ObjectHelper<IfcSpatialStructureElement,1> { IfcSpatialStructureElement() : Object("IfcSpatialStructureElement") {}
		Maybe< IfcElementCompositionEnum::Out > CompositionType;
    };

    // C++ wrapper for IfcBuilding
    struct IfcBuilding : IfcSpatialStructureElement, ObjectHelper<IfcBuilding,3> { IfcBuilding() : Object("IfcBuilding") {}
		Maybe< IfcLengthMeasure::Out > ElevationOfRefHeight;
		Maybe< IfcLengthMeasure::Out > ElevationOfTerrain;
		Maybe< Lazy< NotImplemented > > BuildingAddress;
    };

    // C++ wrapper for IfcElementComponent
    struct IfcElementComponent : IfcElement, ObjectHelper<IfcElementComponent,0> { IfcElementComponent() : Object("IfcElementComponent") {}

    };

    // C++ wrapper for IfcBuildingElementPart
    struct IfcBuildingElementPart : IfcElementComponent, ObjectHelper<IfcBuildingElementPart,1> { IfcBuildingElementPart() : Object("IfcBuildingElementPart") {}
		Maybe< IfcBuildingElementPartTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcElementComponentType
    struct IfcElementComponentType : IfcElementType, ObjectHelper<IfcElementComponentType,0> { IfcElementComponentType() : Object("IfcElementComponentType") {}

    };

    // C++ wrapper for IfcBuildingElementPartType
    struct IfcBuildingElementPartType : IfcElementComponentType, ObjectHelper<IfcBuildingElementPartType,1> { IfcBuildingElementPartType() : Object("IfcBuildingElementPartType") {}
		IfcBuildingElementPartTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcBuildingElementProxy
    struct IfcBuildingElementProxy : IfcBuildingElement, ObjectHelper<IfcBuildingElementProxy,1> { IfcBuildingElementProxy() : Object("IfcBuildingElementProxy") {}
		Maybe< IfcBuildingElementProxyTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcBuildingElementProxyType
    struct IfcBuildingElementProxyType : IfcBuildingElementType, ObjectHelper<IfcBuildingElementProxyType,1> { IfcBuildingElementProxyType() : Object("IfcBuildingElementProxyType") {}
		IfcBuildingElementProxyTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcBuildingStorey
    struct IfcBuildingStorey : IfcSpatialStructureElement, ObjectHelper<IfcBuildingStorey,1> { IfcBuildingStorey() : Object("IfcBuildingStorey") {}
		Maybe< IfcLengthMeasure::Out > Elevation;
    };

    // C++ wrapper for IfcSystem
    struct IfcSystem : IfcGroup, ObjectHelper<IfcSystem,0> { IfcSystem() : Object("IfcSystem") {}

    };

    // C++ wrapper for IfcBuildingSystem
    struct IfcBuildingSystem : IfcSystem, ObjectHelper<IfcBuildingSystem,2> { IfcBuildingSystem() : Object("IfcBuildingSystem") {}
		Maybe< IfcBuildingSystemTypeEnum::Out > PredefinedType;
		Maybe< IfcLabel::Out > LongName;
    };

    // C++ wrapper for IfcBurner
    struct IfcBurner : IfcEnergyConversionDevice, ObjectHelper<IfcBurner,1> { IfcBurner() : Object("IfcBurner") {}
		Maybe< IfcBurnerTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcBurnerType
    struct IfcBurnerType : IfcEnergyConversionDeviceType, ObjectHelper<IfcBurnerType,1> { IfcBurnerType() : Object("IfcBurnerType") {}
		IfcBurnerTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcCShapeProfileDef
    struct IfcCShapeProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcCShapeProfileDef,5> { IfcCShapeProfileDef() : Object("IfcCShapeProfileDef") {}
		IfcPositiveLengthMeasure::Out Depth;
		IfcPositiveLengthMeasure::Out Width;
		IfcPositiveLengthMeasure::Out WallThickness;
		IfcPositiveLengthMeasure::Out Girth;
		Maybe< IfcNonNegativeLengthMeasure::Out > InternalFilletRadius;
    };

    // C++ wrapper for IfcFlowFitting
    struct IfcFlowFitting : IfcDistributionFlowElement, ObjectHelper<IfcFlowFitting,0> { IfcFlowFitting() : Object("IfcFlowFitting") {}

    };

    // C++ wrapper for IfcCableCarrierFitting
    struct IfcCableCarrierFitting : IfcFlowFitting, ObjectHelper<IfcCableCarrierFitting,1> { IfcCableCarrierFitting() : Object("IfcCableCarrierFitting") {}
		Maybe< IfcCableCarrierFittingTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcFlowFittingType
    struct IfcFlowFittingType : IfcDistributionFlowElementType, ObjectHelper<IfcFlowFittingType,0> { IfcFlowFittingType() : Object("IfcFlowFittingType") {}

    };

    // C++ wrapper for IfcCableCarrierFittingType
    struct IfcCableCarrierFittingType : IfcFlowFittingType, ObjectHelper<IfcCableCarrierFittingType,1> { IfcCableCarrierFittingType() : Object("IfcCableCarrierFittingType") {}
		IfcCableCarrierFittingTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcFlowSegment
    struct IfcFlowSegment : IfcDistributionFlowElement, ObjectHelper<IfcFlowSegment,0> { IfcFlowSegment() : Object("IfcFlowSegment") {}

    };

    // C++ wrapper for IfcCableCarrierSegment
    struct IfcCableCarrierSegment : IfcFlowSegment, ObjectHelper<IfcCableCarrierSegment,1> { IfcCableCarrierSegment() : Object("IfcCableCarrierSegment") {}
		Maybe< IfcCableCarrierSegmentTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcFlowSegmentType
    struct IfcFlowSegmentType : IfcDistributionFlowElementType, ObjectHelper<IfcFlowSegmentType,0> { IfcFlowSegmentType() : Object("IfcFlowSegmentType") {}

    };

    // C++ wrapper for IfcCableCarrierSegmentType
    struct IfcCableCarrierSegmentType : IfcFlowSegmentType, ObjectHelper<IfcCableCarrierSegmentType,1> { IfcCableCarrierSegmentType() : Object("IfcCableCarrierSegmentType") {}
		IfcCableCarrierSegmentTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcCableFitting
    struct IfcCableFitting : IfcFlowFitting, ObjectHelper<IfcCableFitting,1> { IfcCableFitting() : Object("IfcCableFitting") {}
		Maybe< IfcCableFittingTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcCableFittingType
    struct IfcCableFittingType : IfcFlowFittingType, ObjectHelper<IfcCableFittingType,1> { IfcCableFittingType() : Object("IfcCableFittingType") {}
		IfcCableFittingTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcCableSegment
    struct IfcCableSegment : IfcFlowSegment, ObjectHelper<IfcCableSegment,1> { IfcCableSegment() : Object("IfcCableSegment") {}
		Maybe< IfcCableSegmentTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcCableSegmentType
    struct IfcCableSegmentType : IfcFlowSegmentType, ObjectHelper<IfcCableSegmentType,1> { IfcCableSegmentType() : Object("IfcCableSegmentType") {}
		IfcCableSegmentTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcPoint
    struct IfcPoint : IfcGeometricRepresentationItem, ObjectHelper<IfcPoint,0> { IfcPoint() : Object("IfcPoint") {}

    };

    // C++ wrapper for IfcCartesianPoint
    struct IfcCartesianPoint : IfcPoint, ObjectHelper<IfcCartesianPoint,1> { IfcCartesianPoint() : Object("IfcCartesianPoint") {}
		ListOf< IfcLengthMeasure, 1, 3 >::Out Coordinates;
    };

    // C++ wrapper for IfcCartesianPointList
    struct IfcCartesianPointList : IfcGeometricRepresentationItem, ObjectHelper<IfcCartesianPointList,0> { IfcCartesianPointList() : Object("IfcCartesianPointList") {}

    };

    // C++ wrapper for IfcCartesianPointList2D
    struct IfcCartesianPointList2D : IfcCartesianPointList, ObjectHelper<IfcCartesianPointList2D,0> { IfcCartesianPointList2D() : Object("IfcCartesianPointList2D") {}

    };

    // C++ wrapper for IfcCartesianPointList3D
    struct IfcCartesianPointList3D : IfcCartesianPointList, ObjectHelper<IfcCartesianPointList3D,0> { IfcCartesianPointList3D() : Object("IfcCartesianPointList3D") {}

    };

    // C++ wrapper for IfcCartesianTransformationOperator
    struct IfcCartesianTransformationOperator : IfcGeometricRepresentationItem, ObjectHelper<IfcCartesianTransformationOperator,4> { IfcCartesianTransformationOperator() : Object("IfcCartesianTransformationOperator") {}
		Maybe< Lazy< IfcDirection > > Axis1;
		Maybe< Lazy< IfcDirection > > Axis2;
		Lazy< IfcCartesianPoint > LocalOrigin;
		Maybe< IfcReal::Out > Scale;
    };

    // C++ wrapper for IfcCartesianTransformationOperator2D
    struct IfcCartesianTransformationOperator2D : IfcCartesianTransformationOperator, ObjectHelper<IfcCartesianTransformationOperator2D,0> { IfcCartesianTransformationOperator2D() : Object("IfcCartesianTransformationOperator2D") {}

    };

    // C++ wrapper for IfcCartesianTransformationOperator2DnonUniform
    struct IfcCartesianTransformationOperator2DnonUniform : IfcCartesianTransformationOperator2D, ObjectHelper<IfcCartesianTransformationOperator2DnonUniform,1> { IfcCartesianTransformationOperator2DnonUniform() : Object("IfcCartesianTransformationOperator2DnonUniform") {}
		Maybe< IfcReal::Out > Scale2;
    };

    // C++ wrapper for IfcCartesianTransformationOperator3D
    struct IfcCartesianTransformationOperator3D : IfcCartesianTransformationOperator, ObjectHelper<IfcCartesianTransformationOperator3D,1> { IfcCartesianTransformationOperator3D() : Object("IfcCartesianTransformationOperator3D") {}
		Maybe< Lazy< IfcDirection > > Axis3;
    };

    // C++ wrapper for IfcCartesianTransformationOperator3DnonUniform
    struct IfcCartesianTransformationOperator3DnonUniform : IfcCartesianTransformationOperator3D, ObjectHelper<IfcCartesianTransformationOperator3DnonUniform,2> { IfcCartesianTransformationOperator3DnonUniform() : Object("IfcCartesianTransformationOperator3DnonUniform") {}
		Maybe< IfcReal::Out > Scale2;
		Maybe< IfcReal::Out > Scale3;
    };

    // C++ wrapper for IfcCenterLineProfileDef
    struct IfcCenterLineProfileDef : IfcArbitraryOpenProfileDef, ObjectHelper<IfcCenterLineProfileDef,1> { IfcCenterLineProfileDef() : Object("IfcCenterLineProfileDef") {}
		IfcPositiveLengthMeasure::Out Thickness;
    };

    // C++ wrapper for IfcChiller
    struct IfcChiller : IfcEnergyConversionDevice, ObjectHelper<IfcChiller,1> { IfcChiller() : Object("IfcChiller") {}
		Maybe< IfcChillerTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcChillerType
    struct IfcChillerType : IfcEnergyConversionDeviceType, ObjectHelper<IfcChillerType,1> { IfcChillerType() : Object("IfcChillerType") {}
		IfcChillerTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcChimney
    struct IfcChimney : IfcBuildingElement, ObjectHelper<IfcChimney,1> { IfcChimney() : Object("IfcChimney") {}
		Maybe< IfcChimneyTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcChimneyType
    struct IfcChimneyType : IfcBuildingElementType, ObjectHelper<IfcChimneyType,1> { IfcChimneyType() : Object("IfcChimneyType") {}
		IfcChimneyTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcConic
    struct IfcConic : IfcCurve, ObjectHelper<IfcConic,1> { IfcConic() : Object("IfcConic") {}
		IfcAxis2Placement::Out Position;
    };

    // C++ wrapper for IfcCircle
    struct IfcCircle : IfcConic, ObjectHelper<IfcCircle,1> { IfcCircle() : Object("IfcCircle") {}
		IfcPositiveLengthMeasure::Out Radius;
    };

    // C++ wrapper for IfcCircleProfileDef
    struct IfcCircleProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcCircleProfileDef,1> { IfcCircleProfileDef() : Object("IfcCircleProfileDef") {}
		IfcPositiveLengthMeasure::Out Radius;
    };

    // C++ wrapper for IfcCircleHollowProfileDef
    struct IfcCircleHollowProfileDef : IfcCircleProfileDef, ObjectHelper<IfcCircleHollowProfileDef,1> { IfcCircleHollowProfileDef() : Object("IfcCircleHollowProfileDef") {}
		IfcPositiveLengthMeasure::Out WallThickness;
    };

    // C++ wrapper for IfcCivilElement
    struct IfcCivilElement : IfcElement, ObjectHelper<IfcCivilElement,0> { IfcCivilElement() : Object("IfcCivilElement") {}

    };

    // C++ wrapper for IfcCivilElementType
    struct IfcCivilElementType : IfcElementType, ObjectHelper<IfcCivilElementType,0> { IfcCivilElementType() : Object("IfcCivilElementType") {}

    };

    // C++ wrapper for IfcConnectedFaceSet
    struct IfcConnectedFaceSet : IfcTopologicalRepresentationItem, ObjectHelper<IfcConnectedFaceSet,1> { IfcConnectedFaceSet() : Object("IfcConnectedFaceSet") {}
		ListOf< Lazy< IfcFace >, 1, 0 > CfsFaces;
    };

    // C++ wrapper for IfcClosedShell
    struct IfcClosedShell : IfcConnectedFaceSet, ObjectHelper<IfcClosedShell,0> { IfcClosedShell() : Object("IfcClosedShell") {}

    };

    // C++ wrapper for IfcCoil
    struct IfcCoil : IfcEnergyConversionDevice, ObjectHelper<IfcCoil,1> { IfcCoil() : Object("IfcCoil") {}
		Maybe< IfcCoilTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcCoilType
    struct IfcCoilType : IfcEnergyConversionDeviceType, ObjectHelper<IfcCoilType,1> { IfcCoilType() : Object("IfcCoilType") {}
		IfcCoilTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcColourSpecification
    struct IfcColourSpecification : IfcPresentationItem, ObjectHelper<IfcColourSpecification,1> { IfcColourSpecification() : Object("IfcColourSpecification") {}
		Maybe< IfcLabel::Out > Name;
    };

    // C++ wrapper for IfcColourRgb
    struct IfcColourRgb : IfcColourSpecification, ObjectHelper<IfcColourRgb,3> { IfcColourRgb() : Object("IfcColourRgb") {}
		IfcNormalisedRatioMeasure::Out Red;
		IfcNormalisedRatioMeasure::Out Green;
		IfcNormalisedRatioMeasure::Out Blue;
    };

    // C++ wrapper for IfcColumn
    struct IfcColumn : IfcBuildingElement, ObjectHelper<IfcColumn,1> { IfcColumn() : Object("IfcColumn") {}
		Maybe< IfcColumnTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcColumnStandardCase
    struct IfcColumnStandardCase : IfcColumn, ObjectHelper<IfcColumnStandardCase,0> { IfcColumnStandardCase() : Object("IfcColumnStandardCase") {}

    };

    // C++ wrapper for IfcColumnType
    struct IfcColumnType : IfcBuildingElementType, ObjectHelper<IfcColumnType,1> { IfcColumnType() : Object("IfcColumnType") {}
		IfcColumnTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcCommunicationsAppliance
    struct IfcCommunicationsAppliance : IfcFlowTerminal, ObjectHelper<IfcCommunicationsAppliance,1> { IfcCommunicationsAppliance() : Object("IfcCommunicationsAppliance") {}
		Maybe< IfcCommunicationsApplianceTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcCommunicationsApplianceType
    struct IfcCommunicationsApplianceType : IfcFlowTerminalType, ObjectHelper<IfcCommunicationsApplianceType,1> { IfcCommunicationsApplianceType() : Object("IfcCommunicationsApplianceType") {}
		IfcCommunicationsApplianceTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcPropertyAbstraction
    struct IfcPropertyAbstraction :  ObjectHelper<IfcPropertyAbstraction,0> { IfcPropertyAbstraction() : Object("IfcPropertyAbstraction") {}

    };

    // C++ wrapper for IfcProperty
    struct IfcProperty : IfcPropertyAbstraction, ObjectHelper<IfcProperty,2> { IfcProperty() : Object("IfcProperty") {}
		IfcIdentifier::Out Name;
		Maybe< IfcText::Out > Description;
    };

    // C++ wrapper for IfcComplexProperty
    struct IfcComplexProperty : IfcProperty, ObjectHelper<IfcComplexProperty,2> { IfcComplexProperty() : Object("IfcComplexProperty") {}
		IfcIdentifier::Out UsageName;
		ListOf< Lazy< IfcProperty >, 1, 0 > HasProperties;
    };

    // C++ wrapper for IfcPropertyDefinition
    struct IfcPropertyDefinition : IfcRoot, ObjectHelper<IfcPropertyDefinition,0> { IfcPropertyDefinition() : Object("IfcPropertyDefinition") {}

    };

    // C++ wrapper for IfcCompositeCurveSegment
    struct IfcCompositeCurveSegment : IfcGeometricRepresentationItem, ObjectHelper<IfcCompositeCurveSegment,3> { IfcCompositeCurveSegment() : Object("IfcCompositeCurveSegment") {}
		IfcTransitionCode::Out Transition;
		IfcBoolean::Out SameSense;
		Lazy< IfcCurve > ParentCurve;
    };

    // C++ wrapper for IfcCompositeProfileDef
    struct IfcCompositeProfileDef : IfcProfileDef, ObjectHelper<IfcCompositeProfileDef,2> { IfcCompositeProfileDef() : Object("IfcCompositeProfileDef") {}
		ListOf< Lazy< IfcProfileDef >, 2, 0 > Profiles;
		Maybe< IfcLabel::Out > Label;
    };

    // C++ wrapper for IfcFlowMovingDevice
    struct IfcFlowMovingDevice : IfcDistributionFlowElement, ObjectHelper<IfcFlowMovingDevice,0> { IfcFlowMovingDevice() : Object("IfcFlowMovingDevice") {}

    };

    // C++ wrapper for IfcCompressor
    struct IfcCompressor : IfcFlowMovingDevice, ObjectHelper<IfcCompressor,1> { IfcCompressor() : Object("IfcCompressor") {}
		Maybe< IfcCompressorTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcFlowMovingDeviceType
    struct IfcFlowMovingDeviceType : IfcDistributionFlowElementType, ObjectHelper<IfcFlowMovingDeviceType,0> { IfcFlowMovingDeviceType() : Object("IfcFlowMovingDeviceType") {}

    };

    // C++ wrapper for IfcCompressorType
    struct IfcCompressorType : IfcFlowMovingDeviceType, ObjectHelper<IfcCompressorType,1> { IfcCompressorType() : Object("IfcCompressorType") {}
		IfcCompressorTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcCondenser
    struct IfcCondenser : IfcEnergyConversionDevice, ObjectHelper<IfcCondenser,1> { IfcCondenser() : Object("IfcCondenser") {}
		Maybe< IfcCondenserTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcCondenserType
    struct IfcCondenserType : IfcEnergyConversionDeviceType, ObjectHelper<IfcCondenserType,1> { IfcCondenserType() : Object("IfcCondenserType") {}
		IfcCondenserTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcResource
    struct IfcResource : IfcObject, ObjectHelper<IfcResource,2> { IfcResource() : Object("IfcResource") {}
		Maybe< IfcIdentifier::Out > Identification;
		Maybe< IfcText::Out > LongDescription;
    };

    // C++ wrapper for IfcConstructionResource
    struct IfcConstructionResource : IfcResource, ObjectHelper<IfcConstructionResource,3> { IfcConstructionResource() : Object("IfcConstructionResource") {}
		Maybe< Lazy< NotImplemented > > Usage;
		Maybe< ListOf< Lazy< NotImplemented >, 1, 0 > > BaseCosts;
		Maybe< Lazy< NotImplemented > > BaseQuantity;
    };

    // C++ wrapper for IfcConstructionEquipmentResource
    struct IfcConstructionEquipmentResource : IfcConstructionResource, ObjectHelper<IfcConstructionEquipmentResource,1> { IfcConstructionEquipmentResource() : Object("IfcConstructionEquipmentResource") {}
		Maybe< IfcConstructionEquipmentResourceTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcTypeResource
    struct IfcTypeResource : IfcTypeObject, ObjectHelper<IfcTypeResource,3> { IfcTypeResource() : Object("IfcTypeResource") {}
		Maybe< IfcIdentifier::Out > Identification;
		Maybe< IfcText::Out > LongDescription;
		Maybe< IfcLabel::Out > ResourceType;
    };

    // C++ wrapper for IfcConstructionResourceType
    struct IfcConstructionResourceType : IfcTypeResource, ObjectHelper<IfcConstructionResourceType,2> { IfcConstructionResourceType() : Object("IfcConstructionResourceType") {}
		Maybe< ListOf< Lazy< NotImplemented >, 1, 0 > > BaseCosts;
		Maybe< Lazy< NotImplemented > > BaseQuantity;
    };

    // C++ wrapper for IfcConstructionEquipmentResourceType
    struct IfcConstructionEquipmentResourceType : IfcConstructionResourceType, ObjectHelper<IfcConstructionEquipmentResourceType,1> { IfcConstructionEquipmentResourceType() : Object("IfcConstructionEquipmentResourceType") {}
		IfcConstructionEquipmentResourceTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcConstructionMaterialResource
    struct IfcConstructionMaterialResource : IfcConstructionResource, ObjectHelper<IfcConstructionMaterialResource,1> { IfcConstructionMaterialResource() : Object("IfcConstructionMaterialResource") {}
		Maybe< IfcConstructionMaterialResourceTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcConstructionMaterialResourceType
    struct IfcConstructionMaterialResourceType : IfcConstructionResourceType, ObjectHelper<IfcConstructionMaterialResourceType,1> { IfcConstructionMaterialResourceType() : Object("IfcConstructionMaterialResourceType") {}
		IfcConstructionMaterialResourceTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcConstructionProductResource
    struct IfcConstructionProductResource : IfcConstructionResource, ObjectHelper<IfcConstructionProductResource,1> { IfcConstructionProductResource() : Object("IfcConstructionProductResource") {}
		Maybe< IfcConstructionProductResourceTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcConstructionProductResourceType
    struct IfcConstructionProductResourceType : IfcConstructionResourceType, ObjectHelper<IfcConstructionProductResourceType,1> { IfcConstructionProductResourceType() : Object("IfcConstructionProductResourceType") {}
		IfcConstructionProductResourceTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcContext
    struct IfcContext : IfcObjectDefinition, ObjectHelper<IfcContext,5> { IfcContext() : Object("IfcContext") {}
		Maybe< IfcLabel::Out > ObjectType;
		Maybe< IfcLabel::Out > LongName;
		Maybe< IfcLabel::Out > Phase;
		Maybe< ListOf< Lazy< IfcRepresentationContext >, 1, 0 > > RepresentationContexts;
		Maybe< Lazy< IfcUnitAssignment > > UnitsInContext;
    };

    // C++ wrapper for IfcNamedUnit
    struct IfcNamedUnit :  ObjectHelper<IfcNamedUnit,2> { IfcNamedUnit() : Object("IfcNamedUnit") {}
		Lazy< NotImplemented > Dimensions;
		IfcUnitEnum::Out UnitType;
    };

    // C++ wrapper for IfcContextDependentUnit
    struct IfcContextDependentUnit : IfcNamedUnit, ObjectHelper<IfcContextDependentUnit,1> { IfcContextDependentUnit() : Object("IfcContextDependentUnit") {}
		IfcLabel::Out Name;
    };

    // C++ wrapper for IfcController
    struct IfcController : IfcDistributionControlElement, ObjectHelper<IfcController,1> { IfcController() : Object("IfcController") {}
		Maybe< IfcControllerTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcControllerType
    struct IfcControllerType : IfcDistributionControlElementType, ObjectHelper<IfcControllerType,1> { IfcControllerType() : Object("IfcControllerType") {}
		IfcControllerTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcConversionBasedUnit
    struct IfcConversionBasedUnit : IfcNamedUnit, ObjectHelper<IfcConversionBasedUnit,2> { IfcConversionBasedUnit() : Object("IfcConversionBasedUnit") {}
		IfcLabel::Out Name;
		Lazy< IfcMeasureWithUnit > ConversionFactor;
    };

    // C++ wrapper for IfcConversionBasedUnitWithOffset
    struct IfcConversionBasedUnitWithOffset : IfcConversionBasedUnit, ObjectHelper<IfcConversionBasedUnitWithOffset,1> { IfcConversionBasedUnitWithOffset() : Object("IfcConversionBasedUnitWithOffset") {}
		IfcReal::Out ConversionOffset;
    };

    // C++ wrapper for IfcCooledBeam
    struct IfcCooledBeam : IfcEnergyConversionDevice, ObjectHelper<IfcCooledBeam,1> { IfcCooledBeam() : Object("IfcCooledBeam") {}
		Maybe< IfcCooledBeamTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcCooledBeamType
    struct IfcCooledBeamType : IfcEnergyConversionDeviceType, ObjectHelper<IfcCooledBeamType,1> { IfcCooledBeamType() : Object("IfcCooledBeamType") {}
		IfcCooledBeamTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcCoolingTower
    struct IfcCoolingTower : IfcEnergyConversionDevice, ObjectHelper<IfcCoolingTower,1> { IfcCoolingTower() : Object("IfcCoolingTower") {}
		Maybe< IfcCoolingTowerTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcCoolingTowerType
    struct IfcCoolingTowerType : IfcEnergyConversionDeviceType, ObjectHelper<IfcCoolingTowerType,1> { IfcCoolingTowerType() : Object("IfcCoolingTowerType") {}
		IfcCoolingTowerTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcCostItem
    struct IfcCostItem : IfcControl, ObjectHelper<IfcCostItem,3> { IfcCostItem() : Object("IfcCostItem") {}
		Maybe< IfcCostItemTypeEnum::Out > PredefinedType;
		Maybe< ListOf< Lazy< NotImplemented >, 1, 0 > > CostValues;
		Maybe< ListOf< Lazy< NotImplemented >, 1, 0 > > CostQuantities;
    };

    // C++ wrapper for IfcCostSchedule
    struct IfcCostSchedule : IfcControl, ObjectHelper<IfcCostSchedule,4> { IfcCostSchedule() : Object("IfcCostSchedule") {}
		Maybe< IfcCostScheduleTypeEnum::Out > PredefinedType;
		Maybe< IfcLabel::Out > Status;
		Maybe< IfcDateTime::Out > SubmittedOn;
		Maybe< IfcDateTime::Out > UpdateDate;
    };

    // C++ wrapper for IfcCovering
    struct IfcCovering : IfcBuildingElement, ObjectHelper<IfcCovering,1> { IfcCovering() : Object("IfcCovering") {}
		Maybe< IfcCoveringTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcCoveringType
    struct IfcCoveringType : IfcBuildingElementType, ObjectHelper<IfcCoveringType,1> { IfcCoveringType() : Object("IfcCoveringType") {}
		IfcCoveringTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcCrewResource
    struct IfcCrewResource : IfcConstructionResource, ObjectHelper<IfcCrewResource,1> { IfcCrewResource() : Object("IfcCrewResource") {}
		Maybe< IfcCrewResourceTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcCrewResourceType
    struct IfcCrewResourceType : IfcConstructionResourceType, ObjectHelper<IfcCrewResourceType,1> { IfcCrewResourceType() : Object("IfcCrewResourceType") {}
		IfcCrewResourceTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcCsgSolid
    struct IfcCsgSolid : IfcSolidModel, ObjectHelper<IfcCsgSolid,1> { IfcCsgSolid() : Object("IfcCsgSolid") {}
		IfcCsgSelect::Out TreeRootExpression;
    };

    // C++ wrapper for IfcCurtainWall
    struct IfcCurtainWall : IfcBuildingElement, ObjectHelper<IfcCurtainWall,1> { IfcCurtainWall() : Object("IfcCurtainWall") {}
		Maybe< IfcCurtainWallTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcCurtainWallType
    struct IfcCurtainWallType : IfcBuildingElementType, ObjectHelper<IfcCurtainWallType,1> { IfcCurtainWallType() : Object("IfcCurtainWallType") {}
		IfcCurtainWallTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcCurveBoundedPlane
    struct IfcCurveBoundedPlane : IfcBoundedSurface, ObjectHelper<IfcCurveBoundedPlane,3> { IfcCurveBoundedPlane() : Object("IfcCurveBoundedPlane") {}
		Lazy< IfcPlane > BasisSurface;
		Lazy< IfcCurve > OuterBoundary;
		ListOf< Lazy< IfcCurve >, 0, 0 > InnerBoundaries;
    };

    // C++ wrapper for IfcCurveBoundedSurface
    struct IfcCurveBoundedSurface : IfcBoundedSurface, ObjectHelper<IfcCurveBoundedSurface,3> { IfcCurveBoundedSurface() : Object("IfcCurveBoundedSurface") {}
		Lazy< IfcSurface > BasisSurface;
		ListOf< Lazy< IfcBoundaryCurve >, 1, 0 > Boundaries;
		IfcBoolean::Out ImplicitOuter;
    };

    // C++ wrapper for IfcPresentationStyle
    struct IfcPresentationStyle :  ObjectHelper<IfcPresentationStyle,1> { IfcPresentationStyle() : Object("IfcPresentationStyle") {}
		Maybe< IfcLabel::Out > Name;
    };

    // C++ wrapper for IfcElementarySurface
    struct IfcElementarySurface : IfcSurface, ObjectHelper<IfcElementarySurface,1> { IfcElementarySurface() : Object("IfcElementarySurface") {}
		Lazy< IfcAxis2Placement3D > Position;
    };

    // C++ wrapper for IfcCylindricalSurface
    struct IfcCylindricalSurface : IfcElementarySurface, ObjectHelper<IfcCylindricalSurface,1> { IfcCylindricalSurface() : Object("IfcCylindricalSurface") {}
		IfcPositiveLengthMeasure::Out Radius;
    };

    // C++ wrapper for IfcDamper
    struct IfcDamper : IfcFlowController, ObjectHelper<IfcDamper,1> { IfcDamper() : Object("IfcDamper") {}
		Maybe< IfcDamperTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcDamperType
    struct IfcDamperType : IfcFlowControllerType, ObjectHelper<IfcDamperType,1> { IfcDamperType() : Object("IfcDamperType") {}
		IfcDamperTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcDerivedProfileDef
    struct IfcDerivedProfileDef : IfcProfileDef, ObjectHelper<IfcDerivedProfileDef,3> { IfcDerivedProfileDef() : Object("IfcDerivedProfileDef") {}
		Lazy< IfcProfileDef > ParentProfile;
		Lazy< IfcCartesianTransformationOperator2D > Operator;
		Maybe< IfcLabel::Out > Label;
    };

    // C++ wrapper for IfcDirection
    struct IfcDirection : IfcGeometricRepresentationItem, ObjectHelper<IfcDirection,1> { IfcDirection() : Object("IfcDirection") {}
		ListOf< IfcReal, 2, 3 >::Out DirectionRatios;
    };

    // C++ wrapper for IfcDiscreteAccessory
    struct IfcDiscreteAccessory : IfcElementComponent, ObjectHelper<IfcDiscreteAccessory,1> { IfcDiscreteAccessory() : Object("IfcDiscreteAccessory") {}
		Maybe< IfcDiscreteAccessoryTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcDiscreteAccessoryType
    struct IfcDiscreteAccessoryType : IfcElementComponentType, ObjectHelper<IfcDiscreteAccessoryType,1> { IfcDiscreteAccessoryType() : Object("IfcDiscreteAccessoryType") {}
		IfcDiscreteAccessoryTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcDistributionChamberElement
    struct IfcDistributionChamberElement : IfcDistributionFlowElement, ObjectHelper<IfcDistributionChamberElement,1> { IfcDistributionChamberElement() : Object("IfcDistributionChamberElement") {}
		Maybe< IfcDistributionChamberElementTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcDistributionChamberElementType
    struct IfcDistributionChamberElementType : IfcDistributionFlowElementType, ObjectHelper<IfcDistributionChamberElementType,1> { IfcDistributionChamberElementType() : Object("IfcDistributionChamberElementType") {}
		IfcDistributionChamberElementTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcDistributionSystem
    struct IfcDistributionSystem : IfcSystem, ObjectHelper<IfcDistributionSystem,2> { IfcDistributionSystem() : Object("IfcDistributionSystem") {}
		Maybe< IfcLabel::Out > LongName;
		Maybe< IfcDistributionSystemEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcDistributionCircuit
    struct IfcDistributionCircuit : IfcDistributionSystem, ObjectHelper<IfcDistributionCircuit,0> { IfcDistributionCircuit() : Object("IfcDistributionCircuit") {}

    };

    // C++ wrapper for IfcPort
    struct IfcPort : IfcProduct, ObjectHelper<IfcPort,0> { IfcPort() : Object("IfcPort") {}

    };

    // C++ wrapper for IfcDistributionPort
    struct IfcDistributionPort : IfcPort, ObjectHelper<IfcDistributionPort,3> { IfcDistributionPort() : Object("IfcDistributionPort") {}
		Maybe< IfcFlowDirectionEnum::Out > FlowDirection;
		Maybe< IfcDistributionPortTypeEnum::Out > PredefinedType;
		Maybe< IfcDistributionSystemEnum::Out > SystemType;
    };

    // C++ wrapper for IfcDoor
    struct IfcDoor : IfcBuildingElement, ObjectHelper<IfcDoor,5> { IfcDoor() : Object("IfcDoor") {}
		Maybe< IfcPositiveLengthMeasure::Out > OverallHeight;
		Maybe< IfcPositiveLengthMeasure::Out > OverallWidth;
		Maybe< IfcDoorTypeEnum::Out > PredefinedType;
		Maybe< IfcDoorTypeOperationEnum::Out > OperationType;
		Maybe< IfcLabel::Out > UserDefinedOperationType;
    };

    // C++ wrapper for IfcPropertySetDefinition
    struct IfcPropertySetDefinition : IfcPropertyDefinition, ObjectHelper<IfcPropertySetDefinition,0> { IfcPropertySetDefinition() : Object("IfcPropertySetDefinition") {}

    };

    // C++ wrapper for IfcDoorStandardCase
    struct IfcDoorStandardCase : IfcDoor, ObjectHelper<IfcDoorStandardCase,0> { IfcDoorStandardCase() : Object("IfcDoorStandardCase") {}

    };

    // C++ wrapper for IfcDoorStyle
    struct IfcDoorStyle : IfcTypeProduct, ObjectHelper<IfcDoorStyle,4> { IfcDoorStyle() : Object("IfcDoorStyle") {}
		IfcDoorStyleOperationEnum::Out OperationType;
		IfcDoorStyleConstructionEnum::Out ConstructionType;
		IfcBoolean::Out ParameterTakesPrecedence;
		IfcBoolean::Out Sizeable;
    };

    // C++ wrapper for IfcDoorType
    struct IfcDoorType : IfcBuildingElementType, ObjectHelper<IfcDoorType,4> { IfcDoorType() : Object("IfcDoorType") {}
		IfcDoorTypeEnum::Out PredefinedType;
		IfcDoorTypeOperationEnum::Out OperationType;
		Maybe< IfcBoolean::Out > ParameterTakesPrecedence;
		Maybe< IfcLabel::Out > UserDefinedOperationType;
    };

    // C++ wrapper for IfcDuctFitting
    struct IfcDuctFitting : IfcFlowFitting, ObjectHelper<IfcDuctFitting,1> { IfcDuctFitting() : Object("IfcDuctFitting") {}
		Maybe< IfcDuctFittingTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcDuctFittingType
    struct IfcDuctFittingType : IfcFlowFittingType, ObjectHelper<IfcDuctFittingType,1> { IfcDuctFittingType() : Object("IfcDuctFittingType") {}
		IfcDuctFittingTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcDuctSegment
    struct IfcDuctSegment : IfcFlowSegment, ObjectHelper<IfcDuctSegment,1> { IfcDuctSegment() : Object("IfcDuctSegment") {}
		Maybe< IfcDuctSegmentTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcDuctSegmentType
    struct IfcDuctSegmentType : IfcFlowSegmentType, ObjectHelper<IfcDuctSegmentType,1> { IfcDuctSegmentType() : Object("IfcDuctSegmentType") {}
		IfcDuctSegmentTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcFlowTreatmentDevice
    struct IfcFlowTreatmentDevice : IfcDistributionFlowElement, ObjectHelper<IfcFlowTreatmentDevice,0> { IfcFlowTreatmentDevice() : Object("IfcFlowTreatmentDevice") {}

    };

    // C++ wrapper for IfcDuctSilencer
    struct IfcDuctSilencer : IfcFlowTreatmentDevice, ObjectHelper<IfcDuctSilencer,1> { IfcDuctSilencer() : Object("IfcDuctSilencer") {}
		Maybe< IfcDuctSilencerTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcFlowTreatmentDeviceType
    struct IfcFlowTreatmentDeviceType : IfcDistributionFlowElementType, ObjectHelper<IfcFlowTreatmentDeviceType,0> { IfcFlowTreatmentDeviceType() : Object("IfcFlowTreatmentDeviceType") {}

    };

    // C++ wrapper for IfcDuctSilencerType
    struct IfcDuctSilencerType : IfcFlowTreatmentDeviceType, ObjectHelper<IfcDuctSilencerType,1> { IfcDuctSilencerType() : Object("IfcDuctSilencerType") {}
		IfcDuctSilencerTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcEdge
    struct IfcEdge : IfcTopologicalRepresentationItem, ObjectHelper<IfcEdge,2> { IfcEdge() : Object("IfcEdge") {}
		Lazy< IfcVertex > EdgeStart;
		Lazy< IfcVertex > EdgeEnd;
    };

    // C++ wrapper for IfcEdgeCurve
    struct IfcEdgeCurve : IfcEdge, ObjectHelper<IfcEdgeCurve,2> { IfcEdgeCurve() : Object("IfcEdgeCurve") {}
		Lazy< IfcCurve > EdgeGeometry;
		IfcBoolean::Out SameSense;
    };

    // C++ wrapper for IfcLoop
    struct IfcLoop : IfcTopologicalRepresentationItem, ObjectHelper<IfcLoop,0> { IfcLoop() : Object("IfcLoop") {}

    };

    // C++ wrapper for IfcEdgeLoop
    struct IfcEdgeLoop : IfcLoop, ObjectHelper<IfcEdgeLoop,1> { IfcEdgeLoop() : Object("IfcEdgeLoop") {}
		ListOf< Lazy< IfcOrientedEdge >, 1, 0 > EdgeList;
    };

    // C++ wrapper for IfcElectricAppliance
    struct IfcElectricAppliance : IfcFlowTerminal, ObjectHelper<IfcElectricAppliance,1> { IfcElectricAppliance() : Object("IfcElectricAppliance") {}
		Maybe< IfcElectricApplianceTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcElectricApplianceType
    struct IfcElectricApplianceType : IfcFlowTerminalType, ObjectHelper<IfcElectricApplianceType,1> { IfcElectricApplianceType() : Object("IfcElectricApplianceType") {}
		IfcElectricApplianceTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcElectricDistributionBoard
    struct IfcElectricDistributionBoard : IfcFlowController, ObjectHelper<IfcElectricDistributionBoard,1> { IfcElectricDistributionBoard() : Object("IfcElectricDistributionBoard") {}
		Maybe< IfcElectricDistributionBoardTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcElectricDistributionBoardType
    struct IfcElectricDistributionBoardType : IfcFlowControllerType, ObjectHelper<IfcElectricDistributionBoardType,1> { IfcElectricDistributionBoardType() : Object("IfcElectricDistributionBoardType") {}
		IfcElectricDistributionBoardTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcFlowStorageDevice
    struct IfcFlowStorageDevice : IfcDistributionFlowElement, ObjectHelper<IfcFlowStorageDevice,0> { IfcFlowStorageDevice() : Object("IfcFlowStorageDevice") {}

    };

    // C++ wrapper for IfcElectricFlowStorageDevice
    struct IfcElectricFlowStorageDevice : IfcFlowStorageDevice, ObjectHelper<IfcElectricFlowStorageDevice,1> { IfcElectricFlowStorageDevice() : Object("IfcElectricFlowStorageDevice") {}
		Maybe< IfcElectricFlowStorageDeviceTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcFlowStorageDeviceType
    struct IfcFlowStorageDeviceType : IfcDistributionFlowElementType, ObjectHelper<IfcFlowStorageDeviceType,0> { IfcFlowStorageDeviceType() : Object("IfcFlowStorageDeviceType") {}

    };

    // C++ wrapper for IfcElectricFlowStorageDeviceType
    struct IfcElectricFlowStorageDeviceType : IfcFlowStorageDeviceType, ObjectHelper<IfcElectricFlowStorageDeviceType,1> { IfcElectricFlowStorageDeviceType() : Object("IfcElectricFlowStorageDeviceType") {}
		IfcElectricFlowStorageDeviceTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcElectricGenerator
    struct IfcElectricGenerator : IfcEnergyConversionDevice, ObjectHelper<IfcElectricGenerator,1> { IfcElectricGenerator() : Object("IfcElectricGenerator") {}
		Maybe< IfcElectricGeneratorTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcElectricGeneratorType
    struct IfcElectricGeneratorType : IfcEnergyConversionDeviceType, ObjectHelper<IfcElectricGeneratorType,1> { IfcElectricGeneratorType() : Object("IfcElectricGeneratorType") {}
		IfcElectricGeneratorTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcElectricMotor
    struct IfcElectricMotor : IfcEnergyConversionDevice, ObjectHelper<IfcElectricMotor,1> { IfcElectricMotor() : Object("IfcElectricMotor") {}
		Maybe< IfcElectricMotorTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcElectricMotorType
    struct IfcElectricMotorType : IfcEnergyConversionDeviceType, ObjectHelper<IfcElectricMotorType,1> { IfcElectricMotorType() : Object("IfcElectricMotorType") {}
		IfcElectricMotorTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcElectricTimeControl
    struct IfcElectricTimeControl : IfcFlowController, ObjectHelper<IfcElectricTimeControl,1> { IfcElectricTimeControl() : Object("IfcElectricTimeControl") {}
		Maybe< IfcElectricTimeControlTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcElectricTimeControlType
    struct IfcElectricTimeControlType : IfcFlowControllerType, ObjectHelper<IfcElectricTimeControlType,1> { IfcElectricTimeControlType() : Object("IfcElectricTimeControlType") {}
		IfcElectricTimeControlTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcElementAssembly
    struct IfcElementAssembly : IfcElement, ObjectHelper<IfcElementAssembly,2> { IfcElementAssembly() : Object("IfcElementAssembly") {}
		Maybe< IfcAssemblyPlaceEnum::Out > AssemblyPlace;
		Maybe< IfcElementAssemblyTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcElementAssemblyType
    struct IfcElementAssemblyType : IfcElementType, ObjectHelper<IfcElementAssemblyType,1> { IfcElementAssemblyType() : Object("IfcElementAssemblyType") {}
		IfcElementAssemblyTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcQuantitySet
    struct IfcQuantitySet : IfcPropertySetDefinition, ObjectHelper<IfcQuantitySet,0> { IfcQuantitySet() : Object("IfcQuantitySet") {}

    };

    // C++ wrapper for IfcElementQuantity
    struct IfcElementQuantity : IfcQuantitySet, ObjectHelper<IfcElementQuantity,2> { IfcElementQuantity() : Object("IfcElementQuantity") {}
		Maybe< IfcLabel::Out > MethodOfMeasurement;
		ListOf< Lazy< NotImplemented >, 1, 0 > Quantities;
    };

    // C++ wrapper for IfcEllipse
    struct IfcEllipse : IfcConic, ObjectHelper<IfcEllipse,2> { IfcEllipse() : Object("IfcEllipse") {}
		IfcPositiveLengthMeasure::Out SemiAxis1;
		IfcPositiveLengthMeasure::Out SemiAxis2;
    };

    // C++ wrapper for IfcEllipseProfileDef
    struct IfcEllipseProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcEllipseProfileDef,2> { IfcEllipseProfileDef() : Object("IfcEllipseProfileDef") {}
		IfcPositiveLengthMeasure::Out SemiAxis1;
		IfcPositiveLengthMeasure::Out SemiAxis2;
    };

    // C++ wrapper for IfcEngine
    struct IfcEngine : IfcEnergyConversionDevice, ObjectHelper<IfcEngine,1> { IfcEngine() : Object("IfcEngine") {}
		Maybe< IfcEngineTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcEngineType
    struct IfcEngineType : IfcEnergyConversionDeviceType, ObjectHelper<IfcEngineType,1> { IfcEngineType() : Object("IfcEngineType") {}
		IfcEngineTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcEvaporativeCooler
    struct IfcEvaporativeCooler : IfcEnergyConversionDevice, ObjectHelper<IfcEvaporativeCooler,1> { IfcEvaporativeCooler() : Object("IfcEvaporativeCooler") {}
		Maybe< IfcEvaporativeCoolerTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcEvaporativeCoolerType
    struct IfcEvaporativeCoolerType : IfcEnergyConversionDeviceType, ObjectHelper<IfcEvaporativeCoolerType,1> { IfcEvaporativeCoolerType() : Object("IfcEvaporativeCoolerType") {}
		IfcEvaporativeCoolerTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcEvaporator
    struct IfcEvaporator : IfcEnergyConversionDevice, ObjectHelper<IfcEvaporator,1> { IfcEvaporator() : Object("IfcEvaporator") {}
		Maybe< IfcEvaporatorTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcEvaporatorType
    struct IfcEvaporatorType : IfcEnergyConversionDeviceType, ObjectHelper<IfcEvaporatorType,1> { IfcEvaporatorType() : Object("IfcEvaporatorType") {}
		IfcEvaporatorTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcProcess
    struct IfcProcess : IfcObject, ObjectHelper<IfcProcess,2> { IfcProcess() : Object("IfcProcess") {}
		Maybe< IfcIdentifier::Out > Identification;
		Maybe< IfcText::Out > LongDescription;
    };

    // C++ wrapper for IfcEvent
    struct IfcEvent : IfcProcess, ObjectHelper<IfcEvent,4> { IfcEvent() : Object("IfcEvent") {}
		Maybe< IfcEventTypeEnum::Out > PredefinedType;
		Maybe< IfcEventTriggerTypeEnum::Out > EventTriggerType;
		Maybe< IfcLabel::Out > UserDefinedEventTriggerType;
		Maybe< Lazy< NotImplemented > > EventOccurenceTime;
    };

    // C++ wrapper for IfcTypeProcess
    struct IfcTypeProcess : IfcTypeObject, ObjectHelper<IfcTypeProcess,3> { IfcTypeProcess() : Object("IfcTypeProcess") {}
		Maybe< IfcIdentifier::Out > Identification;
		Maybe< IfcText::Out > LongDescription;
		Maybe< IfcLabel::Out > ProcessType;
    };

    // C++ wrapper for IfcEventType
    struct IfcEventType : IfcTypeProcess, ObjectHelper<IfcEventType,3> { IfcEventType() : Object("IfcEventType") {}
		IfcEventTypeEnum::Out PredefinedType;
		IfcEventTriggerTypeEnum::Out EventTriggerType;
		Maybe< IfcLabel::Out > UserDefinedEventTriggerType;
    };

    // C++ wrapper for IfcExternalSpatialStructureElement
    struct IfcExternalSpatialStructureElement : IfcSpatialElement, ObjectHelper<IfcExternalSpatialStructureElement,0> { IfcExternalSpatialStructureElement() : Object("IfcExternalSpatialStructureElement") {}

    };

    // C++ wrapper for IfcExternalSpatialElement
    struct IfcExternalSpatialElement : IfcExternalSpatialStructureElement, ObjectHelper<IfcExternalSpatialElement,1> { IfcExternalSpatialElement() : Object("IfcExternalSpatialElement") {}
		Maybe< IfcExternalSpatialElementTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcSweptAreaSolid
    struct IfcSweptAreaSolid : IfcSolidModel, ObjectHelper<IfcSweptAreaSolid,2> { IfcSweptAreaSolid() : Object("IfcSweptAreaSolid") {}
		Lazy< IfcProfileDef > SweptArea;
		Maybe< Lazy< IfcAxis2Placement3D > > Position;
    };

    // C++ wrapper for IfcExtrudedAreaSolid
    struct IfcExtrudedAreaSolid : IfcSweptAreaSolid, ObjectHelper<IfcExtrudedAreaSolid,2> { IfcExtrudedAreaSolid() : Object("IfcExtrudedAreaSolid") {}
		Lazy< IfcDirection > ExtrudedDirection;
		IfcPositiveLengthMeasure::Out Depth;
    };

    // C++ wrapper for IfcExtrudedAreaSolidTapered
    struct IfcExtrudedAreaSolidTapered : IfcExtrudedAreaSolid, ObjectHelper<IfcExtrudedAreaSolidTapered,1> { IfcExtrudedAreaSolidTapered() : Object("IfcExtrudedAreaSolidTapered") {}
		Lazy< IfcProfileDef > EndSweptArea;
    };

    // C++ wrapper for IfcFaceBasedSurfaceModel
    struct IfcFaceBasedSurfaceModel : IfcGeometricRepresentationItem, ObjectHelper<IfcFaceBasedSurfaceModel,1> { IfcFaceBasedSurfaceModel() : Object("IfcFaceBasedSurfaceModel") {}
		ListOf< Lazy< IfcConnectedFaceSet >, 1, 0 > FbsmFaces;
    };

    // C++ wrapper for IfcFaceBound
    struct IfcFaceBound : IfcTopologicalRepresentationItem, ObjectHelper<IfcFaceBound,2> { IfcFaceBound() : Object("IfcFaceBound") {}
		Lazy< IfcLoop > Bound;
		IfcBoolean::Out Orientation;
    };

    // C++ wrapper for IfcFaceOuterBound
    struct IfcFaceOuterBound : IfcFaceBound, ObjectHelper<IfcFaceOuterBound,0> { IfcFaceOuterBound() : Object("IfcFaceOuterBound") {}

    };

    // C++ wrapper for IfcFacetedBrep
    struct IfcFacetedBrep : IfcManifoldSolidBrep, ObjectHelper<IfcFacetedBrep,0> { IfcFacetedBrep() : Object("IfcFacetedBrep") {}

    };

    // C++ wrapper for IfcFacetedBrepWithVoids
    struct IfcFacetedBrepWithVoids : IfcFacetedBrep, ObjectHelper<IfcFacetedBrepWithVoids,1> { IfcFacetedBrepWithVoids() : Object("IfcFacetedBrepWithVoids") {}
		ListOf< Lazy< IfcClosedShell >, 1, 0 > Voids;
    };

    // C++ wrapper for IfcFan
    struct IfcFan : IfcFlowMovingDevice, ObjectHelper<IfcFan,1> { IfcFan() : Object("IfcFan") {}
		Maybe< IfcFanTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcFanType
    struct IfcFanType : IfcFlowMovingDeviceType, ObjectHelper<IfcFanType,1> { IfcFanType() : Object("IfcFanType") {}
		IfcFanTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcFastener
    struct IfcFastener : IfcElementComponent, ObjectHelper<IfcFastener,1> { IfcFastener() : Object("IfcFastener") {}
		Maybe< IfcFastenerTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcFastenerType
    struct IfcFastenerType : IfcElementComponentType, ObjectHelper<IfcFastenerType,1> { IfcFastenerType() : Object("IfcFastenerType") {}
		IfcFastenerTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcFeatureElement
    struct IfcFeatureElement : IfcElement, ObjectHelper<IfcFeatureElement,0> { IfcFeatureElement() : Object("IfcFeatureElement") {}

    };

    // C++ wrapper for IfcFeatureElementAddition
    struct IfcFeatureElementAddition : IfcFeatureElement, ObjectHelper<IfcFeatureElementAddition,0> { IfcFeatureElementAddition() : Object("IfcFeatureElementAddition") {}

    };

    // C++ wrapper for IfcFeatureElementSubtraction
    struct IfcFeatureElementSubtraction : IfcFeatureElement, ObjectHelper<IfcFeatureElementSubtraction,0> { IfcFeatureElementSubtraction() : Object("IfcFeatureElementSubtraction") {}

    };

    // C++ wrapper for IfcFillAreaStyleHatching
    struct IfcFillAreaStyleHatching : IfcGeometricRepresentationItem, ObjectHelper<IfcFillAreaStyleHatching,5> { IfcFillAreaStyleHatching() : Object("IfcFillAreaStyleHatching") {}
		Lazy< NotImplemented > HatchLineAppearance;
		IfcHatchLineDistanceSelect::Out StartOfNextHatchLine;
		Maybe< Lazy< IfcCartesianPoint > > PointOfReferenceHatchLine;
		Maybe< Lazy< IfcCartesianPoint > > PatternStart;
		IfcPlaneAngleMeasure::Out HatchLineAngle;
    };

    // C++ wrapper for IfcFillAreaStyleTiles
    struct IfcFillAreaStyleTiles : IfcGeometricRepresentationItem, ObjectHelper<IfcFillAreaStyleTiles,3> { IfcFillAreaStyleTiles() : Object("IfcFillAreaStyleTiles") {}
		ListOf< Lazy< IfcVector >, 2, 2 > TilingPattern;
		ListOf< Lazy< IfcStyledItem >, 1, 0 > Tiles;
		IfcPositiveRatioMeasure::Out TilingScale;
    };

    // C++ wrapper for IfcFilter
    struct IfcFilter : IfcFlowTreatmentDevice, ObjectHelper<IfcFilter,1> { IfcFilter() : Object("IfcFilter") {}
		Maybe< IfcFilterTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcFilterType
    struct IfcFilterType : IfcFlowTreatmentDeviceType, ObjectHelper<IfcFilterType,1> { IfcFilterType() : Object("IfcFilterType") {}
		IfcFilterTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcFireSuppressionTerminal
    struct IfcFireSuppressionTerminal : IfcFlowTerminal, ObjectHelper<IfcFireSuppressionTerminal,1> { IfcFireSuppressionTerminal() : Object("IfcFireSuppressionTerminal") {}
		Maybe< IfcFireSuppressionTerminalTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcFireSuppressionTerminalType
    struct IfcFireSuppressionTerminalType : IfcFlowTerminalType, ObjectHelper<IfcFireSuppressionTerminalType,1> { IfcFireSuppressionTerminalType() : Object("IfcFireSuppressionTerminalType") {}
		IfcFireSuppressionTerminalTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcFixedReferenceSweptAreaSolid
    struct IfcFixedReferenceSweptAreaSolid : IfcSweptAreaSolid, ObjectHelper<IfcFixedReferenceSweptAreaSolid,4> { IfcFixedReferenceSweptAreaSolid() : Object("IfcFixedReferenceSweptAreaSolid") {}
		Lazy< IfcCurve > Directrix;
		Maybe< IfcParameterValue::Out > StartParam;
		Maybe< IfcParameterValue::Out > EndParam;
		Lazy< IfcDirection > FixedReference;
    };

    // C++ wrapper for IfcFlowInstrument
    struct IfcFlowInstrument : IfcDistributionControlElement, ObjectHelper<IfcFlowInstrument,1> { IfcFlowInstrument() : Object("IfcFlowInstrument") {}
		Maybe< IfcFlowInstrumentTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcFlowInstrumentType
    struct IfcFlowInstrumentType : IfcDistributionControlElementType, ObjectHelper<IfcFlowInstrumentType,1> { IfcFlowInstrumentType() : Object("IfcFlowInstrumentType") {}
		IfcFlowInstrumentTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcFlowMeter
    struct IfcFlowMeter : IfcFlowController, ObjectHelper<IfcFlowMeter,1> { IfcFlowMeter() : Object("IfcFlowMeter") {}
		Maybe< IfcFlowMeterTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcFlowMeterType
    struct IfcFlowMeterType : IfcFlowControllerType, ObjectHelper<IfcFlowMeterType,1> { IfcFlowMeterType() : Object("IfcFlowMeterType") {}
		IfcFlowMeterTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcFooting
    struct IfcFooting : IfcBuildingElement, ObjectHelper<IfcFooting,1> { IfcFooting() : Object("IfcFooting") {}
		Maybe< IfcFootingTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcFootingType
    struct IfcFootingType : IfcBuildingElementType, ObjectHelper<IfcFootingType,1> { IfcFootingType() : Object("IfcFootingType") {}
		IfcFootingTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcFurnishingElement
    struct IfcFurnishingElement : IfcElement, ObjectHelper<IfcFurnishingElement,0> { IfcFurnishingElement() : Object("IfcFurnishingElement") {}

    };

    // C++ wrapper for IfcFurnishingElementType
    struct IfcFurnishingElementType : IfcElementType, ObjectHelper<IfcFurnishingElementType,0> { IfcFurnishingElementType() : Object("IfcFurnishingElementType") {}

    };

    // C++ wrapper for IfcFurniture
    struct IfcFurniture : IfcFurnishingElement, ObjectHelper<IfcFurniture,1> { IfcFurniture() : Object("IfcFurniture") {}
		Maybe< IfcFurnitureTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcFurnitureType
    struct IfcFurnitureType : IfcFurnishingElementType, ObjectHelper<IfcFurnitureType,2> { IfcFurnitureType() : Object("IfcFurnitureType") {}
		IfcAssemblyPlaceEnum::Out AssemblyPlace;
		Maybe< IfcFurnitureTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcGeographicElement
    struct IfcGeographicElement : IfcElement, ObjectHelper<IfcGeographicElement,1> { IfcGeographicElement() : Object("IfcGeographicElement") {}
		Maybe< IfcGeographicElementTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcGeographicElementType
    struct IfcGeographicElementType : IfcElementType, ObjectHelper<IfcGeographicElementType,1> { IfcGeographicElementType() : Object("IfcGeographicElementType") {}
		IfcGeographicElementTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcGeometricSet
    struct IfcGeometricSet : IfcGeometricRepresentationItem, ObjectHelper<IfcGeometricSet,1> { IfcGeometricSet() : Object("IfcGeometricSet") {}
		ListOf< IfcGeometricSetSelect, 1, 0 >::Out Elements;
    };

    // C++ wrapper for IfcGeometricCurveSet
    struct IfcGeometricCurveSet : IfcGeometricSet, ObjectHelper<IfcGeometricCurveSet,0> { IfcGeometricCurveSet() : Object("IfcGeometricCurveSet") {}

    };

    // C++ wrapper for IfcRepresentationContext
    struct IfcRepresentationContext :  ObjectHelper<IfcRepresentationContext,2> { IfcRepresentationContext() : Object("IfcRepresentationContext") {}
		Maybe< IfcLabel::Out > ContextIdentifier;
		Maybe< IfcLabel::Out > ContextType;
    };

    // C++ wrapper for IfcGeometricRepresentationContext
    struct IfcGeometricRepresentationContext : IfcRepresentationContext, ObjectHelper<IfcGeometricRepresentationContext,4> { IfcGeometricRepresentationContext() : Object("IfcGeometricRepresentationContext") {}
		IfcDimensionCount::Out CoordinateSpaceDimension;
		Maybe< IfcReal::Out > Precision;
		IfcAxis2Placement::Out WorldCoordinateSystem;
		Maybe< Lazy< IfcDirection > > TrueNorth;
    };

    // C++ wrapper for IfcGeometricRepresentationSubContext
    struct IfcGeometricRepresentationSubContext : IfcGeometricRepresentationContext, ObjectHelper<IfcGeometricRepresentationSubContext,4> { IfcGeometricRepresentationSubContext() : Object("IfcGeometricRepresentationSubContext") {}
		Lazy< IfcGeometricRepresentationContext > ParentContext;
		Maybe< IfcPositiveRatioMeasure::Out > TargetScale;
		IfcGeometricProjectionEnum::Out TargetView;
		Maybe< IfcLabel::Out > UserDefinedTargetView;
    };

    // C++ wrapper for IfcGrid
    struct IfcGrid : IfcProduct, ObjectHelper<IfcGrid,4> { IfcGrid() : Object("IfcGrid") {}
		ListOf< Lazy< NotImplemented >, 1, 0 > UAxes;
		ListOf< Lazy< NotImplemented >, 1, 0 > VAxes;
		Maybe< ListOf< Lazy< NotImplemented >, 1, 0 > > WAxes;
		Maybe< IfcGridTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcObjectPlacement
    struct IfcObjectPlacement :  ObjectHelper<IfcObjectPlacement,0> { IfcObjectPlacement() : Object("IfcObjectPlacement") {}

    };

    // C++ wrapper for IfcGridPlacement
    struct IfcGridPlacement : IfcObjectPlacement, ObjectHelper<IfcGridPlacement,2> { IfcGridPlacement() : Object("IfcGridPlacement") {}
		Lazy< NotImplemented > PlacementLocation;
		Maybe< IfcGridPlacementDirectionSelect::Out > PlacementRefDirection;
    };

    // C++ wrapper for IfcHeatExchanger
    struct IfcHeatExchanger : IfcEnergyConversionDevice, ObjectHelper<IfcHeatExchanger,1> { IfcHeatExchanger() : Object("IfcHeatExchanger") {}
		Maybe< IfcHeatExchangerTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcHeatExchangerType
    struct IfcHeatExchangerType : IfcEnergyConversionDeviceType, ObjectHelper<IfcHeatExchangerType,1> { IfcHeatExchangerType() : Object("IfcHeatExchangerType") {}
		IfcHeatExchangerTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcHumidifier
    struct IfcHumidifier : IfcEnergyConversionDevice, ObjectHelper<IfcHumidifier,1> { IfcHumidifier() : Object("IfcHumidifier") {}
		Maybe< IfcHumidifierTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcHumidifierType
    struct IfcHumidifierType : IfcEnergyConversionDeviceType, ObjectHelper<IfcHumidifierType,1> { IfcHumidifierType() : Object("IfcHumidifierType") {}
		IfcHumidifierTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcIShapeProfileDef
    struct IfcIShapeProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcIShapeProfileDef,7> { IfcIShapeProfileDef() : Object("IfcIShapeProfileDef") {}
		IfcPositiveLengthMeasure::Out OverallWidth;
		IfcPositiveLengthMeasure::Out OverallDepth;
		IfcPositiveLengthMeasure::Out WebThickness;
		IfcPositiveLengthMeasure::Out FlangeThickness;
		Maybe< IfcNonNegativeLengthMeasure::Out > FilletRadius;
		Maybe< IfcNonNegativeLengthMeasure::Out > FlangeEdgeRadius;
		Maybe< IfcPlaneAngleMeasure::Out > FlangeSlope;
    };

    // C++ wrapper for IfcIndexedPolyCurve
    struct IfcIndexedPolyCurve : IfcBoundedCurve, ObjectHelper<IfcIndexedPolyCurve,3> { IfcIndexedPolyCurve() : Object("IfcIndexedPolyCurve") {}
		Lazy< IfcCartesianPointList > Points;
		Maybe< ListOf< IfcSegmentIndexSelect, 1, 0 >::Out > Segments;
		Maybe< IfcBoolean::Out > SelfIntersect;
    };

    // C++ wrapper for IfcTessellatedItem
    struct IfcTessellatedItem : IfcGeometricRepresentationItem, ObjectHelper<IfcTessellatedItem,0> { IfcTessellatedItem() : Object("IfcTessellatedItem") {}

    };

    // C++ wrapper for IfcIndexedPolygonalFace
    struct IfcIndexedPolygonalFace : IfcTessellatedItem, ObjectHelper<IfcIndexedPolygonalFace,1> { IfcIndexedPolygonalFace() : Object("IfcIndexedPolygonalFace") {}
		ListOf< IfcPositiveInteger, 3, 0 >::Out CoordIndex;
    };

    // C++ wrapper for IfcIndexedPolygonalFaceWithVoids
    struct IfcIndexedPolygonalFaceWithVoids : IfcIndexedPolygonalFace, ObjectHelper<IfcIndexedPolygonalFaceWithVoids,0> { IfcIndexedPolygonalFaceWithVoids() : Object("IfcIndexedPolygonalFaceWithVoids") {}

    };

    // C++ wrapper for IfcInterceptor
    struct IfcInterceptor : IfcFlowTreatmentDevice, ObjectHelper<IfcInterceptor,1> { IfcInterceptor() : Object("IfcInterceptor") {}
		Maybe< IfcInterceptorTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcInterceptorType
    struct IfcInterceptorType : IfcFlowTreatmentDeviceType, ObjectHelper<IfcInterceptorType,1> { IfcInterceptorType() : Object("IfcInterceptorType") {}
		IfcInterceptorTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcSurfaceCurve
    struct IfcSurfaceCurve : IfcCurve, ObjectHelper<IfcSurfaceCurve,3> { IfcSurfaceCurve() : Object("IfcSurfaceCurve") {}
		Lazy< IfcCurve > Curve3D;
		ListOf< Lazy< IfcPcurve >, 1, 2 > AssociatedGeometry;
		IfcPreferredSurfaceCurveRepresentation::Out MasterRepresentation;
    };

    // C++ wrapper for IfcIntersectionCurve
    struct IfcIntersectionCurve : IfcSurfaceCurve, ObjectHelper<IfcIntersectionCurve,0> { IfcIntersectionCurve() : Object("IfcIntersectionCurve") {}

    };

    // C++ wrapper for IfcInventory
    struct IfcInventory : IfcGroup, ObjectHelper<IfcInventory,6> { IfcInventory() : Object("IfcInventory") {}
		Maybe< IfcInventoryTypeEnum::Out > PredefinedType;
		Maybe< IfcActorSelect::Out > Jurisdiction;
		Maybe< ListOf< Lazy< NotImplemented >, 1, 0 > > ResponsiblePersons;
		Maybe< IfcDate::Out > LastUpdateDate;
		Maybe< Lazy< NotImplemented > > CurrentValue;
		Maybe< Lazy< NotImplemented > > OriginalValue;
    };

    // C++ wrapper for IfcJunctionBox
    struct IfcJunctionBox : IfcFlowFitting, ObjectHelper<IfcJunctionBox,1> { IfcJunctionBox() : Object("IfcJunctionBox") {}
		Maybe< IfcJunctionBoxTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcJunctionBoxType
    struct IfcJunctionBoxType : IfcFlowFittingType, ObjectHelper<IfcJunctionBoxType,1> { IfcJunctionBoxType() : Object("IfcJunctionBoxType") {}
		IfcJunctionBoxTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcLShapeProfileDef
    struct IfcLShapeProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcLShapeProfileDef,6> { IfcLShapeProfileDef() : Object("IfcLShapeProfileDef") {}
		IfcPositiveLengthMeasure::Out Depth;
		Maybe< IfcPositiveLengthMeasure::Out > Width;
		IfcPositiveLengthMeasure::Out Thickness;
		Maybe< IfcNonNegativeLengthMeasure::Out > FilletRadius;
		Maybe< IfcNonNegativeLengthMeasure::Out > EdgeRadius;
		Maybe< IfcPlaneAngleMeasure::Out > LegSlope;
    };

    // C++ wrapper for IfcLaborResource
    struct IfcLaborResource : IfcConstructionResource, ObjectHelper<IfcLaborResource,1> { IfcLaborResource() : Object("IfcLaborResource") {}
		Maybe< IfcLaborResourceTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcLaborResourceType
    struct IfcLaborResourceType : IfcConstructionResourceType, ObjectHelper<IfcLaborResourceType,1> { IfcLaborResourceType() : Object("IfcLaborResourceType") {}
		IfcLaborResourceTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcLamp
    struct IfcLamp : IfcFlowTerminal, ObjectHelper<IfcLamp,1> { IfcLamp() : Object("IfcLamp") {}
		Maybe< IfcLampTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcLampType
    struct IfcLampType : IfcFlowTerminalType, ObjectHelper<IfcLampType,1> { IfcLampType() : Object("IfcLampType") {}
		IfcLampTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcLightFixture
    struct IfcLightFixture : IfcFlowTerminal, ObjectHelper<IfcLightFixture,1> { IfcLightFixture() : Object("IfcLightFixture") {}
		Maybe< IfcLightFixtureTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcLightFixtureType
    struct IfcLightFixtureType : IfcFlowTerminalType, ObjectHelper<IfcLightFixtureType,1> { IfcLightFixtureType() : Object("IfcLightFixtureType") {}
		IfcLightFixtureTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcLightSource
    struct IfcLightSource : IfcGeometricRepresentationItem, ObjectHelper<IfcLightSource,4> { IfcLightSource() : Object("IfcLightSource") {}
		Maybe< IfcLabel::Out > Name;
		Lazy< IfcColourRgb > LightColour;
		Maybe< IfcNormalisedRatioMeasure::Out > AmbientIntensity;
		Maybe< IfcNormalisedRatioMeasure::Out > Intensity;
    };

    // C++ wrapper for IfcLightSourceAmbient
    struct IfcLightSourceAmbient : IfcLightSource, ObjectHelper<IfcLightSourceAmbient,0> { IfcLightSourceAmbient() : Object("IfcLightSourceAmbient") {}

    };

    // C++ wrapper for IfcLightSourceDirectional
    struct IfcLightSourceDirectional : IfcLightSource, ObjectHelper<IfcLightSourceDirectional,1> { IfcLightSourceDirectional() : Object("IfcLightSourceDirectional") {}
		Lazy< IfcDirection > Orientation;
    };

    // C++ wrapper for IfcLightSourceGoniometric
    struct IfcLightSourceGoniometric : IfcLightSource, ObjectHelper<IfcLightSourceGoniometric,6> { IfcLightSourceGoniometric() : Object("IfcLightSourceGoniometric") {}
		Lazy< IfcAxis2Placement3D > Position;
		Maybe< Lazy< IfcColourRgb > > ColourAppearance;
		IfcThermodynamicTemperatureMeasure::Out ColourTemperature;
		IfcLuminousFluxMeasure::Out LuminousFlux;
		IfcLightEmissionSourceEnum::Out LightEmissionSource;
		IfcLightDistributionDataSourceSelect::Out LightDistributionDataSource;
    };

    // C++ wrapper for IfcLightSourcePositional
    struct IfcLightSourcePositional : IfcLightSource, ObjectHelper<IfcLightSourcePositional,5> { IfcLightSourcePositional() : Object("IfcLightSourcePositional") {}
		Lazy< IfcCartesianPoint > Position;
		IfcPositiveLengthMeasure::Out Radius;
		IfcReal::Out ConstantAttenuation;
		IfcReal::Out DistanceAttenuation;
		IfcReal::Out QuadricAttenuation;
    };

    // C++ wrapper for IfcLightSourceSpot
    struct IfcLightSourceSpot : IfcLightSourcePositional, ObjectHelper<IfcLightSourceSpot,4> { IfcLightSourceSpot() : Object("IfcLightSourceSpot") {}
		Lazy< IfcDirection > Orientation;
		Maybe< IfcReal::Out > ConcentrationExponent;
		IfcPositivePlaneAngleMeasure::Out SpreadAngle;
		IfcPositivePlaneAngleMeasure::Out BeamWidthAngle;
    };

    // C++ wrapper for IfcLine
    struct IfcLine : IfcCurve, ObjectHelper<IfcLine,2> { IfcLine() : Object("IfcLine") {}
		Lazy< IfcCartesianPoint > Pnt;
		Lazy< IfcVector > Dir;
    };

    // C++ wrapper for IfcLocalPlacement
    struct IfcLocalPlacement : IfcObjectPlacement, ObjectHelper<IfcLocalPlacement,2> { IfcLocalPlacement() : Object("IfcLocalPlacement") {}
		Maybe< Lazy< IfcObjectPlacement > > PlacementRelTo;
		IfcAxis2Placement::Out RelativePlacement;
    };

    // C++ wrapper for IfcMappedItem
    struct IfcMappedItem : IfcRepresentationItem, ObjectHelper<IfcMappedItem,2> { IfcMappedItem() : Object("IfcMappedItem") {}
		Lazy< IfcRepresentationMap > MappingSource;
		Lazy< IfcCartesianTransformationOperator > MappingTarget;
    };

    // C++ wrapper for IfcProductRepresentation
    struct IfcProductRepresentation :  ObjectHelper<IfcProductRepresentation,3> { IfcProductRepresentation() : Object("IfcProductRepresentation") {}
		Maybe< IfcLabel::Out > Name;
		Maybe< IfcText::Out > Description;
		ListOf< Lazy< IfcRepresentation >, 1, 0 > Representations;
    };

    // C++ wrapper for IfcMaterialDefinitionRepresentation
    struct IfcMaterialDefinitionRepresentation : IfcProductRepresentation, ObjectHelper<IfcMaterialDefinitionRepresentation,1> { IfcMaterialDefinitionRepresentation() : Object("IfcMaterialDefinitionRepresentation") {}
		Lazy< NotImplemented > RepresentedMaterial;
    };

    // C++ wrapper for IfcMeasureWithUnit
    struct IfcMeasureWithUnit :  ObjectHelper<IfcMeasureWithUnit,2> { IfcMeasureWithUnit() : Object("IfcMeasureWithUnit") {}
		IfcValue::Out ValueComponent;
		IfcUnit::Out UnitComponent;
    };

    // C++ wrapper for IfcMechanicalFastener
    struct IfcMechanicalFastener : IfcElementComponent, ObjectHelper<IfcMechanicalFastener,3> { IfcMechanicalFastener() : Object("IfcMechanicalFastener") {}
		Maybe< IfcPositiveLengthMeasure::Out > NominalDiameter;
		Maybe< IfcPositiveLengthMeasure::Out > NominalLength;
		Maybe< IfcMechanicalFastenerTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcMechanicalFastenerType
    struct IfcMechanicalFastenerType : IfcElementComponentType, ObjectHelper<IfcMechanicalFastenerType,3> { IfcMechanicalFastenerType() : Object("IfcMechanicalFastenerType") {}
		IfcMechanicalFastenerTypeEnum::Out PredefinedType;
		Maybe< IfcPositiveLengthMeasure::Out > NominalDiameter;
		Maybe< IfcPositiveLengthMeasure::Out > NominalLength;
    };

    // C++ wrapper for IfcMedicalDevice
    struct IfcMedicalDevice : IfcFlowTerminal, ObjectHelper<IfcMedicalDevice,1> { IfcMedicalDevice() : Object("IfcMedicalDevice") {}
		Maybe< IfcMedicalDeviceTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcMedicalDeviceType
    struct IfcMedicalDeviceType : IfcFlowTerminalType, ObjectHelper<IfcMedicalDeviceType,1> { IfcMedicalDeviceType() : Object("IfcMedicalDeviceType") {}
		IfcMedicalDeviceTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcMember
    struct IfcMember : IfcBuildingElement, ObjectHelper<IfcMember,1> { IfcMember() : Object("IfcMember") {}
		Maybe< IfcMemberTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcMemberStandardCase
    struct IfcMemberStandardCase : IfcMember, ObjectHelper<IfcMemberStandardCase,0> { IfcMemberStandardCase() : Object("IfcMemberStandardCase") {}

    };

    // C++ wrapper for IfcMemberType
    struct IfcMemberType : IfcBuildingElementType, ObjectHelper<IfcMemberType,1> { IfcMemberType() : Object("IfcMemberType") {}
		IfcMemberTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcMirroredProfileDef
    struct IfcMirroredProfileDef : IfcDerivedProfileDef, ObjectHelper<IfcMirroredProfileDef,0> { IfcMirroredProfileDef() : Object("IfcMirroredProfileDef") {}

    };

    // C++ wrapper for IfcMotorConnection
    struct IfcMotorConnection : IfcEnergyConversionDevice, ObjectHelper<IfcMotorConnection,1> { IfcMotorConnection() : Object("IfcMotorConnection") {}
		Maybe< IfcMotorConnectionTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcMotorConnectionType
    struct IfcMotorConnectionType : IfcEnergyConversionDeviceType, ObjectHelper<IfcMotorConnectionType,1> { IfcMotorConnectionType() : Object("IfcMotorConnectionType") {}
		IfcMotorConnectionTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcOccupant
    struct IfcOccupant : IfcActor, ObjectHelper<IfcOccupant,1> { IfcOccupant() : Object("IfcOccupant") {}
		Maybe< IfcOccupantTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcOffsetCurve2D
    struct IfcOffsetCurve2D : IfcCurve, ObjectHelper<IfcOffsetCurve2D,3> { IfcOffsetCurve2D() : Object("IfcOffsetCurve2D") {}
		Lazy< IfcCurve > BasisCurve;
		IfcLengthMeasure::Out Distance;
		IfcLogical::Out SelfIntersect;
    };

    // C++ wrapper for IfcOffsetCurve3D
    struct IfcOffsetCurve3D : IfcCurve, ObjectHelper<IfcOffsetCurve3D,4> { IfcOffsetCurve3D() : Object("IfcOffsetCurve3D") {}
		Lazy< IfcCurve > BasisCurve;
		IfcLengthMeasure::Out Distance;
		IfcLogical::Out SelfIntersect;
		Lazy< IfcDirection > RefDirection;
    };

    // C++ wrapper for IfcOpenShell
    struct IfcOpenShell : IfcConnectedFaceSet, ObjectHelper<IfcOpenShell,0> { IfcOpenShell() : Object("IfcOpenShell") {}

    };

    // C++ wrapper for IfcOpeningElement
    struct IfcOpeningElement : IfcFeatureElementSubtraction, ObjectHelper<IfcOpeningElement,1> { IfcOpeningElement() : Object("IfcOpeningElement") {}
		Maybe< IfcOpeningElementTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcOpeningStandardCase
    struct IfcOpeningStandardCase : IfcOpeningElement, ObjectHelper<IfcOpeningStandardCase,0> { IfcOpeningStandardCase() : Object("IfcOpeningStandardCase") {}

    };

    // C++ wrapper for IfcOrientedEdge
    struct IfcOrientedEdge : IfcEdge, ObjectHelper<IfcOrientedEdge,2> { IfcOrientedEdge() : Object("IfcOrientedEdge") {}
		Lazy< IfcEdge > EdgeElement;
		IfcBoolean::Out Orientation;
    };

    // C++ wrapper for IfcOuterBoundaryCurve
    struct IfcOuterBoundaryCurve : IfcBoundaryCurve, ObjectHelper<IfcOuterBoundaryCurve,0> { IfcOuterBoundaryCurve() : Object("IfcOuterBoundaryCurve") {}

    };

    // C++ wrapper for IfcOutlet
    struct IfcOutlet : IfcFlowTerminal, ObjectHelper<IfcOutlet,1> { IfcOutlet() : Object("IfcOutlet") {}
		Maybe< IfcOutletTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcOutletType
    struct IfcOutletType : IfcFlowTerminalType, ObjectHelper<IfcOutletType,1> { IfcOutletType() : Object("IfcOutletType") {}
		IfcOutletTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcPath
    struct IfcPath : IfcTopologicalRepresentationItem, ObjectHelper<IfcPath,1> { IfcPath() : Object("IfcPath") {}
		ListOf< Lazy< IfcOrientedEdge >, 1, 0 > EdgeList;
    };

    // C++ wrapper for IfcPcurve
    struct IfcPcurve : IfcCurve, ObjectHelper<IfcPcurve,2> { IfcPcurve() : Object("IfcPcurve") {}
		Lazy< IfcSurface > BasisSurface;
		Lazy< IfcCurve > ReferenceCurve;
    };

    // C++ wrapper for IfcPerformanceHistory
    struct IfcPerformanceHistory : IfcControl, ObjectHelper<IfcPerformanceHistory,2> { IfcPerformanceHistory() : Object("IfcPerformanceHistory") {}
		IfcLabel::Out LifeCyclePhase;
		Maybe< IfcPerformanceHistoryTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcPermit
    struct IfcPermit : IfcControl, ObjectHelper<IfcPermit,3> { IfcPermit() : Object("IfcPermit") {}
		Maybe< IfcPermitTypeEnum::Out > PredefinedType;
		Maybe< IfcLabel::Out > Status;
		Maybe< IfcText::Out > LongDescription;
    };

    // C++ wrapper for IfcPile
    struct IfcPile : IfcBuildingElement, ObjectHelper<IfcPile,2> { IfcPile() : Object("IfcPile") {}
		Maybe< IfcPileTypeEnum::Out > PredefinedType;
		Maybe< IfcPileConstructionEnum::Out > ConstructionType;
    };

    // C++ wrapper for IfcPileType
    struct IfcPileType : IfcBuildingElementType, ObjectHelper<IfcPileType,1> { IfcPileType() : Object("IfcPileType") {}
		IfcPileTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcPipeFitting
    struct IfcPipeFitting : IfcFlowFitting, ObjectHelper<IfcPipeFitting,1> { IfcPipeFitting() : Object("IfcPipeFitting") {}
		Maybe< IfcPipeFittingTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcPipeFittingType
    struct IfcPipeFittingType : IfcFlowFittingType, ObjectHelper<IfcPipeFittingType,1> { IfcPipeFittingType() : Object("IfcPipeFittingType") {}
		IfcPipeFittingTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcPipeSegment
    struct IfcPipeSegment : IfcFlowSegment, ObjectHelper<IfcPipeSegment,1> { IfcPipeSegment() : Object("IfcPipeSegment") {}
		Maybe< IfcPipeSegmentTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcPipeSegmentType
    struct IfcPipeSegmentType : IfcFlowSegmentType, ObjectHelper<IfcPipeSegmentType,1> { IfcPipeSegmentType() : Object("IfcPipeSegmentType") {}
		IfcPipeSegmentTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcPlanarExtent
    struct IfcPlanarExtent : IfcGeometricRepresentationItem, ObjectHelper<IfcPlanarExtent,2> { IfcPlanarExtent() : Object("IfcPlanarExtent") {}
		IfcLengthMeasure::Out SizeInX;
		IfcLengthMeasure::Out SizeInY;
    };

    // C++ wrapper for IfcPlanarBox
    struct IfcPlanarBox : IfcPlanarExtent, ObjectHelper<IfcPlanarBox,1> { IfcPlanarBox() : Object("IfcPlanarBox") {}
		IfcAxis2Placement::Out Placement;
    };

    // C++ wrapper for IfcPlane
    struct IfcPlane : IfcElementarySurface, ObjectHelper<IfcPlane,0> { IfcPlane() : Object("IfcPlane") {}

    };

    // C++ wrapper for IfcPlate
    struct IfcPlate : IfcBuildingElement, ObjectHelper<IfcPlate,1> { IfcPlate() : Object("IfcPlate") {}
		Maybe< IfcPlateTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcPlateStandardCase
    struct IfcPlateStandardCase : IfcPlate, ObjectHelper<IfcPlateStandardCase,0> { IfcPlateStandardCase() : Object("IfcPlateStandardCase") {}

    };

    // C++ wrapper for IfcPlateType
    struct IfcPlateType : IfcBuildingElementType, ObjectHelper<IfcPlateType,1> { IfcPlateType() : Object("IfcPlateType") {}
		IfcPlateTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcPointOnCurve
    struct IfcPointOnCurve : IfcPoint, ObjectHelper<IfcPointOnCurve,2> { IfcPointOnCurve() : Object("IfcPointOnCurve") {}
		Lazy< IfcCurve > BasisCurve;
		IfcParameterValue::Out PointParameter;
    };

    // C++ wrapper for IfcPointOnSurface
    struct IfcPointOnSurface : IfcPoint, ObjectHelper<IfcPointOnSurface,3> { IfcPointOnSurface() : Object("IfcPointOnSurface") {}
		Lazy< IfcSurface > BasisSurface;
		IfcParameterValue::Out PointParameterU;
		IfcParameterValue::Out PointParameterV;
    };

    // C++ wrapper for IfcPolyLoop
    struct IfcPolyLoop : IfcLoop, ObjectHelper<IfcPolyLoop,1> { IfcPolyLoop() : Object("IfcPolyLoop") {}
		ListOf< Lazy< IfcCartesianPoint >, 3, 0 > Polygon;
    };

    // C++ wrapper for IfcPolygonalBoundedHalfSpace
    struct IfcPolygonalBoundedHalfSpace : IfcHalfSpaceSolid, ObjectHelper<IfcPolygonalBoundedHalfSpace,2> { IfcPolygonalBoundedHalfSpace() : Object("IfcPolygonalBoundedHalfSpace") {}
		Lazy< IfcAxis2Placement3D > Position;
		Lazy< IfcBoundedCurve > PolygonalBoundary;
    };

    // C++ wrapper for IfcTessellatedFaceSet
    struct IfcTessellatedFaceSet : IfcTessellatedItem, ObjectHelper<IfcTessellatedFaceSet,1> { IfcTessellatedFaceSet() : Object("IfcTessellatedFaceSet") {}
		Lazy< IfcCartesianPointList3D > Coordinates;
    };

    // C++ wrapper for IfcPolygonalFaceSet
    struct IfcPolygonalFaceSet : IfcTessellatedFaceSet, ObjectHelper<IfcPolygonalFaceSet,3> { IfcPolygonalFaceSet() : Object("IfcPolygonalFaceSet") {}
		Maybe< IfcBoolean::Out > Closed;
		ListOf< Lazy< IfcIndexedPolygonalFace >, 1, 0 > Faces;
		Maybe< ListOf< IfcPositiveInteger, 1, 0 >::Out > PnIndex;
    };

    // C++ wrapper for IfcPolyline
    struct IfcPolyline : IfcBoundedCurve, ObjectHelper<IfcPolyline,1> { IfcPolyline() : Object("IfcPolyline") {}
		ListOf< Lazy< IfcCartesianPoint >, 2, 0 > Points;
    };

    // C++ wrapper for IfcPresentationStyleAssignment
    struct IfcPresentationStyleAssignment :  ObjectHelper<IfcPresentationStyleAssignment,1> { IfcPresentationStyleAssignment() : Object("IfcPresentationStyleAssignment") {}
		ListOf< IfcPresentationStyleSelect, 1, 0 >::Out Styles;
    };

    // C++ wrapper for IfcProcedure
    struct IfcProcedure : IfcProcess, ObjectHelper<IfcProcedure,1> { IfcProcedure() : Object("IfcProcedure") {}
		Maybe< IfcProcedureTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcProcedureType
    struct IfcProcedureType : IfcTypeProcess, ObjectHelper<IfcProcedureType,1> { IfcProcedureType() : Object("IfcProcedureType") {}
		IfcProcedureTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcProductDefinitionShape
    struct IfcProductDefinitionShape : IfcProductRepresentation, ObjectHelper<IfcProductDefinitionShape,0> { IfcProductDefinitionShape() : Object("IfcProductDefinitionShape") {}

    };

    // C++ wrapper for IfcProject
    struct IfcProject : IfcContext, ObjectHelper<IfcProject,0> { IfcProject() : Object("IfcProject") {}

    };

    // C++ wrapper for IfcProjectLibrary
    struct IfcProjectLibrary : IfcContext, ObjectHelper<IfcProjectLibrary,0> { IfcProjectLibrary() : Object("IfcProjectLibrary") {}

    };

    // C++ wrapper for IfcProjectOrder
    struct IfcProjectOrder : IfcControl, ObjectHelper<IfcProjectOrder,3> { IfcProjectOrder() : Object("IfcProjectOrder") {}
		Maybe< IfcProjectOrderTypeEnum::Out > PredefinedType;
		Maybe< IfcLabel::Out > Status;
		Maybe< IfcText::Out > LongDescription;
    };

    // C++ wrapper for IfcProjectionElement
    struct IfcProjectionElement : IfcFeatureElementAddition, ObjectHelper<IfcProjectionElement,1> { IfcProjectionElement() : Object("IfcProjectionElement") {}
		Maybe< IfcProjectionElementTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcSimpleProperty
    struct IfcSimpleProperty : IfcProperty, ObjectHelper<IfcSimpleProperty,0> { IfcSimpleProperty() : Object("IfcSimpleProperty") {}

    };

    // C++ wrapper for IfcPropertyBoundedValue
    struct IfcPropertyBoundedValue : IfcSimpleProperty, ObjectHelper<IfcPropertyBoundedValue,4> { IfcPropertyBoundedValue() : Object("IfcPropertyBoundedValue") {}
		Maybe< IfcValue::Out > UpperBoundValue;
		Maybe< IfcValue::Out > LowerBoundValue;
		Maybe< IfcUnit::Out > Unit;
		Maybe< IfcValue::Out > SetPointValue;
    };

    // C++ wrapper for IfcPropertyEnumeratedValue
    struct IfcPropertyEnumeratedValue : IfcSimpleProperty, ObjectHelper<IfcPropertyEnumeratedValue,2> { IfcPropertyEnumeratedValue() : Object("IfcPropertyEnumeratedValue") {}
		Maybe< ListOf< IfcValue, 1, 0 >::Out > EnumerationValues;
		Maybe< Lazy< NotImplemented > > EnumerationReference;
    };

    // C++ wrapper for IfcPropertyListValue
    struct IfcPropertyListValue : IfcSimpleProperty, ObjectHelper<IfcPropertyListValue,2> { IfcPropertyListValue() : Object("IfcPropertyListValue") {}
		Maybe< ListOf< IfcValue, 1, 0 >::Out > ListValues;
		Maybe< IfcUnit::Out > Unit;
    };

    // C++ wrapper for IfcPropertyReferenceValue
    struct IfcPropertyReferenceValue : IfcSimpleProperty, ObjectHelper<IfcPropertyReferenceValue,2> { IfcPropertyReferenceValue() : Object("IfcPropertyReferenceValue") {}
		Maybe< IfcText::Out > UsageName;
		Maybe< IfcObjectReferenceSelect::Out > PropertyReference;
    };

    // C++ wrapper for IfcPropertySet
    struct IfcPropertySet : IfcPropertySetDefinition, ObjectHelper<IfcPropertySet,1> { IfcPropertySet() : Object("IfcPropertySet") {}
		ListOf< Lazy< IfcProperty >, 1, 0 > HasProperties;
    };

    // C++ wrapper for IfcPropertySingleValue
    struct IfcPropertySingleValue : IfcSimpleProperty, ObjectHelper<IfcPropertySingleValue,2> { IfcPropertySingleValue() : Object("IfcPropertySingleValue") {}
		Maybe< IfcValue::Out > NominalValue;
		Maybe< IfcUnit::Out > Unit;
    };

    // C++ wrapper for IfcPropertyTableValue
    struct IfcPropertyTableValue : IfcSimpleProperty, ObjectHelper<IfcPropertyTableValue,6> { IfcPropertyTableValue() : Object("IfcPropertyTableValue") {}
		Maybe< ListOf< IfcValue, 1, 0 >::Out > DefiningValues;
		Maybe< ListOf< IfcValue, 1, 0 >::Out > DefinedValues;
		Maybe< IfcText::Out > Expression;
		Maybe< IfcUnit::Out > DefiningUnit;
		Maybe< IfcUnit::Out > DefinedUnit;
		Maybe< IfcCurveInterpolationEnum::Out > CurveInterpolation;
    };

    // C++ wrapper for IfcProtectiveDevice
    struct IfcProtectiveDevice : IfcFlowController, ObjectHelper<IfcProtectiveDevice,1> { IfcProtectiveDevice() : Object("IfcProtectiveDevice") {}
		Maybe< IfcProtectiveDeviceTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcProtectiveDeviceTrippingUnit
    struct IfcProtectiveDeviceTrippingUnit : IfcDistributionControlElement, ObjectHelper<IfcProtectiveDeviceTrippingUnit,1> { IfcProtectiveDeviceTrippingUnit() : Object("IfcProtectiveDeviceTrippingUnit") {}
		Maybe< IfcProtectiveDeviceTrippingUnitTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcProtectiveDeviceTrippingUnitType
    struct IfcProtectiveDeviceTrippingUnitType : IfcDistributionControlElementType, ObjectHelper<IfcProtectiveDeviceTrippingUnitType,1> { IfcProtectiveDeviceTrippingUnitType() : Object("IfcProtectiveDeviceTrippingUnitType") {}
		IfcProtectiveDeviceTrippingUnitTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcProtectiveDeviceType
    struct IfcProtectiveDeviceType : IfcFlowControllerType, ObjectHelper<IfcProtectiveDeviceType,1> { IfcProtectiveDeviceType() : Object("IfcProtectiveDeviceType") {}
		IfcProtectiveDeviceTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcProxy
    struct IfcProxy : IfcProduct, ObjectHelper<IfcProxy,2> { IfcProxy() : Object("IfcProxy") {}
		IfcObjectTypeEnum::Out ProxyType;
		Maybe< IfcLabel::Out > Tag;
    };

    // C++ wrapper for IfcPump
    struct IfcPump : IfcFlowMovingDevice, ObjectHelper<IfcPump,1> { IfcPump() : Object("IfcPump") {}
		Maybe< IfcPumpTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcPumpType
    struct IfcPumpType : IfcFlowMovingDeviceType, ObjectHelper<IfcPumpType,1> { IfcPumpType() : Object("IfcPumpType") {}
		IfcPumpTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcRailing
    struct IfcRailing : IfcBuildingElement, ObjectHelper<IfcRailing,1> { IfcRailing() : Object("IfcRailing") {}
		Maybe< IfcRailingTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcRailingType
    struct IfcRailingType : IfcBuildingElementType, ObjectHelper<IfcRailingType,1> { IfcRailingType() : Object("IfcRailingType") {}
		IfcRailingTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcRamp
    struct IfcRamp : IfcBuildingElement, ObjectHelper<IfcRamp,1> { IfcRamp() : Object("IfcRamp") {}
		Maybe< IfcRampTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcRampFlight
    struct IfcRampFlight : IfcBuildingElement, ObjectHelper<IfcRampFlight,1> { IfcRampFlight() : Object("IfcRampFlight") {}
		Maybe< IfcRampFlightTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcRampFlightType
    struct IfcRampFlightType : IfcBuildingElementType, ObjectHelper<IfcRampFlightType,1> { IfcRampFlightType() : Object("IfcRampFlightType") {}
		IfcRampFlightTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcRampType
    struct IfcRampType : IfcBuildingElementType, ObjectHelper<IfcRampType,1> { IfcRampType() : Object("IfcRampType") {}
		IfcRampTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcRationalBSplineCurveWithKnots
    struct IfcRationalBSplineCurveWithKnots : IfcBSplineCurveWithKnots, ObjectHelper<IfcRationalBSplineCurveWithKnots,1> { IfcRationalBSplineCurveWithKnots() : Object("IfcRationalBSplineCurveWithKnots") {}
		ListOf< IfcReal, 2, 0 >::Out WeightsData;
    };

    // C++ wrapper for IfcRationalBSplineSurfaceWithKnots
    struct IfcRationalBSplineSurfaceWithKnots : IfcBSplineSurfaceWithKnots, ObjectHelper<IfcRationalBSplineSurfaceWithKnots,0> { IfcRationalBSplineSurfaceWithKnots() : Object("IfcRationalBSplineSurfaceWithKnots") {}

    };

    // C++ wrapper for IfcRectangleProfileDef
    struct IfcRectangleProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcRectangleProfileDef,2> { IfcRectangleProfileDef() : Object("IfcRectangleProfileDef") {}
		IfcPositiveLengthMeasure::Out XDim;
		IfcPositiveLengthMeasure::Out YDim;
    };

    // C++ wrapper for IfcRectangleHollowProfileDef
    struct IfcRectangleHollowProfileDef : IfcRectangleProfileDef, ObjectHelper<IfcRectangleHollowProfileDef,3> { IfcRectangleHollowProfileDef() : Object("IfcRectangleHollowProfileDef") {}
		IfcPositiveLengthMeasure::Out WallThickness;
		Maybe< IfcNonNegativeLengthMeasure::Out > InnerFilletRadius;
		Maybe< IfcNonNegativeLengthMeasure::Out > OuterFilletRadius;
    };

    // C++ wrapper for IfcRectangularPyramid
    struct IfcRectangularPyramid : IfcCsgPrimitive3D, ObjectHelper<IfcRectangularPyramid,3> { IfcRectangularPyramid() : Object("IfcRectangularPyramid") {}
		IfcPositiveLengthMeasure::Out XLength;
		IfcPositiveLengthMeasure::Out YLength;
		IfcPositiveLengthMeasure::Out Height;
    };

    // C++ wrapper for IfcRectangularTrimmedSurface
    struct IfcRectangularTrimmedSurface : IfcBoundedSurface, ObjectHelper<IfcRectangularTrimmedSurface,7> { IfcRectangularTrimmedSurface() : Object("IfcRectangularTrimmedSurface") {}
		Lazy< IfcSurface > BasisSurface;
		IfcParameterValue::Out U1;
		IfcParameterValue::Out V1;
		IfcParameterValue::Out U2;
		IfcParameterValue::Out V2;
		IfcBoolean::Out Usense;
		IfcBoolean::Out Vsense;
    };

    // C++ wrapper for IfcReinforcingElement
    struct IfcReinforcingElement : IfcElementComponent, ObjectHelper<IfcReinforcingElement,1> { IfcReinforcingElement() : Object("IfcReinforcingElement") {}
		Maybe< IfcLabel::Out > SteelGrade;
    };

    // C++ wrapper for IfcReinforcingBar
    struct IfcReinforcingBar : IfcReinforcingElement, ObjectHelper<IfcReinforcingBar,5> { IfcReinforcingBar() : Object("IfcReinforcingBar") {}
		Maybe< IfcPositiveLengthMeasure::Out > NominalDiameter;
		Maybe< IfcAreaMeasure::Out > CrossSectionArea;
		Maybe< IfcPositiveLengthMeasure::Out > BarLength;
		Maybe< IfcReinforcingBarTypeEnum::Out > PredefinedType;
		Maybe< IfcReinforcingBarSurfaceEnum::Out > BarSurface;
    };

    // C++ wrapper for IfcReinforcingElementType
    struct IfcReinforcingElementType : IfcElementComponentType, ObjectHelper<IfcReinforcingElementType,0> { IfcReinforcingElementType() : Object("IfcReinforcingElementType") {}

    };

    // C++ wrapper for IfcReinforcingBarType
    struct IfcReinforcingBarType : IfcReinforcingElementType, ObjectHelper<IfcReinforcingBarType,7> { IfcReinforcingBarType() : Object("IfcReinforcingBarType") {}
		IfcReinforcingBarTypeEnum::Out PredefinedType;
		Maybe< IfcPositiveLengthMeasure::Out > NominalDiameter;
		Maybe< IfcAreaMeasure::Out > CrossSectionArea;
		Maybe< IfcPositiveLengthMeasure::Out > BarLength;
		Maybe< IfcReinforcingBarSurfaceEnum::Out > BarSurface;
		Maybe< IfcLabel::Out > BendingShapeCode;
		Maybe< ListOf< IfcBendingParameterSelect, 1, 0 >::Out > BendingParameters;
    };

    // C++ wrapper for IfcReinforcingMesh
    struct IfcReinforcingMesh : IfcReinforcingElement, ObjectHelper<IfcReinforcingMesh,9> { IfcReinforcingMesh() : Object("IfcReinforcingMesh") {}
		Maybe< IfcPositiveLengthMeasure::Out > MeshLength;
		Maybe< IfcPositiveLengthMeasure::Out > MeshWidth;
		Maybe< IfcPositiveLengthMeasure::Out > LongitudinalBarNominalDiameter;
		Maybe< IfcPositiveLengthMeasure::Out > TransverseBarNominalDiameter;
		Maybe< IfcAreaMeasure::Out > LongitudinalBarCrossSectionArea;
		Maybe< IfcAreaMeasure::Out > TransverseBarCrossSectionArea;
		Maybe< IfcPositiveLengthMeasure::Out > LongitudinalBarSpacing;
		Maybe< IfcPositiveLengthMeasure::Out > TransverseBarSpacing;
		Maybe< IfcReinforcingMeshTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcReinforcingMeshType
    struct IfcReinforcingMeshType : IfcReinforcingElementType, ObjectHelper<IfcReinforcingMeshType,11> { IfcReinforcingMeshType() : Object("IfcReinforcingMeshType") {}
		IfcReinforcingMeshTypeEnum::Out PredefinedType;
		Maybe< IfcPositiveLengthMeasure::Out > MeshLength;
		Maybe< IfcPositiveLengthMeasure::Out > MeshWidth;
		Maybe< IfcPositiveLengthMeasure::Out > LongitudinalBarNominalDiameter;
		Maybe< IfcPositiveLengthMeasure::Out > TransverseBarNominalDiameter;
		Maybe< IfcAreaMeasure::Out > LongitudinalBarCrossSectionArea;
		Maybe< IfcAreaMeasure::Out > TransverseBarCrossSectionArea;
		Maybe< IfcPositiveLengthMeasure::Out > LongitudinalBarSpacing;
		Maybe< IfcPositiveLengthMeasure::Out > TransverseBarSpacing;
		Maybe< IfcLabel::Out > BendingShapeCode;
		Maybe< ListOf< IfcBendingParameterSelect, 1, 0 >::Out > BendingParameters;
    };

    // C++ wrapper for IfcRelationship
    struct IfcRelationship : IfcRoot, ObjectHelper<IfcRelationship,0> { IfcRelationship() : Object("IfcRelationship") {}

    };

    // C++ wrapper for IfcRelDecomposes
    struct IfcRelDecomposes : IfcRelationship, ObjectHelper<IfcRelDecomposes,0> { IfcRelDecomposes() : Object("IfcRelDecomposes") {}

    };

    // C++ wrapper for IfcRelAggregates
    struct IfcRelAggregates : IfcRelDecomposes, ObjectHelper<IfcRelAggregates,2> { IfcRelAggregates() : Object("IfcRelAggregates") {}
		Lazy< IfcObjectDefinition > RelatingObject;
		ListOf< Lazy< IfcObjectDefinition >, 1, 0 > RelatedObjects;
    };

    // C++ wrapper for IfcRelConnects
    struct IfcRelConnects : IfcRelationship, ObjectHelper<IfcRelConnects,0> { IfcRelConnects() : Object("IfcRelConnects") {}

    };

    // C++ wrapper for IfcRelContainedInSpatialStructure
    struct IfcRelContainedInSpatialStructure : IfcRelConnects, ObjectHelper<IfcRelContainedInSpatialStructure,2> { IfcRelContainedInSpatialStructure() : Object("IfcRelContainedInSpatialStructure") {}
		ListOf< Lazy< IfcProduct >, 1, 0 > RelatedElements;
		Lazy< IfcSpatialElement > RelatingStructure;
    };

    // C++ wrapper for IfcRelDefines
    struct IfcRelDefines : IfcRelationship, ObjectHelper<IfcRelDefines,0> { IfcRelDefines() : Object("IfcRelDefines") {}

    };

    // C++ wrapper for IfcRelDefinesByProperties
    struct IfcRelDefinesByProperties : IfcRelDefines, ObjectHelper<IfcRelDefinesByProperties,2> { IfcRelDefinesByProperties() : Object("IfcRelDefinesByProperties") {}
		ListOf< Lazy< IfcObjectDefinition >, 1, 0 > RelatedObjects;
		IfcPropertySetDefinitionSelect::Out RelatingPropertyDefinition;
    };

    // C++ wrapper for IfcRelFillsElement
    struct IfcRelFillsElement : IfcRelConnects, ObjectHelper<IfcRelFillsElement,2> { IfcRelFillsElement() : Object("IfcRelFillsElement") {}
		Lazy< IfcOpeningElement > RelatingOpeningElement;
		Lazy< IfcElement > RelatedBuildingElement;
    };

    // C++ wrapper for IfcRelVoidsElement
    struct IfcRelVoidsElement : IfcRelDecomposes, ObjectHelper<IfcRelVoidsElement,2> { IfcRelVoidsElement() : Object("IfcRelVoidsElement") {}
		Lazy< IfcElement > RelatingBuildingElement;
		Lazy< IfcFeatureElementSubtraction > RelatedOpeningElement;
    };

    // C++ wrapper for IfcReparametrisedCompositeCurveSegment
    struct IfcReparametrisedCompositeCurveSegment : IfcCompositeCurveSegment, ObjectHelper<IfcReparametrisedCompositeCurveSegment,1> { IfcReparametrisedCompositeCurveSegment() : Object("IfcReparametrisedCompositeCurveSegment") {}
		IfcParameterValue::Out ParamLength;
    };

    // C++ wrapper for IfcRepresentation
    struct IfcRepresentation :  ObjectHelper<IfcRepresentation,4> { IfcRepresentation() : Object("IfcRepresentation") {}
		Lazy< IfcRepresentationContext > ContextOfItems;
		Maybe< IfcLabel::Out > RepresentationIdentifier;
		Maybe< IfcLabel::Out > RepresentationType;
		ListOf< Lazy< IfcRepresentationItem >, 1, 0 > Items;
    };

    // C++ wrapper for IfcRepresentationMap
    struct IfcRepresentationMap :  ObjectHelper<IfcRepresentationMap,2> { IfcRepresentationMap() : Object("IfcRepresentationMap") {}
		IfcAxis2Placement::Out MappingOrigin;
		Lazy< IfcRepresentation > MappedRepresentation;
    };

    // C++ wrapper for IfcRevolvedAreaSolid
    struct IfcRevolvedAreaSolid : IfcSweptAreaSolid, ObjectHelper<IfcRevolvedAreaSolid,2> { IfcRevolvedAreaSolid() : Object("IfcRevolvedAreaSolid") {}
		Lazy< IfcAxis1Placement > Axis;
		IfcPlaneAngleMeasure::Out Angle;
    };

    // C++ wrapper for IfcRevolvedAreaSolidTapered
    struct IfcRevolvedAreaSolidTapered : IfcRevolvedAreaSolid, ObjectHelper<IfcRevolvedAreaSolidTapered,1> { IfcRevolvedAreaSolidTapered() : Object("IfcRevolvedAreaSolidTapered") {}
		Lazy< IfcProfileDef > EndSweptArea;
    };

    // C++ wrapper for IfcRightCircularCone
    struct IfcRightCircularCone : IfcCsgPrimitive3D, ObjectHelper<IfcRightCircularCone,2> { IfcRightCircularCone() : Object("IfcRightCircularCone") {}
		IfcPositiveLengthMeasure::Out Height;
		IfcPositiveLengthMeasure::Out BottomRadius;
    };

    // C++ wrapper for IfcRightCircularCylinder
    struct IfcRightCircularCylinder : IfcCsgPrimitive3D, ObjectHelper<IfcRightCircularCylinder,2> { IfcRightCircularCylinder() : Object("IfcRightCircularCylinder") {}
		IfcPositiveLengthMeasure::Out Height;
		IfcPositiveLengthMeasure::Out Radius;
    };

    // C++ wrapper for IfcRoof
    struct IfcRoof : IfcBuildingElement, ObjectHelper<IfcRoof,1> { IfcRoof() : Object("IfcRoof") {}
		Maybe< IfcRoofTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcRoofType
    struct IfcRoofType : IfcBuildingElementType, ObjectHelper<IfcRoofType,1> { IfcRoofType() : Object("IfcRoofType") {}
		IfcRoofTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcRoundedRectangleProfileDef
    struct IfcRoundedRectangleProfileDef : IfcRectangleProfileDef, ObjectHelper<IfcRoundedRectangleProfileDef,1> { IfcRoundedRectangleProfileDef() : Object("IfcRoundedRectangleProfileDef") {}
		IfcPositiveLengthMeasure::Out RoundingRadius;
    };

    // C++ wrapper for IfcSIUnit
    struct IfcSIUnit : IfcNamedUnit, ObjectHelper<IfcSIUnit,2> { IfcSIUnit() : Object("IfcSIUnit") {}
		Maybe< IfcSIPrefix::Out > Prefix;
		IfcSIUnitName::Out Name;
    };

    // C++ wrapper for IfcSanitaryTerminal
    struct IfcSanitaryTerminal : IfcFlowTerminal, ObjectHelper<IfcSanitaryTerminal,1> { IfcSanitaryTerminal() : Object("IfcSanitaryTerminal") {}
		Maybe< IfcSanitaryTerminalTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcSanitaryTerminalType
    struct IfcSanitaryTerminalType : IfcFlowTerminalType, ObjectHelper<IfcSanitaryTerminalType,1> { IfcSanitaryTerminalType() : Object("IfcSanitaryTerminalType") {}
		IfcSanitaryTerminalTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcSeamCurve
    struct IfcSeamCurve : IfcSurfaceCurve, ObjectHelper<IfcSeamCurve,0> { IfcSeamCurve() : Object("IfcSeamCurve") {}

    };

    // C++ wrapper for IfcSectionedSpine
    struct IfcSectionedSpine : IfcGeometricRepresentationItem, ObjectHelper<IfcSectionedSpine,3> { IfcSectionedSpine() : Object("IfcSectionedSpine") {}
		Lazy< IfcCompositeCurve > SpineCurve;
		ListOf< Lazy< IfcProfileDef >, 2, 0 > CrossSections;
		ListOf< Lazy< IfcAxis2Placement3D >, 2, 0 > CrossSectionPositions;
    };

    // C++ wrapper for IfcSensor
    struct IfcSensor : IfcDistributionControlElement, ObjectHelper<IfcSensor,1> { IfcSensor() : Object("IfcSensor") {}
		Maybe< IfcSensorTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcSensorType
    struct IfcSensorType : IfcDistributionControlElementType, ObjectHelper<IfcSensorType,1> { IfcSensorType() : Object("IfcSensorType") {}
		IfcSensorTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcShadingDevice
    struct IfcShadingDevice : IfcBuildingElement, ObjectHelper<IfcShadingDevice,1> { IfcShadingDevice() : Object("IfcShadingDevice") {}
		Maybe< IfcShadingDeviceTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcShadingDeviceType
    struct IfcShadingDeviceType : IfcBuildingElementType, ObjectHelper<IfcShadingDeviceType,1> { IfcShadingDeviceType() : Object("IfcShadingDeviceType") {}
		IfcShadingDeviceTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcShapeModel
    struct IfcShapeModel : IfcRepresentation, ObjectHelper<IfcShapeModel,0> { IfcShapeModel() : Object("IfcShapeModel") {}

    };

    // C++ wrapper for IfcShapeRepresentation
    struct IfcShapeRepresentation : IfcShapeModel, ObjectHelper<IfcShapeRepresentation,0> { IfcShapeRepresentation() : Object("IfcShapeRepresentation") {}

    };

    // C++ wrapper for IfcShellBasedSurfaceModel
    struct IfcShellBasedSurfaceModel : IfcGeometricRepresentationItem, ObjectHelper<IfcShellBasedSurfaceModel,1> { IfcShellBasedSurfaceModel() : Object("IfcShellBasedSurfaceModel") {}
		ListOf< IfcShell, 1, 0 >::Out SbsmBoundary;
    };

    // C++ wrapper for IfcSite
    struct IfcSite : IfcSpatialStructureElement, ObjectHelper<IfcSite,5> { IfcSite() : Object("IfcSite") {}
		Maybe< IfcCompoundPlaneAngleMeasure::Out > RefLatitude;
		Maybe< IfcCompoundPlaneAngleMeasure::Out > RefLongitude;
		Maybe< IfcLengthMeasure::Out > RefElevation;
		Maybe< IfcLabel::Out > LandTitleNumber;
		Maybe< Lazy< NotImplemented > > SiteAddress;
    };

    // C++ wrapper for IfcSlab
    struct IfcSlab : IfcBuildingElement, ObjectHelper<IfcSlab,1> { IfcSlab() : Object("IfcSlab") {}
		Maybe< IfcSlabTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcSlabElementedCase
    struct IfcSlabElementedCase : IfcSlab, ObjectHelper<IfcSlabElementedCase,0> { IfcSlabElementedCase() : Object("IfcSlabElementedCase") {}

    };

    // C++ wrapper for IfcSlabStandardCase
    struct IfcSlabStandardCase : IfcSlab, ObjectHelper<IfcSlabStandardCase,0> { IfcSlabStandardCase() : Object("IfcSlabStandardCase") {}

    };

    // C++ wrapper for IfcSlabType
    struct IfcSlabType : IfcBuildingElementType, ObjectHelper<IfcSlabType,1> { IfcSlabType() : Object("IfcSlabType") {}
		IfcSlabTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcSolarDevice
    struct IfcSolarDevice : IfcEnergyConversionDevice, ObjectHelper<IfcSolarDevice,1> { IfcSolarDevice() : Object("IfcSolarDevice") {}
		Maybe< IfcSolarDeviceTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcSolarDeviceType
    struct IfcSolarDeviceType : IfcEnergyConversionDeviceType, ObjectHelper<IfcSolarDeviceType,1> { IfcSolarDeviceType() : Object("IfcSolarDeviceType") {}
		IfcSolarDeviceTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcSpace
    struct IfcSpace : IfcSpatialStructureElement, ObjectHelper<IfcSpace,2> { IfcSpace() : Object("IfcSpace") {}
		Maybe< IfcSpaceTypeEnum::Out > PredefinedType;
		Maybe< IfcLengthMeasure::Out > ElevationWithFlooring;
    };

    // C++ wrapper for IfcSpaceHeater
    struct IfcSpaceHeater : IfcFlowTerminal, ObjectHelper<IfcSpaceHeater,1> { IfcSpaceHeater() : Object("IfcSpaceHeater") {}
		Maybe< IfcSpaceHeaterTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcSpaceHeaterType
    struct IfcSpaceHeaterType : IfcFlowTerminalType, ObjectHelper<IfcSpaceHeaterType,1> { IfcSpaceHeaterType() : Object("IfcSpaceHeaterType") {}
		IfcSpaceHeaterTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcSpatialElementType
    struct IfcSpatialElementType : IfcTypeProduct, ObjectHelper<IfcSpatialElementType,1> { IfcSpatialElementType() : Object("IfcSpatialElementType") {}
		Maybe< IfcLabel::Out > ElementType;
    };

    // C++ wrapper for IfcSpatialStructureElementType
    struct IfcSpatialStructureElementType : IfcSpatialElementType, ObjectHelper<IfcSpatialStructureElementType,0> { IfcSpatialStructureElementType() : Object("IfcSpatialStructureElementType") {}

    };

    // C++ wrapper for IfcSpaceType
    struct IfcSpaceType : IfcSpatialStructureElementType, ObjectHelper<IfcSpaceType,2> { IfcSpaceType() : Object("IfcSpaceType") {}
		IfcSpaceTypeEnum::Out PredefinedType;
		Maybe< IfcLabel::Out > LongName;
    };

    // C++ wrapper for IfcSpatialZone
    struct IfcSpatialZone : IfcSpatialElement, ObjectHelper<IfcSpatialZone,1> { IfcSpatialZone() : Object("IfcSpatialZone") {}
		Maybe< IfcSpatialZoneTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcSpatialZoneType
    struct IfcSpatialZoneType : IfcSpatialElementType, ObjectHelper<IfcSpatialZoneType,2> { IfcSpatialZoneType() : Object("IfcSpatialZoneType") {}
		IfcSpatialZoneTypeEnum::Out PredefinedType;
		Maybe< IfcLabel::Out > LongName;
    };

    // C++ wrapper for IfcSphere
    struct IfcSphere : IfcCsgPrimitive3D, ObjectHelper<IfcSphere,1> { IfcSphere() : Object("IfcSphere") {}
		IfcPositiveLengthMeasure::Out Radius;
    };

    // C++ wrapper for IfcSphericalSurface
    struct IfcSphericalSurface : IfcElementarySurface, ObjectHelper<IfcSphericalSurface,1> { IfcSphericalSurface() : Object("IfcSphericalSurface") {}
		IfcPositiveLengthMeasure::Out Radius;
    };

    // C++ wrapper for IfcStackTerminal
    struct IfcStackTerminal : IfcFlowTerminal, ObjectHelper<IfcStackTerminal,1> { IfcStackTerminal() : Object("IfcStackTerminal") {}
		Maybe< IfcStackTerminalTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcStackTerminalType
    struct IfcStackTerminalType : IfcFlowTerminalType, ObjectHelper<IfcStackTerminalType,1> { IfcStackTerminalType() : Object("IfcStackTerminalType") {}
		IfcStackTerminalTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcStair
    struct IfcStair : IfcBuildingElement, ObjectHelper<IfcStair,1> { IfcStair() : Object("IfcStair") {}
		Maybe< IfcStairTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcStairFlight
    struct IfcStairFlight : IfcBuildingElement, ObjectHelper<IfcStairFlight,5> { IfcStairFlight() : Object("IfcStairFlight") {}
		Maybe< IfcInteger::Out > NumberOfRisers;
		Maybe< IfcInteger::Out > NumberOfTreads;
		Maybe< IfcPositiveLengthMeasure::Out > RiserHeight;
		Maybe< IfcPositiveLengthMeasure::Out > TreadLength;
		Maybe< IfcStairFlightTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcStairFlightType
    struct IfcStairFlightType : IfcBuildingElementType, ObjectHelper<IfcStairFlightType,1> { IfcStairFlightType() : Object("IfcStairFlightType") {}
		IfcStairFlightTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcStairType
    struct IfcStairType : IfcBuildingElementType, ObjectHelper<IfcStairType,1> { IfcStairType() : Object("IfcStairType") {}
		IfcStairTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcStructuralActivity
    struct IfcStructuralActivity : IfcProduct, ObjectHelper<IfcStructuralActivity,2> { IfcStructuralActivity() : Object("IfcStructuralActivity") {}
		Lazy< NotImplemented > AppliedLoad;
		IfcGlobalOrLocalEnum::Out GlobalOrLocal;
    };

    // C++ wrapper for IfcStructuralAction
    struct IfcStructuralAction : IfcStructuralActivity, ObjectHelper<IfcStructuralAction,1> { IfcStructuralAction() : Object("IfcStructuralAction") {}
		Maybe< IfcBoolean::Out > DestabilizingLoad;
    };

    // C++ wrapper for IfcStructuralAnalysisModel
    struct IfcStructuralAnalysisModel : IfcSystem, ObjectHelper<IfcStructuralAnalysisModel,5> { IfcStructuralAnalysisModel() : Object("IfcStructuralAnalysisModel") {}
		IfcAnalysisModelTypeEnum::Out PredefinedType;
		Maybe< Lazy< IfcAxis2Placement3D > > OrientationOf2DPlane;
		Maybe< ListOf< Lazy< IfcStructuralLoadGroup >, 1, 0 > > LoadedBy;
		Maybe< ListOf< Lazy< IfcStructuralResultGroup >, 1, 0 > > HasResults;
		Maybe< Lazy< IfcObjectPlacement > > SharedPlacement;
    };

    // C++ wrapper for IfcStructuralItem
    struct IfcStructuralItem : IfcProduct, ObjectHelper<IfcStructuralItem,0> { IfcStructuralItem() : Object("IfcStructuralItem") {}

    };

    // C++ wrapper for IfcStructuralConnection
    struct IfcStructuralConnection : IfcStructuralItem, ObjectHelper<IfcStructuralConnection,1> { IfcStructuralConnection() : Object("IfcStructuralConnection") {}
		Maybe< Lazy< NotImplemented > > AppliedCondition;
    };

    // C++ wrapper for IfcStructuralCurveAction
    struct IfcStructuralCurveAction : IfcStructuralAction, ObjectHelper<IfcStructuralCurveAction,2> { IfcStructuralCurveAction() : Object("IfcStructuralCurveAction") {}
		Maybe< IfcProjectedOrTrueLengthEnum::Out > ProjectedOrTrue;
		IfcStructuralCurveActivityTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcStructuralCurveConnection
    struct IfcStructuralCurveConnection : IfcStructuralConnection, ObjectHelper<IfcStructuralCurveConnection,1> { IfcStructuralCurveConnection() : Object("IfcStructuralCurveConnection") {}
		Lazy< IfcDirection > Axis;
    };

    // C++ wrapper for IfcStructuralMember
    struct IfcStructuralMember : IfcStructuralItem, ObjectHelper<IfcStructuralMember,0> { IfcStructuralMember() : Object("IfcStructuralMember") {}

    };

    // C++ wrapper for IfcStructuralCurveMember
    struct IfcStructuralCurveMember : IfcStructuralMember, ObjectHelper<IfcStructuralCurveMember,2> { IfcStructuralCurveMember() : Object("IfcStructuralCurveMember") {}
		IfcStructuralCurveMemberTypeEnum::Out PredefinedType;
		Lazy< IfcDirection > Axis;
    };

    // C++ wrapper for IfcStructuralCurveMemberVarying
    struct IfcStructuralCurveMemberVarying : IfcStructuralCurveMember, ObjectHelper<IfcStructuralCurveMemberVarying,0> { IfcStructuralCurveMemberVarying() : Object("IfcStructuralCurveMemberVarying") {}

    };

    // C++ wrapper for IfcStructuralReaction
    struct IfcStructuralReaction : IfcStructuralActivity, ObjectHelper<IfcStructuralReaction,0> { IfcStructuralReaction() : Object("IfcStructuralReaction") {}

    };

    // C++ wrapper for IfcStructuralCurveReaction
    struct IfcStructuralCurveReaction : IfcStructuralReaction, ObjectHelper<IfcStructuralCurveReaction,1> { IfcStructuralCurveReaction() : Object("IfcStructuralCurveReaction") {}
		IfcStructuralCurveActivityTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcStructuralLinearAction
    struct IfcStructuralLinearAction : IfcStructuralCurveAction, ObjectHelper<IfcStructuralLinearAction,0> { IfcStructuralLinearAction() : Object("IfcStructuralLinearAction") {}

    };

    // C++ wrapper for IfcStructuralLoadGroup
    struct IfcStructuralLoadGroup : IfcGroup, ObjectHelper<IfcStructuralLoadGroup,5> { IfcStructuralLoadGroup() : Object("IfcStructuralLoadGroup") {}
		IfcLoadGroupTypeEnum::Out PredefinedType;
		IfcActionTypeEnum::Out ActionType;
		IfcActionSourceTypeEnum::Out ActionSource;
		Maybe< IfcRatioMeasure::Out > Coefficient;
		Maybe< IfcLabel::Out > Purpose;
    };

    // C++ wrapper for IfcStructuralLoadCase
    struct IfcStructuralLoadCase : IfcStructuralLoadGroup, ObjectHelper<IfcStructuralLoadCase,1> { IfcStructuralLoadCase() : Object("IfcStructuralLoadCase") {}
		Maybe< ListOf< IfcRatioMeasure, 3, 3 >::Out > SelfWeightCoefficients;
    };

    // C++ wrapper for IfcStructuralSurfaceAction
    struct IfcStructuralSurfaceAction : IfcStructuralAction, ObjectHelper<IfcStructuralSurfaceAction,2> { IfcStructuralSurfaceAction() : Object("IfcStructuralSurfaceAction") {}
		Maybe< IfcProjectedOrTrueLengthEnum::Out > ProjectedOrTrue;
		IfcStructuralSurfaceActivityTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcStructuralPlanarAction
    struct IfcStructuralPlanarAction : IfcStructuralSurfaceAction, ObjectHelper<IfcStructuralPlanarAction,0> { IfcStructuralPlanarAction() : Object("IfcStructuralPlanarAction") {}

    };

    // C++ wrapper for IfcStructuralPointAction
    struct IfcStructuralPointAction : IfcStructuralAction, ObjectHelper<IfcStructuralPointAction,0> { IfcStructuralPointAction() : Object("IfcStructuralPointAction") {}

    };

    // C++ wrapper for IfcStructuralPointConnection
    struct IfcStructuralPointConnection : IfcStructuralConnection, ObjectHelper<IfcStructuralPointConnection,1> { IfcStructuralPointConnection() : Object("IfcStructuralPointConnection") {}
		Maybe< Lazy< IfcAxis2Placement3D > > ConditionCoordinateSystem;
    };

    // C++ wrapper for IfcStructuralPointReaction
    struct IfcStructuralPointReaction : IfcStructuralReaction, ObjectHelper<IfcStructuralPointReaction,0> { IfcStructuralPointReaction() : Object("IfcStructuralPointReaction") {}

    };

    // C++ wrapper for IfcStructuralResultGroup
    struct IfcStructuralResultGroup : IfcGroup, ObjectHelper<IfcStructuralResultGroup,3> { IfcStructuralResultGroup() : Object("IfcStructuralResultGroup") {}
		IfcAnalysisTheoryTypeEnum::Out TheoryType;
		Maybe< Lazy< IfcStructuralLoadGroup > > ResultForLoadGroup;
		IfcBoolean::Out IsLinear;
    };

    // C++ wrapper for IfcStructuralSurfaceConnection
    struct IfcStructuralSurfaceConnection : IfcStructuralConnection, ObjectHelper<IfcStructuralSurfaceConnection,0> { IfcStructuralSurfaceConnection() : Object("IfcStructuralSurfaceConnection") {}

    };

    // C++ wrapper for IfcStructuralSurfaceMember
    struct IfcStructuralSurfaceMember : IfcStructuralMember, ObjectHelper<IfcStructuralSurfaceMember,2> { IfcStructuralSurfaceMember() : Object("IfcStructuralSurfaceMember") {}
		IfcStructuralSurfaceMemberTypeEnum::Out PredefinedType;
		Maybe< IfcPositiveLengthMeasure::Out > Thickness;
    };

    // C++ wrapper for IfcStructuralSurfaceMemberVarying
    struct IfcStructuralSurfaceMemberVarying : IfcStructuralSurfaceMember, ObjectHelper<IfcStructuralSurfaceMemberVarying,0> { IfcStructuralSurfaceMemberVarying() : Object("IfcStructuralSurfaceMemberVarying") {}

    };

    // C++ wrapper for IfcStructuralSurfaceReaction
    struct IfcStructuralSurfaceReaction : IfcStructuralReaction, ObjectHelper<IfcStructuralSurfaceReaction,1> { IfcStructuralSurfaceReaction() : Object("IfcStructuralSurfaceReaction") {}
		IfcStructuralSurfaceActivityTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcStyleModel
    struct IfcStyleModel : IfcRepresentation, ObjectHelper<IfcStyleModel,0> { IfcStyleModel() : Object("IfcStyleModel") {}

    };

    // C++ wrapper for IfcStyledItem
    struct IfcStyledItem : IfcRepresentationItem, ObjectHelper<IfcStyledItem,3> { IfcStyledItem() : Object("IfcStyledItem") {}
		Maybe< Lazy< IfcRepresentationItem > > Item;
		ListOf< IfcStyleAssignmentSelect, 1, 0 >::Out Styles;
		Maybe< IfcLabel::Out > Name;
    };

    // C++ wrapper for IfcStyledRepresentation
    struct IfcStyledRepresentation : IfcStyleModel, ObjectHelper<IfcStyledRepresentation,0> { IfcStyledRepresentation() : Object("IfcStyledRepresentation") {}

    };

    // C++ wrapper for IfcSubContractResource
    struct IfcSubContractResource : IfcConstructionResource, ObjectHelper<IfcSubContractResource,1> { IfcSubContractResource() : Object("IfcSubContractResource") {}
		Maybe< IfcSubContractResourceTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcSubContractResourceType
    struct IfcSubContractResourceType : IfcConstructionResourceType, ObjectHelper<IfcSubContractResourceType,1> { IfcSubContractResourceType() : Object("IfcSubContractResourceType") {}
		IfcSubContractResourceTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcSubedge
    struct IfcSubedge : IfcEdge, ObjectHelper<IfcSubedge,1> { IfcSubedge() : Object("IfcSubedge") {}
		Lazy< IfcEdge > ParentEdge;
    };

    // C++ wrapper for IfcSurfaceCurveSweptAreaSolid
    struct IfcSurfaceCurveSweptAreaSolid : IfcSweptAreaSolid, ObjectHelper<IfcSurfaceCurveSweptAreaSolid,4> { IfcSurfaceCurveSweptAreaSolid() : Object("IfcSurfaceCurveSweptAreaSolid") {}
		Lazy< IfcCurve > Directrix;
		Maybe< IfcParameterValue::Out > StartParam;
		Maybe< IfcParameterValue::Out > EndParam;
		Lazy< IfcSurface > ReferenceSurface;
    };

    // C++ wrapper for IfcSurfaceFeature
    struct IfcSurfaceFeature : IfcFeatureElement, ObjectHelper<IfcSurfaceFeature,1> { IfcSurfaceFeature() : Object("IfcSurfaceFeature") {}
		Maybe< IfcSurfaceFeatureTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcSweptSurface
    struct IfcSweptSurface : IfcSurface, ObjectHelper<IfcSweptSurface,2> { IfcSweptSurface() : Object("IfcSweptSurface") {}
		Lazy< IfcProfileDef > SweptCurve;
		Maybe< Lazy< IfcAxis2Placement3D > > Position;
    };

    // C++ wrapper for IfcSurfaceOfLinearExtrusion
    struct IfcSurfaceOfLinearExtrusion : IfcSweptSurface, ObjectHelper<IfcSurfaceOfLinearExtrusion,2> { IfcSurfaceOfLinearExtrusion() : Object("IfcSurfaceOfLinearExtrusion") {}
		Lazy< IfcDirection > ExtrudedDirection;
		IfcLengthMeasure::Out Depth;
    };

    // C++ wrapper for IfcSurfaceOfRevolution
    struct IfcSurfaceOfRevolution : IfcSweptSurface, ObjectHelper<IfcSurfaceOfRevolution,1> { IfcSurfaceOfRevolution() : Object("IfcSurfaceOfRevolution") {}
		Lazy< IfcAxis1Placement > AxisPosition;
    };

    // C++ wrapper for IfcSurfaceStyle
    struct IfcSurfaceStyle : IfcPresentationStyle, ObjectHelper<IfcSurfaceStyle,2> { IfcSurfaceStyle() : Object("IfcSurfaceStyle") {}
		IfcSurfaceSide::Out Side;
		ListOf< IfcSurfaceStyleElementSelect, 1, 5 >::Out Styles;
    };

    // C++ wrapper for IfcSurfaceStyleShading
    struct IfcSurfaceStyleShading : IfcPresentationItem, ObjectHelper<IfcSurfaceStyleShading,2> { IfcSurfaceStyleShading() : Object("IfcSurfaceStyleShading") {}
		Lazy< IfcColourRgb > SurfaceColour;
		Maybe< IfcNormalisedRatioMeasure::Out > Transparency;
    };

    // C++ wrapper for IfcSurfaceStyleRendering
    struct IfcSurfaceStyleRendering : IfcSurfaceStyleShading, ObjectHelper<IfcSurfaceStyleRendering,7> { IfcSurfaceStyleRendering() : Object("IfcSurfaceStyleRendering") {}
		Maybe< IfcColourOrFactor::Out > DiffuseColour;
		Maybe< IfcColourOrFactor::Out > TransmissionColour;
		Maybe< IfcColourOrFactor::Out > DiffuseTransmissionColour;
		Maybe< IfcColourOrFactor::Out > ReflectionColour;
		Maybe< IfcColourOrFactor::Out > SpecularColour;
		Maybe< IfcSpecularHighlightSelect::Out > SpecularHighlight;
		IfcReflectanceMethodEnum::Out ReflectanceMethod;
    };

    // C++ wrapper for IfcSurfaceStyleWithTextures
    struct IfcSurfaceStyleWithTextures : IfcPresentationItem, ObjectHelper<IfcSurfaceStyleWithTextures,1> { IfcSurfaceStyleWithTextures() : Object("IfcSurfaceStyleWithTextures") {}
		ListOf< Lazy< NotImplemented >, 1, 0 > Textures;
    };

    // C++ wrapper for IfcSweptDiskSolid
    struct IfcSweptDiskSolid : IfcSolidModel, ObjectHelper<IfcSweptDiskSolid,5> { IfcSweptDiskSolid() : Object("IfcSweptDiskSolid") {}
		Lazy< IfcCurve > Directrix;
		IfcPositiveLengthMeasure::Out Radius;
		Maybe< IfcPositiveLengthMeasure::Out > InnerRadius;
		Maybe< IfcParameterValue::Out > StartParam;
		Maybe< IfcParameterValue::Out > EndParam;
    };

    // C++ wrapper for IfcSweptDiskSolidPolygonal
    struct IfcSweptDiskSolidPolygonal : IfcSweptDiskSolid, ObjectHelper<IfcSweptDiskSolidPolygonal,1> { IfcSweptDiskSolidPolygonal() : Object("IfcSweptDiskSolidPolygonal") {}
		Maybe< IfcPositiveLengthMeasure::Out > FilletRadius;
    };

    // C++ wrapper for IfcSwitchingDevice
    struct IfcSwitchingDevice : IfcFlowController, ObjectHelper<IfcSwitchingDevice,1> { IfcSwitchingDevice() : Object("IfcSwitchingDevice") {}
		Maybe< IfcSwitchingDeviceTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcSwitchingDeviceType
    struct IfcSwitchingDeviceType : IfcFlowControllerType, ObjectHelper<IfcSwitchingDeviceType,1> { IfcSwitchingDeviceType() : Object("IfcSwitchingDeviceType") {}
		IfcSwitchingDeviceTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcSystemFurnitureElement
    struct IfcSystemFurnitureElement : IfcFurnishingElement, ObjectHelper<IfcSystemFurnitureElement,1> { IfcSystemFurnitureElement() : Object("IfcSystemFurnitureElement") {}
		Maybe< IfcSystemFurnitureElementTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcSystemFurnitureElementType
    struct IfcSystemFurnitureElementType : IfcFurnishingElementType, ObjectHelper<IfcSystemFurnitureElementType,1> { IfcSystemFurnitureElementType() : Object("IfcSystemFurnitureElementType") {}
		Maybe< IfcSystemFurnitureElementTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcTShapeProfileDef
    struct IfcTShapeProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcTShapeProfileDef,9> { IfcTShapeProfileDef() : Object("IfcTShapeProfileDef") {}
		IfcPositiveLengthMeasure::Out Depth;
		IfcPositiveLengthMeasure::Out FlangeWidth;
		IfcPositiveLengthMeasure::Out WebThickness;
		IfcPositiveLengthMeasure::Out FlangeThickness;
		Maybe< IfcNonNegativeLengthMeasure::Out > FilletRadius;
		Maybe< IfcNonNegativeLengthMeasure::Out > FlangeEdgeRadius;
		Maybe< IfcNonNegativeLengthMeasure::Out > WebEdgeRadius;
		Maybe< IfcPlaneAngleMeasure::Out > WebSlope;
		Maybe< IfcPlaneAngleMeasure::Out > FlangeSlope;
    };

    // C++ wrapper for IfcTank
    struct IfcTank : IfcFlowStorageDevice, ObjectHelper<IfcTank,1> { IfcTank() : Object("IfcTank") {}
		Maybe< IfcTankTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcTankType
    struct IfcTankType : IfcFlowStorageDeviceType, ObjectHelper<IfcTankType,1> { IfcTankType() : Object("IfcTankType") {}
		IfcTankTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcTask
    struct IfcTask : IfcProcess, ObjectHelper<IfcTask,6> { IfcTask() : Object("IfcTask") {}
		Maybe< IfcLabel::Out > Status;
		Maybe< IfcLabel::Out > WorkMethod;
		IfcBoolean::Out IsMilestone;
		Maybe< IfcInteger::Out > Priority;
		Maybe< Lazy< NotImplemented > > TaskTime;
		Maybe< IfcTaskTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcTaskType
    struct IfcTaskType : IfcTypeProcess, ObjectHelper<IfcTaskType,2> { IfcTaskType() : Object("IfcTaskType") {}
		IfcTaskTypeEnum::Out PredefinedType;
		Maybe< IfcLabel::Out > WorkMethod;
    };

    // C++ wrapper for IfcTendon
    struct IfcTendon : IfcReinforcingElement, ObjectHelper<IfcTendon,8> { IfcTendon() : Object("IfcTendon") {}
		Maybe< IfcTendonTypeEnum::Out > PredefinedType;
		Maybe< IfcPositiveLengthMeasure::Out > NominalDiameter;
		Maybe< IfcAreaMeasure::Out > CrossSectionArea;
		Maybe< IfcForceMeasure::Out > TensionForce;
		Maybe< IfcPressureMeasure::Out > PreStress;
		Maybe< IfcNormalisedRatioMeasure::Out > FrictionCoefficient;
		Maybe< IfcPositiveLengthMeasure::Out > AnchorageSlip;
		Maybe< IfcPositiveLengthMeasure::Out > MinCurvatureRadius;
    };

    // C++ wrapper for IfcTendonAnchor
    struct IfcTendonAnchor : IfcReinforcingElement, ObjectHelper<IfcTendonAnchor,1> { IfcTendonAnchor() : Object("IfcTendonAnchor") {}
		Maybe< IfcTendonAnchorTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcTendonAnchorType
    struct IfcTendonAnchorType : IfcReinforcingElementType, ObjectHelper<IfcTendonAnchorType,1> { IfcTendonAnchorType() : Object("IfcTendonAnchorType") {}
		IfcTendonAnchorTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcTendonType
    struct IfcTendonType : IfcReinforcingElementType, ObjectHelper<IfcTendonType,4> { IfcTendonType() : Object("IfcTendonType") {}
		IfcTendonTypeEnum::Out PredefinedType;
		Maybe< IfcPositiveLengthMeasure::Out > NominalDiameter;
		Maybe< IfcAreaMeasure::Out > CrossSectionArea;
		Maybe< IfcPositiveLengthMeasure::Out > SheathDiameter;
    };

    // C++ wrapper for IfcTextLiteral
    struct IfcTextLiteral : IfcGeometricRepresentationItem, ObjectHelper<IfcTextLiteral,3> { IfcTextLiteral() : Object("IfcTextLiteral") {}
		IfcPresentableText::Out Literal;
		IfcAxis2Placement::Out Placement;
		IfcTextPath::Out Path;
    };

    // C++ wrapper for IfcTextLiteralWithExtent
    struct IfcTextLiteralWithExtent : IfcTextLiteral, ObjectHelper<IfcTextLiteralWithExtent,2> { IfcTextLiteralWithExtent() : Object("IfcTextLiteralWithExtent") {}
		Lazy< IfcPlanarExtent > Extent;
		IfcBoxAlignment::Out BoxAlignment;
    };

    // C++ wrapper for IfcTopologyRepresentation
    struct IfcTopologyRepresentation : IfcShapeModel, ObjectHelper<IfcTopologyRepresentation,0> { IfcTopologyRepresentation() : Object("IfcTopologyRepresentation") {}

    };

    // C++ wrapper for IfcToroidalSurface
    struct IfcToroidalSurface : IfcElementarySurface, ObjectHelper<IfcToroidalSurface,2> { IfcToroidalSurface() : Object("IfcToroidalSurface") {}
		IfcPositiveLengthMeasure::Out MajorRadius;
		IfcPositiveLengthMeasure::Out MinorRadius;
    };

    // C++ wrapper for IfcTransformer
    struct IfcTransformer : IfcEnergyConversionDevice, ObjectHelper<IfcTransformer,1> { IfcTransformer() : Object("IfcTransformer") {}
		Maybe< IfcTransformerTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcTransformerType
    struct IfcTransformerType : IfcEnergyConversionDeviceType, ObjectHelper<IfcTransformerType,1> { IfcTransformerType() : Object("IfcTransformerType") {}
		IfcTransformerTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcTransportElement
    struct IfcTransportElement : IfcElement, ObjectHelper<IfcTransportElement,1> { IfcTransportElement() : Object("IfcTransportElement") {}
		Maybe< IfcTransportElementTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcTransportElementType
    struct IfcTransportElementType : IfcElementType, ObjectHelper<IfcTransportElementType,1> { IfcTransportElementType() : Object("IfcTransportElementType") {}
		IfcTransportElementTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcTrapeziumProfileDef
    struct IfcTrapeziumProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcTrapeziumProfileDef,4> { IfcTrapeziumProfileDef() : Object("IfcTrapeziumProfileDef") {}
		IfcPositiveLengthMeasure::Out BottomXDim;
		IfcPositiveLengthMeasure::Out TopXDim;
		IfcPositiveLengthMeasure::Out YDim;
		IfcLengthMeasure::Out TopXOffset;
    };

    // C++ wrapper for IfcTriangulatedFaceSet
    struct IfcTriangulatedFaceSet : IfcTessellatedFaceSet, ObjectHelper<IfcTriangulatedFaceSet,2> { IfcTriangulatedFaceSet() : Object("IfcTriangulatedFaceSet") {}
		Maybe< IfcBoolean::Out > Closed;
		Maybe< ListOf< IfcPositiveInteger, 1, 0 >::Out > PnIndex;
    };

    // C++ wrapper for IfcTrimmedCurve
    struct IfcTrimmedCurve : IfcBoundedCurve, ObjectHelper<IfcTrimmedCurve,5> { IfcTrimmedCurve() : Object("IfcTrimmedCurve") {}
		Lazy< IfcCurve > BasisCurve;
		ListOf< IfcTrimmingSelect, 1, 2 >::Out Trim1;
		ListOf< IfcTrimmingSelect, 1, 2 >::Out Trim2;
		IfcBoolean::Out SenseAgreement;
		IfcTrimmingPreference::Out MasterRepresentation;
    };

    // C++ wrapper for IfcTubeBundle
    struct IfcTubeBundle : IfcEnergyConversionDevice, ObjectHelper<IfcTubeBundle,1> { IfcTubeBundle() : Object("IfcTubeBundle") {}
		Maybe< IfcTubeBundleTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcTubeBundleType
    struct IfcTubeBundleType : IfcEnergyConversionDeviceType, ObjectHelper<IfcTubeBundleType,1> { IfcTubeBundleType() : Object("IfcTubeBundleType") {}
		IfcTubeBundleTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcUShapeProfileDef
    struct IfcUShapeProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcUShapeProfileDef,7> { IfcUShapeProfileDef() : Object("IfcUShapeProfileDef") {}
		IfcPositiveLengthMeasure::Out Depth;
		IfcPositiveLengthMeasure::Out FlangeWidth;
		IfcPositiveLengthMeasure::Out WebThickness;
		IfcPositiveLengthMeasure::Out FlangeThickness;
		Maybe< IfcNonNegativeLengthMeasure::Out > FilletRadius;
		Maybe< IfcNonNegativeLengthMeasure::Out > EdgeRadius;
		Maybe< IfcPlaneAngleMeasure::Out > FlangeSlope;
    };

    // C++ wrapper for IfcUnitAssignment
    struct IfcUnitAssignment :  ObjectHelper<IfcUnitAssignment,1> { IfcUnitAssignment() : Object("IfcUnitAssignment") {}
		ListOf< IfcUnit, 1, 0 >::Out Units;
    };

    // C++ wrapper for IfcUnitaryControlElement
    struct IfcUnitaryControlElement : IfcDistributionControlElement, ObjectHelper<IfcUnitaryControlElement,1> { IfcUnitaryControlElement() : Object("IfcUnitaryControlElement") {}
		Maybe< IfcUnitaryControlElementTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcUnitaryControlElementType
    struct IfcUnitaryControlElementType : IfcDistributionControlElementType, ObjectHelper<IfcUnitaryControlElementType,1> { IfcUnitaryControlElementType() : Object("IfcUnitaryControlElementType") {}
		IfcUnitaryControlElementTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcUnitaryEquipment
    struct IfcUnitaryEquipment : IfcEnergyConversionDevice, ObjectHelper<IfcUnitaryEquipment,1> { IfcUnitaryEquipment() : Object("IfcUnitaryEquipment") {}
		Maybe< IfcUnitaryEquipmentTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcUnitaryEquipmentType
    struct IfcUnitaryEquipmentType : IfcEnergyConversionDeviceType, ObjectHelper<IfcUnitaryEquipmentType,1> { IfcUnitaryEquipmentType() : Object("IfcUnitaryEquipmentType") {}
		IfcUnitaryEquipmentTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcValve
    struct IfcValve : IfcFlowController, ObjectHelper<IfcValve,1> { IfcValve() : Object("IfcValve") {}
		Maybe< IfcValveTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcValveType
    struct IfcValveType : IfcFlowControllerType, ObjectHelper<IfcValveType,1> { IfcValveType() : Object("IfcValveType") {}
		IfcValveTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcVector
    struct IfcVector : IfcGeometricRepresentationItem, ObjectHelper<IfcVector,2> { IfcVector() : Object("IfcVector") {}
		Lazy< IfcDirection > Orientation;
		IfcLengthMeasure::Out Magnitude;
    };

    // C++ wrapper for IfcVertex
    struct IfcVertex : IfcTopologicalRepresentationItem, ObjectHelper<IfcVertex,0> { IfcVertex() : Object("IfcVertex") {}

    };

    // C++ wrapper for IfcVertexLoop
    struct IfcVertexLoop : IfcLoop, ObjectHelper<IfcVertexLoop,1> { IfcVertexLoop() : Object("IfcVertexLoop") {}
		Lazy< IfcVertex > LoopVertex;
    };

    // C++ wrapper for IfcVertexPoint
    struct IfcVertexPoint : IfcVertex, ObjectHelper<IfcVertexPoint,1> { IfcVertexPoint() : Object("IfcVertexPoint") {}
		Lazy< IfcPoint > VertexGeometry;
    };

    // C++ wrapper for IfcVibrationIsolator
    struct IfcVibrationIsolator : IfcElementComponent, ObjectHelper<IfcVibrationIsolator,1> { IfcVibrationIsolator() : Object("IfcVibrationIsolator") {}
		Maybe< IfcVibrationIsolatorTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcVibrationIsolatorType
    struct IfcVibrationIsolatorType : IfcElementComponentType, ObjectHelper<IfcVibrationIsolatorType,1> { IfcVibrationIsolatorType() : Object("IfcVibrationIsolatorType") {}
		IfcVibrationIsolatorTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcVirtualElement
    struct IfcVirtualElement : IfcElement, ObjectHelper<IfcVirtualElement,0> { IfcVirtualElement() : Object("IfcVirtualElement") {}

    };

    // C++ wrapper for IfcVoidingFeature
    struct IfcVoidingFeature : IfcFeatureElementSubtraction, ObjectHelper<IfcVoidingFeature,1> { IfcVoidingFeature() : Object("IfcVoidingFeature") {}
		Maybe< IfcVoidingFeatureTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcWall
    struct IfcWall : IfcBuildingElement, ObjectHelper<IfcWall,1> { IfcWall() : Object("IfcWall") {}
		Maybe< IfcWallTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcWallElementedCase
    struct IfcWallElementedCase : IfcWall, ObjectHelper<IfcWallElementedCase,0> { IfcWallElementedCase() : Object("IfcWallElementedCase") {}

    };

    // C++ wrapper for IfcWallStandardCase
    struct IfcWallStandardCase : IfcWall, ObjectHelper<IfcWallStandardCase,0> { IfcWallStandardCase() : Object("IfcWallStandardCase") {}

    };

    // C++ wrapper for IfcWallType
    struct IfcWallType : IfcBuildingElementType, ObjectHelper<IfcWallType,1> { IfcWallType() : Object("IfcWallType") {}
		IfcWallTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcWasteTerminal
    struct IfcWasteTerminal : IfcFlowTerminal, ObjectHelper<IfcWasteTerminal,1> { IfcWasteTerminal() : Object("IfcWasteTerminal") {}
		Maybe< IfcWasteTerminalTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcWasteTerminalType
    struct IfcWasteTerminalType : IfcFlowTerminalType, ObjectHelper<IfcWasteTerminalType,1> { IfcWasteTerminalType() : Object("IfcWasteTerminalType") {}
		IfcWasteTerminalTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcWindow
    struct IfcWindow : IfcBuildingElement, ObjectHelper<IfcWindow,5> { IfcWindow() : Object("IfcWindow") {}
		Maybe< IfcPositiveLengthMeasure::Out > OverallHeight;
		Maybe< IfcPositiveLengthMeasure::Out > OverallWidth;
		Maybe< IfcWindowTypeEnum::Out > PredefinedType;
		Maybe< IfcWindowTypePartitioningEnum::Out > PartitioningType;
		Maybe< IfcLabel::Out > UserDefinedPartitioningType;
    };

    // C++ wrapper for IfcWindowStandardCase
    struct IfcWindowStandardCase : IfcWindow, ObjectHelper<IfcWindowStandardCase,0> { IfcWindowStandardCase() : Object("IfcWindowStandardCase") {}

    };

    // C++ wrapper for IfcWindowStyle
    struct IfcWindowStyle : IfcTypeProduct, ObjectHelper<IfcWindowStyle,4> { IfcWindowStyle() : Object("IfcWindowStyle") {}
		IfcWindowStyleConstructionEnum::Out ConstructionType;
		IfcWindowStyleOperationEnum::Out OperationType;
		IfcBoolean::Out ParameterTakesPrecedence;
		IfcBoolean::Out Sizeable;
    };

    // C++ wrapper for IfcWindowType
    struct IfcWindowType : IfcBuildingElementType, ObjectHelper<IfcWindowType,4> { IfcWindowType() : Object("IfcWindowType") {}
		IfcWindowTypeEnum::Out PredefinedType;
		IfcWindowTypePartitioningEnum::Out PartitioningType;
		Maybe< IfcBoolean::Out > ParameterTakesPrecedence;
		Maybe< IfcLabel::Out > UserDefinedPartitioningType;
    };

    // C++ wrapper for IfcWorkCalendar
    struct IfcWorkCalendar : IfcControl, ObjectHelper<IfcWorkCalendar,3> { IfcWorkCalendar() : Object("IfcWorkCalendar") {}
		Maybe< ListOf< Lazy< NotImplemented >, 1, 0 > > WorkingTimes;
		Maybe< ListOf< Lazy< NotImplemented >, 1, 0 > > ExceptionTimes;
		Maybe< IfcWorkCalendarTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcWorkControl
    struct IfcWorkControl : IfcControl, ObjectHelper<IfcWorkControl,7> { IfcWorkControl() : Object("IfcWorkControl") {}
		IfcDateTime::Out CreationDate;
		Maybe< ListOf< Lazy< NotImplemented >, 1, 0 > > Creators;
		Maybe< IfcLabel::Out > Purpose;
		Maybe< IfcDuration::Out > Duration;
		Maybe< IfcDuration::Out > TotalFloat;
		IfcDateTime::Out StartTime;
		Maybe< IfcDateTime::Out > FinishTime;
    };

    // C++ wrapper for IfcWorkPlan
    struct IfcWorkPlan : IfcWorkControl, ObjectHelper<IfcWorkPlan,1> { IfcWorkPlan() : Object("IfcWorkPlan") {}
		Maybe< IfcWorkPlanTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcWorkSchedule
    struct IfcWorkSchedule : IfcWorkControl, ObjectHelper<IfcWorkSchedule,1> { IfcWorkSchedule() : Object("IfcWorkSchedule") {}
		Maybe< IfcWorkScheduleTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcZShapeProfileDef
    struct IfcZShapeProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcZShapeProfileDef,6> { IfcZShapeProfileDef() : Object("IfcZShapeProfileDef") {}
		IfcPositiveLengthMeasure::Out Depth;
		IfcPositiveLengthMeasure::Out FlangeWidth;
		IfcPositiveLengthMeasure::Out WebThickness;
		IfcPositiveLengthMeasure::Out FlangeThickness;
		Maybe< IfcNonNegativeLengthMeasure::Out > FilletRadius;
		Maybe< IfcNonNegativeLengthMeasure::Out > EdgeRadius;
    };

    // C++ wrapper for IfcZone
    struct IfcZone : IfcSystem, ObjectHelper<IfcZone,1> { IfcZone() : Object("IfcZone") {}
		Maybe< IfcLabel::Out > LongName;
    };

	void GetSchema(EXPRESS::ConversionSchema& out);

} //! IFC
namespace STEP {

    // ******************************************************************************
    // Converter stubs
    // ******************************************************************************

#define DECL_CONV_STUB(type) template <> size_t GenericFill<IFC::type>(const STEP::DB& db, const EXPRESS::LIST& params, IFC::type* in)

    DECL_CONV_STUB( IfcRoot );
    DECL_CONV_STUB( IfcObjectDefinition );
    DECL_CONV_STUB( IfcObject );
    DECL_CONV_STUB( IfcControl );
    DECL_CONV_STUB( IfcActionRequest );
    DECL_CONV_STUB( IfcActor );
    DECL_CONV_STUB( IfcProduct );
    DECL_CONV_STUB( IfcElement );
    DECL_CONV_STUB( IfcDistributionElement );
    DECL_CONV_STUB( IfcDistributionControlElement );
    DECL_CONV_STUB( IfcActuator );
    DECL_CONV_STUB( IfcTypeObject );
    DECL_CONV_STUB( IfcTypeProduct );
    DECL_CONV_STUB( IfcElementType );
    DECL_CONV_STUB( IfcDistributionElementType );
    DECL_CONV_STUB( IfcDistributionControlElementType );
    DECL_CONV_STUB( IfcActuatorType );
    DECL_CONV_STUB( IfcRepresentationItem );
    DECL_CONV_STUB( IfcGeometricRepresentationItem );
    DECL_CONV_STUB( IfcSolidModel );
    DECL_CONV_STUB( IfcManifoldSolidBrep );
    DECL_CONV_STUB( IfcAdvancedBrep );
    DECL_CONV_STUB( IfcAdvancedBrepWithVoids );
    DECL_CONV_STUB( IfcTopologicalRepresentationItem );
    DECL_CONV_STUB( IfcFace );
    DECL_CONV_STUB( IfcFaceSurface );
    DECL_CONV_STUB( IfcAdvancedFace );
    DECL_CONV_STUB( IfcDistributionFlowElement );
    DECL_CONV_STUB( IfcFlowTerminal );
    DECL_CONV_STUB( IfcAirTerminal );
    DECL_CONV_STUB( IfcFlowController );
    DECL_CONV_STUB( IfcAirTerminalBox );
    DECL_CONV_STUB( IfcDistributionFlowElementType );
    DECL_CONV_STUB( IfcFlowControllerType );
    DECL_CONV_STUB( IfcAirTerminalBoxType );
    DECL_CONV_STUB( IfcFlowTerminalType );
    DECL_CONV_STUB( IfcAirTerminalType );
    DECL_CONV_STUB( IfcEnergyConversionDevice );
    DECL_CONV_STUB( IfcAirToAirHeatRecovery );
    DECL_CONV_STUB( IfcEnergyConversionDeviceType );
    DECL_CONV_STUB( IfcAirToAirHeatRecoveryType );
    DECL_CONV_STUB( IfcAlarm );
    DECL_CONV_STUB( IfcAlarmType );
    DECL_CONV_STUB( IfcAnnotation );
    DECL_CONV_STUB( IfcAnnotationFillArea );
    DECL_CONV_STUB( IfcProfileDef );
    DECL_CONV_STUB( IfcArbitraryClosedProfileDef );
    DECL_CONV_STUB( IfcArbitraryOpenProfileDef );
    DECL_CONV_STUB( IfcArbitraryProfileDefWithVoids );
    DECL_CONV_STUB( IfcGroup );
    DECL_CONV_STUB( IfcAsset );
    DECL_CONV_STUB( IfcParameterizedProfileDef );
    DECL_CONV_STUB( IfcAsymmetricIShapeProfileDef );
    DECL_CONV_STUB( IfcAudioVisualAppliance );
    DECL_CONV_STUB( IfcAudioVisualApplianceType );
    DECL_CONV_STUB( IfcPlacement );
    DECL_CONV_STUB( IfcAxis1Placement );
    DECL_CONV_STUB( IfcAxis2Placement2D );
    DECL_CONV_STUB( IfcAxis2Placement3D );
    DECL_CONV_STUB( IfcCurve );
    DECL_CONV_STUB( IfcBoundedCurve );
    DECL_CONV_STUB( IfcBSplineCurve );
    DECL_CONV_STUB( IfcBSplineCurveWithKnots );
    DECL_CONV_STUB( IfcSurface );
    DECL_CONV_STUB( IfcBoundedSurface );
    DECL_CONV_STUB( IfcBSplineSurface );
    DECL_CONV_STUB( IfcBSplineSurfaceWithKnots );
    DECL_CONV_STUB( IfcBuildingElement );
    DECL_CONV_STUB( IfcBeam );
    DECL_CONV_STUB( IfcBeamStandardCase );
    DECL_CONV_STUB( IfcBuildingElementType );
    DECL_CONV_STUB( IfcBeamType );
    DECL_CONV_STUB( IfcPresentationItem );
    DECL_CONV_STUB( IfcCsgPrimitive3D );
    DECL_CONV_STUB( IfcBlock );
    DECL_CONV_STUB( IfcBoiler );
    DECL_CONV_STUB( IfcBoilerType );
    DECL_CONV_STUB( IfcBooleanResult );
    DECL_CONV_STUB( IfcBooleanClippingResult );
    DECL_CONV_STUB( IfcCompositeCurve );
    DECL_CONV_STUB( IfcCompositeCurveOnSurface );
    DECL_CONV_STUB( IfcBoundaryCurve );
    DECL_CONV_STUB( IfcBoundingBox );
    DECL_CONV_STUB( IfcHalfSpaceSolid );
    DECL_CONV_STUB( IfcBoxedHalfSpace );
    DECL_CONV_STUB( IfcSpatialElement );
    DECL_CONV_STUB( IfcSpatialStructureElement );
    DECL_CONV_STUB( IfcBuilding );
    DECL_CONV_STUB( IfcElementComponent );
    DECL_CONV_STUB( IfcBuildingElementPart );
    DECL_CONV_STUB( IfcElementComponentType );
    DECL_CONV_STUB( IfcBuildingElementPartType );
    DECL_CONV_STUB( IfcBuildingElementProxy );
    DECL_CONV_STUB( IfcBuildingElementProxyType );
    DECL_CONV_STUB( IfcBuildingStorey );
    DECL_CONV_STUB( IfcSystem );
    DECL_CONV_STUB( IfcBuildingSystem );
    DECL_CONV_STUB( IfcBurner );
    DECL_CONV_STUB( IfcBurnerType );
    DECL_CONV_STUB( IfcCShapeProfileDef );
    DECL_CONV_STUB( IfcFlowFitting );
    DECL_CONV_STUB( IfcCableCarrierFitting );
    DECL_CONV_STUB( IfcFlowFittingType );
    DECL_CONV_STUB( IfcCableCarrierFittingType );
    DECL_CONV_STUB( IfcFlowSegment );
    DECL_CONV_STUB( IfcCableCarrierSegment );
    DECL_CONV_STUB( IfcFlowSegmentType );
    DECL_CONV_STUB( IfcCableCarrierSegmentType );
    DECL_CONV_STUB( IfcCableFitting );
    DECL_CONV_STUB( IfcCableFittingType );
    DECL_CONV_STUB( IfcCableSegment );
    DECL_CONV_STUB( IfcCableSegmentType );
    DECL_CONV_STUB( IfcPoint );
    DECL_CONV_STUB( IfcCartesianPoint );
    DECL_CONV_STUB( IfcCartesianPointList );
    DECL_CONV_STUB( IfcCartesianPointList2D );
    DECL_CONV_STUB( IfcCartesianPointList3D );
    DECL_CONV_STUB( IfcCartesianTransformationOperator );
    DECL_CONV_STUB( IfcCartesianTransformationOperator2D );
    DECL_CONV_STUB( IfcCartesianTransformationOperator2DnonUniform );
    DECL_CONV_STUB( IfcCartesianTransformationOperator3D );
    DECL_CONV_STUB( IfcCartesianTransformationOperator3DnonUniform );
    DECL_CONV_STUB( IfcCenterLineProfileDef );
    DECL_CONV_STUB( IfcChiller );
    DECL_CONV_STUB( IfcChillerType );
    DECL_CONV_STUB( IfcChimney );
    DECL_CONV_STUB( IfcChimneyType );
    DECL_CONV_STUB( IfcConic );
    DECL_CONV_STUB( IfcCircle );
    DECL_CONV_STUB( IfcCircleProfileDef );
    DECL_CONV_STUB( IfcCircleHollowProfileDef );
    DECL_CONV_STUB( IfcCivilElement );
    DECL_CONV_STUB( IfcCivilElementType );
    DECL_CONV_STUB( IfcConnectedFaceSet );
    DECL_CONV_STUB( IfcClosedShell );
    DECL_CONV_STUB( IfcCoil );
    DECL_CONV_STUB( IfcCoilType );
    DECL_CONV_STUB( IfcColourSpecification );
    DECL_CONV_STUB( IfcColourRgb );
    DECL_CONV_STUB( IfcColumn );
    DECL_CONV_STUB( IfcColumnStandardCase );
    DECL_CONV_STUB( IfcColumnType );
    DECL_CONV_STUB( IfcCommunicationsAppliance );
    DECL_CONV_STUB( IfcCommunicationsApplianceType );
    DECL_CONV_STUB( IfcPropertyAbstraction );
    DECL_CONV_STUB( IfcProperty );
    DECL_CONV_STUB( IfcComplexProperty );
    DECL_CONV_STUB( IfcPropertyDefinition );
    DECL_CONV_STUB( IfcCompositeCurveSegment );
    DECL_CONV_STUB( IfcCompositeProfileDef );
    DECL_CONV_STUB( IfcFlowMovingDevice );
    DECL_CONV_STUB( IfcCompressor );
    DECL_CONV_STUB( IfcFlowMovingDeviceType );
    DECL_CONV_STUB( IfcCompressorType );
    DECL_CONV_STUB( IfcCondenser );
    DECL_CONV_STUB( IfcCondenserType );
    DECL_CONV_STUB( IfcResource );
    DECL_CONV_STUB( IfcConstructionResource );
    DECL_CONV_STUB( IfcConstructionEquipmentResource );
    DECL_CONV_STUB( IfcTypeResource );
    DECL_CONV_STUB( IfcConstructionResourceType );
    DECL_CONV_STUB( IfcConstructionEquipmentResourceType );
    DECL_CONV_STUB( IfcConstructionMaterialResource );
    DECL_CONV_STUB( IfcConstructionMaterialResourceType );
    DECL_CONV_STUB( IfcConstructionProductResource );
    DECL_CONV_STUB( IfcConstructionProductResourceType );
    DECL_CONV_STUB( IfcContext );
    DECL_CONV_STUB( IfcNamedUnit );
    DECL_CONV_STUB( IfcContextDependentUnit );
    DECL_CONV_STUB( IfcController );
    DECL_CONV_STUB( IfcControllerType );
    DECL_CONV_STUB( IfcConversionBasedUnit );
    DECL_CONV_STUB( IfcConversionBasedUnitWithOffset );
    DECL_CONV_STUB( IfcCooledBeam );
    DECL_CONV_STUB( IfcCooledBeamType );
    DECL_CONV_STUB( IfcCoolingTower );
    DECL_CONV_STUB( IfcCoolingTowerType );
    DECL_CONV_STUB( IfcCostItem );
    DECL_CONV_STUB( IfcCostSchedule );
    DECL_CONV_STUB( IfcCovering );
    DECL_CONV_STUB( IfcCoveringType );
    DECL_CONV_STUB( IfcCrewResource );
    DECL_CONV_STUB( IfcCrewResourceType );
    DECL_CONV_STUB( IfcCsgSolid );
    DECL_CONV_STUB( IfcCurtainWall );
    DECL_CONV_STUB( IfcCurtainWallType );
    DECL_CONV_STUB( IfcCurveBoundedPlane );
    DECL_CONV_STUB( IfcCurveBoundedSurface );
    DECL_CONV_STUB( IfcPresentationStyle );
    DECL_CONV_STUB( IfcElementarySurface );
    DECL_CONV_STUB( IfcCylindricalSurface );
    DECL_CONV_STUB( IfcDamper );
    DECL_CONV_STUB( IfcDamperType );
    DECL_CONV_STUB( IfcDerivedProfileDef );
    DECL_CONV_STUB( IfcDirection );
    DECL_CONV_STUB( IfcDiscreteAccessory );
    DECL_CONV_STUB( IfcDiscreteAccessoryType );
    DECL_CONV_STUB( IfcDistributionChamberElement );
    DECL_CONV_STUB( IfcDistributionChamberElementType );
    DECL_CONV_STUB( IfcDistributionSystem );
    DECL_CONV_STUB( IfcDistributionCircuit );
    DECL_CONV_STUB( IfcPort );
    DECL_CONV_STUB( IfcDistributionPort );
    DECL_CONV_STUB( IfcDoor );
    DECL_CONV_STUB( IfcPropertySetDefinition );
    DECL_CONV_STUB( IfcDoorStandardCase );
    DECL_CONV_STUB( IfcDoorStyle );
    DECL_CONV_STUB( IfcDoorType );
    DECL_CONV_STUB( IfcDuctFitting );
    DECL_CONV_STUB( IfcDuctFittingType );
    DECL_CONV_STUB( IfcDuctSegment );
    DECL_CONV_STUB( IfcDuctSegmentType );
    DECL_CONV_STUB( IfcFlowTreatmentDevice );
    DECL_CONV_STUB( IfcDuctSilencer );
    DECL_CONV_STUB( IfcFlowTreatmentDeviceType );
    DECL_CONV_STUB( IfcDuctSilencerType );
    DECL_CONV_STUB( IfcEdge );
    DECL_CONV_STUB( IfcEdgeCurve );
    DECL_CONV_STUB( IfcLoop );
    DECL_CONV_STUB( IfcEdgeLoop );
    DECL_CONV_STUB( IfcElectricAppliance );
    DECL_CONV_STUB( IfcElectricApplianceType );
    DECL_CONV_STUB( IfcElectricDistributionBoard );
    DECL_CONV_STUB( IfcElectricDistributionBoardType );
    DECL_CONV_STUB( IfcFlowStorageDevice );
    DECL_CONV_STUB( IfcElectricFlowStorageDevice );
    DECL_CONV_STUB( IfcFlowStorageDeviceType );
    DECL_CONV_STUB( IfcElectricFlowStorageDeviceType );
    DECL_CONV_STUB( IfcElectricGenerator );
    DECL_CONV_STUB( IfcElectricGeneratorType );
    DECL_CONV_STUB( IfcElectricMotor );
    DECL_CONV_STUB( IfcElectricMotorType );
    DECL_CONV_STUB( IfcElectricTimeControl );
    DECL_CONV_STUB( IfcElectricTimeControlType );
    DECL_CONV_STUB( IfcElementAssembly );
    DECL_CONV_STUB( IfcElementAssemblyType );
    DECL_CONV_STUB( IfcQuantitySet );
    DECL_CONV_STUB( IfcElementQuantity );
    DECL_CONV_STUB( IfcEllipse );
    DECL_CONV_STUB( IfcEllipseProfileDef );
    DECL_CONV_STUB( IfcEngine );
    DECL_CONV_STUB( IfcEngineType );
    DECL_CONV_STUB( IfcEvaporativeCooler );
    DECL_CONV_STUB( IfcEvaporativeCoolerType );
    DECL_CONV_STUB( IfcEvaporator );
    DECL_CONV_STUB( IfcEvaporatorType );
    DECL_CONV_STUB( IfcProcess );
    DECL_CONV_STUB( IfcEvent );
    DECL_CONV_STUB( IfcTypeProcess );
    DECL_CONV_STUB( IfcEventType );
    DECL_CONV_STUB( IfcExternalSpatialStructureElement );
    DECL_CONV_STUB( IfcExternalSpatialElement );
    DECL_CONV_STUB( IfcSweptAreaSolid );
    DECL_CONV_STUB( IfcExtrudedAreaSolid );
    DECL_CONV_STUB( IfcExtrudedAreaSolidTapered );
    DECL_CONV_STUB( IfcFaceBasedSurfaceModel );
    DECL_CONV_STUB( IfcFaceBound );
    DECL_CONV_STUB( IfcFaceOuterBound );
    DECL_CONV_STUB( IfcFacetedBrep );
    DECL_CONV_STUB( IfcFacetedBrepWithVoids );
    DECL_CONV_STUB( IfcFan );
    DECL_CONV_STUB( IfcFanType );
    DECL_CONV_STUB( IfcFastener );
    DECL_CONV_STUB( IfcFastenerType );
    DECL_CONV_STUB( IfcFeatureElement );
    DECL_CONV_STUB( IfcFeatureElementAddition );
    DECL_CONV_STUB( IfcFeatureElementSubtraction );
    DECL_CONV_STUB( IfcFillAreaStyleHatching );
    DECL_CONV_STUB( IfcFillAreaStyleTiles );
    DECL_CONV_STUB( IfcFilter );
    DECL_CONV_STUB( IfcFilterType );
    DECL_CONV_STUB( IfcFireSuppressionTerminal );
    DECL_CONV_STUB( IfcFireSuppressionTerminalType );
    DECL_CONV_STUB( IfcFixedReferenceSweptAreaSolid );
    DECL_CONV_STUB( IfcFlowInstrument );
    DECL_CONV_STUB( IfcFlowInstrumentType );
    DECL_CONV_STUB( IfcFlowMeter );
    DECL_CONV_STUB( IfcFlowMeterType );
    DECL_CONV_STUB( IfcFooting );
    DECL_CONV_STUB( IfcFootingType );
    DECL_CONV_STUB( IfcFurnishingElement );
    DECL_CONV_STUB( IfcFurnishingElementType );
    DECL_CONV_STUB( IfcFurniture );
    DECL_CONV_STUB( IfcFurnitureType );
    DECL_CONV_STUB( IfcGeographicElement );
    DECL_CONV_STUB( IfcGeographicElementType );
    DECL_CONV_STUB( IfcGeometricSet );
    DECL_CONV_STUB( IfcGeometricCurveSet );
    DECL_CONV_STUB( IfcRepresentationContext );
    DECL_CONV_STUB( IfcGeometricRepresentationContext );
    DECL_CONV_STUB( IfcGeometricRepresentationSubContext );
    DECL_CONV_STUB( IfcGrid );
    DECL_CONV_STUB( IfcObjectPlacement );
    DECL_CONV_STUB( IfcGridPlacement );
    DECL_CONV_STUB( IfcHeatExchanger );
    DECL_CONV_STUB( IfcHeatExchangerType );
    DECL_CONV_STUB( IfcHumidifier );
    DECL_CONV_STUB( IfcHumidifierType );
    DECL_CONV_STUB( IfcIShapeProfileDef );
    DECL_CONV_STUB( IfcIndexedPolyCurve );
    DECL_CONV_STUB( IfcTessellatedItem );
    DECL_CONV_STUB( IfcIndexedPolygonalFace );
    DECL_CONV_STUB( IfcIndexedPolygonalFaceWithVoids );
    DECL_CONV_STUB( IfcInterceptor );
    DECL_CONV_STUB( IfcInterceptorType );
    DECL_CONV_STUB( IfcSurfaceCurve );
    DECL_CONV_STUB( IfcIntersectionCurve );
    DECL_CONV_STUB( IfcInventory );
    DECL_CONV_STUB( IfcJunctionBox );
    DECL_CONV_STUB( IfcJunctionBoxType );
    DECL_CONV_STUB( IfcLShapeProfileDef );
    DECL_CONV_STUB( IfcLaborResource );
    DECL_CONV_STUB( IfcLaborResourceType );
    DECL_CONV_STUB( IfcLamp );
    DECL_CONV_STUB( IfcLampType );
    DECL_CONV_STUB( IfcLightFixture );
    DECL_CONV_STUB( IfcLightFixtureType );
    DECL_CONV_STUB( IfcLightSource );
    DECL_CONV_STUB( IfcLightSourceAmbient );
    DECL_CONV_STUB( IfcLightSourceDirectional );
    DECL_CONV_STUB( IfcLightSourceGoniometric );
    DECL_CONV_STUB( IfcLightSourcePositional );
    DECL_CONV_STUB( IfcLightSourceSpot );
    DECL_CONV_STUB( IfcLine );
    DECL_CONV_STUB( IfcLocalPlacement );
    DECL_CONV_STUB( IfcMappedItem );
    DECL_CONV_STUB( IfcProductRepresentation );
    DECL_CONV_STUB( IfcMaterialDefinitionRepresentation );
    DECL_CONV_STUB( IfcMeasureWithUnit );
    DECL_CONV_STUB( IfcMechanicalFastener );
    DECL_CONV_STUB( IfcMechanicalFastenerType );
    DECL_CONV_STUB( IfcMedicalDevice );
    DECL_CONV_STUB( IfcMedicalDeviceType );
    DECL_CONV_STUB( IfcMember );
    DECL_CONV_STUB( IfcMemberStandardCase );
    DECL_CONV_STUB( IfcMemberType );
    DECL_CONV_STUB( IfcMirroredProfileDef );
    DECL_CONV_STUB( IfcMotorConnection );
    DECL_CONV_STUB( IfcMotorConnectionType );
    DECL_CONV_STUB( IfcOccupant );
    DECL_CONV_STUB( IfcOffsetCurve2D );
    DECL_CONV_STUB( IfcOffsetCurve3D );
    DECL_CONV_STUB( IfcOpenShell );
    DECL_CONV_STUB( IfcOpeningElement );
    DECL_CONV_STUB( IfcOpeningStandardCase );
    DECL_CONV_STUB( IfcOrientedEdge );
    DECL_CONV_STUB( IfcOuterBoundaryCurve );
    DECL_CONV_STUB( IfcOutlet );
    DECL_CONV_STUB( IfcOutletType );
    DECL_CONV_STUB( IfcPath );
    DECL_CONV_STUB( IfcPcurve );
    DECL_CONV_STUB( IfcPerformanceHistory );
    DECL_CONV_STUB( IfcPermit );
    DECL_CONV_STUB( IfcPile );
    DECL_CONV_STUB( IfcPileType );
    DECL_CONV_STUB( IfcPipeFitting );
    DECL_CONV_STUB( IfcPipeFittingType );
    DECL_CONV_STUB( IfcPipeSegment );
    DECL_CONV_STUB( IfcPipeSegmentType );
    DECL_CONV_STUB( IfcPlanarExtent );
    DECL_CONV_STUB( IfcPlanarBox );
    DECL_CONV_STUB( IfcPlane );
    DECL_CONV_STUB( IfcPlate );
    DECL_CONV_STUB( IfcPlateStandardCase );
    DECL_CONV_STUB( IfcPlateType );
    DECL_CONV_STUB( IfcPointOnCurve );
    DECL_CONV_STUB( IfcPointOnSurface );
    DECL_CONV_STUB( IfcPolyLoop );
    DECL_CONV_STUB( IfcPolygonalBoundedHalfSpace );
    DECL_CONV_STUB( IfcTessellatedFaceSet );
    DECL_CONV_STUB( IfcPolygonalFaceSet );
    DECL_CONV_STUB( IfcPolyline );
    DECL_CONV_STUB( IfcPresentationStyleAssignment );
    DECL_CONV_STUB( IfcProcedure );
    DECL_CONV_STUB( IfcProcedureType );
    DECL_CONV_STUB( IfcProductDefinitionShape );
    DECL_CONV_STUB( IfcProject );
    DECL_CONV_STUB( IfcProjectLibrary );
    DECL_CONV_STUB( IfcProjectOrder );
    DECL_CONV_STUB( IfcProjectionElement );
    DECL_CONV_STUB( IfcSimpleProperty );
    DECL_CONV_STUB( IfcPropertyBoundedValue );
    DECL_CONV_STUB( IfcPropertyEnumeratedValue );
    DECL_CONV_STUB( IfcPropertyListValue );
    DECL_CONV_STUB( IfcPropertyReferenceValue );
    DECL_CONV_STUB( IfcPropertySet );
    DECL_CONV_STUB( IfcPropertySingleValue );
    DECL_CONV_STUB( IfcPropertyTableValue );
    DECL_CONV_STUB( IfcProtectiveDevice );
    DECL_CONV_STUB( IfcProtectiveDeviceTrippingUnit );
    DECL_CONV_STUB( IfcProtectiveDeviceTrippingUnitType );
    DECL_CONV_STUB( IfcProtectiveDeviceType );
    DECL_CONV_STUB( IfcProxy );
    DECL_CONV_STUB( IfcPump );
    DECL_CONV_STUB( IfcPumpType );
    DECL_CONV_STUB( IfcRailing );
    DECL_CONV_STUB( IfcRailingType );
    DECL_CONV_STUB( IfcRamp );
    DECL_CONV_STUB( IfcRampFlight );
    DECL_CONV_STUB( IfcRampFlightType );
    DECL_CONV_STUB( IfcRampType );
    DECL_CONV_STUB( IfcRationalBSplineCurveWithKnots );
    DECL_CONV_STUB( IfcRationalBSplineSurfaceWithKnots );
    DECL_CONV_STUB( IfcRectangleProfileDef );
    DECL_CONV_STUB( IfcRectangleHollowProfileDef );
    DECL_CONV_STUB( IfcRectangularPyramid );
    DECL_CONV_STUB( IfcRectangularTrimmedSurface );
    DECL_CONV_STUB( IfcReinforcingElement );
    DECL_CONV_STUB( IfcReinforcingBar );
    DECL_CONV_STUB( IfcReinforcingElementType );
    DECL_CONV_STUB( IfcReinforcingBarType );
    DECL_CONV_STUB( IfcReinforcingMesh );
    DECL_CONV_STUB( IfcReinforcingMeshType );
    DECL_CONV_STUB( IfcRelationship );
    DECL_CONV_STUB( IfcRelDecomposes );
    DECL_CONV_STUB( IfcRelAggregates );
    DECL_CONV_STUB( IfcRelConnects );
    DECL_CONV_STUB( IfcRelContainedInSpatialStructure );
    DECL_CONV_STUB( IfcRelDefines );
    DECL_CONV_STUB( IfcRelDefinesByProperties );
    DECL_CONV_STUB( IfcRelFillsElement );
    DECL_CONV_STUB( IfcRelVoidsElement );
    DECL_CONV_STUB( IfcReparametrisedCompositeCurveSegment );
    DECL_CONV_STUB( IfcRepresentation );
    DECL_CONV_STUB( IfcRepresentationMap );
    DECL_CONV_STUB( IfcRevolvedAreaSolid );
    DECL_CONV_STUB( IfcRevolvedAreaSolidTapered );
    DECL_CONV_STUB( IfcRightCircularCone );
    DECL_CONV_STUB( IfcRightCircularCylinder );
    DECL_CONV_STUB( IfcRoof );
    DECL_CONV_STUB( IfcRoofType );
    DECL_CONV_STUB( IfcRoundedRectangleProfileDef );
    DECL_CONV_STUB( IfcSIUnit );
    DECL_CONV_STUB( IfcSanitaryTerminal );
    DECL_CONV_STUB( IfcSanitaryTerminalType );
    DECL_CONV_STUB( IfcSeamCurve );
    DECL_CONV_STUB( IfcSectionedSpine );
    DECL_CONV_STUB( IfcSensor );
    DECL_CONV_STUB( IfcSensorType );
    DECL_CONV_STUB( IfcShadingDevice );
    DECL_CONV_STUB( IfcShadingDeviceType );
    DECL_CONV_STUB( IfcShapeModel );
    DECL_CONV_STUB( IfcShapeRepresentation );
    DECL_CONV_STUB( IfcShellBasedSurfaceModel );
    DECL_CONV_STUB( IfcSite );
    DECL_CONV_STUB( IfcSlab );
    DECL_CONV_STUB( IfcSlabElementedCase );
    DECL_CONV_STUB( IfcSlabStandardCase );
    DECL_CONV_STUB( IfcSlabType );
    DECL_CONV_STUB( IfcSolarDevice );
    DECL_CONV_STUB( IfcSolarDeviceType );
    DECL_CONV_STUB( IfcSpace );
    DECL_CONV_STUB( IfcSpaceHeater );
    DECL_CONV_STUB( IfcSpaceHeaterType );
    DECL_CONV_STUB( IfcSpatialElementType );
    DECL_CONV_STUB( IfcSpatialStructureElementType );
    DECL_CONV_STUB( IfcSpaceType );
    DECL_CONV_STUB( IfcSpatialZone );
    DECL_CONV_STUB( IfcSpatialZoneType );
    DECL_CONV_STUB( IfcSphere );
    DECL_CONV_STUB( IfcSphericalSurface );
    DECL_CONV_STUB( IfcStackTerminal );
    DECL_CONV_STUB( IfcStackTerminalType );
    DECL_CONV_STUB( IfcStair );
    DECL_CONV_STUB( IfcStairFlight );
    DECL_CONV_STUB( IfcStairFlightType );
    DECL_CONV_STUB( IfcStairType );
    DECL_CONV_STUB( IfcStructuralActivity );
    DECL_CONV_STUB( IfcStructuralAction );
    DECL_CONV_STUB( IfcStructuralAnalysisModel );
    DECL_CONV_STUB( IfcStructuralItem );
    DECL_CONV_STUB( IfcStructuralConnection );
    DECL_CONV_STUB( IfcStructuralCurveAction );
    DECL_CONV_STUB( IfcStructuralCurveConnection );
    DECL_CONV_STUB( IfcStructuralMember );
    DECL_CONV_STUB( IfcStructuralCurveMember );
    DECL_CONV_STUB( IfcStructuralCurveMemberVarying );
    DECL_CONV_STUB( IfcStructuralReaction );
    DECL_CONV_STUB( IfcStructuralCurveReaction );
    DECL_CONV_STUB( IfcStructuralLinearAction );
    DECL_CONV_STUB( IfcStructuralLoadGroup );
    DECL_CONV_STUB( IfcStructuralLoadCase );
    DECL_CONV_STUB( IfcStructuralSurfaceAction );
    DECL_CONV_STUB( IfcStructuralPlanarAction );
    DECL_CONV_STUB( IfcStructuralPointAction );
    DECL_CONV_STUB( IfcStructuralPointConnection );
    DECL_CONV_STUB( IfcStructuralPointReaction );
    DECL_CONV_STUB( IfcStructuralResultGroup );
    DECL_CONV_STUB( IfcStructuralSurfaceConnection );
    DECL_CONV_STUB( IfcStructuralSurfaceMember );
    DECL_CONV_STUB( IfcStructuralSurfaceMemberVarying );
    DECL_CONV_STUB( IfcStructuralSurfaceReaction );
    DECL_CONV_STUB( IfcStyleModel );
    DECL_CONV_STUB( IfcStyledItem );
    DECL_CONV_STUB( IfcStyledRepresentation );
    DECL_CONV_STUB( IfcSubContractResource );
    DECL_CONV_STUB( IfcSubContractResourceType );
    DECL_CONV_STUB( IfcSubedge );
    DECL_CONV_STUB( IfcSurfaceCurveSweptAreaSolid );
    DECL_CONV_STUB( IfcSurfaceFeature );
    DECL_CONV_STUB( IfcSweptSurface );
    DECL_CONV_STUB( IfcSurfaceOfLinearExtrusion );
    DECL_CONV_STUB( IfcSurfaceOfRevolution );
    DECL_CONV_STUB( IfcSurfaceStyle );
    DECL_CONV_STUB( IfcSurfaceStyleShading );
    DECL_CONV_STUB( IfcSurfaceStyleRendering );
    DECL_CONV_STUB( IfcSurfaceStyleWithTextures );
    DECL_CONV_STUB( IfcSweptDiskSolid );
    DECL_CONV_STUB( IfcSweptDiskSolidPolygonal );
    DECL_CONV_STUB( IfcSwitchingDevice );
    DECL_CONV_STUB( IfcSwitchingDeviceType );
    DECL_CONV_STUB( IfcSystemFurnitureElement );
    DECL_CONV_STUB( IfcSystemFurnitureElementType );
    DECL_CONV_STUB( IfcTShapeProfileDef );
    DECL_CONV_STUB( IfcTank );
    DECL_CONV_STUB( IfcTankType );
    DECL_CONV_STUB( IfcTask );
    DECL_CONV_STUB( IfcTaskType );
    DECL_CONV_STUB( IfcTendon );
    DECL_CONV_STUB( IfcTendonAnchor );
    DECL_CONV_STUB( IfcTendonAnchorType );
    DECL_CONV_STUB( IfcTendonType );
    DECL_CONV_STUB( IfcTextLiteral );
    DECL_CONV_STUB( IfcTextLiteralWithExtent );
    DECL_CONV_STUB( IfcTopologyRepresentation );
    DECL_CONV_STUB( IfcToroidalSurface );
    DECL_CONV_STUB( IfcTransformer );
    DECL_CONV_STUB( IfcTransformerType );
    DECL_CONV_STUB( IfcTransportElement );
    DECL_CONV_STUB( IfcTransportElementType );
    DECL_CONV_STUB( IfcTrapeziumProfileDef );
    DECL_CONV_STUB( IfcTriangulatedFaceSet );
    DECL_CONV_STUB( IfcTrimmedCurve );
    DECL_CONV_STUB( IfcTubeBundle );
    DECL_CONV_STUB( IfcTubeBundleType );
    DECL_CONV_STUB( IfcUShapeProfileDef );
    DECL_CONV_STUB( IfcUnitAssignment );
    DECL_CONV_STUB( IfcUnitaryControlElement );
    DECL_CONV_STUB( IfcUnitaryControlElementType );
    DECL_CONV_STUB( IfcUnitaryEquipment );
    DECL_CONV_STUB( IfcUnitaryEquipmentType );
    DECL_CONV_STUB( IfcValve );
    DECL_CONV_STUB( IfcValveType );
    DECL_CONV_STUB( IfcVector );
    DECL_CONV_STUB( IfcVertex );
    DECL_CONV_STUB( IfcVertexLoop );
    DECL_CONV_STUB( IfcVertexPoint );
    DECL_CONV_STUB( IfcVibrationIsolator );
    DECL_CONV_STUB( IfcVibrationIsolatorType );
    DECL_CONV_STUB( IfcVirtualElement );
    DECL_CONV_STUB( IfcVoidingFeature );
    DECL_CONV_STUB( IfcWall );
    DECL_CONV_STUB( IfcWallElementedCase );
    DECL_CONV_STUB( IfcWallStandardCase );
    DECL_CONV_STUB( IfcWallType );
    DECL_CONV_STUB( IfcWasteTerminal );
    DECL_CONV_STUB( IfcWasteTerminalType );
    DECL_CONV_STUB( IfcWindow );
    DECL_CONV_STUB( IfcWindowStandardCase );
    DECL_CONV_STUB( IfcWindowStyle );
    DECL_CONV_STUB( IfcWindowType );
    DECL_CONV_STUB( IfcWorkCalendar );
    DECL_CONV_STUB( IfcWorkControl );
    DECL_CONV_STUB( IfcWorkPlan );
    DECL_CONV_STUB( IfcWorkSchedule );
    DECL_CONV_STUB( IfcZShapeProfileDef );
    DECL_CONV_STUB( IfcZone );


#undef DECL_CONV_STUB

} //! Schema_4
} //! STEP
} //! Assimp

#endif // INCLUDED_IFC_READER_GEN_H
