/*
 * aBasic
 * Copyright (C) 2007 m_inaba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "common.h"
#include "calc.h"
#include "variant.h"
#include "variant_io.h"
#include "st_inst.h"


#define EVAL		0x80000000
#define IF			0x20000000

//MAX 0xFF ʂɂ荶8Vtg
#define NOTHING		0x01

#define FOR			0x10
#define NEXT		0x11
#define GOTO		0x12
#define GOSUB		0x13
#define RETURN		0x14
#define INPUT		0x15
#define PRINT		0x16
#define CLR			0x17
#define LOCATION	0x18
#define WAIT		0x19
#define ABS			0x1A
#define SHELL		0x1B
#define LEN			0x1C
#define MID			0x1D
#define VAL			0x1E
#define STR			0x1F
#define CSV			0x20
#define CHOP		0x21
#define REPLACE		0x22
#define MATCH		0x23
#define VSC			0x24
#define FREAD		0x25
#define FWRITE		0x26
#define IF2			0x27
#define ELSE		0x28
#define TRIM		0x29
#define LTRIM		0x2A
#define RTRIM		0x2B
#define LCASE		0x2C
#define UCASE		0x2D
#define LEFT		0x2E
#define RIGHT		0x2F
#define JIS			0x30
#define ASC			0x31
#define INSTR		0x32
#define BLOCK		0x33

#define EXP			0xFE
#define MASK		0xFF

unsigned int p_counter; //vOJE^
std::vector<std::string> source; //basic̃vOi[z
std::vector<unsigned long> jmp_true; //basic̃vÕWvz
std::vector<unsigned long> jmp_false;//if̕򌋉ʂɂ2ނ̃AhXKvɂȂ
std::vector<unsigned long> func; //basic̃vO̖߂z

/*
func\ς݃rbg
--------------------------------
*.*.............****************
--------------------------------
32              16             1 LSB

32bit  eval
30bit  IF
16bit`1bit e햽
*/

std::vector<unsigned long> lineNo; //si[z
std::vector<unsigned char> func_true; //֐̃Xe[^Xi[z
std::vector<unsigned char> func_false;
/*
func_true,func_false\ς݃rbg
--------
*****..*
--------
8      1 LSB

8bit`5bit e햽
4bit  _arry֐
1bit ꎞprbg(p0ɖ߂)
*/

static char buff[MAX_STR_LEN];
static char buff2[MAX_STR_LEN];


void instcpy(char*out,char*in);
int fileLoad(char*filename);
int basic_init(char*filename);
void basic_setup();
void basic_start(int adder);
void basic_end();

int eval_(char*str);

int fileLoad(char*filename){
	//basicvOǂݍ݁AHăxN^[zɊi[
	FILE * fp;
	if((fp=fopen(filename,"r"))==NULL){
		//G[
		printf("%s : %s\n","file open error",filename);
		return 1;
	}else{
		unsigned long line=0;//sԍ
		while(fgets(buff,MAX_STR_LEN,fp)!=NULL){
			line++;//ۂ̍sԍ
			instcpy(buff2,buff);
			trim_rl(buff2);

			if(*buff2){
				if(0==strncmp(buff2,"import ",sizeof("import ")-1)){
					char*pos=buff2+sizeof("import ")-1;//߂̌̕ϐo
					//_uNI[e[V<>菜
					if('\"'==*pos){
						pos++;
						pos[strlen(pos)-1]='\0';
					}else if('<'==*pos){
						pos++;
						pos[strlen(pos)-1]='\0';
					}
					if(fileLoad(pos)) return 1;
				}else{
					source.push_back(buff2);
					jmp_true.push_back(0);
					jmp_false.push_back(0);
					func.push_back(0);
					func_true.push_back(0);
					func_false.push_back(0);
					lineNo.push_back(line);//ۂ̍sԍۑ
				}
			}
		}
		fclose(fp);
	}
	return 0;	
}

int basic_init(char*filename){
	srand((unsigned)time(NULL));//̎
	//\G[̋s[hݒ 0:s
	setVariable("system.err.exit","0");

	int r = fileLoad(filename);
	
	source.push_back("\xFF");//EOFŌɒǉ
	jmp_true.push_back(0);
	jmp_false.push_back(0);
	func.push_back(0);
	func_true.push_back(0);
	func_false.push_back(0);
	lineNo.push_back((unsigned long)-1);
	
	return r;
}

void basic_setup(){
	//x̃AhXɓo^
	char*pos;
	for(unsigned int i=0;i<source.size();i++){
		_strcpy(buff,source[i].c_str());
		pos=_strchop(buff ,' ');//1ڂ؂o܂B
		if(NULL==pos) pos=buff;//؂osꍇ
		sprintf(buff2,"%s%s","@",buff);
		sprintf(buff,"%d",i);
		setVariable(buff2,buff);
	}
}

void basic_start(int adder){
	p_counter=adder;
	int rst;
	unsigned int pos;
	std::vector<unsigned long>*jmp;
	int label_flag;//xŗL\ꍇ̃tO
	unsigned char*func_flag;
	
	//[hG[
	if('\0'!=*getVariableConst("system.err")){
		printf("ERR line:%s\n",getVariableConst("system.err"));
		setVariable("system.err.msg",getVariableConst("system.err"));
		return;
	}
	
	while(1){
		char*str=buff;
		_strcpy(str,source[p_counter++].c_str());
//printf("%s\n",str);
		rst=0;
		//EOF̏
		if(*str==EOF){//EOF
			break;
		}

		//\xł邩`FbN
		//x̏ꍇ͍\G[邽
		//\ɃXy[X1̏ꍇɂ̓xƉ肷
		//_uNI[e[Vł܂܂Ăꍇ̓xłȂƉ肷
		//x̏ꍇ͍\G[𖳎
		label_flag=0;
		if(2>count_c((const char*)str,' ')){
			if(!count_c((const char*)str,'\"')) label_flag=1;//xł\
		}

		//eval̏
		if(!(func[p_counter]&EVAL)){
			if(eval_(str)){
				//eval
				//̎_Ńobt@̒Ă				
				//eval͓Ȗ߂̂ߑSĂNA
				func[p_counter]=0;
				func_true[p_counter]=0;
				func_false[p_counter]=0;
				jmp_true[p_counter]=0;//WvZbg
				jmp_false[p_counter]=0;
			}else{
				//evalł͂Ȃ
				func[p_counter]|=EVAL;
			}
		}


		//if̌ʂɂVtgl
		int if_shift=0;
		
		//֐̃Xe[^X
		func_flag=(unsigned char*)&func_true[p_counter];

		//OutputDebugString(str);OutputDebugString("\n");//fobOo

		//WvAhXۑz
		jmp=&jmp_true;
		
		//IF̏ if **** then **** else **** \̏
		if(!(func[p_counter]&IF)){
			rst=if_(str,NULL);
			//߂lɕ򌋉ʂĂ
			if(2==rst){
				//FALSȄꍇ
				if_shift=8;//Vtglݒ
				//֐̃Xe[^X
				func_flag=(unsigned char*)&func_false[p_counter];
				jmp=&jmp_false;//WvAhXۑzւ
			}else if(0==rst){
				//IFŖꍇ 1𗧂Ă
				func[p_counter]|=IF;
			}
		}
		//ߕ󕶎̏ꍇ͎̍sɐi
		if('\0'==*str) {func[p_counter]|=(NOTHING<<if_shift);goto LOOP_LAST;}

		if(0==(func[p_counter]&(MASK<<if_shift))){
			pos=p_counter;
			//foȑ
			if(for_(str,func_flag)){func[pos]|=(FOR<<if_shift);}
			//next̏
			else if(next_(str,&source,&p_counter,jmp,func_flag)){func[pos]|=(NEXT<<if_shift);}
			//gotȍ
			else if(goto_(str,&p_counter,func_flag)){func[pos]|=(GOTO<<if_shift);}
			//gosub̏
			else if(gosub_(str,&source,&p_counter,func_flag)){func[pos]|=(GOSUB<<if_shift);}
			//return̏
			else if(rst=return_(str,&p_counter,func_flag)){func[pos]|=(RETURN<<if_shift);}
			//sɓnif̏
			else if(if2_(str,&source,&p_counter,jmp,func_flag)){func[pos]|=(IF2<<if_shift);}
			//elsȅ
			else if(else_(str,&source,&p_counter,jmp,func_flag)){func[pos]|=(ELSE<<if_shift);}
			//input̏
			else if(input_(str,func_flag)){func[pos]|=(INPUT<<if_shift);}
			//print̏
			else if(print_(str,func_flag)){func[pos]|=(PRINT<<if_shift);}
			//clȑ
			else if(clr_(str,func_flag)){func[pos]|=(CLR<<if_shift);}
			//location̏
			else if(location_(str,func_flag)){func[pos]|=(LOCATION<<if_shift);}
			//wait̏
			else if(wait_(str,func_flag)){func[pos]|=(WAIT<<if_shift);}
			//abs̏
			else if(abs_(str,func_flag)){func[pos]|=(ABS<<if_shift);}
			//shell̏
			else if(shell_(str,func_flag)){func[pos]|=(SHELL<<if_shift);}
			//len̏
			else if(len_(str,func_flag)){func[pos]|=(LEN<<if_shift);}
			//mid̏
			else if(mid_(str,func_flag)){func[pos]|=(MID<<if_shift);}
			//val̏
			else if(val_(str,func_flag)){func[pos]|=(VAL<<if_shift);}
			//stȑ
			else if(str_(str,func_flag)){func[pos]|=(STR<<if_shift);}
			//csv̏
			else if(csv_(str,func_flag)){func[pos]|=(CSV<<if_shift);}
			//vsc̏
			else if(vsc_(str,func_flag)){func[pos]|=(VSC<<if_shift);}
			//chop̏
			else if(chop_(str,func_flag)){func[pos]|=(CHOP<<if_shift);}
			//trim̏
			else if(trim_(str,func_flag)){func[pos]|=(TRIM<<if_shift);}
			//ltrim̏
			else if(ltrim_(str,func_flag)){func[pos]|=(LTRIM<<if_shift);}
			//rtrim̏
			else if(rtrim_(str,func_flag)){func[pos]|=(RTRIM<<if_shift);}
			//replacȅ
			else if(replace_(str,func_flag)){func[pos]|=(REPLACE<<if_shift);}
			//match̏
			else if(match_(str,func_flag)){func[pos]|=(MATCH<<if_shift);}
			//lcasȅ
			else if(lcase_(str,func_flag)){func[pos]|=(LCASE<<if_shift);}
			//ucasȅ
			else if(ucase_(str,func_flag)){func[pos]|=(UCASE<<if_shift);}
			//left̏
			else if(left_(str,func_flag)){func[pos]|=(LEFT<<if_shift);}
			//right̏
			else if(right_(str,func_flag)){func[pos]|=(RIGHT<<if_shift);}
			//jis̏
			else if(jis_(str,func_flag)){func[pos]|=(JIS<<if_shift);}
			//asc̏
			else if(asc_(str,func_flag)){func[pos]|=(ASC<<if_shift);}
			//instȑ
			else if(instr_(str,func_flag)){func[pos]|=(INSTR<<if_shift);}
			//fread̏
			else if(fread_(str,func_flag)){func[pos]|=(FREAD<<if_shift);}
			//fwritȅ
			else if(fwrite_(str,func_flag)){func[pos]|=(FWRITE<<if_shift);}
			//@_̏
			else if(block_(str,&source,&p_counter,jmp,func_flag)){func[pos]|=(BLOCK<<if_shift);}
			//END̏
			else if(0==strncmp(str,"end",sizeof("end")-1)){//END
				if(strlen(str)==strlen("end")) break;
			}
			//̏
			else if(strstr(str,"=")){
				func[pos]|=(EXP<<if_shift);
				trim_a(str);
				if(!calculation(str)) *func_flag|=0x40;//񂩂͌vZKvȂ
			}
			//\G[̏
			else {
				func[pos]|=(NOTHING<<if_shift);
				//xłȂꍇɂ̓G[
				if(!label_flag){
					//G[
					setVariable("system.err",str);
				}
			}
		}else{
			
			switch ((func[p_counter]&(MASK<<if_shift))>>if_shift){
				case FOR:
					//foȑ
					for_(str,func_flag);
					break;
				case NEXT:
					//next̏
					next_(str,&source,&p_counter,jmp,func_flag);
					break;
				case GOTO:
					//gotȍ
					goto_(str,&p_counter,func_flag);
					break;
				case GOSUB:
					//gosub̏
					gosub_(str,&source,&p_counter,func_flag);
					break;
				case RETURN:
					//return̏
					rst=return_(str,&p_counter,func_flag);
					break;
				case IF2:
					//sɓnif̏
					if2_(str,&source,&p_counter,jmp,func_flag);
					break;
				case ELSE:
					//elsȅ
					else_(str,&source,&p_counter,jmp,func_flag);
					break;
				case INPUT:
					//input̏
					input_(str,func_flag);
					break;
				case PRINT:
					//print̏
					print_(str,func_flag);
					break;
				case CLR:
					//clȑ
					clr_(str,func_flag);
					break;
				case LOCATION:	
					//location̏
					location_(str,func_flag);
					break;
				case WAIT:
					//wait̏
					wait_(str,func_flag);
					break;
				case ABS:
					//abs̏
					abs_(str,func_flag);
					break;
				case SHELL:
					//shell̏
					shell_(str,func_flag);
					break;
				case LEN:
					//len̏
					len_(str,func_flag);
					break;
				case MID:
					//mid̏
					mid_(str,func_flag);
					break;
				case VAL:
					//val̏
					val_(str,func_flag);
					break;
				case STR:
					//stȑ
					str_(str,func_flag);
					break;
				case CSV:
					//csv̏
					csv_(str,func_flag);
					break;
				case VSC:
					//vsc̏
					vsc_(str,func_flag);
					break;
				case CHOP:
					//chop̏
					chop_(str,func_flag);
					break;
				case TRIM:
					//trim̏
					trim_(str,func_flag);
					break;
				case LTRIM:
					//ltrim̏
					ltrim_(str,func_flag);
					break;
				case RTRIM:
					//rtrim̏
					rtrim_(str,func_flag);
					break;
				case REPLACE:
					//replacȅ
					replace_(str,func_flag);
					break;
				case MATCH:
					//match̏
					match_(str,func_flag);
					break;
				case LCASE:
					//lcasȅ
					lcase_(str,func_flag);
					break;
				case UCASE:
					//ucasȅ
					ucase_(str,func_flag);
					break;
				case LEFT:
					//left̏
					left_(str,func_flag);
					break;
				case RIGHT:
					//right̏
					right_(str,func_flag);
					break;
				case JIS:
					//jis̏
					jis_(str,func_flag);
					break;
				case ASC:
					//asc̏
					asc_(str,func_flag);
					break;
				case INSTR:
					//instȑ
					instr_(str,func_flag);
					break;
				case FREAD:
					//fread̏
					fread_(str,func_flag);
					break;
				case FWRITE:
					//fwritȅ
					fwrite_(str,func_flag);
					break;
				case BLOCK:
					//@_̏
					block_(str,&source,&p_counter,jmp,func_flag);
					break;
				case EXP:
					//̏
					trim_a(str);
					if(0x40 & *func_flag){
						//vZKvȂ̂
						substitution(str);
					}else{
						//vZKv
						calculation(str);
					}
					break;
			}
		}
		if(-1==rst) break;//returnŖ߂lꍇɂ͏I
LOOP_LAST:;
		//G[
		if('\0'!=*getVariableConst("system.err")){
			printf("ERR line:%d\tmsg:%s\tsource:%s\n",lineNo[p_counter-1],getVariableConst("system.err"),str);
			char pos[16];
			sprintf(pos,"%d",lineNo[p_counter-1]);
			setVariable("system.err.line",pos);
			setVariable("system.err.msg",getVariableConst("system.err"));
			setVariable("system.err","");
			//G[̋s[h̊mF 0:s 0ȊO:vOI
			if(0!=strcmp("0",getVariableConst("system.err.exit"))) return;
		}
	}
}

void basic_end(){
//	for(int i=0;i<source.size();i++){
//		printf("%d:%s\n",i,source[i].c_str());	
//	}
}

//load߂͓Ȗ߂̂߂ɋLq
int load_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"load ",sizeof("load ")-1)){
		*(str + sizeof("load")-1)='=';//print=vZ@ɕό`
		trim_a(str);
		
		if(0x40 & *flag){
			//vZKvȂ̂
			substitution(str);
		}else{
			//vZKv
			if(!calculation(str)) *flag|=0x40;//񂩂͌vZKvȂ
		}
		
		//͕ȅꍇ̏
		//ϐ̏ꍇ̏
		char*str_ptr=getVariable("load");
		//\擪"菜
		if('\"'==*str_ptr) str_ptr++;
		
		//[h̓ǂݍ݃G[ꍇɂ̓tO𗧂ĂĂ
		if(fileLoad(str_ptr) || '\0'!=*getVariableConst("system.err.load")){
			setVariable("system.err","ERR \"load\"");
		}
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}

}

int main(int argc, char* argv[]){
	if(argc>1){
		if(basic_init(argv[1])) return 1;
		//R}hCC^v^̕ϐɊi[
		int i;
		for(i=0;i<argc;i++){
			sprintf(buff,"args[\"%d\"]",i+1);
			sprintf(buff2,"\"%s",argv[i]);
			setVariable(buff,buff2);
		}
		sprintf(buff,"args[\"%d\"]",i+1);
		setVariable(buff,"\",");
		
		basic_setup();
		basic_start(0);//basicC^v^̊Jn
		basic_end();
	}else{
		printf("%s\n","basic [basic program text file name]");
	}
	return 0;
}

//-------------------------------------------------------------------------------
