import jp.sourceforge.acerola3d.a3.*;
import javax.swing.*;
import javax.media.j3d.*;
import com.sun.j3d.utils.universe.SimpleUniverse;
import javax.vecmath.*;
import java.awt.event.*;
import java.awt.*;

public class J3DTest {
    public static void main(String args[]) throws Exception {
        JFrame frame = new JFrame("Java3D");
        frame.setLayout(new BorderLayout());

        GraphicsConfiguration gc = SimpleUniverse.getPreferredConfiguration();
        Canvas3D canvas = new Canvas3D(gc);
        canvas.setSize(300,300);
        frame.add(canvas);

        SimpleUniverse universe = new SimpleUniverse(canvas);
        BranchGroup bg = new BranchGroup();
        Light headLight = new DirectionalLight();
        headLight.setInfluencingBounds(new BoundingSphere(new Point3d(0.0,0.0,0.0),100.0));
        headLight.setEnable(true);
        bg.addChild(headLight);
        //bg.addChild(new com.sun.j3d.utils.geometry.ColorCube(0.5));
        
        Action3D a3 = Action3D.load("x-res:///axis.a3");
        bg.addChild(a3.getNode());
        universe.addBranchGraph(bg);
        universe.getViewingPlatform().setNominalViewingTransform();

        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
        try{Thread.sleep(3000);}catch(Exception e){;}
        a3.change(1);
        a3.setLoc(1.0,0.0,0.0);
    }
}
