package jp.sourceforge.acerola3d.a3;

import javax.vecmath.*;

/**
 * A3CanvasやA3Windowなどに登録されたアバターを
 * 追跡するようにカメラを自動制御するコントローラです。
 * A3CanvasやA3WindowなどのsetA3Controllerメソッドで
 * 有効化します。
 */
public class ChaseController extends A3Controller implements Runnable {
    Thread t;
    volatile boolean stopRequest = false;
    Matrix4d mc; //

    /**
     * アバタ後方5メートルから追跡するように
     * カメラを自動制御するコントローラを生成
     * します。
     */
    public ChaseController() {
        mc = new Matrix4d(new Quat4d(0.0,1.0,0.0,0.0),new Vector3d(0.0,0.0,-5.0),1.0);
    }
    /**
     * アバタを追跡するようにカメラを自動制御する
     * コントローラを生成します。引数はアバタの
     * 座標系をカメラの座標系へ写像するアフィン変換。
     */
    public ChaseController(Matrix4d mc) {
        this.mc = new Matrix4d(mc);
    }

    /**
     * 初期化処理をします。Acerola3Dパッケージの内部で
     * 使用されるメソッドなので直接呼び出さないで下さい。
     */
    public void init() {
        stopRequest = false;
        t = new Thread(this);
        t.start();
    }

    /**
     * 終了処理をします。Acerola3Dパッケージの内部で
     * 使用されるメソッドなので直接呼び出さないで下さい。
     */
    public void stop() {
        stopRequest = true;
    }

    /**
     * 処理をします。Acerola3Dパッケージの内部で
     * 使用されるメソッドなので直接呼び出さないで下さい。
     */
    public void run() {
        while (!stopRequest) {
            A3Object avatar = a3canvas.getAvatar();
            if (avatar==null) {
                try{Thread.sleep(100);}catch(Exception e){;}
                continue;
            }
            Vector3d av = avatar.getLoc();
            Quat4d aq = avatar.getQuat();
            double as = avatar.getScale();
            Matrix4d ma = new Matrix4d(aq,av,as);
            ma.mul(mc);
            ma.get(av);
            ma.get(aq);
            as = ma.getScale();
            //a3canvas.setCameraLocImmediately(av);
            //a3canvas.setCameraQuatImmediately(aq);
            //a3canvas.setCameraScaleImmediately(as);
            a3canvas.setCameraLoc(av);
            a3canvas.setCameraQuat(aq);
            a3canvas.setCameraScale(as);
            try{Thread.sleep(100);}catch(Exception e){;}
        }
    }
}
