package jp.sourceforge.acerola3d.a3;

import javax.media.j3d.*;
import java.util.*;

/**
 * プログラムからキャラクタのモーションを操作するための
 * オブジェクト．
 */
public class Marionette implements Motion {
    String rootBone;
    HashMap<String,String[]> boneHash = new HashMap<String,String[]>();
    HashMap<String,Transform3D> transHash = new HashMap<String,Transform3D>();

    /**
     * 秒単位でモーションの長さを返す．
     */
    public double getMotionLength() {
        return -1.0;
    }

    /**
     * デフォルトのフレームタイムを返す．
     */
    public double getDefaultFrameTime() {
        return 0.0333;
    }

    /**
     * ルートのbone名を返す．
     */
    public String getRootBone() {
        return rootBone;
    }

    /**
     * 指定したboneの子boneを返す．
     */
    public String[] getChildBones(String boneName) {
        return boneHash.get(boneName).clone();
    }

    /**
     * 指定された骨と時間における座標変換を返す．
     */
    public Transform3D getTransform3D(String bone,double time) {
        return new Transform3D(transHash.get(bone));
    }

    /**
     * ルートboneを指定する．
     */
    public void setRootBone(String rootBone) {
        this.rootBone = rootBone;
    }

    /**
     * 指定したboneの子boneをセットする．
     */
    public void setChildBones(String parent,String[] children) {
        boneHash.put(parent,children.clone());
    }

    /**
     * 指定された骨と時間における座標変換をセットする．
     */
    public void getTransform3D(String bone,double time,Transform3D trans) {
        transHash.put(bone,new Transform3D(trans));
    }
}
