package jp.sourceforge.acerola3d.a3;

import javax.media.j3d.*;
import javax.vecmath.*;
import jp.sourceforge.acerola3d.A23;
import java.net.URL;

/**
 * 仮想空間の背景を表現するためのクラス。
 */
public class A3Background extends A3Object {
    static BoundingSphere bs = new BoundingSphere(new Point3d(0.0,0.0,0.0),100.0);
    Background background;

    /**
     * デフォルトのパラメータでA3Backgroundオブジェクトを生成します。
     */
    public A3Background() {
        super(new A3InitData("jp.sourceforge.acerola3d.a3.A3Background"));
        A3InitData d = new A3InitData("jp.sourceforge.acerola3d.a3.A3Background");
        d.set(0.0f,0.0f,0.0f);
        realConstructor(d);
    }

    /**
     * R,G,Bで指定された色の背景を持つ3Backgroundオブジェクトを生成します。
     */
    public A3Background(float r,float g,float b) {
        super(new A3InitData("jp.sourceforge.acerola3d.a3.A3Background"));
        A3InitData d = new A3InitData("jp.sourceforge.acerola3d.a3.A3Background");
        d.set(r,g,b);
        realConstructor(d);
    }

    /**
     * URLで指定されたVRMLを背景データとするA3Backgroundオブジェクトを生成します。
     */
    public A3Background(String url) {
        super(new A3InitData("jp.sourceforge.acerola3d.a3.A3Background"));
        A3InitData d = new A3InitData("jp.sourceforge.acerola3d.a3.A3Background");
        d.set(0.0f,0.0f,0.0f,url);
        realConstructor(d);
    }

    /**
     * A3InitDataをもとにA3Backgroundオブジェクトを生成するコンストラクタ。
     * A3InitDataにセットされるデータは、？？？
     * 
     * <table border="1">
     * <tr><td>0:float  </td><td>背景の色(赤成分) </td><td>必須</td></tr>
     * <tr><td>1:float  </td><td>背景の色(緑成分) </td><td>必須</td></tr>
     * <tr><td>2:float  </td><td>背景の色(青成分) </td><td>必須</td></tr>
     * <tr><td>3:String </td><td>背景のVRMLのURL  </td><td>任意</td></tr>
     * </table>
     */
    public A3Background(A3InitData d) {
        super(d);
        realConstructor(d);
    }

    void realConstructor(A3InitData d) {
        background = new Background();
        background.setApplicationBounds(bs);
        background.setCapability(Background.ALLOW_COLOR_WRITE);
        background.setCapability(Background.ALLOW_GEOMETRY_WRITE);
        float r = d.getFloat(0);
        float g = d.getFloat(1);
        float b = d.getFloat(2);
        background.setColor(r,g,b);
        if (d.getDataCount()>=4) {
            try {
                A23.initA23();
                VRML.initVRML();
                URL url = new URL(d.getString(3));
                BranchGroup bg = VRML.loader.load(url).getSceneGroup();
                background.setGeometry(bg);
System.out.println("*************gaha*************"+bg.toString());
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        setNode(background);
    }

    /**
     * A3UpdateDataの情報をもとに現在の3Dオブジェクトの
     * 状態を更新します。
     *
     * A3UpdateDataにセットするデータは以下のようになります。
     * 
     * <table border="1">
     * <tr><td>0:float  </td><td>背景の色(赤成分) </td><td>必須</td></tr>
     * <tr><td>1:float  </td><td>背景の色(緑成分) </td><td>必須</td></tr>
     * <tr><td>2:float  </td><td>背景の色(青成分) </td><td>必須</td></tr>
     * <tr><td>3:String </td><td>背景のVRMLのURL  </td><td>任意</td></tr>
     * </table>
     */
    public void update(A3UpdateData d) {
        super.update(d);
        float r = d.getFloat(0);
        float g = d.getFloat(1);
        float b = d.getFloat(2);
        background.setColor(r,g,b);
        if (d.getDataCount()>=4) {
            try {
                A23.initA23();
                VRML.initVRML();
                URL url = new URL(d.getString(3));
                BranchGroup bg = VRML.loader.load(url).getSceneGroup();
                background.setGeometry(bg);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
    /**
     * このA3Backgroundの色をR,G,Bで指定します。
     */
    public void setColor(float r,float g,float b) {
        background.setColor(r,g,b);
    }
    /**
     * このA3Backgroundの背景データを引数のBranchGroupの内容に
     * セットします。
     */
    public void setGeometry(BranchGroup bg) {
        background.setGeometry(bg);
    }
    /**
     * このA3Backgroundの背景データを引数のURLで指定されるVRMLに
     * セットします。
     */
    public void setVRML(String url) {
        try {
            A23.initA23();
            VRML.initVRML();
            URL u = new URL(url);
            BranchGroup bg = VRML.loader.load(u).getSceneGroup();
            background.setGeometry(bg);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
