/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.vecmath.Matrix3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Event;

class FlyController
extends A3Controller
implements Runnable {
    int startMouseX = -1;
    int startMouseY = -1;
    int lastMouseX;
    int lastMouseY;
    MouseStatus mouseStatus = MouseStatus.N;
    Thread t;
    volatile boolean stopRequest = false;

    FlyController() {
    }

    @Override
    public void init() {
        this.stopRequest = false;
        this.startMouseX = -1;
        this.startMouseY = -1;
        this.lastMouseX = 0;
        this.lastMouseY = 0;
        this.mouseStatus = MouseStatus.N;
        this.t = new Thread(this);
        this.t.start();
    }

    @Override
    public void stop() {
        this.stopRequest = true;
    }

    @Override
    public void run() {
        while (!this.stopRequest) {
            if (this.mouseStatus == MouseStatus.B1) {
                this.flyNavi();
            } else if (this.mouseStatus == MouseStatus.B2) {
                this.rotNavi();
            } else if (this.mouseStatus == MouseStatus.B3) {
                this.transNavi();
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void mousePressed(A3Event ae) {
        MouseEvent me = ae.getMouseEvent();
        this.startMouseX = me.getX();
        this.startMouseY = me.getY();
        this.lastMouseX = me.getX();
        this.lastMouseY = me.getY();
        if ((me.getModifiersEx() & 0x400) != 0) {
            this.mouseStatus = MouseStatus.B1;
        } else if ((me.getModifiersEx() & 0x800) != 0) {
            this.mouseStatus = MouseStatus.B2;
        } else if ((me.getModifiersEx() & 0x1000) != 0) {
            this.mouseStatus = MouseStatus.B3;
        }
    }

    @Override
    public void mouseDragged(A3Event ae) {
        MouseEvent me = ae.getMouseEvent();
        if (this.startMouseX == -1) {
            this.startMouseX = me.getX();
            this.startMouseY = me.getY();
        }
        this.lastMouseX = me.getX();
        this.lastMouseY = me.getY();
        if ((me.getModifiersEx() & 0x400) != 0) {
            this.mouseStatus = MouseStatus.B1;
        } else if ((me.getModifiersEx() & 0x800) != 0) {
            this.mouseStatus = MouseStatus.B2;
        } else if ((me.getModifiersEx() & 0x1000) != 0) {
            this.mouseStatus = MouseStatus.B3;
        }
    }

    void flyNavi() {
        Vector3d cameraV = this.a3canvas.getCameraLoc();
        Quat4d cameraQ = this.a3canvas.getCameraQuat();
        int shiftX = this.lastMouseX - this.startMouseX;
        int shiftY = this.lastMouseY - this.startMouseY;
        double s = 0.004 * (double)shiftY * this.a3canvas.getNavigationSpeed();
        Vector3d v = new Vector3d(0.0, 0.0, s);
        Matrix3d m = new Matrix3d();
        m.set(cameraQ);
        m.transform((Tuple3d)v);
        cameraV.add((Tuple3d)v);
        double t = (double)shiftX * -0.001;
        Quat4d q = new Quat4d(0.0, Math.sin(t), 0.0, Math.cos(t));
        cameraQ.mul(q);
        this.a3canvas.setCameraLocImmediately(cameraV);
        this.a3canvas.setCameraQuatImmediately(cameraQ);
    }

    void rotNavi() {
        Quat4d cameraQ = this.a3canvas.getCameraQuat();
        int shiftX = this.lastMouseX - this.startMouseX;
        int shiftY = this.lastMouseY - this.startMouseY;
        double t = (double)shiftY * -0.001;
        Quat4d q = new Quat4d(Math.sin(t), 0.0, 0.0, Math.cos(t));
        cameraQ.mul(q);
        t = (double)shiftX * -0.001;
        q = new Quat4d(0.0, Math.sin(t), 0.0, Math.cos(t));
        cameraQ.mul(q);
        this.a3canvas.setCameraQuatImmediately(cameraQ);
    }

    void transNavi() {
        Vector3d cameraV = this.a3canvas.getCameraLoc();
        Quat4d cameraQ = this.a3canvas.getCameraQuat();
        int shiftX = this.lastMouseX - this.startMouseX;
        int shiftY = this.lastMouseY - this.startMouseY;
        double s = 0.004 * (double)shiftX * this.a3canvas.getNavigationSpeed();
        Vector3d v = new Vector3d(s, 0.0, 0.0);
        Matrix3d m = new Matrix3d();
        m.set(cameraQ);
        m.transform((Tuple3d)v);
        cameraV.add((Tuple3d)v);
        s = -0.004 * (double)shiftY * this.a3canvas.getNavigationSpeed();
        v = new Vector3d(0.0, s, 0.0);
        m = new Matrix3d();
        m.set(cameraQ);
        m.transform((Tuple3d)v);
        cameraV.add((Tuple3d)v);
        this.a3canvas.setCameraLocImmediately(cameraV);
    }

    @Override
    public void mouseReleased(A3Event ae) {
        this.mouseStatus = MouseStatus.N;
    }

    @Override
    public void mouseClicked(A3Event ae) {
    }

    @Override
    public void mouseDoubleClicked(A3Event ae) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    static enum MouseStatus {
        N,
        B1,
        B2,
        B3;

    }
}

