/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedTime;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.Skeleton;
import jp.sourceforge.acerola3d.a3.bvh.BVH;

class SkeletonBehavior
extends Behavior {
    static BoundingSphere bounding = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
    Skeleton skeleton;
    BVH bvh;
    BranchGroup allBranchGroup = null;
    boolean pause;
    boolean loopFlag;
    boolean defaultPose;
    long motionLength;
    int elapsedTime;
    long timeOffset = 0L;
    long pauseTime;
    HashMap<String, BoneShape> bones = new HashMap();
    ArrayList<SR> selectRequests = new ArrayList();

    public SkeletonBehavior(Skeleton s, String rulString) {
        this.skeleton = s;
        try {
            URL url = new URL(rulString);
            this.bvh = new BVH(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.motionLength = (long)(this.bvh.getMotionLength() * 1000.0);
        this.elapsedTime = (int)(1000.0 * this.bvh.getDefaultFrameTime());
        this.loopFlag = true;
        this.defaultPose = true;
        this.setSchedulingBounds((Bounds)bounding);
        this.allBranchGroup = new BranchGroup();
        this.allBranchGroup.addChild((Node)this.constructSkeleton(this.bvh.getRootBone(), null));
        this.allBranchGroup.addChild((Node)this);
    }

    BoneShape constructSkeleton(String boneName, BoneShape parent) {
        BoneShape bs = new BoneShape(this.bvh.getBoneTails(boneName), this.bvh.getOffset(boneName));
        this.bones.put(boneName, bs);
        for (String bn : this.bvh.getChildBones(boneName)) {
            BoneShape bs2 = this.constructSkeleton(bn, bs);
            bs.addChild((Node)bs2);
        }
        return bs;
    }

    public void initialize() {
        if (this.elapsedTime == 0) {
            return;
        }
        WakeupOnElapsedTime w = new WakeupOnElapsedTime((long)this.elapsedTime);
        this.wakeupOn((WakeupCondition)w);
        this.timeOffset = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStimulus(Enumeration criteria) {
        BVH bVH = this.bvh;
        synchronized (bVH) {
            WakeupOnElapsedTime w = new WakeupOnElapsedTime((long)this.elapsedTime);
            this.wakeupOn((WakeupCondition)w);
            for (SR sr : this.selectRequests) {
                BoneShape bs = this.bones.get(sr.name);
                bs.setSelected(sr.selected);
            }
            this.selectRequests.clear();
            if (this.defaultPose) {
                this.init();
                return;
            }
            long nowTime = System.currentTimeMillis();
            long time = this.pause ? this.pauseTime : nowTime - this.timeOffset;
            double timeD = (double)(time %= this.motionLength) / 1000.0;
            for (String boneName : this.bones.keySet()) {
                TransformGroup tg = this.bones.get(boneName);
                Transform3D t = this.bvh.getTransform3D(boneName, timeD);
                tg.setTransform(t);
            }
        }
    }

    void init() {
        for (String boneName : this.bones.keySet()) {
            BoneShape bs = this.bones.get(boneName);
            bs.init();
        }
    }

    public void setFrameTime(double d) {
        this.elapsedTime = (int)(1000.0 * d);
    }

    public void setPauseTime(double t) {
        this.pauseTime = (long)(1000.0 * t);
    }

    public void defaultPose() {
        this.defaultPose = true;
    }

    public void start() {
        this.defaultPose = false;
        this.pause = false;
    }

    public void pause() {
        this.defaultPose = false;
        this.pause = true;
    }

    public void setBoneSelected(String boneName, boolean b) {
        this.selectRequests.add(new SR(boneName, b));
    }

    public String getRootBone() {
        return this.bvh.getRootBone();
    }

    public String getParentBone(String boneName) {
        return this.bvh.getParentBone(boneName);
    }

    public String[] getChildBones(String boneName) {
        return this.bvh.getChildBones(boneName);
    }

    public Vector3d getOffset(String boneName) {
        Vector3d ret = new Vector3d(this.bvh.getOffset(boneName));
        while ((boneName = this.bvh.getParentBone(boneName)) != null) {
            ret.add((Tuple3d)this.bvh.getOffset(boneName));
        }
        return ret;
    }

    Node getNode() {
        return this.allBranchGroup;
    }

    class SR {
        String name;
        boolean selected;

        SR(String n, boolean s) {
            this.name = n;
            this.selected = s;
        }
    }

    class BoneShape
    extends TransformGroup {
        LineArray[] geometries = null;
        Vector3d offset;

        BoneShape(ArrayList<Vector3d> tails, Vector3d o) {
            this.offset = o;
            this.setCapability(18);
            this.geometries = new LineArray[tails.size()];
            int i = 0;
            for (Vector3d t : tails) {
                Point3d[] vertex = new Point3d[]{new Point3d(0.0, 0.0, 0.0), new Point3d((Tuple3d)t)};
                this.geometries[i] = new LineArray(2, 5);
                this.geometries[i].setCapability(3);
                this.geometries[i].setCoordinates(0, vertex);
                this.geometries[i].setColor(0, new Color3f(0.0f, 0.0f, 1.0f));
                this.geometries[i].setColor(1, new Color3f(1.0f, 0.0f, 0.0f));
                Shape3D shape = new Shape3D((Geometry)this.geometries[i]);
                this.addChild((Node)shape);
                ++i;
            }
        }

        void setSelected(boolean b) {
            for (int i = 0; i < this.geometries.length; ++i) {
                if (b) {
                    this.geometries[i].setColor(0, new Color3f(0.5f, 0.5f, 1.0f));
                    this.geometries[i].setColor(1, new Color3f(1.0f, 0.5f, 0.5f));
                    continue;
                }
                this.geometries[i].setColor(0, new Color3f(0.0f, 0.0f, 1.0f));
                this.geometries[i].setColor(1, new Color3f(1.0f, 0.0f, 0.0f));
            }
        }

        void init() {
            Transform3D t = new Transform3D();
            t.set(this.offset);
            this.setTransform(t);
        }
    }
}

