/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.sound;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.sound.A3Sound;
import jp.sourceforge.acerola3d.sound.A3SoundSystem;
import jp.sourceforge.acerola3d.sound.A3SoundType;

public class ShortSound
implements A3Sound {
    String file;
    A3SoundSystem soundSystem;
    float segnoTime;
    A3SoundType type;
    float gain;
    boolean loop = false;
    int[] buffer = new int[1];
    int[] source = new int[1];

    ShortSound() {
    }

    @Override
    public void init(String file, A3SoundSystem ss, float segno, A3SoundType t, float g, boolean l) throws Exception {
        this.file = file;
        this.soundSystem = ss;
        this.segnoTime = segno;
        this.type = t;
        this.gain = g;
        this.loop = l;
        this.initBuffer();
        this.initSource();
    }

    void initBuffer() throws Exception {
        int[] format = new int[1];
        ByteBuffer[] data = new ByteBuffer[1];
        int[] size = new int[1];
        int[] freq = new int[1];
        URL url = new URL(this.file);
        InputStream is = url.openStream();
        AudioInputStream ais = AudioSystem.getAudioInputStream(is);
        AudioFormat audioFormat = ais.getFormat();
        audioFormat = new AudioFormat(audioFormat.getSampleRate(), 16, audioFormat.getChannels(), true, false);
        ais = AudioSystem.getAudioInputStream(audioFormat, ais);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        int cnt = 0;
        while ((cnt = ais.read(b)) != -1) {
            baos.write(b, 0, cnt);
        }
        b = baos.toByteArray();
        data[0] = ByteBuffer.wrap(b);
        format[0] = audioFormat.getChannels() == 1 ? 4353 : 4355;
        size[0] = b.length;
        freq[0] = (int)audioFormat.getSampleRate();
        this.soundSystem.al.alGenBuffers(1, this.buffer, 0);
        this.check(1);
        this.soundSystem.al.alBufferData(this.buffer[0], format[0], (Buffer)data[0], size[0], freq[0]);
        this.check(2);
    }

    void initSource() {
        this.soundSystem.al.alGenSources(1, this.source, 0);
        this.check(3);
        this.soundSystem.al.alSourcei(this.source[0], 4105, this.buffer[0]);
        this.soundSystem.al.alSourcef(this.source[0], 4099, 1.0f);
        this.soundSystem.al.alSourcef(this.source[0], 4106, 1.0f);
        this.soundSystem.al.alSource3f(this.source[0], 4100, 0.0f, 0.0f, 0.0f);
        this.soundSystem.al.alSourcef(this.source[0], 4106, this.gain);
        if (this.loop) {
            this.soundSystem.al.alSourcei(this.source[0], 4103, 1);
        } else {
            this.soundSystem.al.alSourcei(this.source[0], 4103, 0);
        }
        if (this.type == A3SoundType.BackgroundSound) {
            this.soundSystem.al.alSourcei(this.source[0], 514, 1);
            this.soundSystem.al.alSource3f(this.source[0], 4100, 0.0f, 0.0f, 1.0f);
        }
        if (this.type == A3SoundType.ConeSound) {
            this.soundSystem.al.alSourcef(this.source[0], 4097, 90.0f);
            this.soundSystem.al.alSourcef(this.source[0], 4098, 135.0f);
            this.soundSystem.al.alSourcef(this.source[0], 4130, 0.0f);
            this.soundSystem.al.alSource3f(this.source[0], 4101, 0.0f, 0.0f, 1.0f);
        }
        this.check(4);
    }

    @Override
    public void start() {
        this.soundSystem.al.alSourcePlay(this.source[0]);
        this.check(5);
    }

    @Override
    public void segno() {
        this.soundSystem.al.alSourcef(this.source[0], 4132, this.segnoTime);
        this.soundSystem.al.alGetError();
        this.soundSystem.al.alSourcePlay(this.source[0]);
        this.check(7);
    }

    @Override
    public void stop() {
        this.soundSystem.al.alSourceStop(this.source[0]);
    }

    @Override
    public void pause() {
        this.soundSystem.al.alSourcePause(this.source[0]);
    }

    @Override
    public void rewind() {
        this.soundSystem.al.alSourceRewind(this.source[0]);
    }

    @Override
    public void setLoc(float x, float y, float z) {
        if (this.type != A3SoundType.BackgroundSound) {
            this.soundSystem.al.alSource3f(this.source[0], 4100, x, y, z);
        }
    }

    @Override
    public void setLoc(Vector3d v) {
        if (this.type != A3SoundType.BackgroundSound) {
            float x = (float)v.x;
            float y = (float)v.y;
            float z = (float)v.z;
            this.soundSystem.al.alSource3f(this.source[0], 4100, x, y, z);
        }
    }

    @Override
    public void setRot(float x, float y, float z) {
        Quat4d qx = new Quat4d(Math.sin((double)x / 2.0), 0.0, 0.0, Math.cos((double)x / 2.0));
        Quat4d qy = new Quat4d(0.0, Math.sin((double)y / 2.0), 0.0, Math.cos((double)y / 2.0));
        Quat4d qz = new Quat4d(0.0, 0.0, Math.sin((double)z / 2.0), Math.cos((double)z / 2.0));
        Quat4d q = new Quat4d(0.0, 0.0, 0.0, 1.0);
        q.mul(qx);
        q.mul(qy);
        q.mul(qz);
        this.setQuat(q);
    }

    @Override
    public void setRot(Vector3d r) {
        float x = (float)r.x;
        float y = (float)r.y;
        float z = (float)r.z;
        this.setRot(x, y, z);
    }

    @Override
    public void setQuat(Quat4d q) {
        if (this.type != A3SoundType.BackgroundSound) {
            Quat4d qTmp = new Quat4d(0.0, 0.0, 1.0, 0.0);
            Quat4d qq = new Quat4d(q);
            Quat4d qc = new Quat4d(q);
            qc.conjugate();
            qTmp.mul(qq, qTmp);
            qTmp.mul(qc);
            float x = (float)qTmp.x;
            float y = (float)qTmp.y;
            float z = (float)qTmp.z;
            this.soundSystem.al.alSource3f(this.source[0], 4101, x, y, z);
        }
    }

    @Override
    public void setVel() {
    }

    @Override
    public void setGain(float g) {
        this.soundSystem.al.alSourcef(this.source[0], 4106, g);
    }

    @Override
    public void setDirection(float x, float y, float z) {
        this.soundSystem.al.alSource3f(this.source[0], 4101, x, y, z);
    }

    @Override
    public void setDirection(Vector3d d) {
        this.setDirection((float)d.x, (float)d.y, (float)d.z);
    }

    @Override
    public void setLoop(boolean l) {
        this.loop = l;
        if (this.loop) {
            this.soundSystem.al.alSourcei(this.source[0], 4103, 1);
        } else {
            this.soundSystem.al.alSourcei(this.source[0], 4103, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp() {
        this.soundSystem.al.alSourceStop(this.source[0]);
        this.soundSystem.al.alDeleteSources(1, this.source, 0);
        this.soundSystem.al.alDeleteBuffers(1, this.buffer, 0);
        ArrayList<A3Sound> arrayList = this.soundSystem.sounds;
        synchronized (arrayList) {
            this.soundSystem.sounds.remove(this);
        }
    }

    @Override
    public void setType(A3SoundType t) {
        if (t == A3SoundType.BackgroundSound) {
            this.type = t;
            this.soundSystem.al.alSourcei(this.source[0], 514, 1);
            this.soundSystem.al.alSource3f(this.source[0], 4100, 0.0f, 0.0f, 1.0f);
        } else if (t == A3SoundType.ConeSound) {
            this.type = t;
            this.soundSystem.al.alSourcef(this.source[0], 4097, 90.0f);
            this.soundSystem.al.alSourcef(this.source[0], 4098, 135.0f);
            this.soundSystem.al.alSourcef(this.source[0], 4130, 0.0f);
            this.soundSystem.al.alSource3f(this.source[0], 4101, 0.0f, 0.0f, 1.0f);
        } else {
            this.type = t;
            this.soundSystem.al.alSourcef(this.source[0], 4097, 360.0f);
            this.soundSystem.al.alSourcef(this.source[0], 4098, 360.0f);
            this.soundSystem.al.alSourcef(this.source[0], 4130, 0.0f);
            this.soundSystem.al.alSource3f(this.source[0], 4101, 0.0f, 0.0f, 0.0f);
        }
    }

    @Override
    public void setSegno(float s) {
        this.segnoTime = s;
    }

    @Override
    public A3Sound copy() {
        ShortSound ret = new ShortSound();
        ret.file = this.file;
        ret.soundSystem = this.soundSystem;
        ret.segnoTime = this.segnoTime;
        ret.type = this.type;
        ret.gain = this.gain;
        ret.loop = this.loop;
        ret.buffer[0] = this.buffer[0];
        this.soundSystem.al.alGenSources(1, ret.source, 0);
        this.check(8);
        this.soundSystem.al.alSourcei(ret.source[0], 4105, ret.buffer[0]);
        this.soundSystem.al.alSourcef(ret.source[0], 4099, 1.0f);
        this.soundSystem.al.alSourcef(ret.source[0], 4106, 1.0f);
        this.soundSystem.al.alSource3f(ret.source[0], 4100, 0.0f, 0.0f, 0.0f);
        this.check(9);
        return ret;
    }

    void check(int i) {
        int e = this.soundSystem.al.alGetError();
        if (e == 0) {
            return;
        }
        String s = "??????";
        switch (e) {
            case 40961: {
                s = "AL_INVALID_NAME";
                break;
            }
            case 40962: {
                s = "AL_INVALID_ENUM";
                break;
            }
            case 40963: {
                s = "AL_INVALID_VALUE";
                break;
            }
            case 40964: {
                s = "AL_INVALID_OPERATION";
                break;
            }
            case 40965: {
                s = "AL_OUT_OF_MEMORY";
            }
        }
        System.out.println("----------ShortSound----------");
        System.out.println("OpenAL error raised..." + s + i);
        System.out.println("------------------------------\n");
    }
}

