/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.sourceforge.acerola3d.a3editor.A3Editor;
import jp.sourceforge.acerola3d.a3editor.A3eA3Panel;
import jp.sourceforge.acerola3d.a3editor.A3eActionEditorGUI;
import jp.sourceforge.acerola3d.a3editor.A3eFileManagerGUI;
import jp.sourceforge.acerola3d.a3editor.A3eMetadataGUI;
import jp.sourceforge.acerola3d.a3editor.CreateA3GUI;
import jp.sourceforge.acerola3d.a3panels.HtmlPanel;

class A3EditorGUI
extends JFrame
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    A3Editor editor;
    JTabbedPane tPane;
    JMenuItem helpMI;
    JMenuItem aboutMI;
    JMenuItem closeMI;
    A3eFileManagerGUI fileManagerGUI;
    A3eActionEditorGUI actionEditorGUI;
    A3eMetadataGUI metadataGUI;
    A3eA3Panel a3eA3Panel;
    CreateA3GUI createA3GUI;
    JFrame htmlFrame;
    HtmlPanel htmlViewer;
    int currentPane = 0;

    A3EditorGUI(A3Editor e) {
        super("A3Editor");
        this.editor = e;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                A3EditorGUI.this.actionEditorGUI.clear();
                A3EditorGUI.this.metadataGUI.clear();
                System.exit(0);
            }
        });
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        menuBar.add(Box.createHorizontalGlue());
        JMenu menu = new JMenu("menu");
        menuBar.add(menu);
        this.helpMI = new JMenuItem("help");
        this.helpMI.addActionListener(this);
        menu.add(this.helpMI);
        this.aboutMI = new JMenuItem("about");
        this.aboutMI.addActionListener(this);
        menu.add(this.aboutMI);
        this.closeMI = new JMenuItem("close");
        this.closeMI.addActionListener(this);
        menu.add(this.closeMI);
        this.tPane = new JTabbedPane();
        this.tPane.addChangeListener(this);
        this.add(this.tPane);
        this.fileManagerGUI = this.editor.fileManager.getGUI();
        this.tPane.addTab("\u30d5\u30a1\u30a4\u30eb\u306e\u6574\u7406\u78ba\u8a8d", this.fileManagerGUI);
        this.actionEditorGUI = this.editor.actionEditor.getGUI();
        this.tPane.addTab("\u30a2\u30af\u30b7\u30e7\u30f3\u7de8\u96c6", this.actionEditorGUI);
        this.metadataGUI = this.editor.catalog.getMetadataGUI();
        this.tPane.addTab("\u30e1\u30bf\u30c7\u30fc\u30bf\u7de8\u96c6", this.metadataGUI);
        this.a3eA3Panel = new A3eA3Panel(this.editor.fileManager);
        this.tPane.addTab("\u8868\u793a\u78ba\u8a8d", this.a3eA3Panel);
        this.createA3GUI = new CreateA3GUI(this.editor.fileManager);
        this.tPane.addTab("\u30d5\u30a1\u30a4\u30eb\u751f\u6210", this.createA3GUI);
        this.htmlFrame = new JFrame();
        this.htmlFrame.setLayout(new BorderLayout());
        this.htmlViewer = new HtmlPanel(null);
        this.htmlFrame.add((Component)this.htmlViewer, "Center");
        this.setSize(1000, 700);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.helpMI) {
            this.openHelp();
        } else if (e.getSource() == this.aboutMI) {
            this.openAbout();
        } else if (e.getSource() == this.closeMI) {
            this.actionEditorGUI.clear();
            this.metadataGUI.clear();
            System.exit(0);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.tPane) {
            int newPane = this.tPane.getSelectedIndex();
            if (this.currentPane == 0 && this.fileManagerGUI != null) {
                this.fileManagerGUI.clear();
            }
            if (this.currentPane == 1 && this.actionEditorGUI != null) {
                this.actionEditorGUI.clear();
            }
            if (this.currentPane == 2 && this.metadataGUI != null) {
                this.metadataGUI.clear();
            }
            if (this.currentPane == 3 && this.a3eA3Panel != null) {
                this.a3eA3Panel.clear();
            }
            if (this.currentPane == 4 && this.createA3GUI != null) {
                this.createA3GUI.clear();
            }
            if (newPane == 0) {
                this.fileManagerGUI.init();
            } else if (newPane == 1) {
                this.actionEditorGUI.init();
            } else if (newPane == 2) {
                this.metadataGUI.init();
            } else if (newPane == 3) {
                this.a3eA3Panel.loadAction3D(this.editor.fileManager.rootDir);
            } else if (newPane == 4) {
                this.createA3GUI.init();
            }
            this.currentPane = newPane;
        }
    }

    void openHelp() {
        URL url = null;
        try {
            url = new URL("x-res:///jp/sourceforge/acerola3d/a3editor/resources/ja/help.html");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.htmlViewer.open(url);
        this.htmlFrame.setSize(500, 500);
        this.htmlFrame.setVisible(true);
    }

    void openAbout() {
        URL url = null;
        try {
            url = new URL("x-res:///jp/sourceforge/acerola3d/a3editor/resources/ja/about.html");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.htmlViewer.open(url);
        this.htmlFrame.setSize(500, 500);
        this.htmlFrame.setVisible(true);
    }
}

