/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.sourceforge.acerola3d.a3editor.A3eFile;
import jp.sourceforge.acerola3d.a3editor.A3eFileManagerGUI;
import jp.sourceforge.acerola3d.a3editor.A3eFileType;

class A3eFileGUI
extends JPanel
implements MouseListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    A3eFileManagerGUI fileManagerGUI;
    A3eFile file;
    JLabel filenameL;
    static String[] fileTypeS = new String[]{"\u30c7\u30a3\u30ec\u30af\u30c8\u30ea", "\u30ab\u30bf\u30ed\u30b0", "BVH", "VRML", "\u753b\u50cf", "\u97f3\u58f0", "HTML", "UNKNOWN"};
    JCheckBox isIgnoredCB;
    JComboBox filetypeCB;

    A3eFileGUI(A3eFile f, A3eFileManagerGUI fmGUI) {
        this.fileManagerGUI = fmGUI;
        this.file = f;
        this.setLayout(new BoxLayout(this, 0));
        this.isIgnoredCB = new JCheckBox("\u9664\u5916");
        if (this.file.isIgnored) {
            this.isIgnoredCB.setSelected(true);
        } else {
            this.isIgnoredCB.setSelected(false);
        }
        this.isIgnoredCB.addActionListener(this);
        this.add(this.isIgnoredCB);
        this.filetypeCB = new JComboBox<String>(fileTypeS);
        this.filetypeCB.setMaximumSize(new Dimension(30, 20));
        if (this.file.type == A3eFileType.DIR) {
            this.filetypeCB.setSelectedItem(fileTypeS[0]);
        } else if (this.file.type == A3eFileType.CATALOG) {
            this.filetypeCB.setSelectedItem(fileTypeS[1]);
        } else if (this.file.type == A3eFileType.BVH) {
            this.filetypeCB.setSelectedItem(fileTypeS[2]);
        } else if (this.file.type == A3eFileType.VRML) {
            this.filetypeCB.setSelectedItem(fileTypeS[3]);
        } else if (this.file.type == A3eFileType.IMAGE) {
            this.filetypeCB.setSelectedItem(fileTypeS[4]);
        } else if (this.file.type == A3eFileType.SOUND) {
            this.filetypeCB.setSelectedItem(fileTypeS[5]);
        } else if (this.file.type == A3eFileType.HTML) {
            this.filetypeCB.setSelectedItem(fileTypeS[6]);
        } else if (this.file.type == A3eFileType.UNKNOWN) {
            this.filetypeCB.setSelectedItem(fileTypeS[7]);
        }
        this.filetypeCB.addActionListener(this);
        this.add(this.filetypeCB);
        ImageIcon icon = null;
        try {
            URL url = null;
            url = this.file.type == A3eFileType.DIR ? new URL("x-res:///jp/sourceforge/acerola3d/a3editor/resources/directory.png") : new URL("x-res:///jp/sourceforge/acerola3d/a3editor/resources/file.png");
            icon = new ImageIcon(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.filenameL = new JLabel(f.name, icon, 0);
        this.filenameL.addMouseListener(this);
        this.add(this.filenameL);
        this.add(Box.createHorizontalGlue());
        this.setSelected(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.isIgnoredCB) {
            if (this.isIgnoredCB.isSelected()) {
                this.file.setIgnored(true);
            } else {
                this.file.setIgnored(false);
            }
        } else if (e.getSource() == this.filetypeCB) {
            if (this.filetypeCB.getSelectedIndex() == 0) {
                this.file.setFileType(A3eFileType.DIR);
            } else if (this.filetypeCB.getSelectedIndex() == 1) {
                this.file.setFileType(A3eFileType.CATALOG);
            } else if (this.filetypeCB.getSelectedIndex() == 2) {
                this.file.setFileType(A3eFileType.BVH);
            } else if (this.filetypeCB.getSelectedIndex() == 3) {
                this.file.setFileType(A3eFileType.VRML);
            } else if (this.filetypeCB.getSelectedIndex() == 4) {
                this.file.setFileType(A3eFileType.IMAGE);
            } else if (this.filetypeCB.getSelectedIndex() == 5) {
                this.file.setFileType(A3eFileType.SOUND);
            } else if (this.filetypeCB.getSelectedIndex() == 6) {
                this.file.setFileType(A3eFileType.HTML);
            } else if (this.filetypeCB.getSelectedIndex() == 7) {
                this.file.setFileType(A3eFileType.UNKNOWN);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        int clickCount = e.getClickCount();
        if (this.file.type == A3eFileType.DIR && clickCount == 2) {
            this.fileManagerGUI.currentDir = this.file;
            this.fileManagerGUI.refresh();
        }
        this.fileManagerGUI.openViewer(this.file, this);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    void setSelected(boolean b) {
        if (b) {
            this.setBackground(Color.red);
            this.isIgnoredCB.setBackground(Color.red);
        } else {
            this.setBackground(Color.white);
            this.isIgnoredCB.setBackground(Color.white);
        }
    }
}

