/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3editor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import jp.sourceforge.acerola3d.a3editor.A3eFile;
import jp.sourceforge.acerola3d.a3editor.A3eFileManagerGUI;
import jp.sourceforge.acerola3d.a3editor.A3eFileType;

class A3eFileManager {
    File rootDir;
    A3eFile a3eRootDir;
    A3eFile[] files;
    A3eFileManagerGUI fileManagerGUI;

    A3eFileManager(File rootDir) throws IOException {
        this.rootDir = rootDir;
        this.refresh();
        this.fileManagerGUI = new A3eFileManagerGUI(this);
    }

    void setRootDir(File rootDir) throws IOException {
        this.rootDir = rootDir;
        this.refresh();
    }

    void refresh() throws IOException {
        ArrayList<A3eFile> filesAL = new ArrayList<A3eFile>();
        this.a3eRootDir = new A3eFile(this, null, "");
        for (File f : this.rootDir.listFiles()) {
            this.refreshR(this.a3eRootDir, f, filesAL);
        }
        A3eFile[] oldFiles = this.files;
        this.files = filesAL.toArray(new A3eFile[0]);
        if (oldFiles != null) {
            for (A3eFile newF : this.files) {
                for (A3eFile oldF : oldFiles) {
                    if (!newF.getPath().equals(oldF.getPath())) continue;
                    newF.isIgnored = oldF.isIgnored;
                    newF.type = oldF.type;
                }
            }
        }
        int catalogCount = 0;
        for (A3eFile f : this.files) {
            if (f.type != A3eFileType.CATALOG) continue;
            ++catalogCount;
        }
        if (catalogCount == 0) {
            File f = new File(this.rootDir, "CATALOG.XML");
            if (f.exists()) {
                this.fixCatalogFilename(f);
            }
            f.createNewFile();
            this.refresh();
        } else if (catalogCount >= 2) {
            System.out.println("\u8b66\u544a\uff1a2\u4ee5\u4e0a\u306eCATALOG.XML\u30d5\u30a1\u30a4\u30eb\u304c\u3042\u308a\u307e\u3059\uff0e");
        }
    }

    void refreshR(A3eFile parent, File f, ArrayList<A3eFile> filesAL) {
        if (!f.isDirectory()) {
            A3eFile af = new A3eFile(this, parent, f.getName());
            filesAL.add(af);
            parent.children.add(af);
        } else {
            A3eFile af = new A3eFile(this, parent, f.getName());
            filesAL.add(af);
            parent.children.add(af);
            for (File ff : f.listFiles()) {
                this.refreshR(af, ff, filesAL);
            }
        }
    }

    String[] list() {
        ArrayList<String> ret = new ArrayList<String>();
        for (A3eFile f : this.files) {
            if (f.isIgnored) continue;
            ret.add(f.getPath());
        }
        return ret.toArray(new String[0]);
    }

    String[] list(A3eFileType t) {
        ArrayList<String> ret = new ArrayList<String>();
        for (A3eFile f : this.files) {
            if (f.type != t || f.isIgnored) continue;
            ret.add(f.getPath());
        }
        return ret.toArray(new String[0]);
    }

    A3eFile[] listA3eFile() {
        return (A3eFile[])this.files.clone();
    }

    A3eFile[] listA3eFile(A3eFileType t) {
        ArrayList<A3eFile> ret = new ArrayList<A3eFile>();
        for (A3eFile f : this.files) {
            if (f.type != t || f.isIgnored) continue;
            ret.add(f);
        }
        return ret.toArray(new A3eFile[0]);
    }

    A3eFileManagerGUI getGUI() {
        return this.fileManagerGUI;
    }

    A3eFile getRefreshedFile(A3eFile oldFile) {
        A3eFile ret = null;
        for (A3eFile f : this.files) {
            if (!oldFile.getPath().equals(f.getPath())) continue;
            ret = f;
            break;
        }
        return ret;
    }

    A3eFile getA3eFileFromPath(String path) {
        A3eFile ret = null;
        for (A3eFile f : this.listA3eFile()) {
            if (!f.getPath().equals(path)) continue;
            ret = f;
            break;
        }
        return ret;
    }

    String path2FileName(String filePath) {
        A3eFile f = this.getA3eFileFromPath(filePath);
        if (f != null) {
            return f.getPath();
        }
        return null;
    }

    String[] fileName2Path(String fileName, A3eFileType t) {
        A3eFile[] files = null;
        files = t == null ? this.listA3eFile() : this.listA3eFile(t);
        ArrayList<String> al = new ArrayList<String>();
        for (A3eFile f : files) {
            if (!f.name.equals(fileName)) continue;
            al.add(f.getPath());
        }
        return al.toArray(new String[0]);
    }

    String path2UrlString(String path) {
        A3eFile f = this.getA3eFileFromPath(path);
        if (f == null) {
            return null;
        }
        try {
            return f.toFile().toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fixCatalogFilename(File f) throws IOException {
        File orgFile = f;
        File bakFile = new File(orgFile.getParentFile(), orgFile.getName() + ".bak");
        FileInputStream fis = new FileInputStream(orgFile);
        FileOutputStream fos = new FileOutputStream(bakFile);
        FileChannel orgChannel = fis.getChannel();
        FileChannel bakChannel = fos.getChannel();
        try {
            orgChannel.transferTo(0L, orgChannel.size(), bakChannel);
        }
        finally {
            orgChannel.close();
            bakChannel.close();
        }
        if (!f.delete()) {
            throw new IOException();
        }
        orgFile = bakFile;
        bakFile = new File(f.getParentFile(), "CATALOG.XML");
        fis = new FileInputStream(orgFile);
        fos = new FileOutputStream(bakFile);
        orgChannel = fis.getChannel();
        bakChannel = fos.getChannel();
        try {
            orgChannel.transferTo(0L, orgChannel.size(), bakChannel);
        }
        finally {
            orgChannel.close();
            bakChannel.close();
        }
    }
}

