/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nwn.j3dfly;

import com.sun.j3d.demos.utils.scenegraph.traverser.NodeChangeProcessor;
import com.sun.j3d.demos.utils.scenegraph.traverser.ProcessNodeInterface;
import com.sun.j3d.demos.utils.scenegraph.traverser.TreeScan;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import net.sf.nwn.loader.AnimationBehavior;
import org.jdesktop.j3dfly.J3dFlyContext;
import org.jdesktop.j3dfly.event.FileLoadEvent;
import org.jdesktop.j3dfly.event.FlyEvent;
import org.jdesktop.j3dfly.event.FlyEventListener;
import org.jdesktop.j3dfly.plugins.J3dFlyPlugin;
import org.jdesktop.j3dfly.plugins.PluginPreference;

public class AnimationControlPlugin
extends J3dFlyPlugin
implements FlyEventListener {
    public void installPlugin(PluginPreference pluginPreference, J3dFlyContext j3dFlyContext) {
        super.installPlugin(pluginPreference, j3dFlyContext);
        this.menu = new JMenu("NWN Animation");
        this.menu.setEnabled(false);
        if (pluginPreference.isInstallInMenu()) {
            this.getMenu("Plugins").add(this.menu);
        }
        j3dFlyContext.getEventProcessor().addListener((FlyEventListener)this, FileLoadEvent.class);
    }

    public void uninstallPlugin() {
        super.uninstallPlugin();
        this.j3dflyContext.getEventProcessor().removeListener((FlyEventListener)this, FileLoadEvent.class);
        if (this.pluginPref.isInstallInMenu()) {
            this.getMenu("Plugins").remove(this.menu);
        }
    }

    public JPanel getControlPanel() {
        return null;
    }

    public Class getPluginPreferenceClass() {
        return AnimationControlPluginPreference.class;
    }

    public void processFlyEvent(FlyEvent flyEvent) {
        if (!(flyEvent instanceof FileLoadEvent)) {
            return;
        }
        final JMenu jMenu = new JMenu(((FileLoadEvent)flyEvent).getFile().getName());
        this.menu.setEnabled(true);
        BranchGroup[] branchGroupArray = ((FileLoadEvent)flyEvent).getBranchGroups();
        for (int i = 0; i < branchGroupArray.length; ++i) {
            TreeScan.findNode((Node)branchGroupArray[i], AnimationBehavior.class, (ProcessNodeInterface)new NodeChangeProcessor(){

                public void changeNode(final Node node) {
                    System.out.println(node);
                    final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Continous");
                    jMenu.add(jCheckBoxMenuItem);
                    jMenu.add(new JSeparator());
                    ActionListener actionListener = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            System.out.println("Playing animation " + ((JRadioButtonMenuItem)actionEvent.getSource()).getText());
                            ((AnimationBehavior)node).playAnimation(((JRadioButtonMenuItem)actionEvent.getSource()).getText(), jCheckBoxMenuItem.isSelected());
                        }
                    };
                    ButtonGroup buttonGroup = new ButtonGroup();
                    Iterator iterator = ((AnimationBehavior)node).getAllAnimationNames().iterator();
                    while (iterator.hasNext()) {
                        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem((String)iterator.next());
                        buttonGroup.add(jRadioButtonMenuItem);
                        jRadioButtonMenuItem.addActionListener(actionListener);
                        jMenu.add(jRadioButtonMenuItem);
                    }
                    ((AnimationBehavior)node).setDefaultAnimations(new ArrayList());
                }
            }, false, true);
        }
        this.menu.add(jMenu);
    }

    public static class AnimationControlPluginPreference
    extends PluginPreference {
        public AnimationControlPluginPreference() {
        }

        public AnimationControlPluginPreference(boolean bl, boolean bl2) {
            super(bl, bl2);
        }

        public J3dFlyPlugin instantiatePlugin() {
            return new AnimationControlPlugin();
        }

        public String getDescription() {
            return "Controls for Never Winter Nights Animations";
        }

        public String getName() {
            return "NWN Animation Controls";
        }
    }
}

