/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nwn.loader;

import java.io.Serializable;
import javax.media.j3d.Transform3D;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.sf.nwn.loader.KeyAxisAngle;
import net.sf.nwn.loader.KeyQuat;
import net.sf.nwn.loader.KeyVector;
import net.sf.nwn.loader.NWNUserData;

public class AnimNode
implements Serializable {
    private String name;
    private String parent;
    private float[] orientations = new float[15];
    private float[] positions = null;
    private int oTop = 0;
    private int pTop = 0;
    private static KeyAxisAngle tempKaa = new KeyAxisAngle();
    private static Quat4f QTt = new Quat4f();
    private static Quat4f QTtt = new Quat4f();
    private static Quat4f QTp = new Quat4f();
    private static Quat4f QRt = new Quat4f();
    private static Quat4f Qdiff = new Quat4f();
    private static Quat4f Qzero = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
    private static Vector3f VTt = new Vector3f();
    private static Vector3f VTp = new Vector3f();
    private static Vector3f VRt = new Vector3f();
    private static KeyQuat kq = new KeyQuat();
    private static KeyQuat kqp = new KeyQuat();
    private static KeyVector kv = new KeyVector();
    private static KeyVector kvp = new KeyVector();
    private static final float EPSILON = 1.0E-4f;
    private static final long serialVersionUID = 1L;

    public AnimNode(String string) {
        this.name = string.toLowerCase();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String string) {
        this.parent = string;
    }

    public void addPositionKey(KeyVector keyVector) {
        int n;
        if (this.positions == null) {
            this.positions = new float[12];
        }
        if ((n = this.pTop * 4) >= this.positions.length) {
            float[] fArray = new float[n + 12];
            System.arraycopy(this.positions, 0, fArray, 0, n);
            this.positions = fArray;
        }
        this.positions[n] = keyVector.getKey();
        this.positions[n + 1] = keyVector.x;
        this.positions[n + 2] = keyVector.y;
        this.positions[n + 3] = keyVector.z;
        ++this.pTop;
    }

    public void addOrientationKey(float f, float f2, float f3, float f4, float f5) {
        tempKaa.set(f2, f3, f4, f5);
        tempKaa.setKey(f);
        this.addOrientationKey(tempKaa);
    }

    public void addOrientationKey(KeyAxisAngle keyAxisAngle) {
        if (keyAxisAngle.x == 0.0f && keyAxisAngle.y == 0.0f && keyAxisAngle.z == 0.0f) {
            keyAxisAngle.z = 1.0f;
        }
        kq.setKey(keyAxisAngle.getKey());
        kq.set(keyAxisAngle);
        kq.normalize();
        int n = this.oTop * 5;
        if (n >= this.orientations.length) {
            float[] fArray = new float[n + 15];
            System.arraycopy(this.orientations, 0, fArray, 0, n);
            this.orientations = fArray;
        }
        this.orientations[n] = kq.getKey();
        this.orientations[n + 1] = AnimNode.kq.w;
        this.orientations[n + 2] = AnimNode.kq.x;
        this.orientations[n + 3] = AnimNode.kq.y;
        this.orientations[n + 4] = AnimNode.kq.z;
        ++this.oTop;
    }

    public void dump(StringBuffer stringBuffer) {
        int n;
        KeyAxisAngle keyAxisAngle = new KeyAxisAngle();
        stringBuffer.append("node dummy ").append(this.getName()).append("\n");
        stringBuffer.append("  parent ").append(this.getParent()).append("\n");
        stringBuffer.append("  positionkey\n");
        for (n = 0; n < this.pTop; ++n) {
            this.getPosition(n, kv);
            stringBuffer.append("    ").append((Object)kv).append("\n");
        }
        stringBuffer.append("  endlist\n");
        stringBuffer.append("  orientationkey\n");
        for (n = 0; n < this.oTop; ++n) {
            this.getOrientation(n, kq);
            keyAxisAngle.set(kq);
            stringBuffer.append("    ").append((Object)keyAxisAngle).append("\n");
        }
        stringBuffer.append("  endlist\n");
        stringBuffer.append("endnode\n");
    }

    private void getOrientation(int n, KeyQuat keyQuat) {
        keyQuat.setKey(this.orientations[n *= 5]);
        keyQuat.w = this.orientations[n + 1];
        keyQuat.x = this.orientations[n + 2];
        keyQuat.y = this.orientations[n + 3];
        keyQuat.z = this.orientations[n + 4];
    }

    private void getOrientation(int n, Quat4f quat4f) {
        quat4f.w = this.orientations[(n *= 5) + 1];
        quat4f.x = this.orientations[n + 2];
        quat4f.y = this.orientations[n + 3];
        quat4f.z = this.orientations[n + 4];
    }

    private void getPosition(int n, KeyVector keyVector) {
        keyVector.setKey(this.positions[n *= 4]);
        keyVector.x = this.positions[n + 1];
        keyVector.y = this.positions[n + 2];
        keyVector.z = this.positions[n + 3];
    }

    private void getPosition(int n, Vector3f vector3f) {
        vector3f.x = this.positions[(n *= 4) + 1];
        vector3f.y = this.positions[n + 2];
        vector3f.z = this.positions[n + 3];
    }

    public void trimSlack() {
        float[] fArray;
        if (this.positions != null && this.positions.length > this.pTop * 4) {
            fArray = new float[this.pTop * 4];
            System.arraycopy(this.positions, 0, fArray, 0, this.pTop * 4);
            this.positions = fArray;
        }
        if (this.orientations.length > this.oTop * 5) {
            fArray = new float[this.oTop * 5];
            System.arraycopy(this.orientations, 0, fArray, 0, this.oTop * 5);
            this.orientations = fArray;
        }
    }

    private boolean getTargetOrientation(float f, Quat4f quat4f) {
        if (this.oTop == 0) {
            return false;
        }
        if (this.oTop == 1 || f <= 0.0f) {
            this.getOrientation(0, quat4f);
            return true;
        }
        for (int i = 1; i < this.oTop; ++i) {
            this.getOrientation(i, kq);
            if (!(kq.getKey() >= f)) continue;
            this.getOrientation(i - 1, kqp);
            quat4f.interpolate((Quat4f)kqp, (Quat4f)kq, (f - kqp.getKey()) / (kq.getKey() - kqp.getKey()));
            quat4f.normalize();
            return true;
        }
        System.err.println("Cannot interpolate orientation " + this.getName() + " " + f);
        this.getOrientation(this.oTop - 1, quat4f);
        return true;
    }

    private Quat4f getRealOrientation(float f, float f2, Quat4f quat4f) {
        if (this.oTop == 0) {
            return null;
        }
        if (!this.getTargetOrientation(f, QTt)) {
            return null;
        }
        if (f + 1.0E-4f >= f2) {
            return QTt;
        }
        this.getOrientation(0, kq);
        Qdiff.inverse((Quat4f)kq);
        Qdiff.mul(quat4f, Qdiff);
        Qdiff.interpolate(Qzero, f / f2);
        QRt.mul(Qdiff, QTt);
        QRt.normalize();
        return QRt;
    }

    private boolean getTargetPosition(float f, Vector3f vector3f) {
        if (this.positions == null) {
            return false;
        }
        if (this.pTop == 1) {
            this.getPosition(0, vector3f);
            return true;
        }
        for (int i = 1; i < this.pTop; ++i) {
            this.getPosition(i, kv);
            if (!(kv.getKey() >= f)) continue;
            this.getPosition(i - 1, kvp);
            vector3f.interpolate((Tuple3f)kvp, (Tuple3f)kv, (f - kvp.getKey()) / (kv.getKey() - kvp.getKey()));
            return true;
        }
        System.err.println("Cannot interpolate position " + this.getName() + " " + f);
        return false;
    }

    private Vector3f getRealPosition(float f, float f2, Vector3f vector3f) {
        if (this.positions == null) {
            return null;
        }
        if (!this.getTargetPosition(f, VTt)) {
            return null;
        }
        if (f + 1.0E-4f >= f2) {
            return VTt;
        }
        this.getPosition(0, kv);
        VRt.sub((Tuple3f)vector3f, (Tuple3f)kv);
        VRt.scale(1.0f - f / f2);
        VRt.add((Tuple3f)VTt);
        return VRt;
    }

    public void update(Transform3D transform3D, NWNUserData nWNUserData, float f, float f2) {
        Quat4f quat4f;
        Vector3f vector3f;
        if ((double)f <= 0.001) {
            transform3D.get(nWNUserData.oldOrientation, nWNUserData.oldPosition);
        }
        if ((vector3f = this.getRealPosition(f, f2, nWNUserData.oldPosition)) != null) {
            transform3D.setTranslation(vector3f);
        }
        if ((quat4f = this.getRealOrientation(f, f2, nWNUserData.oldOrientation)) != null) {
            transform3D.setRotation(quat4f);
        }
    }
}

