/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nwn.viewer;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.sf.nwn.viewer.AnimPanel;
import net.sf.nwn.viewer.ControlPanel;
import net.sf.nwn.viewer.Display;
import net.sf.nwn.viewer.FilePanel;
import net.sf.nwn.viewer.LaunchMe;
import net.sf.nwn.viewer.MDLFileFilter;

public class Main {
    public static String[] arguments = null;

    public static void main(String[] stringArray) throws Exception {
        LaunchMe launchMe = new LaunchMe(stringArray);
        final Thread thread = new Thread((Runnable)launchMe, "NWM Demo - LaunchMe thread");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                thread.start();
            }
        });
    }

    public static void launch(String[] stringArray) {
        File file = null;
        File file2 = new File(".");
        File[] fileArray = new File[1];
        if (stringArray.length > 0) {
            file = new File(stringArray[0]);
            if (!file.exists()) {
                System.err.println("" + file + " not found");
                System.exit(1);
            }
            if (!file.isDirectory()) {
                fileArray[0] = file2 = file;
            } else {
                file2 = file.getParentFile();
                fileArray = file2.listFiles(new MDLFileFilter());
                file = null;
            }
        } else {
            fileArray = file2.listFiles(new MDLFileFilter());
        }
        String[] stringArray2 = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray2[i] = fileArray[i].getName().substring(0, fileArray[i].getName().indexOf(".mdl"));
            System.out.println(stringArray2[i]);
        }
        Display display = new Display();
        AnimPanel animPanel = new AnimPanel();
        ControlPanel controlPanel = new ControlPanel(display, animPanel);
        FilePanel filePanel = null;
        try {
            filePanel = new FilePanel(display, animPanel, controlPanel, file2.toURL(), stringArray2);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        display.getView().setMinimumFrameCycleTime(10L);
        final JFrame jFrame = new JFrame("NWN Display");
        final JDialog jDialog = new JDialog((Frame)jFrame, "NWN Models");
        final JDialog jDialog2 = new JDialog((Frame)jFrame, "NWN Animation");
        final JDialog jDialog3 = new JDialog((Frame)jFrame, "NWN Control Panel");
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                jDialog.setVisible(false);
                jDialog2.setVisible(false);
                jDialog3.setVisible(false);
                jFrame.setVisible(false);
                jDialog.dispose();
                jDialog2.dispose();
                jDialog3.dispose();
                jFrame.dispose();
                System.exit(0);
            }
        };
        jDialog.getContentPane().add(filePanel);
        jDialog.setSize(200, 600);
        jDialog.addWindowListener(windowAdapter);
        jDialog.setVisible(true);
        jFrame.getContentPane().add((Component)((Object)display));
        jFrame.setSize(600, 600);
        jFrame.setLocation(jDialog.getWidth(), 0);
        jFrame.addWindowListener(windowAdapter);
        jFrame.setVisible(true);
        jDialog2.getContentPane().add(animPanel);
        jDialog2.setSize(200, 600);
        jDialog2.setLocation(jFrame.getX() + jFrame.getWidth(), 0);
        jDialog2.addWindowListener(windowAdapter);
        jDialog2.setVisible(true);
        jDialog3.getContentPane().add(controlPanel);
        jDialog3.setLocation(0, 600);
        jDialog3.setSize(jDialog.getWidth() + jFrame.getWidth() + jDialog2.getWidth(), 200);
        jDialog3.addWindowListener(windowAdapter);
        jDialog3.setVisible(true);
        if (file != null) {
            if (file.getName().endsWith(".gz")) {
                file = new File(file.getPath().substring(0, file.getPath().length() - 3));
            }
            try {
                filePanel.setCurrentModel(file.toURL());
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
    }
}

