/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import org.jdesktop.j3d.loaders.vrml97.impl.Browser;
import org.jdesktop.j3d.loaders.vrml97.impl.DragSensor;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.SFBool;
import org.jdesktop.j3d.loaders.vrml97.impl.SFFloat;
import org.jdesktop.j3d.loaders.vrml97.impl.SFInt32;
import org.jdesktop.j3d.loaders.vrml97.impl.SFRotation;

public class SphereSensor
extends DragSensor {
    SFRotation offset;
    SFBool autoSpin;
    SFInt32 autoSpinFrameWait;
    SFFloat spinKick;
    SFRotation rotation;
    Transform3D l2vwTf = new Transform3D();
    Transform3D im2vwTf = new Transform3D();
    Transform3D TTf = new Transform3D();
    Quat4d T = new Quat4d();
    Quat4d T_;
    Quat4d rot = new Quat4d();
    Transform3D im2lTf = new Transform3D();
    Transform3D l2imTf = new Transform3D();
    Transform3D vw2lTf = new Transform3D();
    Point3d p1 = new Point3d();
    Point3d p2 = new Point3d();
    Transform3D rotTf = new Transform3D();
    AxisAngle4d sfrOffset = new AxisAngle4d();
    AxisAngle4d sfrR = new AxisAngle4d();
    AxisAngle4d rotAxAngle = new AxisAngle4d();
    Vector3d trackpt = new Vector3d();
    Vector3d v = new Vector3d();
    Vector3d vlast = new Vector3d();
    Vector3d t = new Vector3d();
    Vector3d u = new Vector3d();
    double a;
    Bounds bounds;
    int count = 0;
    boolean autoSpinning = false;
    static double EPSILON = 1.0E-8;
    static double DELTA = 1.0E-5;
    Node node = null;
    SceneGraphPath path = null;

    public SphereSensor(Loader loader) {
        super(loader);
        this.offset = new SFRotation(0.0f, 1.0f, 0.0f, 0.0f);
        this.rotation = new SFRotation(0.0f, 1.0f, 0.0f, 0.0f);
        this.sfrOffset.set((double)this.offset.rot[0], (double)this.offset.rot[1], (double)this.offset.rot[2], (double)this.offset.rot[3]);
        this.sfrR.set((double)this.rotation.rot[0], (double)this.rotation.rot[1], (double)this.rotation.rot[2], (double)this.rotation.rot[3]);
        this.autoSpin = new SFBool(false);
        this.autoSpinFrameWait = new SFInt32(3);
        this.spinKick = new SFFloat(10.0f);
        this.vlast.x = 0.0;
        this.vlast.y = 1.0;
        this.vlast.z = 0.0;
        this.initSphereSensorFields();
    }

    void update(Point3d p1, Point3d p2, Node nodeIn, SceneGraphPath pathIn) {
        this.p1 = p1;
        this.p2 = p2;
        this.count = this.autoSpinFrameWait.value;
        if (nodeIn != null && pathIn != null) {
            this.node = nodeIn;
            this.path = pathIn;
            if (Browser.debug) {
                System.out.println(pathIn);
                System.out.println(pathIn.getLocale());
                for (int xx = 0; xx < pathIn.nodeCount(); ++xx) {
                    System.out.println(pathIn.getNode(xx));
                }
                System.out.println(pathIn.getObject());
                System.out.println("picked node" + this.node);
            }
            this.aquireTransform(nodeIn);
            this.isActive.setValue(true);
            this.bounds = this.node.getBounds();
        } else if (this.autoSpinning) {
            this.browser.evagation.forceUpDown();
            this.aquireTransform(this.node);
            this.doUpdate();
            this.offset();
            this.browser.evagation.curDragSensor = this;
            this.autoSpinning = false;
        }
        this.browser.canvas.getImagePlateToVworld(this.im2vwTf);
        try {
            this.node.getLocalToVworld(this.l2vwTf);
        }
        catch (IllegalSharingException e) {
            this.node.getLocalToVworld(this.path, this.l2vwTf);
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        catch (CapabilityNotSetException cnse) {
            // empty catch block
        }
        this.vw2lTf.invert(this.l2vwTf);
        this.im2lTf.mul(this.vw2lTf, this.im2vwTf);
        this.im2lTf.transform(p1);
        this.im2lTf.transform(p2);
        this.t.set((Tuple3d)p1);
        this.u.set((Tuple3d)p2);
        try {
            SphereSensor.norm(this.t);
            SphereSensor.norm(this.u);
            this.v.cross(this.t, this.u);
            this.a = SphereSensor.angle(this.t, this.u) * SphereSensor.coorelate(this.im2lTf);
            if (Math.abs(this.a) > EPSILON) {
                SphereSensor.norm(this.v);
                this.vlast.set((Tuple3d)this.v);
            } else {
                this.v.set((Tuple3d)this.vlast);
            }
        }
        catch (ArithmeticException ae) {
            System.out.println("dinky delta");
        }
        this.rotAxAngle.set(this.v.x, this.v.y, this.v.z, this.a);
        this.rot.set(this.rotAxAngle);
        this.T_.mul(this.rot, this.T);
        this.doUpdate();
    }

    void simTick(double t) {
        if (this.autoSpin.value && this.count-- <= 0) {
            this.autoSpinning = true;
            this.rotAxAngle.set(this.v.x, this.v.y, this.v.z, this.rotAxAngle.angle + this.a);
            this.rot.set(this.rotAxAngle);
            this.T_.mul(this.rot, this.T);
            this.doUpdate();
        } else {
            this.autoSpinning = false;
        }
    }

    void aquireTransform(Node nodeIn) {
        if (this.T_ == null) {
            if (nodeIn instanceof TransformGroup) {
                ((TransformGroup)nodeIn).getTransform(this.TTf);
            } else {
                this.TTf.setIdentity();
            }
            this.T_ = new Quat4d();
            this.TTf.get(this.T);
            this.T_.set((Tuple4d)this.T);
        } else {
            this.T_.get((Tuple4d)this.T);
        }
    }

    void doUpdate() {
        if (this.enabled.value) {
            this.sfrR.set(this.T_);
            this.rotation.setValue((float)this.sfrR.x, (float)this.sfrR.y, (float)this.sfrR.z, (float)this.sfrR.angle);
            this.trackpt.set((Tuple3d)this.p2);
            try {
                SphereSensor.norm(this.trackpt);
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            this.trackpt.scale(((BoundingSphere)this.bounds).getRadius());
            this.trackPoint.setValue((float)this.trackpt.x, (float)this.trackpt.y, (float)this.trackpt.z);
        }
    }

    public void offset() {
        this.isActive.setValue(false);
        AxisAngle4d sfrO = new AxisAngle4d();
        sfrO.set(this.T_);
        this.offset.setValue((float)sfrO.x, (float)sfrO.y, (float)sfrO.z, (float)sfrO.angle);
        this.count = 0;
    }

    public void notifyMethod(String eventInName, double time) {
        if (eventInName.equals("autoSpin") && this.autoSpinning) {
            this.autoSpinning = false;
        }
    }

    public String getType() {
        return "SphereSensor";
    }

    public Object clone() {
        return new SphereSensor(this.loader);
    }

    void initSphereSensorFields() {
        this.offset.init(this, this.FieldSpec, 3, "offset");
        this.rotation.init(this, this.FieldSpec, 2, "rotation");
        this.autoSpin.init(this, this.FieldSpec, 0, "autoSpin");
        this.autoSpinFrameWait.init(this, this.FieldSpec, 0, "autoSpinFrameWait");
        this.spinKick.init(this, this.FieldSpec, 0, "spinKick");
    }
}

