/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.ac3d;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.newdawn.j3d.loaders.ac3d.AC3DModel;
import org.newdawn.j3d.loaders.ac3d.NodeFactory;
import org.newdawn.loaders.FileFormatException;
import org.newdawn.loaders.InvalidDataException;
import org.newdawn.loaders.resourcepools.ResourceLoadFailedException;

public class AC3DLoader {
    private URL modelURL;
    private String texturePath;
    private NodeFactory nodeFactory;

    private AC3DLoader(URL modelLocation, String relativeTexturePath) {
        String tempURLString = modelLocation.toString();
        this.modelURL = modelLocation;
        String file = tempURLString.substring(tempURLString.lastIndexOf("/") + 1);
        String baseURL = tempURLString.substring(0, tempURLString.lastIndexOf("/") + 1);
        if (relativeTexturePath != null) {
            if (relativeTexturePath.charAt(relativeTexturePath.length() - 1) != '/') {
                relativeTexturePath = relativeTexturePath + "/";
            }
            this.texturePath = baseURL + relativeTexturePath;
        } else {
            this.texturePath = baseURL;
        }
    }

    public static AC3DModel load(String modelFilename) throws IOException, FileFormatException, InvalidDataException, ResourceLoadFailedException {
        URL url = ClassLoader.getSystemResource(modelFilename);
        if (url == null) {
            throw new FileNotFoundException("Could not find file: " + modelFilename);
        }
        return new AC3DLoader(url, null).load();
    }

    public static AC3DModel load(URL modelLocation) throws IOException, FileFormatException, InvalidDataException, ResourceLoadFailedException {
        return new AC3DLoader(modelLocation, null).load();
    }

    public static AC3DModel load(String modelFilename, String texturePath) throws IOException, FileFormatException, InvalidDataException, ResourceLoadFailedException {
        URL url = ClassLoader.getSystemResource(modelFilename);
        if (url == null) {
            throw new FileNotFoundException("Could not find file: " + modelFilename);
        }
        return new AC3DLoader(url, texturePath).load();
    }

    public static AC3DModel load(URL modelLocation, String texturePath) throws IOException, FileFormatException, InvalidDataException, ResourceLoadFailedException {
        return new AC3DLoader(modelLocation, texturePath).load();
    }

    private AC3DModel load() throws IOException, FileFormatException, InvalidDataException, ResourceLoadFailedException {
        long startTime = System.currentTimeMillis();
        AC3DModel theModel = new AC3DModel(org.newdawn.loaders.ac3d.AC3DLoader.load(this.modelURL), this.texturePath);
        return theModel;
    }

    public static void main(String[] args) {
        try {
            if (args[0].equals("URL")) {
                AC3DLoader.load(new URL(args[1]));
            } else {
                AC3DLoader.load(args[1]);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

