/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nwn.loader;

import com.sun.j3d.utils.scenegraph.io.SceneGraphIO;
import com.sun.j3d.utils.scenegraph.io.SceneGraphObjectReferenceControl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Point3d;
import net.sf.nwn.loader.EmitterBehavior;
import net.sf.nwn.loader.J3dClock;
import net.sf.nwn.loader.ModelAnimation;

public class AnimationBehavior
extends Behavior
implements SceneGraphIO {
    private WakeupOnElapsedFrames wakeup = new WakeupOnElapsedFrames(FRAME_SLEEP, false);
    private Map namedTransforms;
    private Map namedEmitters;
    private Map animations;
    private List defaultAnims;
    private float animationTimeScale = 1.0f;
    private ModelAnimation currentAnimation;
    private ModelAnimation nextAnimation;
    private long start;
    private boolean loop;
    private float explicitAnimationStage = -1.0f;
    static long totalTime;
    static int count;
    private static boolean timerWorkaround;
    private static boolean timerSystem;
    public static final double TIMER_SCALE;
    public static int FRAME_SLEEP;
    private HashMap namedTransformReferences = null;
    private HashMap namedEmitterReferences = null;
    public static float ACTIVATION_RADIUS;

    public AnimationBehavior() {
    }

    public AnimationBehavior(Map map, Map map2, Map map3, List list) {
        this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), (double)ACTIVATION_RADIUS));
        this.namedTransforms = map;
        this.animations = map3;
        this.defaultAnims = list;
        this.namedEmitters = map2;
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)this.wakeup);
    }

    public void processStimulus(Enumeration enumeration) {
        this.wakeupOn((WakeupCondition)this.wakeup);
        if (this.nextAnimation != null) {
            this.start = AnimationBehavior.getTime();
            this.currentAnimation = this.nextAnimation;
            this.nextAnimation = null;
        }
        if (this.currentAnimation == null) {
            this.playDefaultAnimation();
            return;
        }
        long l = AnimationBehavior.getTime();
        float f = (float)((double)(l - this.start) / (TIMER_SCALE * (double)this.animationTimeScale));
        boolean bl = true;
        if (this.explicitAnimationStage >= 0.0f) {
            f = this.currentAnimation.getLength() * this.explicitAnimationStage;
            bl = false;
        } else if (f >= this.currentAnimation.getLength()) {
            if (!this.loop) {
                this.playDefaultAnimation();
                return;
            }
            this.nextAnimation = this.currentAnimation;
            return;
        }
        this.currentAnimation.update(this.namedTransforms, this.namedEmitters, f, bl);
    }

    public synchronized void playDefaultAnimation() {
        int n = this.defaultAnims.size();
        if (n == 0) {
            return;
        }
        n = (int)(Math.random() * (double)n);
        this.playAnimation((ModelAnimation)this.animations.get(this.defaultAnims.get(n)), false);
    }

    public void playAnimation(String string, boolean bl) {
        ModelAnimation modelAnimation = (ModelAnimation)this.animations.get(string);
        if (modelAnimation == null) {
            return;
        }
        this.playAnimation(modelAnimation, bl);
    }

    public void playAnimation(ModelAnimation modelAnimation, boolean bl) {
        this.nextAnimation = modelAnimation;
        this.loop = bl;
    }

    public List getDefaultAnimations() {
        return this.defaultAnims;
    }

    public synchronized void setDefaultAnimations(List list) {
        this.defaultAnims = list;
    }

    public Set getAllAnimationNames() {
        return this.animations.keySet();
    }

    public Collection getAllAnimations() {
        return this.animations.values();
    }

    public float getAnimationTimeScale() {
        return this.animationTimeScale;
    }

    public void setAnimationTimeScale(float f) {
        this.animationTimeScale = f;
    }

    public Map getNamedTransforms() {
        return this.namedTransforms;
    }

    public Node cloneNode(boolean bl) {
        AnimationBehavior animationBehavior = new AnimationBehavior();
        animationBehavior.duplicateNode((Node)this, bl);
        return animationBehavior;
    }

    public void duplicateNode(Node node, boolean bl) {
        super.duplicateNode(node, bl);
        AnimationBehavior animationBehavior = (AnimationBehavior)node;
        if (bl) {
            this.animations = new HashMap(animationBehavior.animations);
            this.defaultAnims = new ArrayList(animationBehavior.defaultAnims);
        } else {
            this.animations = animationBehavior.animations;
            this.defaultAnims = animationBehavior.defaultAnims;
        }
        this.namedTransforms = new HashMap(animationBehavior.namedTransforms);
        this.namedEmitters = new HashMap(animationBehavior.namedEmitters);
    }

    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        super.updateNodeReferences(nodeReferenceTable);
        for (Map.Entry entry : this.namedTransforms.entrySet()) {
            entry.setValue(nodeReferenceTable.getNewObjectReference((SceneGraphObject)((TransformGroup)entry.getValue())));
        }
        for (Map.Entry entry : this.namedEmitters.entrySet()) {
            entry.setValue(nodeReferenceTable.getNewObjectReference((SceneGraphObject)((EmitterBehavior)((Object)entry.getValue()))));
        }
    }

    public void setExplicitAnimationStage(float f) {
        this.explicitAnimationStage = f;
    }

    public void disableExplicitAnimationStage() {
        this.explicitAnimationStage = -1.0f;
    }

    public static long getTime() {
        if (timerWorkaround) {
            return J3dClock.currentTimeMillis() * 1000000L;
        }
        if (timerSystem) {
            return System.currentTimeMillis() * 1000000L;
        }
        return J3dClock.currentTimeMillis() * 1000000L;
    }

    public void createSceneGraphObjectReferences(SceneGraphObjectReferenceControl sceneGraphObjectReferenceControl) {
        this.namedTransformReferences = new HashMap();
        this.namedEmitterReferences = new HashMap();
        for (Map.Entry entry : this.namedTransforms.entrySet()) {
            this.namedTransformReferences.put(entry.getKey(), new Integer(sceneGraphObjectReferenceControl.addReference((SceneGraphObject)((TransformGroup)entry.getValue()))));
        }
        for (Map.Entry entry : this.namedEmitters.entrySet()) {
            this.namedEmitterReferences.put(entry.getKey(), new Integer(sceneGraphObjectReferenceControl.addReference((SceneGraphObject)((EmitterBehavior)((Object)entry.getValue())))));
        }
    }

    public void readSceneGraphObject(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        try {
            this.animations = (Map)objectInputStream.readObject();
            this.defaultAnims = (List)objectInputStream.readObject();
            this.namedTransformReferences = (HashMap)objectInputStream.readObject();
            this.namedEmitterReferences = (HashMap)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Class Not Found while loading, class " + classNotFoundException.getMessage());
        }
    }

    public void restoreSceneGraphObjectReferences(SceneGraphObjectReferenceControl sceneGraphObjectReferenceControl) {
        this.namedTransforms = new HashMap();
        this.namedEmitters = new HashMap();
        for (Map.Entry entry : this.namedTransformReferences.entrySet()) {
            this.namedTransforms.put(entry.getKey(), sceneGraphObjectReferenceControl.resolveReference(((Integer)entry.getValue()).intValue()));
        }
        for (Map.Entry entry : this.namedEmitterReferences.entrySet()) {
            this.namedEmitters.put(entry.getKey(), sceneGraphObjectReferenceControl.resolveReference(((Integer)entry.getValue()).intValue()));
        }
        this.namedTransformReferences = null;
        this.namedEmitterReferences = null;
    }

    public boolean saveChildren() {
        return false;
    }

    public void writeSceneGraphObject(DataOutput dataOutput) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this.animations);
        objectOutputStream.writeObject(this.defaultAnims);
        objectOutputStream.writeObject(this.namedTransformReferences);
        objectOutputStream.writeObject(this.namedEmitterReferences);
        objectOutputStream.close();
        dataOutput.writeInt(byteArrayOutputStream.size());
        dataOutput.write(byteArrayOutputStream.toByteArray());
        this.namedTransformReferences = null;
        this.namedEmitterReferences = null;
    }

    static {
        timerWorkaround = false;
        timerSystem = false;
        try {
            timerWorkaround = System.getProperty("j3dtimer.workaround", "false").equalsIgnoreCase("true");
            if (timerWorkaround) {
                System.out.println("Beta 1 j3dtimer workaround active");
            }
            if (timerSystem = System.getProperty("j3dtimer.usesystem", "" + System.getProperty("os.name", "other").equalsIgnoreCase("linux")).equalsIgnoreCase("true")) {
                System.out.println("Timer will use System.currentTimeMillis");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TIMER_SCALE = timerWorkaround ? 1.0E9 : 1.0E9;
        FRAME_SLEEP = 0;
        ACTIVATION_RADIUS = 5.0f;
    }
}

