/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nwn.loader;

import java.net.URL;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.sf.nwn.loader.GeomNode;
import net.sf.nwn.loader.NWNUserData;

public class DummyGeomNode
extends GeomNode {
    private Vector3f position;
    private AxisAngle4f orientation;
    private Color3f wirecolor;
    private float scale = 1.0f;

    public DummyGeomNode(GeomNode geomNode) {
        super(geomNode);
    }

    @Override
    public String getType() {
        return "dummy";
    }

    public AxisAngle4f getOrientation() {
        return this.orientation;
    }

    public void setOrientation(AxisAngle4f axisAngle4f) {
        this.orientation = axisAngle4f;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public void setPosition(Vector3f vector3f) {
        this.position = vector3f;
    }

    public Color3f getWirecolor() {
        return this.wirecolor;
    }

    public void setWirecolor(Color3f color3f) {
        this.wirecolor = color3f;
    }

    @Override
    public void dumpSingle(StringBuffer stringBuffer) {
        super.dumpSingle(stringBuffer);
        if (this.position != null) {
            stringBuffer.append("  position ");
            this.dump(stringBuffer, (Tuple3f)this.position);
            stringBuffer.append("\n");
        }
        if (this.orientation != null) {
            stringBuffer.append("  orientation ");
            this.dump(stringBuffer, this.orientation);
            stringBuffer.append("\n");
        }
        if (this.wirecolor != null) {
            stringBuffer.append("  wirecolor ");
            this.dump(stringBuffer, (Tuple3f)this.wirecolor);
            stringBuffer.append("\n");
        }
        if ((double)this.scale != 1.0) {
            stringBuffer.append("  scale ").append(this.scale).append("\n");
        }
    }

    @Override
    public TransformGroup createSingleTG(URL uRL, boolean bl) {
        Transform3D transform3D = new Transform3D();
        if (this.getOrientation() != null) {
            transform3D.set(this.getOrientation());
        }
        if (this.getPosition() != null) {
            transform3D.setTranslation(this.getPosition());
        }
        if ((double)this.scale != 1.0) {
            transform3D.setScale((double)this.scale);
        }
        TransformGroup transformGroup = new TransformGroup(transform3D);
        transformGroup.setUserData((Object)new NWNUserData(this.getName(), (Node)transformGroup));
        transformGroup.setCapability(17);
        transformGroup.setCapability(18);
        return transformGroup;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float f) {
        this.scale = f;
    }
}

