/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nwn.loader;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.Stripifier;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TextureUnitState;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.sf.nwn.loader.DummyGeomNode;
import net.sf.nwn.loader.Face;
import net.sf.nwn.loader.GeomNode;
import net.sf.nwn.loader.TargaImage;

public class TrimeshGeomNode
extends DummyGeomNode {
    private Color3f ambient;
    private Color3f diffuse;
    private Color3f specular;
    private Color3f emissive;
    private float shininess;
    private ArrayList verts = new ArrayList();
    private ArrayList faces = new ArrayList();
    private ArrayList tverts = new ArrayList();
    private ArrayList colors = new ArrayList();
    private ArrayList normals = new ArrayList();
    protected ArrayList constraints;
    private String bitmap;
    private float alpha = 1.0f;
    private WeakReference cachedGeometry;
    TexCoord2f zeroTvert = new TexCoord2f(0.0f, 0.0f);
    static int icount = 0;
    public static final Color3f black = new Color3f();
    public static final Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
    private static Map textures = new HashMap();
    private static Map images = new HashMap();

    public TrimeshGeomNode(GeomNode geomNode) {
        super(geomNode);
    }

    @Override
    public String getType() {
        return "trimesh";
    }

    public Color3f getAmbient() {
        return this.ambient;
    }

    public void setAmbient(Color3f color3f) {
        this.ambient = color3f;
    }

    public Color3f getDiffuse() {
        return this.diffuse;
    }

    public void setDiffuse(Color3f color3f) {
        this.diffuse = color3f;
    }

    public float getShininess() {
        return this.shininess;
    }

    public void setShininess(float f) {
        this.shininess = f;
    }

    public Color3f getSpecular() {
        return this.specular;
    }

    public void setSpecular(Color3f color3f) {
        this.specular = color3f;
    }

    public void addVert(Point3f point3f) {
        this.verts.add(point3f);
    }

    public void addTvert(TexCoord2f texCoord2f) {
        this.tverts.add(texCoord2f);
    }

    public void addFace(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        Face face = new Face();
        face.setV1(n);
        face.setV2(n2);
        face.setV3(n3);
        face.setM1(n4);
        face.setT1(n5);
        face.setT2(n6);
        face.setT3(n7);
        face.setM2(n8);
        this.faces.add(face);
    }

    public void addColor(Color3f color3f) {
        this.colors.add(color3f);
    }

    public String getBitmap() {
        return this.bitmap;
    }

    public void setBitmap(String string) {
        this.bitmap = string;
    }

    public TexCoord2f getTvert(int n) {
        if (n < 0) {
            System.err.println("WARN: Negative tvert for part " + this.getName());
            return this.zeroTvert;
        }
        if (n >= this.tverts.size()) {
            System.err.println("WARN: Requested tvert index out of range " + n + " >= " + this.tverts.size() + " for part " + this.getName());
            return this.zeroTvert;
        }
        return (TexCoord2f)this.tverts.get(n);
    }

    @Override
    public void dumpSingle(StringBuffer stringBuffer) {
        int n;
        super.dumpSingle(stringBuffer);
        if (this.ambient != null) {
            stringBuffer.append("  ambient ");
            this.dump(stringBuffer, (Tuple3f)this.ambient);
            stringBuffer.append("\n");
        }
        if (this.diffuse != null) {
            stringBuffer.append("  diffuse ");
            this.dump(stringBuffer, (Tuple3f)this.diffuse);
            stringBuffer.append("\n");
        }
        if (this.specular != null) {
            stringBuffer.append("  specular ");
            this.dump(stringBuffer, (Tuple3f)this.specular);
            stringBuffer.append("\n");
        }
        if (this.emissive != null && this.emissive != black) {
            stringBuffer.append(" selfillumcolor ");
            this.dump(stringBuffer, (Tuple3f)this.emissive);
            stringBuffer.append("\n");
        }
        stringBuffer.append("  shininess ").append(this.shininess).append("\n");
        if (this.bitmap != null) {
            stringBuffer.append("  bitmap ").append(this.bitmap).append("\n");
        }
        stringBuffer.append("  verts ").append(this.verts.size()).append("\n");
        for (n = 0; n < this.verts.size(); ++n) {
            stringBuffer.append("    ");
            this.dump(stringBuffer, (Tuple3f)((Point3f)this.verts.get(n)));
            stringBuffer.append("\n");
        }
        stringBuffer.append("  faces ").append(this.faces.size()).append("\n");
        for (n = 0; n < this.faces.size(); ++n) {
            stringBuffer.append("    ");
            stringBuffer.append(this.faces.get(n));
            stringBuffer.append("\n");
        }
        stringBuffer.append("  tverts ").append(this.tverts.size()).append("\n");
        for (n = 0; n < this.tverts.size(); ++n) {
            stringBuffer.append("    ");
            this.dump(stringBuffer, (Tuple2f)((TexCoord2f)this.tverts.get(n)));
            stringBuffer.append(" 0\n");
        }
        if (this.colors.size() > 0) {
            stringBuffer.append("  colors ").append(this.colors.size()).append("\n");
            for (n = 0; n < this.colors.size(); ++n) {
                stringBuffer.append("    ");
                this.dump(stringBuffer, (Tuple3f)((Color3f)this.colors.get(n)));
                stringBuffer.append("\n");
            }
        }
    }

    public void indexify() {
        Integer n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Face face;
        HashMap<Vertex, Integer> hashMap = new HashMap<Vertex, Integer>();
        ArrayList<Point3f> arrayList = new ArrayList<Point3f>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = null;
        if (this.constraints != null) {
            arrayList4 = new ArrayList();
        }
        this.normals.clear();
        ArrayList<Object> arrayList5 = new ArrayList<Object>();
        ArrayList<Object> arrayList6 = new ArrayList<Object>();
        ArrayList<Point3f> arrayList7 = new ArrayList<Point3f>();
        int n2 = 0;
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        for (int i = 0; i < this.faces.size(); ++i) {
            face = (Face)this.faces.get(i);
            object5 = (Point3f)this.verts.get(face.getV1());
            object4 = (Point3f)this.verts.get(face.getV2());
            object3 = (Point3f)this.verts.get(face.getV3());
            object2 = new Vector3f();
            vector3f.sub((Tuple3f)object3, (Tuple3f)object4);
            vector3f2.sub((Tuple3f)object5, (Tuple3f)object4);
            object2.cross(vector3f, vector3f2);
            object2.normalize();
            if (Float.isNaN(((Vector3f)object2).x)) {
                System.err.println("WARN: Illegal normal for part " + this.getName());
                System.err.println(" face " + i);
                System.err.println(" p1=" + face.getV1() + "(" + object5 + ")");
                System.err.println(" p2=" + face.getV2() + "(" + object4 + ")");
                System.err.println(" p3=" + face.getV3() + "(" + object3 + ")");
                ((Vector3f)object2).x = 1.0f;
                ((Vector3f)object2).y = 0.0f;
                ((Vector3f)object2).z = 0.0f;
            }
            arrayList5.add(object5);
            arrayList6.add(object2);
            arrayList5.add(object4);
            arrayList6.add(object2);
            arrayList5.add(object3);
            arrayList6.add(object2);
            object = new Integer(face.getM1());
            arrayList7.add((Point3f)object);
            arrayList7.add((Point3f)object);
            arrayList7.add((Point3f)object);
            Point3f point3f = (Point3f)this.verts.get(face.getV1());
            n = this.getTvert(face.getT1());
            Vertex vertex = new Vertex(point3f, (TexCoord2f)n, face.getM1());
            Integer n3 = (Integer)hashMap.get(vertex);
            if (n3 == null) {
                n3 = new Integer(n2);
                ++n2;
                hashMap.put(vertex, n3);
                arrayList.add(point3f);
                arrayList2.add(n);
                this.normals.add(object2);
                if (this.colors.size() > 0) {
                    arrayList3.add(this.colors.get(face.getV1()));
                }
                if (this.constraints != null) {
                    arrayList4.add(this.constraints.get(face.getV1()));
                }
            }
            face.setV1(n3);
            face.setT1(n3);
            point3f = (Point3f)this.verts.get(face.getV2());
            n = this.getTvert(face.getT2());
            vertex = new Vertex(point3f, (TexCoord2f)n, face.getM1());
            n3 = (Integer)hashMap.get(vertex);
            if (n3 == null) {
                n3 = new Integer(n2);
                ++n2;
                hashMap.put(vertex, n3);
                arrayList.add(point3f);
                arrayList2.add(n);
                this.normals.add(object2);
                if (this.colors.size() > 0) {
                    arrayList3.add(this.colors.get(face.getV2()));
                }
                if (this.constraints != null) {
                    arrayList4.add(this.constraints.get(face.getV2()));
                }
            }
            face.setV2(n3);
            face.setT2(n3);
            point3f = (Point3f)this.verts.get(face.getV3());
            n = this.getTvert(face.getT3());
            vertex = new Vertex(point3f, (TexCoord2f)n, face.getM1());
            n3 = (Integer)hashMap.get(vertex);
            if (n3 == null) {
                n3 = new Integer(n2);
                ++n2;
                hashMap.put(vertex, n3);
                arrayList.add(point3f);
                arrayList2.add(n);
                this.normals.add(object2);
                if (this.colors.size() > 0) {
                    arrayList3.add(this.colors.get(face.getV3()));
                }
                if (this.constraints != null) {
                    arrayList4.add(this.constraints.get(face.getV3()));
                }
            }
            face.setV3(n3);
            face.setT3(n3);
        }
        this.verts = arrayList;
        this.tverts = arrayList2;
        this.colors = arrayList3;
        this.constraints = arrayList4;
        ArrayList<Vector3f> arrayList8 = new ArrayList<Vector3f>();
        while (arrayList5.size() > 0) {
            int n4;
            arrayList8.clear();
            face = (Point3f)arrayList5.get(arrayList5.size() - 1);
            object5 = (Integer)arrayList7.get(arrayList7.size() - 1);
            object4 = arrayList5.iterator();
            object3 = arrayList6.iterator();
            object2 = arrayList7.iterator();
            while (object4.hasNext()) {
                object = (Point3f)object4.next();
                Vector3f vector3f3 = (Vector3f)object3.next();
                n = (Integer)object2.next();
                if (!object.equals((Tuple3f)face)) continue;
                object4.remove();
                object3.remove();
                object2.remove();
                arrayList8.add(vector3f3);
            }
            object = new Vector3f();
            for (n4 = 0; n4 < arrayList8.size(); ++n4) {
                object.add((Tuple3f)((Vector3f)arrayList8.get(n4)));
            }
            object.normalize();
            if (Float.isNaN(object.x)) {
                System.err.println("Illegal normal");
                object.x = 1.0f;
                object.y = 0.0f;
                object.z = 0.0f;
            }
            for (n4 = 0; n4 < this.verts.size(); ++n4) {
                if (!face.equals(this.verts.get(n4))) continue;
                this.normals.set(n4, object);
            }
        }
    }

    public GeometryArray createGeometry(boolean bl) {
        return this.createGeometry(true, bl);
    }

    public GeometryArray createGeometry(boolean bl, boolean bl2) {
        Stripifier stripifier;
        Vector3f[] vector3fArray;
        GeometryArray geometryArray;
        boolean bl3 = true;
        if (this.cachedGeometry != null && (geometryArray = (GeometryArray)this.cachedGeometry.get()) != null) {
            return geometryArray;
        }
        this.indexify();
        geometryArray = new GeometryInfo(1);
        Point3f[] point3fArray = new Point3f[this.verts.size()];
        this.verts.toArray(point3fArray);
        geometryArray.setCoordinates(point3fArray);
        int[] nArray = new int[this.faces.size() * 3];
        for (int i = 0; i < this.faces.size(); ++i) {
            vector3fArray = (Vector3f[])this.faces.get(i);
            nArray[i * 3] = vector3fArray.getV1();
            nArray[i * 3 + 1] = vector3fArray.getV2();
            nArray[i * 3 + 2] = vector3fArray.getV3();
        }
        geometryArray.setCoordinateIndices(nArray);
        geometryArray.setUseCoordIndexOnly(bl3);
        if (this.colors.size() > 0) {
            Color3f[] color3fArray = new Color3f[this.colors.size()];
            this.colors.toArray(color3fArray);
            geometryArray.setColors(color3fArray);
            if (!bl3) {
                geometryArray.setColorIndices(nArray);
            }
        }
        geometryArray.setTextureCoordinateParams(1, 2);
        if (bl2) {
            geometryArray.setTexCoordSetMap(new int[]{0, -1});
        } else {
            geometryArray.setTexCoordSetMap(new int[]{0});
        }
        TexCoord2f[] texCoord2fArray = new TexCoord2f[this.tverts.size()];
        this.tverts.toArray(texCoord2fArray);
        geometryArray.setTextureCoordinates(0, texCoord2fArray);
        if (!bl3) {
            geometryArray.setTextureCoordinateIndices(0, nArray);
        }
        vector3fArray = new Vector3f[this.normals.size()];
        this.normals.toArray(vector3fArray);
        geometryArray.setNormals(vector3fArray);
        if (!bl3) {
            geometryArray.setNormalIndices(nArray);
        }
        if (bl) {
            stripifier = new Stripifier();
            stripifier.stripify((GeometryInfo)geometryArray);
        }
        try {
            stripifier = geometryArray.getIndexedGeometryArray(false, false, false, bl3, false);
            this.cachedGeometry = new WeakReference<Stripifier>(stripifier);
            return stripifier;
        }
        catch (Exception exception) {
            RuntimeException runtimeException = new RuntimeException("Error while creating part " + this.getName());
            runtimeException.initCause(exception);
            throw runtimeException;
        }
    }

    public Appearance createAppearance(URL uRL, boolean bl) {
        TexCoordGeneration texCoordGeneration;
        TextureAttributes textureAttributes;
        Appearance appearance = new Appearance();
        if (this.ambient == null) {
            System.out.println("WARN: ambient null for " + this.getName());
            this.ambient = black;
        }
        if (this.diffuse == null) {
            System.out.println("WARN: diffuse null for " + this.getName());
            this.diffuse = black;
        }
        if (this.specular == null) {
            System.out.println("WARN: specular null for " + this.getName());
            this.specular = black;
        }
        if (this.emissive == null) {
            this.emissive = black;
        }
        Material material = new Material(this.ambient, this.emissive, this.diffuse, this.specular, this.shininess);
        material.setLightingEnable(true);
        appearance.setMaterial(material);
        TextureUnitState textureUnitState = null;
        Texture texture = TrimeshGeomNode.findTexture(uRL, this.getBitmap());
        if (texture != null) {
            textureAttributes = new TextureAttributes();
            textureAttributes.setTextureMode(2);
            texCoordGeneration = new TexCoordGeneration();
            texCoordGeneration.setEnable(false);
            textureUnitState = new TextureUnitState(texture, textureAttributes, texCoordGeneration);
        }
        if (bl) {
            textureAttributes = TrimeshGeomNode.findTexture(uRL, "chrome1");
            if (textureAttributes != null) {
                texCoordGeneration = new TexCoordGeneration(2, 0);
                TextureAttributes textureAttributes2 = new TextureAttributes();
                textureAttributes2.setTextureMode(6);
                textureAttributes2.setCombineRgbMode(1);
                textureAttributes2.setCombineRgbSource(0, 3);
                textureAttributes2.setCombineRgbFunction(0, 0);
                textureAttributes2.setCombineRgbSource(1, 1);
                textureAttributes2.setCombineRgbFunction(1, 0);
                textureAttributes2.setCombineRgbSource(2, 3);
                textureAttributes2.setCombineRgbFunction(2, 2);
                TextureUnitState textureUnitState2 = new TextureUnitState((Texture)textureAttributes, textureAttributes2, texCoordGeneration);
                appearance.setTextureUnitState(new TextureUnitState[]{textureUnitState, textureUnitState2});
            }
        } else {
            appearance.setTextureUnitState(new TextureUnitState[]{textureUnitState});
        }
        if (this.alpha < 1.0f || !bl && texture != null && texture.getFormat() == 6) {
            appearance.setTransparencyAttributes(new TransparencyAttributes(2, 0.01f));
            textureUnitState.getTextureAttributes().setTextureMode(5);
        }
        return appearance;
    }

    public Shape3D createShape(URL uRL, boolean bl) {
        return new Shape3D((Geometry)this.createGeometry(bl), this.createAppearance(uRL, bl));
    }

    public boolean hasShape() {
        if (this.verts.size() == 0) {
            System.out.println("WARN: No vertices for trimesh " + this.getName());
            return false;
        }
        if (this.faces.size() == 0) {
            System.out.println("WARN: No faces for trimesh " + this.getName());
            return false;
        }
        return true;
    }

    @Override
    public TransformGroup createSingleTG(URL uRL, boolean bl) {
        TransformGroup transformGroup = super.createSingleTG(uRL, bl);
        if (this.hasShape()) {
            transformGroup.addChild((Node)this.createShape(uRL, bl));
        }
        return transformGroup;
    }

    public static Texture findTexture(URL uRL, String string) {
        Object object;
        Object object2;
        if (string == null) {
            return null;
        }
        Texture texture = null;
        Object object3 = (TargaImage)images.get(string);
        if (object3 == null && !images.containsKey(string)) {
            try {
                try {
                    object2 = new TargaImage(new URL(uRL, string + ".tga"));
                }
                catch (IOException iOException) {
                    object = new GZIPInputStream(new URL(uRL, string + ".tga.gz").openStream());
                    object2 = new TargaImage((InputStream)object);
                    ((InputStream)object).close();
                }
                object3 = object2;
                images.put(string, object3);
            }
            catch (Exception exception) {
                System.out.println("WARN: Cannot load texture " + string);
                return null;
            }
        }
        object2 = ((TargaImage)object3).getPixelDepth() == 32 ? "RGBA" : "RGB";
        BufferedImage bufferedImage = ((TargaImage)object3).getImage();
        object = new TextureLoader(bufferedImage, (String)object2);
        texture = object.getTexture();
        texture.setCapability(9);
        return texture;
    }

    public Color3f getEmissive() {
        return this.emissive;
    }

    public void setEmissive(Color3f color3f) {
        this.emissive = color3f;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float f) {
        this.alpha = f;
    }

    static class Vertex {
        public Point3f p;
        public TexCoord2f t;
        public int group;

        public Vertex(Point3f point3f, TexCoord2f texCoord2f, int n) {
            this.p = point3f;
            this.t = texCoord2f;
            this.group = n;
        }

        public boolean equals(Vertex vertex) {
            return this.p.equals((Tuple3f)vertex.p) && this.t.equals((Tuple2f)vertex.t) && this.group == vertex.group;
        }

        public boolean equals(Object object) {
            return this.equals((Vertex)object);
        }

        public int hashCode() {
            return this.p.hashCode() ^ this.t.hashCode();
        }
    }
}

