/*
 * Decompiled with CFR 0.152.
 */
package com.microcrowd.loader.java3d.max3ds.data;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.media.j3d.Alpha;
import javax.media.j3d.Behavior;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.RotPosPathInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransformInterpolator;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class KeyFramer {
    private HashMap lastGroupMap = new HashMap();
    private HashMap fatherMap = new HashMap();
    private Quat4f rotation;
    private Point3f position;
    private Point3f pivotCenter;
    private Vector3f pivot;
    private Vector3f scale;
    private HashMap namedObjectCoordinateSystems = new HashMap();
    private List positionKeys;
    private List orientationKeys;
    private List scaleKeys;
    private Integer id;
    private Group father;
    private Group dummyObject;

    public Behavior createBehavior(String meshName, Group transformGroup, Object testObject) {
        Group objectGroup = this.getObjectByName(meshName, transformGroup, testObject);
        if (objectGroup == null) {
            return null;
        }
        this.insertFather(objectGroup, meshName);
        TransformInterpolator behavior = null;
        Transform3D coordinateSystem = (Transform3D)this.namedObjectCoordinateSystems.get(meshName);
        Enumeration children = this.removeChildren(objectGroup);
        Transform3D coordinateTransform = coordinateSystem == null ? new Transform3D() : new Transform3D(coordinateSystem);
        Transform3D targetTransform = new Transform3D();
        TransformGroup targetGroup = new TransformGroup(targetTransform);
        TransformGroup localCoordinates = this.hasKeys() ? this.buildLocalCoordinates(coordinateSystem) : new TransformGroup();
        TransformGroup lastGroup = (TransformGroup)this.addGroups(objectGroup, new Group[]{localCoordinates, targetGroup, this.buildPivotGroup(coordinateTransform, this.pivot), this.buildKeysGroup()});
        this.addChildren(children, (Group)lastGroup);
        this.lastGroupMap.put(objectGroup, lastGroup);
        behavior = this.buildInterpolator(targetGroup, coordinateSystem);
        if (behavior != null) {
            behavior.setEnable(false);
            targetGroup.addChild((Node)behavior);
            behavior.computeTransform(0.0f, targetTransform);
            targetGroup.setTransform(targetTransform);
        }
        return behavior;
    }

    private Enumeration removeChildren(Group group) {
        Enumeration children = group.getAllChildren();
        group.removeAllChildren();
        return children;
    }

    private void addChildren(Enumeration children, Group group) {
        if (group == null) {
            return;
        }
        while (children.hasMoreElements()) {
            Node node = (Node)children.nextElement();
            group.addChild(node);
        }
    }

    private Group getObjectByName(String objectName, Group objectGroup, Object testObject) {
        if (objectGroup == null && testObject == null) {
            this.namedObjectCoordinateSystems.put(objectName, new Transform3D());
            objectGroup = this.dummyObject;
        }
        return objectGroup;
    }

    private void insertFather(Group parentGroup, String objectName) {
        if (this.father == null) {
            return;
        }
        TransformGroup topGroup = new TransformGroup();
        topGroup.addChild((Node)this.father);
        Group bottomGroup = (Group)this.lastGroupMap.get(this.father);
        if (topGroup == null) {
            return;
        }
        Group fatherParent = (Group)topGroup.getParent();
        if (fatherParent != null) {
            fatherParent.removeChild((Node)topGroup);
        }
        Enumeration originalChildren = this.removeChildren(parentGroup);
        parentGroup.addChild((Node)topGroup);
        this.addChildren(originalChildren, bottomGroup);
    }

    private TransformGroup buildKeysGroup() {
        Transform3D positionTransform = new Transform3D();
        positionTransform.set(new Vector3f((Tuple3f)this.position));
        Transform3D rotationTransform = new Transform3D();
        rotationTransform.set(this.rotation);
        Transform3D scaleTransform = new Transform3D();
        scaleTransform.setScale(new Vector3d(this.scale));
        TransformGroup scaleGroup = new TransformGroup(scaleTransform);
        Transform3D keyTransform = new Transform3D(positionTransform);
        keyTransform.mul(scaleTransform);
        keyTransform.mul(rotationTransform);
        return new TransformGroup(keyTransform);
    }

    private TransformGroup buildPivotGroup(Transform3D coordinateTransform, Vector3f pivot) {
        Transform3D pivotTransform = new Transform3D();
        pivotTransform.mulInverse(coordinateTransform);
        pivot = new Vector3f(pivot);
        pivot.negate();
        this.translatePivot(pivotTransform, pivot, this.pivotCenter);
        return new TransformGroup(pivotTransform);
    }

    private TransformGroup buildLocalCoordinates(Transform3D coordinateSystem) {
        Matrix4f coordMatrix = new Matrix4f();
        Vector3f translation = new Vector3f();
        coordinateSystem.get(translation);
        coordinateSystem.invert();
        coordinateSystem.get(coordMatrix);
        coordMatrix.m03 = translation.x;
        coordMatrix.m13 = translation.y;
        coordMatrix.m23 = translation.z;
        coordinateSystem.set(coordMatrix);
        coordinateSystem.invert();
        TransformGroup systemGroup = new TransformGroup(coordinateSystem);
        coordinateSystem.invert();
        return systemGroup;
    }

    private Group addGroups(Group parentGroup, Group[] groups) {
        Group nextGroup = parentGroup;
        for (int i = 0; i < groups.length; ++i) {
            nextGroup.addChild((Node)groups[i]);
            nextGroup = groups[i];
        }
        return groups[groups.length - 1];
    }

    private void translatePivot(Transform3D transform, Vector3f vector, Point3f offset) {
        if (offset != null) {
            this.pivot.sub((Tuple3f)offset);
        }
        Matrix4f matrix = new Matrix4f();
        transform.get(matrix);
        matrix.m03 += matrix.m00 * vector.x + matrix.m01 * vector.y + matrix.m02 * vector.z;
        matrix.m13 += matrix.m10 * vector.x + matrix.m11 * vector.y + matrix.m12 * vector.z;
        matrix.m23 += matrix.m20 * vector.x + matrix.m21 * vector.y + matrix.m22 * vector.z;
        transform.set(matrix);
    }

    private TransformInterpolator buildInterpolator(TransformGroup targetGroup, Transform3D axisOfTransform) {
        this.makeTwoListsTheSameSize(this.positionKeys, this.orientationKeys);
        int numKeys = this.positionKeys.size();
        Point3f currentPoint = this.position;
        Quat4f currentQuat = this.rotation;
        RotPosPathInterpolator rotator = null;
        if (numKeys > 1) {
            float[] knots = new float[numKeys];
            Point3f[] points = new Point3f[numKeys];
            Quat4f[] quats = new Quat4f[numKeys];
            for (int i = 0; i < numKeys; ++i) {
                float f = knots[i] = i == 0 ? 0.0f : (float)i / (float)(numKeys - 1);
                if (this.positionKeys.size() > i) {
                    Quat4f newQuat;
                    Point3f newPoint = (Point3f)this.positionKeys.get(i);
                    if (newPoint != null) {
                        currentPoint = newPoint;
                    }
                    if ((newQuat = (Quat4f)this.orientationKeys.get(i)) != null) {
                        currentQuat = newQuat;
                    }
                }
                points[i] = currentPoint;
                quats[i] = currentQuat;
                quats[i].inverse();
            }
            Alpha alpha = new Alpha(-1, (long)((double)numKeys / 0.03));
            alpha.setStartTime(System.currentTimeMillis());
            alpha.setDuplicateOnCloneTree(true);
            rotator = new RotPosPathInterpolator(alpha, targetGroup, axisOfTransform, knots, quats, points);
        }
        return rotator;
    }

    public void makeTwoListsTheSameSize(List list1, List list2) {
        this.growList(list2.size() - 1, list1);
        this.growList(list1.size() - 1, list2);
    }

    public void growList(int index, List list) {
        int numNeeded = index + 1 - list.size();
        while (numNeeded-- > 0) {
            list.add(null);
        }
    }

    public void setPivotCenter(Point3f center) {
        this.pivotCenter = center;
    }

    public void setCoordinateSystem(String objectName, Transform3D coordinateSystem) {
        this.namedObjectCoordinateSystems.put(objectName, coordinateSystem);
    }

    public void setRotation(Quat4f rotation) {
        this.rotation = rotation;
    }

    public void setPivot(Vector3f pivot) {
        this.pivot = pivot;
    }

    public void setScale(Vector3f scale) {
        this.scale = scale;
    }

    public void setScaleKeys(List scaleKeys) {
        this.scaleKeys = scaleKeys;
    }

    public void setPosition(Point3f position) {
        this.position = position;
    }

    public void setPositionKeys(List positions) {
        this.positionKeys = positions;
    }

    public void setOrientationKeys(List orientations) {
        this.orientationKeys = orientations;
    }

    public void setDummyObject(Group object) {
        this.dummyObject = object;
    }

    public boolean hasKeys() {
        return this.positionKeys.size() > 1 || this.orientationKeys.size() > 1;
    }

    public void addFather(int fatherID, TransformGroup newFather) {
        if (fatherID < 0) {
            this.father = null;
        } else {
            this.father = (TransformGroup)this.fatherMap.get(new Integer(fatherID));
            Group grandFather = (Group)this.father.getParent();
            if (grandFather != null) {
                grandFather.removeChild((Node)this.father);
            }
        }
        this.fatherMap.put(this.id, newFather);
    }

    public void setID(int id) {
        this.id = new Integer(id);
    }
}

