/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.md2;

import java.io.IOException;
import org.newdawn.j3d.loaders.cio.LittleEndianDataInputStream;
import org.newdawn.j3d.loaders.md2.MD2GLCommand;

public class MD2GLCommands {
    public static final int STRIP = 1;
    public static final int FAN = 2;
    private int indicator;
    private int type;
    private MD2GLCommand[] commands;

    public MD2GLCommands(LittleEndianDataInputStream in, int indicator) throws IOException {
        this.indicator = indicator;
        this.type = indicator < 0 ? 2 : 1;
        this.commands = new MD2GLCommand[this.getCount()];
        int i = 0;
        while (i < this.getCount()) {
            this.commands[i] = new MD2GLCommand(in);
            ++i;
        }
    }

    public int getType() {
        return this.type;
    }

    public MD2GLCommand getCommand(int i) {
        return this.commands[i];
    }

    public int getCount() {
        if (this.indicator < 0) {
            return -this.indicator;
        }
        return this.indicator;
    }

    static {
        STRIP = 1;
        FAN = 2;
    }
}

